/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.ILRUManager;
import cerent.cms.model.IModelPersistenceConstants;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SequenceNumberLRUMap;
import cerent.util.ISequenceNumberConstants;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.TimeLRUMap;
import cerent.util.threadpool.IActionClient;
import cerent.util.threadpool.IThreadWorker;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class LRUManager
implements ILRUManager,
IActionClient {
    public static final String PREFS_LRU = "ctc.model.persist.lru";
    public static final String PREFS_LRU_AGE = "age";
    public static final int PREFS_LRU_AGE_DEFAULT = 10;
    private static ModelSingletonCollection LRUManagerSingletons;
    public static final int MINUTE_RESOLUTION = 60;
    public static final int DEFAULT_RESOLUTION = 60;
    public static final int NUM_MINUTES = 1;
    public static final int SLEEP_AMT = 1;
    public static final int SIZE_ADJUST_COUNT = 4;
    private static Class[] LRUMapClassArgTypes;
    private String threadName;
    private boolean isSelfRunning;
    private SDebug db;
    private TimeLRUMap lru;
    private int sleepTime;
    private long passCount;
    private boolean doStop = false;
    private ArrayList handlers;
    private WorkerThread worker;
    static /* synthetic */ Class class$cerent$util$SDebug;
    static /* synthetic */ Class class$cerent$cms$model$LRUManager;
    static /* synthetic */ Class class$cerent$cms$model$LRUManager$Debug;

    private LRUManager(TimeLRUMap timeLRUMap, LRUObjectHandler lRUObjectHandler) {
        this.lru = timeLRUMap;
        this.handlers = new ArrayList();
        this.handlers.add(lRUObjectHandler);
        this.sleepTime = 60000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final WorkerThread getWorker() {
        Object object = this.getInternalLock();
        synchronized (object) {
            if (this.worker == null) {
                this.worker = new WorkerThread(this.threadName);
            }
        }
        return this.worker;
    }

    private LRUManager(String string, TimeLRUMap timeLRUMap, LRUObjectHandler lRUObjectHandler) {
        this.threadName = string;
        this.lru = timeLRUMap;
        this.handlers = new ArrayList();
        this.handlers.add(lRUObjectHandler);
        this.sleepTime = 60000;
    }

    private LRUManager(NodeModelDelegate nodeModelDelegate, int n, LRUObjectHandler lRUObjectHandler) {
        this(nodeModelDelegate, new TimeLRUMap(n, null), lRUObjectHandler);
    }

    private LRUManager(NodeModelDelegate nodeModelDelegate, TimeLRUMap timeLRUMap, LRUObjectHandler lRUObjectHandler) {
        this("LRUManager for " + nodeModelDelegate.getHostName(), timeLRUMap, lRUObjectHandler);
        try {
            this.db = nodeModelDelegate.getChildDebug(class$cerent$cms$model$LRUManager == null ? (class$cerent$cms$model$LRUManager = LRUManager.class$("cerent.cms.model.LRUManager")) : class$cerent$cms$model$LRUManager, class$cerent$cms$model$LRUManager$Debug == null ? (class$cerent$cms$model$LRUManager$Debug = LRUManager.class$("cerent.cms.model.LRUManager$Debug")) : class$cerent$cms$model$LRUManager$Debug, this);
            timeLRUMap.setDebug(this.db);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private LRUManager(TimeLRUMap timeLRUMap, LRUObjectHandler lRUObjectHandler, SDebug sDebug) {
        this(timeLRUMap, lRUObjectHandler);
        this.db = sDebug;
    }

    public void addHandler(LRUObjectHandler lRUObjectHandler) {
        if (this.handlers.indexOf(lRUObjectHandler) < 0) {
            this.handlers.add(lRUObjectHandler);
        }
    }

    public TimeLRUMap getLRU() {
        return this.lru;
    }

    public void setLRU(TimeLRUMap timeLRUMap) {
        this.lru = timeLRUMap;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int n) {
        this.sleepTime = n;
    }

    public boolean doStop() {
        return this.doStop;
    }

    public void runOnce(TimeLRUMap timeLRUMap) {
        this.runOnce(timeLRUMap, true);
    }

    public void runOnce() {
        this.runOnce(this.lru);
    }

    public void runOnce(TimeLRUMap timeLRUMap, boolean bl) {
        this._runOnceSync(timeLRUMap, bl);
    }

    private void _runOnce(TimeLRUMap timeLRUMap, boolean bl) {
        this._runOnceNoSync(timeLRUMap, bl);
    }

    private void _runOnceNoSync(TimeLRUMap timeLRUMap, boolean bl) {
        if (timeLRUMap == null) {
            return;
        }
        List list = timeLRUMap.removeAllOld();
        int n = list.size();
        if (n == 0) {
            if (this.db.isFinestEnabled()) {
                this.db.finest(new Date() + " model state LRU mgmt processing " + n + " persist-needed entries");
            }
        } else if (this.db.on()) {
            this.db.println(new Date() + " model state LRU mgmt processing " + n + " persist-needed entries");
        }
        int n2 = this.processAll(list);
        if (bl && this.passCount % 4L == 1L) {
            timeLRUMap.adjustSize();
        }
        if (this.db.on()) {
            int n3 = this.getWorkCount();
            int n4 = this.getImmediateWorkCount();
            if (n3 == 0 && n4 == 0) {
                if (this.db.isFinestEnabled()) {
                    this.db.finest("LRU mgmt total content is now: " + n3 + " (" + n4 + ")");
                }
            } else {
                this.db.println("LRU mgmt total content is now: " + n3 + " (" + n4 + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _runOnceSync(TimeLRUMap timeLRUMap, boolean bl) {
        int n;
        ArrayList arrayList = null;
        int n2 = 0;
        boolean bl2 = false;
        Object object = this.getInternalLock();
        synchronized (object) {
            if (timeLRUMap == null) {
                return;
            }
            List list = timeLRUMap.removeAllOld();
            n = list.size();
            if (n == 0) {
                if (this.db.isFinestEnabled()) {
                    this.db.finest(new Date() + " model state LRU mgmt processing " + n + " persist-needed entries");
                }
            } else if (this.db.on()) {
                this.db.println(new Date() + " model state LRU mgmt processing " + n + " persist-needed entries");
            }
            if (n > 0) {
                arrayList = new ArrayList(n);
                n2 = this.processAllPhase1(list, arrayList);
                bl2 = bl && this.passCount % 4L == 1L;
            }
        }
        n2 = this.processAllPhase2(arrayList);
        if (bl2) {
            object = this.getInternalLock();
            synchronized (object) {
                timeLRUMap.adjustSize();
            }
        }
        if (this.db.on()) {
            object = this.getInternalLock();
            synchronized (object) {
                int n3 = this.getWorkCount();
                n = this.getImmediateWorkCount();
                if (n3 == 0 && n == 0) {
                    if (this.db.isFinestEnabled()) {
                        this.db.finest("LRU mgmt total content is now: " + n3 + " (" + n + ")");
                    }
                } else {
                    this.db.println("LRU mgmt total content is now: " + n3 + " (" + n + ")");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalRun() {
        TimeLRUMap timeLRUMap = this.lru;
        if (timeLRUMap != null) {
            Object object = this.getInternalLock();
            synchronized (object) {
                if (this.db.on()) {
                    this.db.println("finalRun() starting");
                }
                this.dispose();
                boolean bl = this.isSelfRunning;
                if (bl) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!bl && timeLRUMap != null) {
                    timeLRUMap.removeAll();
                    this._runOnce(timeLRUMap, false);
                    this.setLRU(null);
                }
                if (this.db.on()) {
                    this.db.println("finalRun() done");
                }
            }
            object = this.getInternalLock();
            synchronized (object) {
                this.notifyAll();
            }
        }
    }

    public void doAction() {
        this.getWorker().run();
    }

    public int getImmediateWorkCount() {
        return this.lru == null ? 0 : this.lru.getToBeProcessed().size();
    }

    public int getWorkCount() {
        return this.lru == null ? 0 : this.lru.size() + this.getImmediateWorkCount();
    }

    protected int processAll(List list) {
        int n = 0;
        while (true) {
            block4: {
                try {
                    if (list.size() == 0) break;
                    Object e = list.remove(0);
                    if (this.db.on()) {
                        this.db.println("about to process obj: " + e + " (" + list.size() + ")");
                    }
                    if (e == null) break block4;
                    this.process(e);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
            }
            ++n;
        }
        this.process(null);
        return n;
    }

    protected int processAllPhase1(List list, List list2) {
        int n = 0;
        while (true) {
            block4: {
                try {
                    if (list.size() == 0) break;
                    Object e = list.remove(0);
                    if (this.db.on()) {
                        this.db.println("about to process obj: " + e + " (" + list.size() + ")");
                    }
                    if (e == null) break block4;
                    list2.add(e);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
            }
            ++n;
        }
        return n;
    }

    protected int processAllPhase2(List list) {
        int n;
        int n2 = list == null ? 0 : list.size();
        for (n = 0; n < n2; ++n) {
            Object e = list.get(n);
            if (this.db.on()) {
                this.db.println("phase 2 - about to process obj: " + e + " (" + list.size() + ")");
            }
            this.process(e);
        }
        this.process(null);
        return n;
    }

    protected void process(Object object) {
        LRUObjectHandler lRUObjectHandler;
        int n;
        Long l = object == null ? ISequenceNumberConstants.UNINITIALIZED_SEQ_NUM_OBJ : this.lru.dequeued(object);
        int n2 = this.handlers.size();
        for (int i = 0; i < n2 && (n = (lRUObjectHandler = (LRUObjectHandler)this.handlers.get(i)).handleLRUObject(object, l)) == 3; ++i) {
        }
    }

    public void failedAction(IThreadWorker iThreadWorker) {
    }

    public void dispose() {
        this.doStop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWork() {
        boolean bl = false;
        Object object = this.getInternalLock();
        synchronized (object) {
            if (!this.doStop && this.worker == null && !this.isSelfRunning) {
                this.isSelfRunning = true;
                bl = true;
            }
        }
        if (bl) {
            this.worker = new WorkerThread(this.threadName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishWork() {
        Object object = this.getInternalLock();
        synchronized (object) {
            if (this.worker != null && this.worker.isAlive()) {
                block7: {
                    this.worker.interrupt();
                    this.dispose();
                    try {
                        this.worker.join();
                    }
                    catch (InterruptedException interruptedException) {
                        if (!this.db.on()) break block7;
                        this.db.println("LRUManager interrupted");
                    }
                }
                if (this.db.on()) {
                    this.db.println("LRUManager stopped");
                }
                this.finalRun();
            }
        }
    }

    public static synchronized LRUManager getInstance(NodeModelDelegate nodeModelDelegate, LRUObjectHandler lRUObjectHandler, Class clazz) {
        LRUManager lRUManager;
        if (LRUManagerSingletons == null) {
            LRUManagerSingletons = ModelSingletonCollection.getMSCInstanceByName("LRUManager");
        }
        if ((lRUManager = (LRUManager)LRUManagerSingletons.get(nodeModelDelegate)) == null) {
            int n = Preferences.instance().getInt(PREFS_LRU, PREFS_LRU_AGE, 10);
            Constructor constructor = null;
            if (clazz != null) {
                try {
                    constructor = clazz.getConstructor(LRUMapClassArgTypes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (constructor != null) {
                try {
                    TimeLRUMap timeLRUMap = (TimeLRUMap)((Object)constructor.newInstance(new Integer(n), null));
                    timeLRUMap.enableTouching(IModelPersistenceConstants.ENABLE_PERSISTENCE);
                    lRUManager = new LRUManager(nodeModelDelegate, timeLRUMap, lRUObjectHandler);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (lRUManager == null) {
                lRUManager = new LRUManager(nodeModelDelegate, n, lRUObjectHandler);
            }
            LRUManagerSingletons.add(nodeModelDelegate, lRUManager);
        }
        return lRUManager;
    }

    Object getInternalLock() {
        return this.handlers;
    }

    static void sleep(int n) {
        try {
            Thread.sleep(n * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        TestLRUManager testLRUManager = new TestLRUManager();
        TimeLRUMap timeLRUMap = testLRUManager.getLRU();
        testLRUManager.setSleepTime(1);
        Touch touch = new Touch("a");
        Touch touch2 = new Touch("b");
        Touch touch3 = new Touch("c");
        Touch touch4 = new Touch("d");
        touch4.touch(timeLRUMap);
        LRUManager.sleep(1);
        touch3.touch(timeLRUMap);
        LRUManager.sleep(1);
        touch2.touch(timeLRUMap);
        LRUManager.sleep(1);
        touch.touch(timeLRUMap);
        while (testLRUManager.getWorkCount() > 0) {
            testLRUManager.runOnce(testLRUManager.getLRU());
            LRUManager.sleep(1);
        }
        Touch[] touchArray = new Touch[]{touch, touch2, touch3, touch4};
        TestLRUManager testLRUManager2 = new TestLRUManager(10);
        timeLRUMap = testLRUManager2.getLRU();
        testLRUManager2.startWork();
        int n = 256;
        long l = System.currentTimeMillis();
        System.out.println("seed: " + l);
        Random random = new Random(l);
        for (int i = 0; i < n; ++i) {
            int n2;
            if (i > 0 && i % 10 == 0) {
                System.out.println("case " + i);
                System.out.println("LRU: " + timeLRUMap.size() + " - " + timeLRUMap.getMaximumSize());
            }
            Touch touch5 = (n2 = Math.abs(random.nextInt()) % (touchArray.length * 2)) >= touchArray.length ? new Touch("x" + i) : touchArray[n2];
            touch5.touch(timeLRUMap);
            timeLRUMap.checkOrder();
            LRUManager.sleep(1);
        }
        System.out.println("manager1 being interrupted");
        testLRUManager2.getWorker().interrupt();
        try {
            testLRUManager2.getWorker().join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("manager1 thread now stopped");
        testLRUManager2.finalRun();
        System.out.println("*** test completed");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LRUMapClassArgTypes = new Class[]{Integer.TYPE, class$cerent$util$SDebug == null ? (class$cerent$util$SDebug = LRUManager.class$("cerent.util.SDebug")) : class$cerent$util$SDebug};
    }

    public class Debug
    extends SDebug {
        public Debug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        public Debug(String string) {
            super(string);
        }

        public final void dump() {
            Object object;
            List list;
            Object object2;
            int n;
            Iterator iterator;
            WorkerThread workerThread = LRUManager.this.worker;
            boolean bl = workerThread == null ? false : workerThread.isAlive();
            this.println(bl ? "running" : "stopped");
            TimeLRUMap timeLRUMap = LRUManager.this.getLRU();
            if (timeLRUMap != null) {
                long l = TimeLRUMap.timestamp();
                this.println("TimeLRUMap: " + timeLRUMap.size());
                LinkedList linkedList = new LinkedList();
                boolean bl2 = false;
                while (!bl2) {
                    bl2 = true;
                    try {
                        iterator = timeLRUMap.iterator();
                        n = 0;
                        while (iterator.hasNext()) {
                            object2 = iterator.next();
                            linkedList.add(object2);
                            ++n;
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        bl2 = false;
                        try {
                            Thread.sleep(1000L);
                            break;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break;
                        }
                    }
                }
                iterator = linkedList.iterator();
                n = 0;
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    long l2 = timeLRUMap.getTimeStamp(object2);
                    long l3 = l2 == 0L ? 0L : l - l2;
                    this.println("" + n + "/" + l3 + " msecs - " + object2.toString());
                    ++n;
                }
                list = timeLRUMap.getToBeProcessed();
            } else {
                this.println("TimeLRUMap: null");
                list = null;
            }
            int n2 = list == null ? 0 : list.size();
            this.println("toBeProcessedList: " + n2);
            iterator = list.iterator();
            n = 0;
            while (iterator.hasNext()) {
                object = iterator.next();
                this.println("" + n + " - " + object.toString());
                ++n;
            }
            if (timeLRUMap != null) {
                if (timeLRUMap instanceof SequenceNumberLRUMap) {
                    object = (SequenceNumberLRUMap)timeLRUMap;
                    object2 = ((SequenceNumberLRUMap)((Object)object)).prettyString("*** SequenceNumberLRUMap");
                    this.println((String)object2);
                } else {
                    this.println("LRU class: " + ((Object)((Object)timeLRUMap)).getClass().getName());
                }
            }
        }
    }

    static class TestLRUMap
    extends TimeLRUMap {
        public TestLRUMap(int n, int n2, int n3) {
            super(n, n2, n3, null);
        }

        public int getResolution() {
            return 1;
        }
    }

    static class TestLRUManager
    extends LRUManager {
        public TestLRUManager() {
            super(new TestLRUMap(1, 1, 1), null, new SDebug("LRUManager"));
        }

        public TestLRUManager(int n) {
            super(new TestLRUMap(n, 10, 10), null, new SDebug("LRUManager"));
        }

        protected void process(Object object) {
            long l;
            int n;
            TimeLRUMap timeLRUMap;
            int n2;
            Touch touch = (Touch)object;
            long l2 = touch.getTime();
            if (l2 + (long)((n2 = (timeLRUMap = this.getLRU()).getAgeCapacity()) * (n = timeLRUMap.getResolution())) > (l = System.currentTimeMillis())) {
                throw new IllegalStateException("LRU didn't hold " + touch + " long enough");
            }
            System.out.println(touch);
        }
    }

    static class Touch {
        private String name;
        private long initialTime;
        private long time;

        public Touch(String string) {
            if (string == null) {
                string = "";
            }
            this.name = string;
            this.initialTime = TimeLRUMap.timestamp();
        }

        private void touch(TimeLRUMap timeLRUMap) {
            this.time = TimeLRUMap.timestamp();
            timeLRUMap.touch(this, this.time);
        }

        public long getTime() {
            return this.time;
        }

        public String toString() {
            String string = this.name + " " + Touch.seconds(this.time) + " (" + Touch.seconds(this.initialTime) + ")";
            return string;
        }

        public static long seconds(long l) {
            return TimeLRUMap.seconds(l);
        }

        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = bl = this == object;
            if (!bl && object instanceof Touch) {
                bl = this.name.equals(((Touch)object).name);
            }
            return bl;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    class WorkerThread
    extends Thread {
        public WorkerThread(String string) {
            super(string);
            if (LRUManager.this.db.on()) {
                LRUManager.this.db.println("model state LRU mgmt start requested...");
            }
            this.start();
            if (LRUManager.this.db.on()) {
                LRUManager.this.db.println("model state LRU mgmt started...");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = true;
            while (!LRUManager.this.doStop() && !this.isInterrupted()) {
                try {
                    if (!bl) {
                        Thread.sleep(LRUManager.this.getSleepTime());
                    } else {
                        bl = false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!LRUManager.this.db.on()) break;
                    LRUManager.this.db.println("model state LRU mgmt interrupted...");
                    break;
                }
                LRUManager.this._runOnce(LRUManager.this.lru, true);
                LRUManager.this.passCount++;
            }
            if (LRUManager.this.doStop() && LRUManager.this.lru != null) {
                LRUManager.this.lru.removeAll();
                LRUManager.this._runOnce(LRUManager.this.lru, false);
                LRUManager.this.setLRU(null);
            }
            if (LRUManager.this.db.on()) {
                LRUManager.this.db.println("model state LRU mgmt stopped...");
            }
            Object object = LRUManager.this.getInternalLock();
            synchronized (object) {
                LRUManager.this.isSelfRunning = false;
                LRUManager.this.notifyAll();
            }
        }
    }

    public static abstract class AbstractLRUObjectHandler
    implements LRUObjectHandler {
        public boolean equals(Object object) {
            boolean bl;
            boolean bl2 = bl = object != null && object instanceof LRUObjectHandler;
            if (bl) {
                bl = object == this;
            }
            return bl;
        }
    }

    public static interface LRUObjectHandler {
        public static final int OK = 0;
        public static final int UNEXPECTED_INPUT = 1;
        public static final int ERROR = 2;
        public static final int CANT_HANDLE = 3;

        public int handleLRUObject(Object var1, Long var2);
    }
}

