/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.SonetTopology.SonetFactory;
import cerent.cms.idl.SonetTopology.VtAdit;
import cerent.cms.idl.SonetTopology.sVtAditItem;
import cerent.cms.idl.SonetTopology.xNoSuchConnection;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.Connections;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.LoAditModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PoolModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class LoAdits
extends Connections
implements Observer {
    private static final String MY_DEBUG_KEY = "LoAdits";
    ConnectionModelsDelegate container;
    NodeModelDelegate node;
    GetVtAdits getVtAdits;
    GetConnectionObjIndex getConnectionObjIndex;
    GetVtAditList getVtAditList;
    GetVtAditIndexes getVtAditIndexes;
    GetVtAditItem getVtAditItem;
    private EventDispatcher dispatcher;
    private LoAditDebug db;

    public LoAdits(ConnectionModelsDelegate connectionModelsDelegate) {
        this.container = connectionModelsDelegate;
        this.node = connectionModelsDelegate.node;
        this.db = new LoAditDebug(this.node.db);
        this.getVtAdits = new GetVtAdits(this.node, "LoAdits.getVtAdits");
        this.getConnectionObjIndex = new GetConnectionObjIndex(this.node, "LoAdits.getConnectionObjIndex");
        this.getVtAditList = new GetVtAditList(this.node, "LoAdits.getVtAditList");
        this.getVtAditIndexes = new GetVtAditIndexes(this.node, "LoAdits.getVtAditIndexes");
        this.getVtAditItem = new GetVtAditItem(this.node, "LoAdits.getVtAditItem");
        this.dispatcher = null;
    }

    private SonetFactory getSonetFactoryRef() {
        return this.container.getSonetFactoryRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectStsConnectionList, 0, (Observer)this);
        }
        LoAdits loAdits = this;
        synchronized (loAdits) {
            this.discover(this.connectionModels);
            Iterator iterator = this.connectionModels.values().iterator();
            while (iterator.hasNext()) {
                ((LoAditModel)iterator.next()).init();
            }
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectStsConnectionList, 0, (Observer)this);
        }
        super.dispose();
    }

    public void update(Observable observable, Object object) {
        int n = ((IObjectMessageInfo)object).getUpdateType();
        switch (n) {
            case 1: {
                if (this.db.on) {
                    this.db.println("Got a Changed Message for LoAdits");
                }
                this.container.updateLocal();
                break;
            }
            case 2: {
                if (this.db.on) {
                    this.db.println("Got an UpdateStructure Message for VtAdit");
                }
                if (!this.updateVtAditStructure()) break;
                if (this.db.on) {
                    this.db.println("Going to notify about update");
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.ADDED);
                break;
            }
            case 0: {
                break;
            }
            default: {
                String string = "Unknown update message (" + n + ") on LoAdits";
                this.db.println(string);
                LoAditDebug.printStackTrace((Throwable)new IllegalArgumentException(string));
            }
        }
    }

    public Collection getConnectionModels() {
        return this.connectionModels.values();
    }

    protected boolean updateStructure() {
        return this.updateVtAditStructure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LoAditModel add(VtAdit vtAdit) {
        LoAditModel loAditModel = null;
        if (vtAdit == null) {
            return null;
        }
        LoAdits loAdits = this;
        synchronized (loAdits) {
            block13: {
                loAditModel = this.findLoAditModel(vtAdit);
                if (loAditModel == null) {
                    try {
                        Integer n;
                        block12: {
                            loAditModel = new LoAditModel(this.node, vtAdit, (Connections)this);
                            n = new Integer(loAditModel.getObjIndex());
                            try {
                                loAditModel.setAttributes(this.getVtAditItem(n));
                            }
                            catch (xNoSuchConnection xNoSuchConnection2) {
                                if (!this.db.on) break block12;
                                this.db.println("Caught noSuchConnection ");
                                LoAditDebug.printStackTrace((Throwable)((Object)xNoSuchConnection2));
                            }
                        }
                        loAditModel.init();
                        this.connectionModels.put(n, loAditModel);
                        this.setChanged();
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (this.db.on()) {
                            this.db.println("Exception in add-vtAdit " + (Object)((Object)abstractCmsIOException));
                            this.printStackTrace((Exception)((Object)abstractCmsIOException));
                        }
                        if (loAditModel == null) break block13;
                        loAditModel.dispose();
                        loAditModel = null;
                    }
                }
            }
        }
        if (loAditModel != null) {
            if (this.db.on) {
                this.db.println("marking Pools dirty ");
            }
            loAditModel.markPoolDirty();
        }
        this.notifyObservers(ModelUpdateType.ADDED);
        return loAditModel;
    }

    public synchronized LoAditModel findLoAditModel(sCircuitId sCircuitId2) {
        return (LoAditModel)this.findConnectionModel(this.connectionModels.values(), sCircuitId2);
    }

    private void discover(Map map) {
        sVtAditItem[] sVtAditItemArray = this.getVtAditItems();
        if (sVtAditItemArray == null) {
            this.db.println("Error in getting Vt Adits (null) ConnectionModels::discover");
            return;
        }
        for (int i = 0; i < sVtAditItemArray.length; ++i) {
            if (sVtAditItemArray[i] == null) continue;
            Integer n = new Integer(sVtAditItemArray[i].objIndex);
            map.put(n, new LoAditModel(this.node, sVtAditItemArray[i], (Connections)this));
        }
    }

    private sVtAditItem[] getVtAditItems() {
        sVtAditItem[] sVtAditItemArray;
        try {
            sVtAditItemArray = (sVtAditItem[])this.getVtAditList.get();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println("Error in getting LoAdits " + (Object)((Object)abstractCmsIOException));
            LoAditDebug.printStackTrace((Throwable)abstractCmsIOException);
            return null;
        }
        catch (UserException userException) {
            LoAditDebug.printStackTrace((Throwable)userException);
            return null;
        }
        return sVtAditItemArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoAditModel findLoAditModel(VtAdit vtAdit) {
        Object var2_2 = null;
        if (vtAdit != null) {
            try {
                LoAdits loAdits = this;
                synchronized (loAdits) {
                    Object object;
                    Iterator iterator = this.connectionModels.values().iterator();
                    while (iterator.hasNext()) {
                        object = (LoAditModel)iterator.next();
                        if (!vtAdit._is_equivalent(((LoAditModel)object).getVtAditRef())) continue;
                        if (this.db.on) {
                            this.db.println("Found LoAdit using _is_equivalent");
                        }
                        return object;
                    }
                    if (this.db.on) {
                        this.db.println("Cannot find VtAdit using _is_equivalent");
                    }
                    object = (Integer)this.getConnectionObjIndex.get(vtAdit);
                    var2_2 = this.connectionModels.get(object);
                }
            }
            catch (UserException userException) {
                LoAditDebug.printStackTrace((Throwable)userException);
            }
        }
        if (var2_2 == null && this.db.on()) {
            this.db.println("Could not find the VtAdit in the cache ");
        }
        return var2_2;
    }

    private void discoverVtAditItems(HashMap hashMap) {
        sVtAditItem[] sVtAditItemArray = this.getVtAditItems();
        if (sVtAditItemArray == null) {
            return;
        }
        for (int i = 0; i < sVtAditItemArray.length; ++i) {
            hashMap.put(new Integer(sVtAditItemArray[i].objIndex), sVtAditItemArray[i]);
        }
    }

    private synchronized boolean updateVtAditStructure() {
        Object object;
        Object object2;
        if (this.db.on()) {
            this.db.println("Entry:: ConnectionModels::updateVtAditStructure");
        }
        Collection collection = null;
        boolean bl = false;
        collection = this.getVtAditIndexes();
        if (collection == null) {
            this.db.println("Got no VtAditIndexes from Node .. returning ..");
            return bl;
        }
        Collection collection2 = LoAdits.getAddedObjects(collection, this.connectionModels.keySet());
        Iterator iterator = collection2.iterator();
        if (collection2.size() > 0) {
            if (this.db.on()) {
                this.db.println("Vt Adit found # " + collection2.size());
            }
            while (iterator.hasNext()) {
                object2 = null;
                object = (Integer)iterator.next();
                try {
                    object2 = this.getVtAditItem((Integer)object);
                }
                catch (xNoSuchConnection xNoSuchConnection2) {
                    if (!this.db.on) continue;
                    this.db.println("Caught xNoSuchConnection in LoAdit updateSt..");
                    continue;
                }
                LoAditModel loAditModel = new LoAditModel(this.node, (sVtAditItem)object2, (Connections)this);
                loAditModel.init();
                this.connectionModels.put(object, loAditModel);
            }
            bl = true;
        }
        if ((object2 = LoAdits.getDeletedObjects(collection, this.connectionModels.keySet())).size() > 0) {
            if (this.db.on()) {
                this.db.println("VtAdit Deleted found # " + object2.size());
            }
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (LoAditModel)this.connectionModels.get(iterator.next());
                if (object == null) continue;
                ((ConnectionModel)object).delete();
            }
        }
        if (this.db.on()) {
            this.db.println("Exit:: ConnectionModels::updateVtStructure");
        }
        return bl;
    }

    private Collection getVtAditIndexes() {
        try {
            return this.toCollection((int[])this.getVtAditIndexes.get());
        }
        catch (UserException userException) {
            LoAditDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private sVtAditItem getVtAditItem(Integer n) throws xNoSuchConnection {
        try {
            return (sVtAditItem)this.getVtAditItem.get(n);
        }
        catch (xNoSuchConnection xNoSuchConnection2) {
            throw xNoSuchConnection2;
        }
        catch (UserException userException) {
            LoAditDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILoAditModel[] getAditsInPool(IPoolModel iPoolModel) {
        ILoAditModel[] iLoAditModelArray = null;
        ArrayList<ILoAditModel> arrayList = new ArrayList<ILoAditModel>();
        if (this.db.on) {
            this.db.println("Entering getAditsInPool");
        }
        LoAdits loAdits = this;
        synchronized (loAdits) {
            iLoAditModelArray = this.connectionModels.values().toArray(new ILoAditModel[0]);
        }
        for (int i = 0; i < iLoAditModelArray.length; ++i) {
            try {
                IPoolModel iPoolModel2 = iLoAditModelArray[i].getHo().getPool();
                if (!iPoolModel.equals(iPoolModel2) && !((PoolModel)iPoolModel).isSharedPool(iPoolModel2)) continue;
                if (this.db.on) {
                    this.db.println("Found Adit to add " + iLoAditModelArray[i]);
                }
                arrayList.add(iLoAditModelArray[i]);
                continue;
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (this.db.on()) {
                    this.db.println("CmsObjectNotExistException in " + iLoAditModelArray[i]);
                }
                if (!this.db.on()) continue;
                LoAditDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
            }
        }
        if (this.db.on) {
            this.db.println("Exiting getAditsInPool found " + arrayList.size());
        }
        return arrayList.toArray(new ILoAditModel[0]);
    }

    public class LoAditDebug
    extends SDebug {
        LoAditDebug(SDebug sDebug) {
            super((KDebug)sDebug, LoAdits.MY_DEBUG_KEY);
        }

        public final void update() {
            LoAdits.this.updateVtAditStructure();
        }

        public final void printConnections() {
            LoAdits.this.db.println("Printing List of LoAdits \n");
            LoAdits.this.printConnectionString(this);
        }
    }

    private class GetVtAditItem
    extends NonCachedValue {
        public GetVtAditItem(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return LoAdits.this.getSonetFactoryRef().getVtAditItem((Integer)object);
        }

        public Object outer() {
            return LoAdits.this;
        }
    }

    private class GetVtAditIndexes
    extends NonCachedValue {
        public GetVtAditIndexes(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            if (((LoAdits)LoAdits.this).db.on) {
                LoAdits.this.db.println("Calling getVtAditIndexes");
            }
            return LoAdits.this.getSonetFactoryRef().getVtAditIndexes();
        }

        public Object outer() {
            return LoAdits.this;
        }
    }

    private class GetConnectionObjIndex
    extends NonCachedValue {
        public GetConnectionObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue(Object object) throws UserException {
            int n = ((VtAdit)object).objIndex();
            return new Integer(n);
        }

        public Object outer() {
            return LoAdits.this;
        }
    }

    private class GetVtAdits
    extends NonCachedValue {
        public GetVtAdits(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return LoAdits.this.getSonetFactoryRef().getVtAdits();
        }

        public Object outer() {
            return LoAdits.this;
        }
    }

    private class GetVtAditList
    extends NonCachedValue {
        public GetVtAditList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return LoAdits.this.getSonetFactoryRef().getVtAditList();
        }

        public Object outer() {
            return LoAdits.this;
        }
    }
}

