/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ML2EtherLineModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;

public class ML2EtherPortModel
extends PortModel {
    public ML2EtherPortModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2);
        this.index = n;
    }

    public void init() {
        super.init();
    }

    public ML2EtherLineModel getLineModel() {
        return (ML2EtherLineModel)this.getInterfaceModel();
    }

    public String toString() {
        return "ML2Map" + super.toString();
    }

    public boolean isInLoopback() {
        return this.getLineModel().getLoopbackAsInt() != 0;
    }

    public boolean supportsMonitorCircuits() {
        return false;
    }

    public int getServiceStateType() throws NoSuchInterface {
        try {
            return this.getLineModel().getML2EtherLineInfo().linkUp ? 100 : 101;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            return 101;
        }
    }

    public boolean supportsSplitRouting() {
        return true;
    }

    public boolean isInMapperMode() {
        try {
            return ((ML2ModuleModel)this.getModuleModel()).isInMapperMode();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return true;
        }
    }

    public int getPort() {
        IEntityModel iEntityModel = this.getParent();
        int n = this.getPositionInParent();
        if (iEntityModel.getEqType() == 163 || iEntityModel.getEqType() == 187) {
            n -= 14;
        } else if (iEntityModel.getEqType() == 164) {
            n -= 15;
        }
        return n;
    }
}

