/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eModuleOp;
import cerent.cms.idl.Equipment.eProtectionState;
import cerent.cms.idl.Equipment.xAlreadyLocked;
import cerent.cms.idl.Equipment.xBusy;
import cerent.cms.idl.Equipment.xDuplexLocked;
import cerent.cms.idl.Equipment.xDuplexUnlocked;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.Equipment.xInvalidState;
import cerent.cms.idl.Equipment.xNotSupportedOnEquipment;
import cerent.cms.idl.Equipment.xProtectActive;
import cerent.cms.idl.Equipment.xProtectFailedOrMissing;
import cerent.cms.idl.Equipment.xProtectLocked;
import cerent.cms.idl.Equipment.xProvisionError;
import cerent.cms.idl.Equipment.xUnsupportedOperMode;
import cerent.cms.idl.Equipment.xWorkingFailedOrMissing;
import cerent.cms.idl.Equipment.xWorkingLocked;
import cerent.cms.idl.SonetTopology.sBlsrProvision;
import cerent.cms.idl.Synchronization.eRef;
import cerent.cms.idl.Synchronization.sInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AlreadyLocked;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.DeletionToken;
import cerent.cms.model.DuplexLocked;
import cerent.cms.model.DuplexUnlocked;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.HoCircuitPartModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModelPersistenceStrategy;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITermConnectionModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InterfaceModelTypeUtil;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LRUManager;
import cerent.cms.model.MfgPortModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PathTraceInfo;
import cerent.cms.model.PathTraceTable;
import cerent.cms.model.PersistenceException;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.ProtectActive;
import cerent.cms.model.ProtectFailedOrMissing;
import cerent.cms.model.ProtectLocked;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.UnsupportedCardOperMode;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WorkingFailedOrMissing;
import cerent.cms.model.WorkingLocked;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.EnumStrings;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.PathTraceUtil;
import cerent.util.SDebug;
import cerent.util.TimeLRUMap;
import cerent.util.id.INetwideModelTypeIdentity;
import cerent.util.id.ModelIdentityFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.UserException;

public class ModuleModel
extends PluggableModel
implements IModuleModel {
    private static final String PROP_CTC = "ctc";
    private ProtectionGroupModel protectionGroupModel = null;
    private ProtectionState protectionState = new ProtectionState("ModuleModel.protectionState");
    private UnprovisionOnExtract unprovisionOnExtract = new UnprovisionOnExtract("ModuleModel.unprovisionOnExtract");
    private ChangeEquipmentType changeEquipmentType = new ChangeEquipmentType(this.node, "ModuleModel.ChangeEquipmentType");
    private ChangeToCarrierEqType changeToCarrierEqType = new ChangeToCarrierEqType(this.node, "ModuleModel.changeToCarrierEqType");
    private SlotsOccupied slotsOccupied = new SlotsOccupied("ModuleModel.slotsOcupied");
    private CardOperMode cardOperMode;
    private CardOperModeList cardOperModeList;
    private SetPortGroupState setPortGroupState = new SetPortGroupState("ModuleModel.setPortGroupState");
    private IsPortGroupStateClosed isPortGroupStateClosed = new IsPortGroupStateClosed("ModuleModel.isPortGroupStateClosed");
    protected LastInterfaceChange lastInterfaceChange = new LastInterfaceChange(this.node, "ModuleModel.getLastInterfaceChange");
    private boolean interfacesInited = false;
    static /* synthetic */ Class class$cerent$cms$model$AbstractPersistableModelState;
    static /* synthetic */ Class class$cerent$cms$idl$Equipment$eProtectionState;
    static /* synthetic */ Class class$cerent$cms$idl$Equipment$eModuleOp;
    static /* synthetic */ Class class$cerent$cms$model$InterfaceModel;

    public ModuleModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        this(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(class$cerent$cms$model$AbstractPersistableModelState == null ? (class$cerent$cms$model$AbstractPersistableModelState = ModuleModel.class$("cerent.cms.model.AbstractPersistableModelState")) : class$cerent$cms$model$AbstractPersistableModelState));
    }

    public ModuleModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2, SDebug sDebug) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, sDebug);
        this.cardOperMode = new CardOperMode("ModuleModel.cardOperMode");
        this.cardOperModeList = new CardOperModeList("ModuleModel.cardOperModeList");
    }

    public void init() {
        IModelPersistenceStrategy iModelPersistenceStrategy;
        if (this.db.on()) {
            this.db.println("init(): entry " + this);
            this.db.println("interfaces are inited Yes/No (true/false)" + this.interfacesInited);
        }
        super.init();
        if (this.db.on()) {
            this.db.println("init(): exit " + this);
        }
        if ((iModelPersistenceStrategy = this.getIFPersistenceStrategy()).doesGetReallyPersisted(null) && !this.doesIfSequenceNumberMatch()) {
            this.deleteIfPersistedState();
        }
    }

    public ProtectionGroupModel getProtectionGroupModel() {
        if (this.db.on()) {
            this.db.println("getProtectionGroupModel(): " + this.protectionGroupModel);
        }
        return this.protectionGroupModel;
    }

    public boolean isProtectModule() {
        if (this.isHdElectricalCard()) {
            int n = this.getSlot();
            return n == 3 || n == 15;
        }
        return this.protectionGroupModel != null && this.protectionGroupModel.getProtectModuleModel() == this;
    }

    public void setProtectionGroupModel(ProtectionGroupModel protectionGroupModel) {
        if (this.db.on()) {
            this.db.println("setProtectionGroupModel(" + protectionGroupModel + ")");
            if (this.protectionGroupModel != null && protectionGroupModel != null) {
                this.db.println("\nWARNING: setProtectionGroupModel(): Attempting to set a new value atop an existing value.\n");
            } else if (this.protectionGroupModel == null && protectionGroupModel == null) {
                this.db.println("\n\nCAUTION: setProtectionGroupModel(): Attempting to remove a ProtectionGroupModel\n(by setting it to null) when there is no\nProtectionGroupModel to remove (i.e., it's\nalready null).\n");
            }
        }
        this.protectionGroupModel = protectionGroupModel;
        this.setChanged();
        if (this.db.on()) {
            this.db.println("setProtectionGroupModel():  Will notifyObservers(CHANGED)");
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public eProtectionState getProtectionState() {
        try {
            eProtectionState eProtectionState2 = (eProtectionState)this.protectionState.get();
            if (this.db.on()) {
                this.db.println("getProtectionState(): " + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Equipment$eProtectionState == null ? (class$cerent$cms$idl$Equipment$eProtectionState = ModuleModel.class$("cerent.cms.idl.Equipment.eProtectionState")) : class$cerent$cms$idl$Equipment$eProtectionState))[eProtectionState2.value()]);
            }
            return eProtectionState2;
        }
        catch (UserException userException) {
            throw this.doUnknown("getProtectionState", userException);
        }
    }

    public boolean isUnprovisionOnExtract() {
        try {
            boolean bl = (Boolean)this.unprovisionOnExtract.get();
            if (this.db.on()) {
                this.db.println("isUnprovisionedOnExtract(): " + (bl ? "true" : "false"));
            }
            return bl;
        }
        catch (UserException userException) {
            throw this.doUnknown("isUnprovisionOnExtract", userException);
        }
    }

    public void setPortGroupState(short s, boolean bl) throws UnsupportedOperation, ProvisionError {
        try {
            if (this.db.on()) {
                this.db.println("setPortGroupState() for portGroupNum=" + s + " isPortClosed=" + bl);
            }
            Object[] objectArray = new Object[]{new Integer(s), new Boolean(bl)};
            this.setPortGroupState.set(objectArray);
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new UnsupportedOperation((UserException)xNotSupportedOnEquipment2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setPortGroupState", userException);
        }
    }

    public boolean isPortGroupStateClosed(short s) throws UnsupportedOperation, ProvisionError {
        try {
            if (this.db.on()) {
                this.db.println("isPortGroupStateClosed() for portGroupNum=" + s);
            }
            return (Boolean)this.isPortGroupStateClosed.get(new Integer(s));
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new UnsupportedOperation((UserException)xNotSupportedOnEquipment2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("isPortGroupStateClosed", userException);
        }
    }

    public boolean isValidPGElectricalCard() {
        return this.getEqType() == 65 || this.getEqType() == 66 || this.getEqType() == 67;
    }

    public boolean isHdElectricalCard() {
        return this.getEqType() == 185;
    }

    public boolean isOpticsCard() {
        return false;
    }

    public void doCommand(eModuleOp eModuleOp2) throws ProtectFailedOrMissing, WorkingFailedOrMissing, AlreadyLocked, ProtectLocked, WorkingLocked, ProtectActive, InvalidState, DuplexLocked, DuplexUnlocked, ProvisionError, Busy {
        try {
            if (this.db.on()) {
                this.db.println("doCommand(): " + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Equipment$eModuleOp == null ? (class$cerent$cms$idl$Equipment$eModuleOp = ModuleModel.class$("cerent.cms.idl.Equipment.eModuleOp")) : class$cerent$cms$idl$Equipment$eModuleOp))[eModuleOp2.value()] + " for " + Integer.toHexString(this.getEntityIndex()));
            }
            this.protectionState.set(eModuleOp2);
        }
        catch (xProtectFailedOrMissing xProtectFailedOrMissing2) {
            throw new ProtectFailedOrMissing((UserException)xProtectFailedOrMissing2);
        }
        catch (xWorkingFailedOrMissing xWorkingFailedOrMissing2) {
            throw new WorkingFailedOrMissing((UserException)xWorkingFailedOrMissing2);
        }
        catch (xAlreadyLocked xAlreadyLocked2) {
            throw new AlreadyLocked((UserException)xAlreadyLocked2);
        }
        catch (xProtectLocked xProtectLocked2) {
            throw new ProtectLocked((UserException)xProtectLocked2);
        }
        catch (xWorkingLocked xWorkingLocked2) {
            throw new WorkingLocked((UserException)xWorkingLocked2);
        }
        catch (xProtectActive xProtectActive2) {
            throw new ProtectActive((UserException)xProtectActive2);
        }
        catch (xInvalidState xInvalidState2) {
            throw new InvalidState((UserException)xInvalidState2);
        }
        catch (xDuplexLocked xDuplexLocked2) {
            throw new DuplexLocked((UserException)xDuplexLocked2);
        }
        catch (xDuplexUnlocked xDuplexUnlocked2) {
            throw new DuplexUnlocked((UserException)xDuplexUnlocked2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (UserException userException) {
            throw this.doUnknown("doCommand", userException);
        }
    }

    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("updateLocal(): entry");
        }
        this.protectionState.update();
        this.unprovisionOnExtract.update();
        this.cardOperMode.update();
        this.setChanged();
        super.updateLocal();
        if (this.db.on()) {
            this.db.println("updateLocal(): exit");
        }
    }

    protected final void deleteIfPersistedState() {
        IModelPersistenceStrategy iModelPersistenceStrategy = this.getIFPersistenceStrategy();
        if (!iModelPersistenceStrategy.doesGetReallyPersisted(class$cerent$cms$model$InterfaceModel == null ? (class$cerent$cms$model$InterfaceModel = ModuleModel.class$("cerent.cms.model.InterfaceModel")) : class$cerent$cms$model$InterfaceModel)) {
            return;
        }
        int n = this.getNmd().getPersistenceId();
        short s = this.getSlotNum();
        ModuleModel.deleteIfPersistedState(this.db, iModelPersistenceStrategy, n, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void enqueueDeleteIfPersistedState() {
        IModelPersistenceStrategy iModelPersistenceStrategy = this.getIFPersistenceStrategy();
        if (!iModelPersistenceStrategy.doesGetReallyPersisted(class$cerent$cms$model$InterfaceModel == null ? (class$cerent$cms$model$InterfaceModel = ModuleModel.class$("cerent.cms.model.InterfaceModel")) : class$cerent$cms$model$InterfaceModel)) {
            return;
        }
        int n = this.getNmd().getPersistenceId();
        short s = this.getSlotNum();
        INetwideModelTypeIdentity iNetwideModelTypeIdentity = ModuleModel.getNetwideModelTypeIdentity(n, s);
        DeletionToken deletionToken = new DeletionToken(iNetwideModelTypeIdentity, iModelPersistenceStrategy);
        LRUManager lRUManager = (LRUManager)this.getNmd().getNodeAdapter().getLRUManager();
        if (lRUManager != null) {
            TimeLRUMap timeLRUMap = null;
            LRUManager lRUManager2 = lRUManager;
            synchronized (lRUManager2) {
                timeLRUMap = lRUManager.getLRU();
            }
            if (timeLRUMap != null) {
                timeLRUMap.touch(deletionToken);
            }
        }
    }

    static final void deleteIfPersistedState(SDebug sDebug, IModelPersistenceStrategy iModelPersistenceStrategy, int n, short s) {
        block3: {
            INetwideModelTypeIdentity iNetwideModelTypeIdentity = ModuleModel.getNetwideModelTypeIdentity(n, s);
            try {
                if (sDebug.on()) {
                    sDebug.println("about to delete all persisted state for slot: " + s);
                }
                iModelPersistenceStrategy.deletePartition(iNetwideModelTypeIdentity);
            }
            catch (PersistenceException persistenceException) {
                if (!sDebug.on()) break block3;
                sDebug.println("DB partition delete for " + iNetwideModelTypeIdentity + " failed w/ err: " + (Object)((Object)persistenceException));
            }
        }
    }

    protected void deleteLocal() {
        this.enqueueDeleteIfPersistedState();
    }

    public void dispose() {
        this.protectionState.dispose();
        this.unprovisionOnExtract.dispose();
        this.cardOperMode.dispose();
        this.setInterfacesInited(false);
        super.dispose();
    }

    public HashMap getChildrenEqTypes() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            int n = ((EntityModel)iterator.next()).getEqType();
            Integer n2 = new Integer(n);
            if (!hashMap.containsKey(n2)) {
                hashMap.put(n2, new Integer(1));
                continue;
            }
            Integer n3 = (Integer)hashMap.remove(n2);
            int n4 = n3;
            hashMap.put(n2, new Integer(++n4));
        }
        return hashMap;
    }

    public boolean isComboModule() {
        return false;
    }

    public boolean isInProtectionGroup() {
        boolean bl = false;
        if (this.isProtectModule()) {
            bl = true;
        } else {
            PortModel[] portModelArray = this.getPortModels();
            for (int i = 0; !bl && i < portModelArray.length; ++i) {
                if (portModelArray[i] instanceof TdmPortModel) {
                    bl = ((TdmPortModel)portModelArray[i]).hasOpticalProtection();
                    continue;
                }
                if (!(portModelArray[i] instanceof DwdmPortModel)) continue;
                DwdmPortModel dwdmPortModel = (DwdmPortModel)portModelArray[i];
                bl = dwdmPortModel.hasYCableProtection() && dwdmPortModel.isClientPort();
            }
        }
        return bl;
    }

    public boolean isSupportingSDCC() {
        boolean bl = false;
        ITermConnectionModel iTermConnectionModel = this.getNodeModelDelegate().getDccTermConnectionModel();
        PortModel[] portModelArray = this.getPortModels();
        for (int i = 0; !bl && i < portModelArray.length; ++i) {
            bl = iTermConnectionModel.entityExistsInTerminations((IEntityModel)portModelArray[i]);
        }
        return bl;
    }

    public boolean isSupportingGCC() {
        boolean bl = false;
        ITermConnectionModel iTermConnectionModel = this.getNodeModelDelegate().getGccTermConnectionModel();
        PortModel[] portModelArray = this.getPortModels();
        for (int i = 0; !bl && i < portModelArray.length; ++i) {
            bl = iTermConnectionModel.entityExistsInTerminations((IEntityModel)portModelArray[i]);
        }
        return bl;
    }

    public boolean isSupportingLDCC() {
        boolean bl = false;
        ITermConnectionModel iTermConnectionModel = this.getNodeModelDelegate().getLdccTermConnectionModel();
        PortModel[] portModelArray = this.getPortModels();
        for (int i = 0; !bl && i < portModelArray.length; ++i) {
            bl = iTermConnectionModel.entityExistsInTerminations((IEntityModel)portModelArray[i]);
        }
        return bl;
    }

    public boolean isTimingSource() {
        return this.isTimingSource(eRef.NE);
    }

    public boolean isEXT_1TimingSource() {
        return this.isTimingSource(eRef.EXT_1);
    }

    public boolean isEXT_2TimingSource() {
        return this.isTimingSource(eRef.EXT_2);
    }

    public boolean isTimingSource(eRef eRef2) {
        boolean bl = false;
        sInfo[] sInfoArray = this.getNodeModelDelegate().getSynchronizationModel().getRefSources(eRef2);
        PortModel[] portModelArray = this.getPortModels();
        for (int i = 0; !bl && i < portModelArray.length; ++i) {
            for (int j = 0; !bl && j < sInfoArray.length; ++j) {
                bl = portModelArray[i].getEntityIndex() == sInfoArray[j].line;
            }
        }
        return bl;
    }

    public boolean isCardNamed(String string) {
        return this.getMfgData().name.equals(string);
    }

    public boolean hasCircuits() {
        boolean bl = false;
        PortModel[] portModelArray = this.getPortModels();
        for (int i = 0; !bl && i < portModelArray.length; ++i) {
            bl = !portModelArray[i].getConnectionsList().isEmpty();
        }
        return bl;
    }

    public boolean hasOhCircuits() {
        return false;
    }

    public boolean isSupportingBLSR() {
        boolean bl = false;
        Set set = this.getNodeModelDelegate().getElementModelsDelegate().getBlsrElements();
        BlsrModel[] blsrModelArray = set.toArray(new BlsrModel[set.size()]);
        PortModel[] portModelArray = this.getPortModels();
        for (int i = 0; !bl && i < portModelArray.length; ++i) {
            for (int j = 0; !bl && j < blsrModelArray.length; ++j) {
                sBlsrProvision sBlsrProvision2 = blsrModelArray[j].getProvision();
                int n = portModelArray[i].getEntityIndex();
                bl = n == sBlsrProvision2.eastPort || n == sBlsrProvision2.westPort || n == sBlsrProvision2.eastProtectPort || n == sBlsrProvision2.westProtectPort;
            }
        }
        return bl;
    }

    public void changeEqType(int n) throws ProvisionError, ResourceInUse {
        try {
            this.changeEquipmentType.set(eEqType.from_int(n));
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse("Resources still in use.");
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError("New type is invalid or incompatible.");
        }
        catch (UserException userException) {
            throw this.doUnknown("changeEqType", userException);
        }
    }

    public void changeToCarrierEqType(int n, int[] nArray) throws ProvisionError, ResourceInUse {
        try {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = new Object[nArray.length];
            objectArray[0] = eEqType.from_int(n);
            for (int i = 0; i < nArray.length; ++i) {
                objectArray2[i] = eEqType.from_int(nArray[i]);
            }
            this.changeToCarrierEqType.set(objectArray);
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse("Resources still in use.");
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError("New type is invalid or incompatible.");
        }
        catch (UserException userException) {
            throw this.doUnknown("changeToCarrierEqType", userException);
        }
    }

    public int getSlotsOccupied() {
        int n = 1;
        try {
            n = (Integer)this.slotsOccupied.get();
            if (this.db.on()) {
                this.db.println("getSlotsOccupied(): " + n);
            }
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            if (this.db.on()) {
                this.db.println("NE doesn't support getSlotsOccupied operation");
            }
        }
        catch (UserException userException) {
            throw this.doUnknown("getSlotsOccupied", userException);
        }
        return n;
    }

    public IModuleModel getModuleModel() {
        return this;
    }

    public InterfaceModel[] getAllInterfaceModels() {
        return this.node.getIfModels().getAllInterfaceModels(this);
    }

    public String toString() {
        return "Module[" + super.toShortString() + ", " + (this.protectionGroupModel == null ? "unprot'd" : "prot'n=" + this.protectionGroupModel.toString()) + "]";
    }

    public ILoNum getLoNumForPort(int n, int n2) {
        return null;
    }

    public IHoNum getHoNumForPort(int n, int n2) {
        return null;
    }

    public int getPortForPath(ILoNum iLoNum, IHoNum iHoNum) {
        return 0;
    }

    public List getMfgPorts() {
        ArrayList<PortModel> arrayList = new ArrayList<PortModel>();
        PortModel[] portModelArray = this.getPortModels();
        for (int i = 0; i < portModelArray.length; ++i) {
            if (!(portModelArray[i] instanceof MfgPortModel)) continue;
            arrayList.add(portModelArray[i]);
        }
        return arrayList;
    }

    public PathTraceInfo[] getJ1PathTraceInfo() throws CTCUserException {
        return this.getJ1PathTraceInfo(this.getPathTraceLines());
    }

    public List getPortsInGroup(IPortModel iPortModel, int n) {
        ArrayList<IPortModel> arrayList = new ArrayList<IPortModel>();
        arrayList.add(iPortModel);
        return arrayList;
    }

    public PathTraceInfo[] getJ1PathTraceInfo(InterfaceModel[] interfaceModelArray) throws CTCUserException {
        PathTraceInfo[] pathTraceInfoArray = null;
        if (!this.supportsJ1PathTrace(interfaceModelArray)) {
            throw new CTCUserException("Path Trace not supported for ModuleModel with index " + this.getIndex());
        }
        pathTraceInfoArray = new PathTraceTable(this, interfaceModelArray).getJ1PathTraceInfo();
        return pathTraceInfoArray;
    }

    public long getLastInterfaceChange() {
        try {
            return (Long)this.lastInterfaceChange.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getLastInterfaceChange", userException);
        }
    }

    public long getPersistenceLastInterfaceChange() {
        IModelPersistenceStrategy iModelPersistenceStrategy = this.getIFPersistenceStrategy();
        INetwideModelTypeIdentity iNetwideModelTypeIdentity = this.getNetwideModelTypeIdentity();
        long l = -1L;
        try {
            l = iModelPersistenceStrategy.retrieveSequenceNum(iNetwideModelTypeIdentity, l);
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        return l;
    }

    static final INetwideModelTypeIdentity getNetwideModelTypeIdentity(NodeModelDelegate nodeModelDelegate, short s, int n) {
        int n2 = nodeModelDelegate.getPersistenceId();
        return ModuleModel.getNetwideModelTypeIdentity(n2, s, n);
    }

    static final INetwideModelTypeIdentity getNetwideModelTypeIdentity(int n, short s) {
        return ModuleModel.getNetwideModelTypeIdentity(n, s, 0);
    }

    static final INetwideModelTypeIdentity getNetwideModelTypeIdentity(int n, short s, int n2) {
        int n3 = ModuleModel.getModelType(s, n2);
        INetwideModelTypeIdentity iNetwideModelTypeIdentity = ModelIdentityFactory.instance().createNetwideModelTypeIdentity(n, n3);
        return iNetwideModelTypeIdentity;
    }

    protected final INetwideModelTypeIdentity getNetwideModelTypeIdentity() {
        return ModuleModel.getNetwideModelTypeIdentity(this.getNmd(), this.getSlotNum(), 0);
    }

    protected final boolean doesIfSequenceNumberMatch() {
        boolean bl;
        long l;
        long l2;
        block3: {
            INetwideModelTypeIdentity iNetwideModelTypeIdentity = this.getNetwideModelTypeIdentity();
            l2 = this.getLastInterfaceChange();
            IModelPersistenceStrategy iModelPersistenceStrategy = this.getIFPersistenceStrategy();
            l = -2L;
            try {
                l = iModelPersistenceStrategy.retrieveSequenceNum(iNetwideModelTypeIdentity, l);
            }
            catch (PersistenceException persistenceException) {
                if (!this.db.on()) break block3;
                this.db.println("DB retrieve seq # for " + iNetwideModelTypeIdentity + " failed w/ err: " + (Object)((Object)persistenceException));
            }
        }
        boolean bl2 = bl = l == -2L || l2 == l;
        if (!bl && this.db.on()) {
            this.db.println("DB seq #: " + l + " - NE seq #: " + l2);
        }
        return bl;
    }

    protected IModelPersistenceStrategy getIFPersistenceStrategy() {
        return this.getNmd().getModelPersistenceStrategy(class$cerent$cms$model$InterfaceModel == null ? (class$cerent$cms$model$InterfaceModel = ModuleModel.class$("cerent.cms.model.InterfaceModel")) : class$cerent$cms$model$InterfaceModel);
    }

    protected NodeModelDelegate getNmd() {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getNodeModel();
        return nodeModelDelegate;
    }

    int getModelType() {
        return ModuleModel.getModelType(this.getSlotNum(), 0);
    }

    short getSlotNum() {
        IEntityModel iEntityModel = this.getParent();
        return (short)iEntityModel.getPositionInParent();
    }

    int getModelType(int n) {
        return ModuleModel.getModelType(this.getSlotNum(), n);
    }

    static int getModelType(short s, int n) {
        int n2 = InterfaceModelTypeUtil.createInterfaceModelType(s, n);
        return n2;
    }

    public void getAllInterfacesOnCardNoReturn() {
        if (!this.areInterfacesInited()) {
            this.node.getIfModels().getAllInterfaceModels(this);
        }
    }

    public void sendInitNeededNotification() {
        if (this.db.on()) {
            this.db.println("Notify Observers, INIT_NEEDED on slot " + this.getSlot());
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.INIT_NEEDED);
    }

    public synchronized boolean areInterfacesInited() {
        return this.interfacesInited;
    }

    public synchronized void setInterfacesInited(boolean bl) {
        this.interfacesInited = bl;
    }

    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        portModelArray = eEqType2 != null ? this.getDescendantsOfType(eEqType2).toArray(new PortModel[0]) : this.getDescendantsOfClassType(7).toArray(new PortModel[0]);
        return portModelArray == null ? new PortModel[]{} : portModelArray;
    }

    public InterfaceModel[] getLineModels() {
        return this.getLineModels(null);
    }

    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        PortModel[] portModelArray = this.getPortModels(eEqType2);
        ArrayList<InterfaceModel> arrayList = new ArrayList<InterfaceModel>();
        InterfaceModel interfaceModel = null;
        for (int i = 0; i < portModelArray.length; ++i) {
            interfaceModel = (InterfaceModel)portModelArray[i].getInterfaceModel();
            if (interfaceModel == null) continue;
            arrayList.add(interfaceModel);
        }
        return arrayList.toArray(new InterfaceModel[arrayList.size()]);
    }

    public int getBandwidthUsage() {
        int n = 0;
        List list = this.getConnectionsList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ConnectionModel connectionModel = (ConnectionModel)iterator.next();
            if (!(connectionModel instanceof HoCircuitPartModel)) continue;
            HoCircuitPartModel hoCircuitPartModel = (HoCircuitPartModel)connectionModel;
            n += hoCircuitPartModel.getPathWidth();
        }
        return n;
    }

    public InterfaceModel[] getLineInterfaces() {
        return null;
    }

    public eCardOperMode getCardOperMode() {
        try {
            return (eCardOperMode)this.cardOperMode.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getCardOperMode", userException);
        }
    }

    public void setCardOperMode(eCardOperMode eCardOperMode2) throws ProvisionError, UnsupportedCardOperMode, ResourceInUse {
        try {
            this.cardOperMode.set(eCardOperMode2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (xUnsupportedOperMode xUnsupportedOperMode2) {
            throw new UnsupportedCardOperMode((UserException)xUnsupportedOperMode2);
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse("Resources still in use.");
        }
        catch (UserException userException) {
            throw this.doUnknown("setCardOperMode", userException);
        }
    }

    boolean isPortNumUnique(int n) {
        return true;
    }

    public boolean supportsJ1PathTrace(InterfaceModel[] interfaceModelArray) {
        return PathTraceUtil.supportsJ1PathTrace(this);
    }

    public PortModel[] getPortModels() {
        return this.getPortModels(null);
    }

    public InterfaceModel[] getPathTraceLines() {
        return this.getLineModels();
    }

    public boolean supportsAls() {
        return false;
    }

    public boolean supportsClearPM() {
        return true;
    }

    public eCardOperMode[] getCardOperModeList() {
        try {
            return (eCardOperMode[])this.cardOperModeList.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getCardOperModeList", userException);
        }
    }

    public boolean supportsLoopbackAis() {
        return false;
    }

    public boolean supportsTermLoopbackAis(IPortModel iPortModel) {
        return false;
    }

    public void update(Observable observable, Object object) {
        int n = ((IObjectMessageInfo)object).getUpdateType();
        if (n == 1) {
            eEqState eEqState2 = this.getState();
            this.setChanged();
            this.updateLocal();
            eEqState eEqState3 = this.getState();
            if (eEqState2 != eEqState3 && eEqState3 == eEqState.DELETED) {
                this.updateStructure();
                if (this.db.on()) {
                    this.db.println("Card deleted, notifying observers");
                }
                this.deleteLocal();
                this.setChanged();
                this.notifyObservers(ModelUpdateType.DELETED);
            }
        } else {
            super.update(observable, object);
        }
    }

    boolean allowsPortEditing(PpmModel ppmModel) {
        return true;
    }

    public PortModel[] getAlarmablePorts() {
        return this.getPortModels();
    }

    boolean supportXC() {
        switch (this.getEqType()) {
            case 3: 
            case 43: 
            case 59: 
            case 84: 
            case 91: 
            case 107: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsAutoTrace() throws AbstractCmsNoSuchEntityException {
        return false;
    }

    public boolean supportsPhysicalPm() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CardOperModeList
    extends CachedValue {
        public CardOperModeList(String string) {
            super(ModuleModel.this.node, string);
        }

        protected Object getValue() throws UserException {
            return ModuleModel.this.getIModuleRef().getCardOperModeList();
        }

        public Object outer() {
            return ModuleModel.this;
        }
    }

    private class CardOperMode
    extends CachedValue {
        public CardOperMode(String string) {
            super(ModuleModel.this.node, string);
        }

        protected void setValue(Object object) throws UserException {
            ModuleModel.this.getIModuleRef().setCardOperMode((eCardOperMode)object);
        }

        protected Object getValue() throws UserException {
            return ModuleModel.this.getIModuleRef().getCardOperMode();
        }

        public Object outer() {
            return ModuleModel.this;
        }
    }

    private class LastInterfaceChange
    extends NonCachedValue {
        public LastInterfaceChange(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Long(ModuleModel.this.getIModuleRef().lastInterfaceChange());
        }

        public Object outer() {
            return ModuleModel.this;
        }
    }

    private class IsPortGroupStateClosed
    extends NonCachedValue {
        public IsPortGroupStateClosed(String string) {
            super(ModuleModel.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            boolean bl = ModuleModel.this.getIModuleRef().isPortGroupStateClosed(((Integer)object).shortValue());
            return new Boolean(bl);
        }

        public Object outer() {
            return ModuleModel.this;
        }
    }

    private class SetPortGroupState
    extends NonCachedValue {
        public SetPortGroupState(String string) {
            super(ModuleModel.this.node, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            ModuleModel.this.getIModuleRef().setPortGroupState(((Integer)objectArray[0]).shortValue(), (Boolean)objectArray[1]);
        }

        public Object outer() {
            return ModuleModel.this;
        }
    }

    private class SlotsOccupied
    extends CachedValue {
        public SlotsOccupied(String string) {
            super(ModuleModel.this.node, string);
        }

        protected Object getValue() throws UserException {
            return new Integer(ModuleModel.this.getIModuleRef().getSlotsOccupied());
        }
    }

    private class UnprovisionOnExtract
    extends CachedValue {
        public UnprovisionOnExtract(String string) {
            super(ModuleModel.this.node, string);
        }

        protected Object getValue() throws UserException {
            return new Boolean(ModuleModel.this.getIModuleRef().unprovisionOnExtract());
        }

        public Object outer() {
            return ModuleModel.this;
        }
    }

    private class ProtectionState
    extends CachedValue {
        public ProtectionState(String string) {
            super(ModuleModel.this.node, string);
        }

        protected void setValue(Object object) throws UserException {
            ModuleModel.this.getIModuleRef().doCommand((eModuleOp)object);
        }

        protected Object getValue() throws UserException {
            return ModuleModel.this.getIModuleRef().protectionState();
        }

        public Object outer() {
            return ModuleModel.this;
        }
    }

    private class ChangeToCarrierEqType
    extends NonCachedValue {
        public ChangeToCarrierEqType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            eEqType eEqType2 = (eEqType)objectArray[0];
            eEqType[] eEqTypeArray = (eEqType[])objectArray[1];
            ModuleModel.this.getIModuleRef().changeToCarrierEqType(eEqType2, eEqTypeArray);
        }

        public Object outer() {
            return ModuleModel.this;
        }
    }

    private class ChangeEquipmentType
    extends NonCachedValue {
        public ChangeEquipmentType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            ModuleModel.this.getIModuleRef().changeEqType((eEqType)object);
        }

        public Object outer() {
            return ModuleModel.this;
        }
    }
}

