/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Circuits.xInvalidCircuitName;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eEdAdminStateCmd;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.If.xInvalidState;
import cerent.cms.idl.SonetTopology.OchncConnection;
import cerent.cms.idl.SonetTopology.eConnectionType;
import cerent.cms.idl.SonetTopology.sOchncConnectionItem;
import cerent.cms.idl.SonetTopology.sOchncPathDef;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.idl.SonetTopology.xConnectionInLoopback;
import cerent.cms.idl.SonetTopology.xTestAccessActive;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CloneHelper;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.Connections;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.IOpticsModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OchncPathDefModelFactory;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.TestAccessActive;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.UserException;

public class OchncConnectionModel
extends ConnectionModel
implements IOchncConnectionModel {
    private OchncConnection ochncConnectionRef;
    private ObjIndex objIndex;
    private Destroy destroy = null;
    private CircuitId circuitId;
    private ConnectionType connectionType;
    private AdminState adminState;
    private ServiceState serviceState;
    private Paths paths = null;
    private PortEntities portEntities = null;
    private ConnectionName connectionName = null;
    static /* synthetic */ Class class$cerent$cms$model$OchncConnectionModel;

    public OchncConnectionModel(NodeModelDelegate nodeModelDelegate, OchncConnection ochncConnection, Connections connections) {
        super(nodeModelDelegate, connections, nodeModelDelegate.getChildDebug(class$cerent$cms$model$OchncConnectionModel == null ? (class$cerent$cms$model$OchncConnectionModel = OchncConnectionModel.class$("cerent.cms.model.OchncConnectionModel")) : class$cerent$cms$model$OchncConnectionModel));
        this.ochncConnectionRef = ochncConnection;
        this.destroy = new Destroy(nodeModelDelegate, "OchncConnectionModel.destroy");
        this.objIndex = new ObjIndex(nodeModelDelegate, "OchncConnectionModel.objIndex");
        this.circuitId = new CircuitId(nodeModelDelegate, "OchncConnectionModel.circuitId");
        this.connectionType = new ConnectionType(nodeModelDelegate, "OchncConnectionModel.connectionType");
        this.adminState = new AdminState(nodeModelDelegate, "OchncConnectionModel.adminState");
        this.serviceState = new ServiceState(nodeModelDelegate, "OchncConnectionModel.serviceState");
        this.paths = new Paths(nodeModelDelegate, "OchncConnectionModel.paths");
        this.portEntities = new PortEntities(nodeModelDelegate, "OchncConnectionModel.getPortModels");
        this.connectionName = new ConnectionName(nodeModelDelegate, "OchncConnectionModel.connectionName");
    }

    public OchncConnectionModel(NodeModelDelegate nodeModelDelegate, sOchncConnectionItem sOchncConnectionItem2, Connections connections) {
        this(nodeModelDelegate, sOchncConnectionItem2.ochncConn, connections);
        this.setAttributes(sOchncConnectionItem2);
    }

    public void init() {
        super.init();
    }

    public void setAttributes(sOchncConnectionItem sOchncConnectionItem2) {
        this.adminState.setValueExternally(sOchncConnectionItem2.adminState);
        this.serviceState.setValueExternally(sOchncConnectionItem2.serviceState);
        this.circuitId.setValueExternally(sOchncConnectionItem2.circuitId);
        this.connectionName.setValueExternally(sOchncConnectionItem2.name);
        this.connectionType.setValueExternally(sOchncConnectionItem2.connectionType);
        this.objIndex.setValueExternally(new Integer(sOchncConnectionItem2.objIndex));
        this.paths.setValueExternally(sOchncConnectionItem2.paths);
    }

    protected void updateLocal() {
        this.adminState.update();
        this.serviceState.update();
        this.circuitId.update();
        this.connectionType.update();
        this.paths.update();
        this.portEntities.update();
        this.connectionName.update();
        this.setChanged();
        super.updateLocal();
    }

    public void dispose() {
        this.adminState.dispose();
        this.serviceState.dispose();
        this.circuitId.dispose();
        this.connectionType.dispose();
        this.paths.dispose();
        this.portEntities.dispose();
        this.connectionName.dispose();
        super.dispose();
    }

    public void destroy() {
        super.destroy();
        this.ochncConnectionRef = null;
    }

    public OchncConnection getOchncConnectionRef() {
        if (this.ochncConnectionRef == null) {
            throw new CmsObjectNotExistException(ErrorMsg.getString((EID)EMC.EID_ERROR_ACCESS_OCHNCCONNECTION));
        }
        return this.ochncConnectionRef;
    }

    public IOchncPathDefModel[] getPaths() {
        if (this.db.on()) {
            this.db.println("getPaths called on" + this);
        }
        IOchncPathDefModel[] iOchncPathDefModelArray = null;
        try {
            iOchncPathDefModelArray = (IOchncPathDefModel[])this.paths.get();
            if (this.db.on) {
                this.db.println("Paths(size=" + iOchncPathDefModelArray.length + ")= " + Arrays.asList(iOchncPathDefModelArray));
            }
        }
        catch (UserException userException) {
            this.db.println("OchncConnectionModel.getPaths(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
        return iOchncPathDefModelArray;
    }

    public List getPathList() {
        return Arrays.asList(this.getPaths());
    }

    public void localDestroy() throws Busy {
        try {
            this.destroy.get();
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (UserException userException) {
            this.db.println("OchncConnectionModel.destroy(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getOptDir() {
        IOchncPathDefModel[] iOchncPathDefModelArray = this.getPaths();
        try {
            NodeModelDelegate nodeModelDelegate = this.getNodeModelDelegate();
            InterfaceModel interfaceModel = nodeModelDelegate.getIfModels().getInterfaceModel(iOchncPathDefModelArray[0].getPortEntityIdx());
            if (interfaceModel instanceof IOpticsModel) {
                IOpticsModel iOpticsModel = (IOpticsModel)interfaceModel;
                return iOpticsModel.getOptDirection();
            }
        }
        catch (NoSuchInterface noSuchInterface) {
        }
        catch (WrongInterfaceType wrongInterfaceType) {
        }
        catch (InternalCommError internalCommError) {
            // empty catch block
        }
        return 0;
    }

    public int getOptChannel() {
        IOchncPathDefModel[] iOchncPathDefModelArray = this.getPaths();
        return iOchncPathDefModelArray[0].getOptChannel();
    }

    public ICircuitId getCircuitId() {
        try {
            sCircuitId sCircuitId2 = (sCircuitId)this.circuitId.get();
            return CircuitIdFactory.getICircuitId(sCircuitId2);
        }
        catch (UserException userException) {
            this.db.println("OchncConnectionModel.getCircuitId(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public String getConnectionName() {
        try {
            return (String)this.connectionName.get();
        }
        catch (UserException userException) {
            this.db.println("UserException caught in CircuitModel::setName");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setConnectionName(String string) throws InvalidCircuitName {
        try {
            this.connectionName.set(string);
        }
        catch (xInvalidCircuitName xInvalidCircuitName2) {
            throw new InvalidCircuitName((UserException)xInvalidCircuitName2);
        }
        catch (UserException userException) {
            this.db.println("UserException caught in CircuitModel::setName");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getObjIndex() {
        try {
            return (Integer)this.objIndex.get();
        }
        catch (UserException userException) {
            this.db.println("OchncConnectionModel.getObjIndex(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    protected ObjectType getObjectType() {
        return ObjectType.ObjectOchncConnection;
    }

    public void setCircuitId(ICircuitId iCircuitId) {
        try {
            this.circuitId.set(CircuitIdFactory.getCircuitId(iCircuitId));
        }
        catch (UserException userException) {
            this.db.println("OchncConnectionModel.setCircuitId(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getConnectionType() {
        try {
            eConnectionType eConnectionType2 = (eConnectionType)this.connectionType.get();
            return eConnectionType2.value();
        }
        catch (UserException userException) {
            this.db.println("OchncConnectionModel.getConnectionType(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public eAdminState getAdminStateEnum() throws AbstractCmsIOException {
        try {
            return (eAdminState)this.adminState.get();
        }
        catch (UserException userException) {
            this.db.severe("OchncConnectionModel: user exception in getAdminState");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setAdminState(eAdminState eAdminState2) throws TestAccessActive, ConnectionInLoopback, AbstractCmsIOException, InvalidState {
        try {
            this.adminState.set(eAdminState2);
        }
        catch (xTestAccessActive xTestAccessActive2) {
            throw new TestAccessActive((UserException)xTestAccessActive2);
        }
        catch (xConnectionInLoopback xConnectionInLoopback2) {
            throw new ConnectionInLoopback((UserException)xConnectionInLoopback2);
        }
        catch (xInvalidState xInvalidState2) {
            this.db.println("LoConnectionModel.setAdminState: state = " + eAdminState2.value());
            throw new InvalidState((UserException)xInvalidState2);
        }
        catch (UserException userException) {
            this.db.severe("OchncConnectionModel: user exception in setAdminState");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public int getServiceState() throws AbstractCmsIOException {
        try {
            return ServiceStateFactory.getServiceState((sServiceState)this.serviceState.get()).getType();
        }
        catch (UserException userException) {
            this.db.severe("OchncConnectionModel: user exception in getServiceState");
            SDebug.printStackTrace((Throwable)userException);
            return -2;
        }
    }

    protected void printString(SDebug sDebug) {
        IOchncPathDefModel[] iOchncPathDefModelArray = this.getPaths();
        sDebug.println("Number of Paths Are " + iOchncPathDefModelArray.length);
        for (int i = 0; i < iOchncPathDefModelArray.length; ++i) {
            sDebug.println("Path " + i + iOchncPathDefModelArray[i]);
        }
    }

    public List getPortModels() {
        try {
            return (List)this.portEntities.get();
        }
        catch (UserException userException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)userException);
            }
            return new LinkedList();
        }
    }

    public boolean inRoll() {
        return false;
    }

    public boolean validateNewAdminState(int n) throws AbstractCmsIOException {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ConnectionName
    extends CachedValue {
        public ConnectionName(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return OchncConnectionModel.this.getOchncConnectionRef().getConnectionName();
        }

        protected void setValue(Object object) throws UserException {
            OchncConnectionModel.this.getOchncConnectionRef().setConnectionName((String)object);
        }
    }

    private class PortEntities
    extends CachedValue {
        public PortEntities(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            IOchncPathDefModel[] iOchncPathDefModelArray = null;
            LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
            try {
                iOchncPathDefModelArray = OchncConnectionModel.this.getPaths();
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (OchncConnectionModel.this.db.on()) {
                    SDebug cfr_ignored_0 = OchncConnectionModel.this.db;
                    SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
                }
                return linkedList;
            }
            if (iOchncPathDefModelArray != null) {
                for (int i = 0; i < iOchncPathDefModelArray.length; ++i) {
                    try {
                        if (iOchncPathDefModelArray[i] == null) continue;
                        linkedList.add(OchncConnectionModel.this.getNodeModel().getEntityTable().getEntityModelByIndex(iOchncPathDefModelArray[i].getPortEntityIdx()));
                        continue;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!OchncConnectionModel.this.db.on()) continue;
                        SDebug cfr_ignored_1 = OchncConnectionModel.this.db;
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
            }
            return linkedList;
        }

        protected void setValue(Object object) throws UserException {
        }
    }

    private class Destroy
    extends NonCachedValue {
        public Destroy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            OchncConnectionModel.this.getOchncConnectionRef().destroy();
            return null;
        }
    }

    private class Paths
    extends CachedValue {
        public Paths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return OchncPathDefModelFactory.getIOchncPathDefArray(this.node, OchncConnectionModel.this.getOchncConnectionRef().paths());
        }

        public void setValueExternally(Object object) {
            super.setValueExternally(OchncPathDefModelFactory.getIOchncPathDefArray(this.node, (sOchncPathDef[])object));
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object cloneValue() {
            return CloneHelper.clone((IOchncPathDefModel[])this.value);
        }
    }

    private class ServiceState
    extends CachedValue {
        public ServiceState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            if (OchncConnectionModel.this.db.on) {
                OchncConnectionModel.this.db.println("Making CORBA call to get serviceState");
            }
            return OchncConnectionModel.this.getOchncConnectionRef().getServiceState();
        }

        protected Object cloneValue() {
            return CloneHelper.clone((sServiceState)this.value);
        }
    }

    private class AdminState
    extends CachedValue {
        public AdminState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return OchncConnectionModel.this.getOchncConnectionRef().adminState();
        }

        protected void setValue(Object object) throws UserException {
            OchncConnectionModel.this.getOchncConnectionRef().setAdminState((eAdminState)object, eEdAdminStateCmd.EDSTATE_ED);
        }

        protected Object cloneValue() {
            return CloneHelper.clone((eAdminState)this.value);
        }
    }

    private class ObjIndex
    extends CachedValue {
        public ObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            int n = OchncConnectionModel.this.getOchncConnectionRef().objIndex();
            return new Integer(n);
        }

        protected void setValue(Object object) throws UserException {
        }

        public Object outer() {
            return OchncConnectionModel.this;
        }
    }

    private class ConnectionType
    extends CachedValue {
        public ConnectionType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return OchncConnectionModel.this.getOchncConnectionRef().connectionType();
        }

        protected void setValue(Object object) throws UserException {
        }

        public Object outer() {
            return OchncConnectionModel.this;
        }
    }

    private class CircuitId
    extends CachedValue {
        public CircuitId(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            if (OchncConnectionModel.this.db.on) {
                OchncConnectionModel.this.db.println("Making CORBA call to get circuitId");
            }
            return OchncConnectionModel.this.getOchncConnectionRef().circuitId();
        }

        protected void setValue(Object object) throws UserException {
            OchncConnectionModel.this.getOchncConnectionRef().circuitId((sCircuitId)object);
        }

        public Object outer() {
            return OchncConnectionModel.this;
        }
    }
}

