/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.If.eUdcRate;
import cerent.cms.idl.OpticsTopology.sOscPort;
import cerent.cms.idl.SonetMedia.sOverheadTerm;
import cerent.cms.idl.SonetMedia.sOverheadXcon;
import cerent.cms.idl.SonetTopology.OverheadFactory;
import cerent.cms.idl.SonetTopology.OverheadTermination;
import cerent.cms.idl.SonetTopology.OverheadXConnection;
import cerent.cms.idl.SonetTopology.sOverheadIpTunnel;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.idl.SonetTopology.xInvalidOverheadTerm;
import cerent.cms.idl.SonetTopology.xInvalidOverheadXcon;
import cerent.cms.idl.SonetTopology.xInvalidUdcRate;
import cerent.cms.idl.SonetTopology.xOverheadMaxConnections;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.Busy;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ElementModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhConnectionModels;
import cerent.cms.model.IOhIpTunnelTerm;
import cerent.cms.model.IOhIpTunnelTermModel;
import cerent.cms.model.IOhTerm;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.IOhXcon;
import cerent.cms.model.IOhXconModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmLineModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.InvalidOhTerm;
import cerent.cms.model.InvalidOhXcon;
import cerent.cms.model.InvalidUdcRate;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OhChannel;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhCircuitType;
import cerent.cms.model.OhMaxConnections;
import cerent.cms.model.OhTermFactory;
import cerent.cms.model.OhTermModel;
import cerent.cms.model.OhTerms;
import cerent.cms.model.OhXconFactory;
import cerent.cms.model.OhXconModel;
import cerent.cms.model.OhXcons;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.EntityComparator;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import java.util.TreeSet;
import org.omg.CORBA.UserException;

public class OhConnectionModelsDelegate
extends Model
implements IOhConnectionModels {
    protected NodeModelDelegate node = null;
    private HashMap circuitNameMap = new HashMap();
    CreateOhTerm createOhTerm = null;
    CreateOhXcon createOhXcon = null;
    CreateOhIpTunnel createOhIpTunnel = null;
    CreateOhUdcTerm createOhUdcTerm = null;
    OhTerms ohTerms;
    OhXcons ohXcons;
    boolean disposeCalled = false;
    private static EntityComparator entComparator = new EntityComparator();
    private static ModelSingletonCollection ohConnectionModelsDelegateSingletons;
    private static final String CM_DEBUG_KEY = "OhConnectionModels";

    public static synchronized OhConnectionModelsDelegate getInstance(NodeModelDelegate nodeModelDelegate) {
        OhConnectionModelsDelegate ohConnectionModelsDelegate;
        if (ohConnectionModelsDelegateSingletons == null) {
            ohConnectionModelsDelegateSingletons = ModelSingletonCollection.getMSCInstanceByName("OhConnectionModelsDelegate");
        }
        if ((ohConnectionModelsDelegate = (OhConnectionModelsDelegate)ohConnectionModelsDelegateSingletons.get(nodeModelDelegate)) == null) {
            ohConnectionModelsDelegate = new OhConnectionModelsDelegate(nodeModelDelegate);
            ohConnectionModelsDelegateSingletons.add(nodeModelDelegate, ohConnectionModelsDelegate);
        }
        return ohConnectionModelsDelegate;
    }

    private OhConnectionModelsDelegate(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.node = nodeModelDelegate;
        this.index = 0;
        if (this.db == null) {
            this.db = new CmDebug(nodeModelDelegate.db);
        }
        this.createOhTerm = new CreateOhTerm("OhConnectionModels::createOhTerm");
        this.createOhXcon = new CreateOhXcon("OhConnectionModels::createOhXcon");
        this.createOhIpTunnel = new CreateOhIpTunnel("OhConnectionModels::createOhIpTunnel");
        this.createOhUdcTerm = new CreateOhUdcTerm("OhConnectionModels::createOhUdcTerm");
        this.ohTerms = new OhTerms(this);
        this.ohXcons = new OhXcons(this);
    }

    public void init() {
        if (this.db.on()) {
            this.db.finer("ConnectionModels: init entry");
        }
        super.init0();
        this.ohTerms.init();
        this.ohXcons.init();
        this.ohTerms.addObserver(this);
        this.ohXcons.addObserver(this);
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
        if (this.db.on()) {
            this.db.finer(this.node.dbName() + "init() exit");
        }
    }

    public void destroy() {
        super.destroy();
    }

    public OhTermModel add(OverheadTermination overheadTermination) {
        return (OhTermModel)this.ohTerms.add(overheadTermination);
    }

    public OhXconModel add(OverheadXConnection overheadXConnection) {
        return (OhXconModel)this.ohXcons.add(overheadXConnection);
    }

    private synchronized void destroyCollection(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ConnectionModel connectionModel = (ConnectionModel)iterator.next();
            if (this.db.on()) {
                this.db.fine("Destroying " + connectionModel);
            }
            connectionModel.destroy();
        }
    }

    public void dispose() {
        this.ohTerms.deleteObserver(this);
        this.ohXcons.deleteObserver(this);
        this.ohTerms.dispose();
        this.ohXcons.dispose();
        super.dispose();
    }

    private synchronized void dispose(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ConnectionModel connectionModel = (ConnectionModel)iterator.next();
            if (this.db.on()) {
                this.db.fine("Disposing of " + connectionModel);
            }
            connectionModel.destroy();
        }
    }

    public IOhTermModel[] getOhTermModels() {
        return this.ohTerms.getConnectionModels().toArray(new IOhTermModel[0]);
    }

    public IOhXconModel[] getOhXconModels() {
        return this.ohXcons.getConnectionModels().toArray(new IOhXconModel[0]);
    }

    public IOhIpTunnelTermModel[] getOhIpTunnelTermModels() {
        return new IOhIpTunnelTermModel[0];
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.node;
    }

    public OverheadFactory getOverheadFactoryRef() {
        return this.node.getIorRepository().getOverheadFactoryRef();
    }

    public void setNodeModel(INodeModel iNodeModel) {
        this.node = (NodeModelDelegate)iNodeModel;
    }

    protected void updateLocal() {
        super.updateLocal();
    }

    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public IOhTermModel createOhTerm(ICircuitId iCircuitId, IOhTerm iOhTerm) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections, InvalidUdcRate {
        if (iOhTerm.getChannel().getType() == 7) {
            return this.createUdcTerm(iCircuitId, iOhTerm);
        }
        return this.createOverheadTerm(iCircuitId, iOhTerm);
    }

    protected IOhTermModel createOverheadTerm(ICircuitId iCircuitId, IOhTerm iOhTerm) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections {
        sCircuitId sCircuitId2 = CircuitIdFactory.getCircuitId(iCircuitId);
        sOverheadTerm sOverheadTerm2 = OhTermFactory.getOhTerm(iOhTerm);
        Object[] objectArray = new Object[]{sCircuitId2, sOverheadTerm2};
        try {
            OverheadTermination overheadTermination = (OverheadTermination)this.createOhTerm.get(objectArray);
            return (IOhTermModel)this.ohTerms.add(overheadTermination);
        }
        catch (xInvalidOverheadTerm xInvalidOverheadTerm2) {
            throw new InvalidOhTerm("Invalid Overhead Termination");
        }
        catch (xBusy xBusy2) {
            throw new Busy("The overhead channel is already in use");
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse("The AIC port is already in use");
        }
        catch (xOverheadMaxConnections xOverheadMaxConnections2) {
            throw new OhMaxConnections("The overhead connection limit is exceeded");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IOhXconModel createOhXcon(ICircuitId iCircuitId, IOhXcon iOhXcon) throws InvalidOhXcon, Busy, OhMaxConnections {
        sCircuitId sCircuitId2 = CircuitIdFactory.getCircuitId(iCircuitId);
        sOverheadXcon sOverheadXcon2 = OhXconFactory.getOhXcon(iOhXcon);
        try {
            Object[] objectArray = new Object[]{sCircuitId2, sOverheadXcon2};
            OverheadXConnection overheadXConnection = (OverheadXConnection)this.createOhXcon.get(objectArray);
            return (IOhXconModel)this.ohXcons.add(overheadXConnection);
        }
        catch (xInvalidOverheadXcon xInvalidOverheadXcon2) {
            throw new InvalidOhXcon("Invalid overhead cross connection");
        }
        catch (xBusy xBusy2) {
            throw new Busy("The ovheadhead channel is already in use");
        }
        catch (xOverheadMaxConnections xOverheadMaxConnections2) {
            throw new OhMaxConnections("The overhead connection limit is exceeded");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IOhIpTunnelTermModel createOhIpTunnelTerm(ICircuitId iCircuitId, IOhIpTunnelTerm iOhIpTunnelTerm) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections {
        sCircuitId sCircuitId2 = CircuitIdFactory.getCircuitId(iCircuitId);
        sOverheadTerm sOverheadTerm2 = OhTermFactory.getOhTerm(iOhIpTunnelTerm.getOhTerm());
        sOverheadIpTunnel sOverheadIpTunnel2 = OhTermFactory.getOhIpTunnel(iOhIpTunnelTerm);
        try {
            Object[] objectArray = new Object[]{sCircuitId2, sOverheadTerm2, sOverheadIpTunnel2};
            OverheadTermination overheadTermination = (OverheadTermination)this.createOhIpTunnel.get(objectArray);
            return (IOhIpTunnelTermModel)this.ohTerms.add(overheadTermination);
        }
        catch (xInvalidOverheadTerm xInvalidOverheadTerm2) {
            throw new InvalidOhTerm("Invalid Overhead Termination");
        }
        catch (xBusy xBusy2) {
            throw new Busy("The ovheadhead channel is already in use");
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse("The AIC port is already in use");
        }
        catch (xOverheadMaxConnections xOverheadMaxConnections2) {
            throw new OhMaxConnections("The overhead connectionlimit is exceeded");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    protected IOhTermModel createUdcTerm(ICircuitId iCircuitId, IOhTerm iOhTerm) throws InvalidOhTerm, Busy, OhMaxConnections, InvalidUdcRate {
        sCircuitId sCircuitId2 = CircuitIdFactory.getCircuitId(iCircuitId);
        sOverheadTerm sOverheadTerm2 = OhTermFactory.getOhTerm(iOhTerm);
        try {
            Object[] objectArray = new Object[]{sCircuitId2, sOverheadTerm2, eUdcRate.from_int(iOhTerm.getUdcRate())};
            OverheadTermination overheadTermination = (OverheadTermination)this.createOhUdcTerm.get(objectArray);
            return (IOhTermModel)this.ohTerms.add(overheadTermination);
        }
        catch (xInvalidOverheadTerm xInvalidOverheadTerm2) {
            throw new InvalidOhTerm("Invalid Overhead Termination");
        }
        catch (xBusy xBusy2) {
            throw new Busy("The overhead channel is already in use");
        }
        catch (xOverheadMaxConnections xOverheadMaxConnections2) {
            throw new OhMaxConnections("The overhead connection limit is exceeded");
        }
        catch (xInvalidUdcRate xInvalidUdcRate2) {
            throw new InvalidUdcRate("Invalid UDC rate");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private void printConnectionList(String string, Collection collection) {
        Iterator iterator = collection.iterator();
        if (this.db.on()) {
            this.db.fine("Connections of " + string);
        }
        while (iterator.hasNext()) {
            ConnectionModel connectionModel = (ConnectionModel)iterator.next();
            this.db.fine(this.getCircuitName(connectionModel.getCircuitId()) + ",");
        }
        if (this.db.on()) {
            this.db.fine("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCircuitNameMap(HashMap hashMap) {
        HashMap hashMap2 = this.circuitNameMap;
        synchronized (hashMap2) {
            this.circuitNameMap = new HashMap(hashMap);
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCircuitName(ICircuitId iCircuitId) {
        Long l = new Long(iCircuitId.longValue());
        HashMap hashMap = this.circuitNameMap;
        synchronized (hashMap) {
            return (String)this.circuitNameMap.get(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCircuitName(sCircuitId sCircuitId2) {
        ICircuitId iCircuitId = CircuitIdFactory.getICircuitId(sCircuitId2);
        Long l = new Long(iCircuitId.longValue());
        HashMap hashMap = this.circuitNameMap;
        synchronized (hashMap) {
            return (String)this.circuitNameMap.get(l);
        }
    }

    public Set getAvailAicPorts(OhCircuitType ohCircuitType) {
        Set set = this.getAicPorts(ohCircuitType);
        if (this.db.on()) {
            this.db.fine("All Aic ports (" + set.size() + "): " + set);
        }
        if (set.isEmpty()) {
            return set;
        }
        Set set2 = this.getUsedAicPorts(ohCircuitType);
        if (this.db.on()) {
            this.db.fine("Used Aic ports (" + set2.size() + "): " + set2);
        }
        set.removeAll(set2);
        if (this.db.on()) {
            this.db.fine("Avail Aic ports (" + set.size() + "): " + set);
        }
        return set;
    }

    public Set getAvailOpticalPorts(OhCircuitType ohCircuitType) throws AbstractCmsNoSuchEntityException, NoSuchInterface {
        Set set = this.getAvailTdmPorts(ohCircuitType);
        set.addAll(this.getAvailDwdmPorts(ohCircuitType));
        set.addAll(this.getOscPorts(ohCircuitType));
        return set;
    }

    public Set getAvailTdmPorts(OhCircuitType ohCircuitType) {
        Set set = this.getNodeModelDelegate().getElementModelsDelegate().getNonProtectOpticalEntities();
        if (this.db.on()) {
            this.db.fine("Found unprotected TDM optical ports: " + set);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IPortModel iPortModel = (IPortModel)iterator.next();
            if (this.isChannelAvailable(iPortModel, ohCircuitType)) continue;
            iterator.remove();
        }
        if (this.db.on()) {
            this.db.fine("Avail optical ports (" + set.size() + "): " + set);
        }
        return set;
    }

    public Set getAvailDwdmPorts(OhCircuitType ohCircuitType) throws AbstractCmsNoSuchEntityException, NoSuchInterface {
        Set set = this.getNodeModelDelegate().getElementModelsDelegate().getNonProtectDwdmEntities();
        if (this.db.on()) {
            this.db.fine("Found unprotected dwdm ports: " + set);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AbstractDwdmLineModel abstractDwdmLineModel = (AbstractDwdmLineModel)((IPortModel)iterator.next()).getInterfaceModel();
            if (!abstractDwdmLineModel.supportOHCircuitTypes(ohCircuitType)) {
                iterator.remove();
                continue;
            }
            if (abstractDwdmLineModel instanceof DwdmTrkLineModel) {
                DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)abstractDwdmLineModel;
                try {
                    if (dwdmTrkLineModel.getOTNStatus()) {
                        iterator.remove();
                        continue;
                    }
                    if (abstractDwdmLineModel.isSonetSdhPayload() && !abstractDwdmLineModel.isTransparent()) continue;
                    iterator.remove();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                continue;
            }
            if (abstractDwdmLineModel.isSonetSdhPayload() && !abstractDwdmLineModel.isTransparent()) continue;
            iterator.remove();
        }
        if (this.db.on()) {
            this.db.fine("All candidate dwdm ports (" + set.size() + "): " + set);
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            if (this.isChannelAvailable((IPortModel)iterator.next(), ohCircuitType)) continue;
            iterator.remove();
        }
        if (this.db.on()) {
            this.db.fine("Avail dwdm ports (" + set.size() + "): " + set);
        }
        return set;
    }

    public Set getAicPorts(OhCircuitType ohCircuitType) {
        EntityModel entityModel;
        TreeSet<IEntityModel> treeSet = new TreeSet<IEntityModel>(entComparator);
        int n = ohCircuitType.getCorrespondingAicPortEqType();
        List list = ((EntityModel)this.node.getChassis()).getDescendantsOfEqType(n);
        IEntityModel iEntityModel = list.iterator();
        while (iEntityModel.hasNext()) {
            entityModel = (EntityModel)iEntityModel.next();
            if (((ModuleModel)entityModel.getModuleModel()).getState() != eEqState.DELETED) continue;
            iEntityModel.remove();
        }
        if (ohCircuitType.isOwCircuitType() && !list.isEmpty()) {
            if (list.size() != 2) {
                throw new IllegalStateException("Should have only 2 Orderwire ports");
            }
            iEntityModel = (IEntityModel)list.get(0);
            entityModel = (IEntityModel)list.get(1);
            if (ohCircuitType.equals((Object)OhCircuitType.LOW_CIRCUIT_OBJ)) {
                treeSet.add((IEntityModel)(iEntityModel.getEntityIndex() < entityModel.getEntityIndex() ? iEntityModel : entityModel));
            } else {
                treeSet.add(iEntityModel.getEntityIndex() < entityModel.getEntityIndex() ? entityModel : iEntityModel);
            }
        } else {
            treeSet.addAll(list);
        }
        return treeSet;
    }

    public Set getUsedAicPorts(OhCircuitType ohCircuitType) {
        return this.getUsedAicPorts(ohCircuitType.getCorrespondingChannelType());
    }

    public Set getUsedAicPorts(OhChannelType ohChannelType) {
        TreeSet<IEntityModel> treeSet = new TreeSet<IEntityModel>(entComparator);
        IEntityTableModel iEntityTableModel = this.getNodeModel().getEntityTable();
        IOhTermModel[] iOhTermModelArray = this.getOhTermModels();
        int n = 0;
        IEntityModel iEntityModel = null;
        for (int i = 0; i < iOhTermModelArray.length; ++i) {
            OhTermModel ohTermModel = (OhTermModel)iOhTermModelArray[i];
            if (ohTermModel.getChannelType() != ohChannelType.getIndex()) continue;
            if (!ohChannelType.isOwChannelType()) {
                IEntityModel iEntityModel2 = ohTermModel.getAicPortModel();
                if (iEntityModel2 == null) continue;
                treeSet.add(iEntityModel2);
                continue;
            }
            if (iEntityModel == null) {
                iEntityModel = ohTermModel.getAicPortModel();
            }
            ++n;
        }
        if (iEntityModel != null && n >= 4) {
            treeSet.add(iEntityModel);
        }
        return treeSet;
    }

    private boolean isChannelAvailable(IPortModel iPortModel, OhCircuitType ohCircuitType) {
        if (ohCircuitType.equals((Object)OhCircuitType.SDCC_TUNNEL_CIRCUIT_OBJ)) {
            OhChannelType[] ohChannelTypeArray = OhChannelType.DCC_CHANNEL_TYPES;
            for (int i = 0; i < ohChannelTypeArray.length; ++i) {
                if (!this.isChannelAvailable(iPortModel, ohChannelTypeArray[i])) continue;
                return true;
            }
            return false;
        }
        return this.isChannelAvailable(iPortModel, ohCircuitType.getCorrespondingChannelType());
    }

    public Set getUsedOpticalPorts(OhChannelType ohChannelType) {
        Set set = this.getOpticalPortsInTerms(ohChannelType);
        set.addAll(this.getOpticalPortsInXcons(ohChannelType));
        return set;
    }

    public Set getOpticalPortsInTerms(OhChannelType ohChannelType) {
        TreeSet<IEntityModel> treeSet = new TreeSet<IEntityModel>(entComparator);
        IEntityTableModel iEntityTableModel = this.getNodeModel().getEntityTable();
        IOhTermModel[] iOhTermModelArray = this.getOhTermModels();
        for (int i = 0; i < iOhTermModelArray.length; ++i) {
            IEntityModel iEntityModel;
            OhTermModel ohTermModel = (OhTermModel)iOhTermModelArray[i];
            if (ohTermModel.getChannelType() != ohChannelType.getIndex() || (iEntityModel = ohTermModel.getOpticalPortModel()) == null) continue;
            treeSet.add(iEntityModel);
        }
        return treeSet;
    }

    public Set getOpticalPortsInXcons(OhChannelType ohChannelType) {
        TreeSet<IEntityModel> treeSet = new TreeSet<IEntityModel>(entComparator);
        IEntityTableModel iEntityTableModel = this.getNodeModel().getEntityTable();
        IOhXconModel[] iOhXconModelArray = this.getOhXconModels();
        for (int i = 0; i < iOhXconModelArray.length; ++i) {
            IEntityModel iEntityModel;
            OhXconModel ohXconModel = (OhXconModel)iOhXconModelArray[i];
            if (ohXconModel.getInputChannelType() == ohChannelType.getIndex() && (iEntityModel = ohXconModel.getInputPortModel()) != null) {
                treeSet.add(iEntityModel);
            }
            if (ohXconModel.getOutputChannelType() != ohChannelType.getIndex() || (iEntityModel = ohXconModel.getOutputPortModel()) == null) continue;
            treeSet.add(iEntityModel);
        }
        return treeSet;
    }

    public boolean isChannelInUse(int n, OhChannelType ohChannelType) {
        boolean bl = this.ohTerms.isChannelInUse(n, ohChannelType) || this.ohXcons.isChannelInUse(n, ohChannelType);
        return bl;
    }

    public boolean isChannelAvailable(int n, OhChannelType ohChannelType) {
        IPortModel iPortModel;
        block4: {
            iPortModel = null;
            try {
                IEntityTableModel iEntityTableModel = this.getNodeModel().getEntityTable();
                if (iEntityTableModel != null) {
                    iPortModel = (IPortModel)iEntityTableModel.getEntityModelByIndex(n);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block4;
                this.db.warning("Enity with index " + n + " does not exist.");
            }
        }
        if (iPortModel == null) {
            return false;
        }
        return this.isChannelAvailable(iPortModel, ohChannelType);
    }

    private boolean isChannelAvailable(IPortModel iPortModel, OhChannelType ohChannelType) {
        ITdmPortModel iTdmPortModel;
        ITdmLineModel iTdmLineModel;
        if (iPortModel == null) {
            return false;
        }
        if (ohChannelType == null) {
            return true;
        }
        int n = iPortModel.getIndex();
        OhChannelType[] ohChannelTypeArray = ohChannelType.getMutualExclusiveChannelTypes();
        for (int i = 0; i < ohChannelTypeArray.length; ++i) {
            if (!this.isChannelInUse(n, ohChannelTypeArray[i])) continue;
            return false;
        }
        if (ohChannelType.usingLDCC() && iPortModel instanceof ITdmPortModel && !(iTdmLineModel = (iTdmPortModel = (ITdmPortModel)iPortModel).getITdmLineModel()).supportsOhChannel(4)) {
            return false;
        }
        return !this.usedByBlsrExtByte(iPortModel, ohChannelType);
    }

    private boolean usedByBlsrExtByte(IPortModel iPortModel, OhChannelType ohChannelType) {
        if (ohChannelType.getCorrespondingBlsrExtByte() != -1 && iPortModel instanceof ITdmPortModel) {
            HashSet<IPortModel> hashSet = new HashSet<IPortModel>();
            hashSet.add(iPortModel);
            TdmPortModel tdmPortModel = this.getPeerPortModel((ITdmPortModel)iPortModel);
            if (tdmPortModel != null) {
                hashSet.add(tdmPortModel);
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ITdmPortModel iTdmPortModel = (ITdmPortModel)iterator.next();
                ITdmLineModel iTdmLineModel = iTdmPortModel.getITdmLineModel();
                try {
                    int n = iTdmLineModel.getBlsrByte();
                    if (ohChannelType.getCorrespondingBlsrExtByte() != n) continue;
                    return true;
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (!this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!this.db.on()) continue;
                    this.db.finer("Line " + iTdmLineModel + " does not support BLSR extension " + "function");
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    if (!this.db.on()) continue;
                    this.db.finer("Line " + iTdmLineModel + " does not support BLSRs");
                }
            }
        }
        return false;
    }

    private TdmPortModel getPeerPortModel(ITdmPortModel iTdmPortModel) {
        IEntityModel iEntityModel = null;
        try {
            ElementModel elementModel = this.node.getElementModelsDelegate().getElementModel(iTdmPortModel.getIndex());
            switch (elementModel.getType()) {
                case 1: {
                    OnePlusOneModel onePlusOneModel = (OnePlusOneModel)elementModel;
                    if (iTdmPortModel.equals(onePlusOneModel.getMainEntityModel())) {
                        iEntityModel = onePlusOneModel.getProtectEntityModel();
                        break;
                    }
                    iEntityModel = onePlusOneModel.getMainEntityModel();
                    break;
                }
                case 3: {
                    BlsrModel blsrModel = (BlsrModel)elementModel;
                    if (iTdmPortModel.equals(blsrModel.getEastEntityModel())) {
                        iEntityModel = blsrModel.getEastProtectEntityModel();
                        break;
                    }
                    if (iTdmPortModel.equals(blsrModel.getEastProtectEntityModel())) {
                        iEntityModel = blsrModel.getEastEntityModel();
                        break;
                    }
                    if (iTdmPortModel.equals(blsrModel.getWestEntityModel())) {
                        iEntityModel = blsrModel.getWestProtectEntityModel();
                        break;
                    }
                    if (!iTdmPortModel.equals(blsrModel.getWestProtectEntityModel())) break;
                    iEntityModel = blsrModel.getWestEntityModel();
                }
            }
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        if (iEntityModel == null) {
            return null;
        }
        return (TdmPortModel)iEntityModel;
    }

    public IOhTermModel findOhTermModel(OhChannel ohChannel) {
        return this.ohTerms.findOhTermModel(ohChannel);
    }

    public OhTerms getOhTerms() {
        return this.ohTerms;
    }

    public OhXcons getOhXcons() {
        return this.ohXcons;
    }

    private Set getOscPorts(OhCircuitType ohCircuitType) {
        HashSet<TdmPortModel> hashSet = new HashSet<TdmPortModel>();
        if (ohCircuitType.equals((Object)OhCircuitType.F1_UDC_CIRCUIT_OBJ) || ohCircuitType.equals((Object)OhCircuitType.EOW_CIRCUIT_OBJ) || ohCircuitType.equals((Object)OhCircuitType.LOW_CIRCUIT_OBJ)) {
            sOscPort[] sOscPortArray = null;
            try {
                sOscPortArray = this.getNodeModelDelegate().getDwdmOpticalSetupModel().getOscPortList();
            }
            catch (FeatureUnsupported featureUnsupported) {
                this.db.info(featureUnsupported.toString());
            }
            catch (CannotPerform cannotPerform) {
                SDebug.printStackTrace((Throwable)cannotPerform);
            }
            IEntityModel iEntityModel = null;
            if (sOscPortArray != null) {
                for (int i = 0; i < sOscPortArray.length; ++i) {
                    block9: {
                        try {
                            iEntityModel = null;
                            iEntityModel = this.getNodeModelDelegate().getEntityTableModel().getEntityModelByIndex(sOscPortArray[i].oscPort);
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            if (!this.db.on()) break block9;
                            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        }
                    }
                    if (iEntityModel == null || !(iEntityModel instanceof TdmPortModel)) continue;
                    hashSet.add((TdmPortModel)iEntityModel);
                }
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    if (this.isChannelAvailable((IPortModel)iterator.next(), ohCircuitType)) continue;
                    iterator.remove();
                }
            }
        }
        return hashSet;
    }

    public String toString() {
        return "ConnectionModels for " + this.getNodeModel();
    }

    public class CmDebug
    extends SDebug {
        CmDebug(SDebug sDebug) {
            super((KDebug)sDebug, OhConnectionModelsDelegate.CM_DEBUG_KEY);
        }

        public final void dumpOhTerms() {
            OhConnectionModelsDelegate.this.ohTerms.printConnectionString(this);
        }

        public final void dumpOhXcons() {
            OhConnectionModelsDelegate.this.ohXcons.printConnectionString(this);
        }
    }

    private class CreateOhUdcTerm
    extends NonCachedValue {
        public CreateOhUdcTerm(String string) {
            super(OhConnectionModelsDelegate.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            try {
                return OhConnectionModelsDelegate.this.getOverheadFactoryRef().createOverheadUdcTerm((sCircuitId)objectArray[0], (sOverheadTerm)objectArray[1], (eUdcRate)objectArray[2]);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Error casting class in getValue for CreateOhUdcTerm " + classCastException);
            }
        }
    }

    private class CreateOhIpTunnel
    extends NonCachedValue {
        public CreateOhIpTunnel(String string) {
            super(OhConnectionModelsDelegate.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            try {
                return OhConnectionModelsDelegate.this.getOverheadFactoryRef().createOverheadIpTunnelTerm((sCircuitId)objectArray[0], (sOverheadTerm)objectArray[1], (sOverheadIpTunnel)objectArray[2]);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Error casting class in getValuefor CreateOhIpTunnelTerm " + classCastException);
            }
        }
    }

    private class CreateOhXcon
    extends NonCachedValue {
        public CreateOhXcon(String string) {
            super(OhConnectionModelsDelegate.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            try {
                return OhConnectionModelsDelegate.this.getOverheadFactoryRef().createOverheadXcon((sCircuitId)objectArray[0], (sOverheadXcon)objectArray[1]);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Error casting class in getValue for CreateOhXcon " + classCastException);
            }
        }
    }

    private class CreateOhTerm
    extends NonCachedValue {
        public CreateOhTerm(String string) {
            super(OhConnectionModelsDelegate.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            try {
                return OhConnectionModelsDelegate.this.getOverheadFactoryRef().createOverheadTerm((sCircuitId)objectArray[0], (sOverheadTerm)objectArray[1]);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Error casting class in getValue for CreateOhTerm " + classCastException);
            }
        }
    }
}

