/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Node.eDccType;
import cerent.cms.idl.Node.sDccOspfArea;
import cerent.cms.idl.Node.sOspfAreaRange;
import cerent.cms.idl.Node.sOspfLanConfig;
import cerent.cms.idl.Node.sOspfVirtualLink;
import cerent.cms.idl.Node.xDccBackBoneArea;
import cerent.cms.idl.Node.xDccNumOutOfRange;
import cerent.cms.idl.Node.xDuplicateDcc;
import cerent.cms.idl.Node.xDuplicateOspfAreaId;
import cerent.cms.idl.Node.xInvalidMask;
import cerent.cms.idl.Node.xInvalidOspfRangeAddress;
import cerent.cms.idl.Node.xInvalidVlinkNeighborAddress;
import cerent.cms.idl.Node.xLanDifferent;
import cerent.cms.idl.Node.xLanOspfNotConfigured;
import cerent.cms.idl.Node.xLanRipAlreadyRun;
import cerent.cms.idl.Node.xMaxOspfAreaRanges;
import cerent.cms.idl.Node.xOspfMetricZero;
import cerent.cms.idl.Node.xStandbyTccNotReady;
import cerent.cms.idl.Node.xUnknownAreaId;
import cerent.cms.idl.Node.xdccHasBlsr;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CloneHelper;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DccBackBoneArea;
import cerent.cms.model.DccHasBlsr;
import cerent.cms.model.DccNumOutOfRange;
import cerent.cms.model.DccOspfAreaFactory;
import cerent.cms.model.DuplicateDccNum;
import cerent.cms.model.DuplicateOspfAreaId;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IDccOspfArea;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOspfAreaRange;
import cerent.cms.model.IOspfLanConfig;
import cerent.cms.model.IOspfLanConfigModel;
import cerent.cms.model.IOspfVLink;
import cerent.cms.model.InvalidMask;
import cerent.cms.model.InvalidOspfRangeAddress;
import cerent.cms.model.InvalidVlinkNeighborAddress;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.LanDifferent;
import cerent.cms.model.LanOspfNotConfigured;
import cerent.cms.model.LanRipAlreadyRun;
import cerent.cms.model.MaxOspfAreaRanges;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OspfAreaRangeFactory;
import cerent.cms.model.OspfLanConfig;
import cerent.cms.model.OspfLanConfigFactory;
import cerent.cms.model.OspfMetricZero;
import cerent.cms.model.OspfVLinkFactory;
import cerent.cms.model.StandbyTccNotReady;
import cerent.cms.model.UnknownAreaId;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class OspfLanConfigModel
extends Model
implements IOspfLanConfigModel {
    private DccMetric dccMetric;
    private DccOspfAreaId dccOspfAreaId;
    private LanOspfConfig lanOspfConfig;
    private SetOspfAreaRange setOspfAreaRange;
    private OspfVLink ospfVLink;
    private DeleteOspfVLink deleteOspfVLink;
    private DeleteOspfAreaRange deleteOspfAreaRange;
    private GetDccOspfAreaRanges getDccOspfAreaRanges;
    private EventDispatcher dispatcher;
    private NodeModelDelegate nmd;
    private static ModelSingletonCollection ospfLanConfigModelSingletons;
    static /* synthetic */ Class class$cerent$cms$model$OspfLanConfigModel;

    public static synchronized OspfLanConfigModel getInstance(NodeModelDelegate nodeModelDelegate) {
        OspfLanConfigModel ospfLanConfigModel;
        if (ospfLanConfigModelSingletons == null) {
            ospfLanConfigModelSingletons = ModelSingletonCollection.getMSCInstanceByName("OspfLanConfigModel");
        }
        if ((ospfLanConfigModel = (OspfLanConfigModel)ospfLanConfigModelSingletons.get(nodeModelDelegate)) == null) {
            ospfLanConfigModel = new OspfLanConfigModel(nodeModelDelegate);
            ospfLanConfigModelSingletons.add(nodeModelDelegate, ospfLanConfigModel);
        }
        return ospfLanConfigModel;
    }

    private OspfLanConfigModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(class$cerent$cms$model$OspfLanConfigModel == null ? (class$cerent$cms$model$OspfLanConfigModel = OspfLanConfigModel.class$("cerent.cms.model.OspfLanConfigModel")) : class$cerent$cms$model$OspfLanConfigModel));
        this.nmd = nodeModelDelegate;
        this.dispatcher = nodeModelDelegate.getDispatcher();
        this.index = 0;
        this.setOspfAreaRange = new SetOspfAreaRange(this.nmd, "OspfLanConfigModel.setOspfAreaRange");
        this.deleteOspfVLink = new DeleteOspfVLink(this.nmd, "OspfLanConfigModel.deleteOspfVLink");
        this.ospfVLink = new OspfVLink(this.nmd, "OspfLanConfigModel.ospfVLink");
        this.deleteOspfAreaRange = new DeleteOspfAreaRange(this.nmd, "OspfLanConfigModel.deleteDccOspfAreaRange");
        this.getDccOspfAreaRanges = new GetDccOspfAreaRanges(this.nmd, "OspfLanConfigModel.getDccOspfAreaRanges");
        this.dccOspfAreaId = new DccOspfAreaId(this.nmd, "OspfLanConfigModel.dccOspfAreaId");
        this.lanOspfConfig = new LanOspfConfig(this.nmd, "OspfLanConfigModel.lanOspfConfig");
        this.dccMetric = new DccMetric(this.nmd, "OspfLanConfigModel.dccMetric");
    }

    public void init() {
        super.init0();
        if (this.dispatcher == null) {
            this.dispatcher = this.nmd.getDispatcher();
        }
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectSystem, 1, (Observer)this);
        } else {
            this.db.println("Could not register with EventDispatcher = null");
        }
    }

    public void dispose() {
        if (this.db.on) {
            this.db.println("Enter OspfLanConfigModel dispose()");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectSystem, 1, (Observer)this);
        }
        this.dccOspfAreaId.dispose();
        this.lanOspfConfig.dispose();
        this.getDccOspfAreaRanges.dispose();
        super.dispose();
        if (this.db.on) {
            this.db.println("Exit OspfLanConfigModel dispose()");
        }
    }

    public void destroy() {
        super.destroy();
        this.setOspfAreaRange = null;
        this.deleteOspfAreaRange = null;
        this.getDccOspfAreaRanges = null;
        this.dccOspfAreaId = null;
        this.lanOspfConfig = null;
        this.nmd = null;
        this.dispatcher = null;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            switch (((ObjectMessageInfo)object).getUpdateType()) {
                case 1: {
                    if (this.db.on()) {
                        this.db.println("OspfLanConfigModel Making local changes.");
                    }
                    this.updateLocal();
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("OspfLanConfigModel update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    protected void updateLocal() {
        this.dccOspfAreaId.update();
        this.lanOspfConfig.update();
        this.getDccOspfAreaRanges.update();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public short getDccMetric() throws AbstractCmsIOException {
        return 0;
    }

    public int getDccMet(eDccType eDccType2) throws AbstractCmsIOException {
        try {
            return (Integer)this.dccMetric.get(eDccType2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return 0;
        }
    }

    public void setDccMetric(short s) throws AbstractCmsIOException, OspfMetricZero {
    }

    public void setDccMet(eDccType eDccType2, int n) throws AbstractCmsIOException, OspfMetricZero {
        try {
            Object[] objectArray = new Object[]{eDccType2, new Integer(n)};
            this.dccMetric.set(objectArray);
        }
        catch (xOspfMetricZero xOspfMetricZero2) {
            throw new OspfMetricZero("DCC metric may not be zero.");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public IOspfVLink getOspfVLink() throws AbstractCmsIOException {
        try {
            return OspfVLinkFactory.getIOspfVLink((sOspfVirtualLink)this.ospfVLink.get());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setOspfVLink(IOspfVLink iOspfVLink) throws LanOspfNotConfigured, InvalidVlinkNeighborAddress {
        try {
            sOspfVirtualLink sOspfVirtualLink2 = OspfVLinkFactory.getOspfVLink(iOspfVLink);
            this.ospfVLink.set(sOspfVirtualLink2);
        }
        catch (xLanOspfNotConfigured xLanOspfNotConfigured2) {
            throw new LanOspfNotConfigured((UserException)xLanOspfNotConfigured2);
        }
        catch (xInvalidVlinkNeighborAddress xInvalidVlinkNeighborAddress2) {
            throw new InvalidVlinkNeighborAddress((UserException)xInvalidVlinkNeighborAddress2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void deleteOspfVLink() throws AbstractCmsIOException {
        try {
            this.deleteOspfVLink.set();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public IDccOspfArea[] getDccOspfAreaIdArray() throws AbstractCmsIOException {
        try {
            return DccOspfAreaFactory.getIDccOspfAreaArray((sDccOspfArea[])this.dccOspfAreaId.get());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IDccOspfArea[] getDccOspfAreaIds() throws AbstractCmsIOException {
        return this.getDccOspfAreaIdArray();
    }

    public IIpAddr getDccOspfAreaId() throws AbstractCmsIOException {
        try {
            return IpAddrFactory.getIIpAddr((sIpAddr)this.dccOspfAreaId.get());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setDccOspfAreaId(IDccOspfArea[] iDccOspfAreaArray) throws AbstractCmsIOException, DuplicateDccNum, DuplicateOspfAreaId, DccNumOutOfRange, DccBackBoneArea, StandbyTccNotReady, DccHasBlsr {
        try {
            sDccOspfArea[] sDccOspfAreaArray = DccOspfAreaFactory.getDccOspfAreaArray(iDccOspfAreaArray);
            this.dccOspfAreaId.set(sDccOspfAreaArray);
        }
        catch (xDuplicateDcc xDuplicateDcc2) {
            throw new DuplicateDccNum((UserException)xDuplicateDcc2);
        }
        catch (xDuplicateOspfAreaId xDuplicateOspfAreaId2) {
            throw new DuplicateOspfAreaId((UserException)xDuplicateOspfAreaId2);
        }
        catch (xDccNumOutOfRange xDccNumOutOfRange2) {
            throw new DccNumOutOfRange((UserException)xDccNumOutOfRange2);
        }
        catch (xDccBackBoneArea xDccBackBoneArea2) {
            throw new DccBackBoneArea((UserException)xDccBackBoneArea2);
        }
        catch (xStandbyTccNotReady xStandbyTccNotReady2) {
            throw new StandbyTccNotReady((UserException)xStandbyTccNotReady2);
        }
        catch (xdccHasBlsr xdccHasBlsr2) {
            throw new DccHasBlsr((UserException)xdccHasBlsr2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setDccOspfAreaId(IIpAddr iIpAddr) throws AbstractCmsIOException {
        try {
            this.dccOspfAreaId.set(IpAddrFactory.getIpAddr(iIpAddr));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public IOspfLanConfig getLanOspfConfig() throws AbstractCmsIOException {
        return null;
    }

    public OspfLanConfig getLanOspfConf() throws AbstractCmsIOException {
        try {
            sOspfLanConfig sOspfLanConfig2 = (sOspfLanConfig)this.lanOspfConfig.get();
            return OspfLanConfigFactory.getOspfLanConfig(sOspfLanConfig2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setLanOspfConfig(IOspfLanConfig iOspfLanConfig) throws OspfMetricZero {
    }

    public void setLanOspfConf(OspfLanConfig ospfLanConfig) throws DuplicateOspfAreaId, OspfMetricZero, StandbyTccNotReady, AbstractCmsIOException, LanRipAlreadyRun, LanDifferent {
        try {
            sOspfLanConfig sOspfLanConfig2 = OspfLanConfigFactory.getsOspfLanConfig(ospfLanConfig);
            this.lanOspfConfig.set(sOspfLanConfig2);
        }
        catch (xDuplicateOspfAreaId xDuplicateOspfAreaId2) {
            throw new DuplicateOspfAreaId((UserException)xDuplicateOspfAreaId2);
        }
        catch (xOspfMetricZero xOspfMetricZero2) {
            throw new OspfMetricZero("LAN metric may not be zero.");
        }
        catch (xStandbyTccNotReady xStandbyTccNotReady2) {
            throw new StandbyTccNotReady((UserException)xStandbyTccNotReady2);
        }
        catch (xLanRipAlreadyRun xLanRipAlreadyRun2) {
            throw new LanRipAlreadyRun((UserException)xLanRipAlreadyRun2);
        }
        catch (xLanDifferent xLanDifferent2) {
            throw new LanDifferent((UserException)xLanDifferent2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setOspfAreaRange(IOspfAreaRange iOspfAreaRange) throws MaxOspfAreaRanges, UnknownAreaId, InvalidOspfRangeAddress, InvalidMask {
        sOspfAreaRange sOspfAreaRange2 = OspfAreaRangeFactory.getOspfAreaRange(iOspfAreaRange);
        Object[] objectArray = new Object[]{sOspfAreaRange2};
        try {
            this.setOspfAreaRange.set(objectArray[0]);
        }
        catch (xMaxOspfAreaRanges xMaxOspfAreaRanges2) {
            throw new MaxOspfAreaRanges((UserException)xMaxOspfAreaRanges2);
        }
        catch (xUnknownAreaId xUnknownAreaId2) {
            throw new UnknownAreaId((UserException)xUnknownAreaId2);
        }
        catch (xInvalidOspfRangeAddress xInvalidOspfRangeAddress2) {
            throw new InvalidOspfRangeAddress((UserException)xInvalidOspfRangeAddress2);
        }
        catch (xInvalidMask xInvalidMask2) {
            throw new InvalidMask((UserException)xInvalidMask2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void deleteOspfAreaRange(IIpAddr iIpAddr, IIpAddr iIpAddr2) {
        Object[] objectArray = new Object[]{IpAddrFactory.getIpAddr(iIpAddr), IpAddrFactory.getIpAddr(iIpAddr2)};
        try {
            this.deleteOspfAreaRange.set(objectArray);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public IOspfAreaRange[] getDccOspfAreaRanges() {
        try {
            sOspfAreaRange[] sOspfAreaRangeArray = (sOspfAreaRange[])this.getDccOspfAreaRanges.get();
            return OspfAreaRangeFactory.getIOspfAreaRangeArray(sOspfAreaRangeArray);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class LanOspfConfig
    extends CachedValue {
        public LanOspfConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            this.node.getIorRepository().getNodeNetRef().setLanOspfConfig((sOspfLanConfig)object);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getNodeNetRef().lanOspfConfig();
        }

        protected Object cloneValue() {
            return this.value;
        }

        public Object outer() {
            return OspfLanConfigModel.this;
        }
    }

    class DccOspfAreaId
    extends CachedValue {
        public DccOspfAreaId(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            sDccOspfArea[] sDccOspfAreaArray = new sDccOspfArea[objectArray.length];
            System.arraycopy(objectArray, 0, sDccOspfAreaArray, 0, objectArray.length);
            this.node.getIorRepository().getNodeNetRef().setDccOspfAreaId(sDccOspfAreaArray);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getNodeNetRef().dccOspfAreaIdTable();
        }

        protected Object cloneValue() {
            if (this.value instanceof sDccOspfArea[]) {
                return CloneHelper.clone((sDccOspfArea[])this.value);
            }
            if (OspfLanConfigModel.this.db.on()) {
                OspfLanConfigModel.this.db.println("DccOspfAreas are null");
            }
            return null;
        }

        public Object outer() {
            return OspfLanConfigModel.this;
        }
    }

    class GetDccOspfAreaRanges
    extends CachedValue {
        public GetDccOspfAreaRanges(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getNodeNetRef().areaRangeTable();
        }

        protected void setValue(Object object) throws UserException {
        }

        public Object outer() {
            return OspfLanConfigModel.this;
        }
    }

    class DeleteOspfAreaRange
    extends NonCachedValue {
        public DeleteOspfAreaRange(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            sIpAddr sIpAddr2 = (sIpAddr)objectArray[0];
            sIpAddr sIpAddr3 = (sIpAddr)objectArray[1];
            this.node.getIorRepository().getNodeNetRef().deleteOspfAreaRange(sIpAddr2, sIpAddr3);
        }

        public Object outer() {
            return OspfLanConfigModel.this;
        }
    }

    class SetOspfAreaRange
    extends NonCachedValue {
        public SetOspfAreaRange(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            this.node.getIorRepository().getNodeNetRef().setOspfAreaRange((sOspfAreaRange)object);
        }

        public Object outer() {
            return OspfLanConfigModel.this;
        }
    }

    class DeleteOspfVLink
    extends NonCachedValue {
        public DeleteOspfVLink(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws UserException {
            this.node.getIorRepository().getNodeNetRef().deleteOspfVLink();
        }

        public Object outer() {
            return OspfLanConfigModel.this;
        }
    }

    class OspfVLink
    extends NonCachedValue {
        public OspfVLink(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getNodeNetRef().ospfVlink();
        }

        protected void setValue(Object object) throws UserException {
            this.node.getIorRepository().getNodeNetRef().setOspfVLink((sOspfVirtualLink)object);
        }

        public Object outer() {
            return OspfLanConfigModel.this;
        }
    }

    class DccMetric
    extends NonCachedValue {
        public DccMetric(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            short s = this.node.getIorRepository().getNodeNetRef().getDccMetric((eDccType)object);
            return new Integer(s & 0xFFFF);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            short s = (short)((Integer)objectArray[1]).intValue();
            this.node.getIorRepository().getNodeNetRef().setDccMetric((eDccType)objectArray[0], s);
        }

        public Object outer() {
            return OspfLanConfigModel.this;
        }
    }
}

