/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IParserIfName;

public class ParserIfName
implements IParserIfName {
    int ifVal = 0;
    int[] ParserIfName = new int[]{0, 0, 0, 0};
    private static final int MAX_PORT_TYPE = 3;

    public ParserIfName(String string) {
        this.init(Integer.decode("0x" + string));
    }

    public ParserIfName(int n) {
        this.init(n);
    }

    private void init(int n) {
        this.ifVal = n;
        for (int i = 0; i < 4; ++i) {
            this.ParserIfName[i] = this.shift(n, 4 * (3 - i), 255);
        }
    }

    private int shift(int n, int n2, int n3) {
        return n >> n2 & n3;
    }

    public String getAID() {
        StringBuffer stringBuffer = new StringBuffer(this.getEntityType());
        stringBuffer.append("-");
        stringBuffer.append(this.getSlotNum());
        stringBuffer.append("-");
        stringBuffer.append(this.getPortNum());
        stringBuffer.append("-");
        stringBuffer.append(this.getDir());
        return stringBuffer.toString();
    }

    public String getPortName() {
        StringBuffer stringBuffer = new StringBuffer(this.getEntityType());
        stringBuffer.append("-");
        stringBuffer.append(this.getPortNum());
        stringBuffer.append("-");
        stringBuffer.append(this.getDir());
        return stringBuffer.toString();
    }

    public String getEntityType() {
        int n = this.getEntityTypeId();
        if (n == 8) {
            return "LINE";
        }
        if (n == 32) {
            return "BAND";
        }
        return "CHAN";
    }

    public int getEntityTypeVal() {
        return this.getEntityTypeId();
    }

    private int getEntityTypeId() {
        int n = this.ifVal & 0xFFF;
        if (n >= 8 && n < 32) {
            return 8;
        }
        if (n >= 32 && n < 64) {
            return 32;
        }
        if (n >= 64 && n < 128) {
            return 64;
        }
        return 128;
    }

    public String getSlotNum() {
        return new Integer(this.ParserIfName[0]).toString();
    }

    public String getPortNum() {
        return this.getPortNumInt().toString();
    }

    public Integer getPortNumInt() {
        return new Integer(((this.ifVal & 0xFFF) - this.getEntityTypeId() - this.getDirId() + 3) / 2 + this.getDirId() / 3);
    }

    public String getDir() {
        switch (this.getDirId()) {
            case 1: {
                return "RX";
            }
            case 2: {
                return "TX";
            }
            case 3: {
                return "PT";
            }
        }
        return "TX";
    }

    public int getDirId() {
        int n = (this.ifVal - this.getEntityTypeId() & 0xF) % 2;
        if (this.getEntityTypeId() == 128) {
            return 3;
        }
        return n == 0 ? 1 : 2;
    }

    public boolean isPTport() {
        return this.getEntityTypeId() == 128;
    }

    public boolean isLINEport() {
        return this.getEntityTypeId() == 8;
    }

    public boolean isBANDport() {
        return this.getEntityTypeId() == 32;
    }

    public boolean isCHANport() {
        return this.getEntityTypeId() == 64;
    }
}

