/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.Equipment.xProvisionError;
import cerent.cms.model.CachedValue;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.ServiceState;
import cerent.cms.ui.helper.PluggableHelper;
import cerent.util.SDebug;
import org.omg.CORBA.UserException;

public class PluggableModel
extends MfgEntityModel {
    private Unprovision unprovision;
    private PluggableTypeList pluggableTypeList;
    private int[] hierarchyNums = null;
    static /* synthetic */ Class class$cerent$cms$model$PluggableModel;

    public PluggableModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        this(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(class$cerent$cms$model$PluggableModel == null ? (class$cerent$cms$model$PluggableModel = PluggableModel.class$("cerent.cms.model.PluggableModel")) : class$cerent$cms$model$PluggableModel));
    }

    public PluggableModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2, SDebug sDebug) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, sDebug);
        this.unprovision = new Unprovision(nodeModelDelegate, "PluggableModel::unprovision");
        this.pluggableTypeList = new PluggableTypeList(nodeModelDelegate, "PluggableModel::pluggableTypeList");
    }

    public void unprovision() throws ProvisionError, ResourceInUse {
        try {
            this.unprovision.set();
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw this.doUnknown("unprovision", userException);
        }
    }

    public eEqType[] getPluggableTypeList(int n) {
        try {
            return (eEqType[])this.pluggableTypeList.get(new Integer(n));
        }
        catch (UserException userException) {
            throw this.doUnknown("getPluggableTypeList", userException);
        }
    }

    public void init() {
        this.pluggableTypeList.init();
        super.init();
    }

    public void dispose() {
        this.pluggableTypeList.dispose();
        super.dispose();
    }

    protected void updateLocal() {
        this.pluggableTypeList.update();
        this.setChanged();
        super.updateLocal();
    }

    public boolean isResettable() {
        boolean bl = false;
        eEqType eEqType2 = this.getEqTypeEnum();
        if (eEqType2 != eEqType.ML2_EXIGE_MAPPER_CARD && (this.node.getPlatform().is454() || this.node.getPlatform().is455() || this.node.getPlatform().is327())) {
            bl = eEqType2 != eEqType.MIC_CARD && eEqType2 != eEqType.MIC_EXT_CARD && eEqType2 != eEqType.FILLER_CARD && ServiceState.isEquipmentResetAvailable(this.getServiceSt());
        }
        return bl;
    }

    public boolean isHardResettable() {
        boolean bl = false;
        eEqType eEqType2 = this.getEqTypeEnum();
        if (eEqType2 == eEqType.ML2_EXIGE_MAPPER_CARD || this.node.getPlatform().is600() || this.node.getPlatform().is310cl()) {
            boolean bl2 = bl = eEqType2 != eEqType.MIC_CARD && eEqType2 != eEqType.MIC_EXT_CARD && eEqType2 != eEqType.FILLER_CARD;
            if (bl) {
                bl = this.getServiceSt().equals(3);
            }
        }
        return bl;
    }

    public boolean isSoftResettable() {
        boolean bl = false;
        eEqType eEqType2 = this.getEqTypeEnum();
        if (eEqType2 == eEqType.ML2_EXIGE_MAPPER_CARD || this.node.getPlatform().is600() || this.node.getPlatform().is310cl()) {
            bl = eEqType2 != eEqType.MIC_CARD && eEqType2 != eEqType.MIC_EXT_CARD && eEqType2 != eEqType.FILLER_CARD && ServiceState.isEquipmentResetAvailable(this.getServiceSt());
        }
        return bl;
    }

    public boolean isDeletable() {
        eEqType eEqType2 = this.getEqTypeEnum();
        eEqState eEqState2 = this.getState();
        return eEqType2 != eEqType.TCC_CARD && eEqType2 != eEqType.XTC_CARD && eEqType2 != eEqType.TSC_CARD && eEqType2 != eEqType.CTX_CARD && eEqType2 != eEqType.FILLER_CARD && eEqType2 != eEqType.UNKNOWN_CARD && eEqState2 != eEqState.DELETED;
    }

    public int[] getHierarchyNums() {
        if (this.hierarchyNums == null) {
            if (this instanceof IModuleModel) {
                this.hierarchyNums = new int[0];
            } else if (this.getParent() instanceof PluggableSlotModel) {
                this.hierarchyNums = ((PluggableSlotModel)this.getParent()).getHierarchyNums();
            } else {
                throw new IllegalStateException("Incorrect model type");
            }
        }
        return this.hierarchyNums;
    }

    public String getLocation() {
        String string = String.valueOf(this.getSlot());
        if (this.getHierarchyNums().length > 0) {
            string = string + "-" + PluggableHelper.getHierarchyNumString(this.getHierarchyNums(), '-');
        }
        return string;
    }

    public boolean isDeleted() {
        return this.getState() == eEqState.DELETED;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Unprovision
    extends NonCachedValue {
        public Unprovision(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws xInUse, xProvisionError {
            PluggableModel.this.getIModuleRef().unprovision();
        }

        public Object outer() {
            return PluggableModel.this;
        }
    }

    private class PluggableTypeList
    extends CachedValue {
        public PluggableTypeList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            return PluggableModel.this.getIModuleRef().getPluggableTypeList(n);
        }

        public Object outer() {
            return PluggableModel.this;
        }
    }
}

