/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.SonetMedia.Pool;
import cerent.cms.idl.SonetMedia.sPoolAttributes;
import cerent.cms.idl.SonetTopology.eElementType;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractPoolModels;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ElementModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchPoolException;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.PoolModel;
import cerent.cms.model.UnprotectedLineModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.EnumStrings;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;

public class PoolModelsDelegate
extends AbstractPoolModels {
    private PoolModelMap poolModels;
    private GetSonetPools getSonetPools;
    private NodeModelDelegate nmd;
    private GetObjIndex getObjIndex;
    private EventDispatcher dispatcher;
    private static ModelSingletonCollection poolModelsDelegateSingletons;
    private static final String PM_DEBUG_KEY = "PoolModelsDelegate";
    static /* synthetic */ Class class$cerent$cms$idl$Event$eUpdateType;
    static /* synthetic */ Class class$cerent$cms$idl$SonetTopology$eElementType;

    public static synchronized PoolModelsDelegate getInstance(NodeModelDelegate nodeModelDelegate) {
        PoolModelsDelegate poolModelsDelegate;
        if (poolModelsDelegateSingletons == null) {
            poolModelsDelegateSingletons = ModelSingletonCollection.getMSCInstanceByName(PM_DEBUG_KEY);
        }
        if ((poolModelsDelegate = (PoolModelsDelegate)poolModelsDelegateSingletons.get(nodeModelDelegate)) == null) {
            poolModelsDelegate = new PoolModelsDelegate(nodeModelDelegate);
            poolModelsDelegateSingletons.add(nodeModelDelegate, poolModelsDelegate);
        }
        return poolModelsDelegate;
    }

    private PoolModelsDelegate(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.nmd = nodeModelDelegate;
        this.index = 0;
        if (this.db == null) {
            this.db = new PmDebug(this.nmd.db);
        }
        this.poolModels = new PoolModelMap();
        this.getSonetPools = new GetSonetPools(this.nmd, "PoolModels::getSonetPools");
        this.getObjIndex = new GetObjIndex(this.nmd, "PoolModels.getObjIndex");
        this.dispatcher = null;
    }

    public void init() {
        if (this.db.on()) {
            this.db.println("Init : Entry");
        }
        super.init0();
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectSonetPoolList, 0, (Observer)this);
        }
        this.discover(this.poolModels, true);
        if (this.db.on()) {
            this.db.println("Init : Exit, size of PoolModels: " + this.poolModels.size());
        }
    }

    protected boolean discover(PoolModelMap poolModelMap) {
        return this.discover(poolModelMap, false);
    }

    protected synchronized boolean discover(PoolModelMap poolModelMap, boolean bl) {
        sPoolAttributes[] sPoolAttributesArray = null;
        if (this.db.on()) {
            this.db.println("Discover : Entry");
        }
        try {
            sPoolAttributesArray = (sPoolAttributes[])this.getSonetPools.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        catch (SystemException systemException) {
            if (this.db.on()) {
                this.db.println("getPoolModels is not implemented");
            }
            return false;
        }
        if (this.db.on()) {
            this.db.println("Found " + sPoolAttributesArray.length + " PoolModels");
        }
        for (int i = 0; i < sPoolAttributesArray.length; ++i) {
            PoolModel poolModel = new PoolModel(this.nmd, sPoolAttributesArray[i], null);
            if (bl) {
                poolModel.init();
            }
            poolModel.setAttributes(sPoolAttributesArray[i]);
            poolModelMap.put(sPoolAttributesArray[i].objIndex, poolModel);
        }
        if (this.db.on()) {
            this.db.println("Discover: exit");
        }
        return true;
    }

    private synchronized void initializePoolModels() {
        if (this.db.on()) {
            this.db.println("InitializePoolModels:Entry");
        }
        Iterator iterator = this.poolModels.values().iterator();
        while (iterator.hasNext()) {
            PoolModel poolModel = (PoolModel)iterator.next();
            poolModel.init();
        }
        if (this.db.on()) {
            this.db.println("InitializePoolModels:Exit");
        }
    }

    private synchronized void destroyPoolModels(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PoolModel poolModel = (PoolModel)iterator.next();
            poolModel.destroy();
        }
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStructure() {
        PoolModelMap poolModelMap = new PoolModelMap();
        boolean bl = false;
        if (this.db.on()) {
            this.db.println("Enter UpdateStrucuture");
        }
        PoolModelsDelegate poolModelsDelegate = this;
        synchronized (poolModelsDelegate) {
            PoolModel poolModel;
            Object e;
            this.discover(poolModelMap);
            Collection collection = this.getAddedObjects(poolModelMap.keySet(), this.poolModels.keySet());
            Collection collection2 = this.getDeletedObjects(poolModelMap.keySet(), this.poolModels.keySet());
            if (this.db.on()) {
                this.db.println("No of added PoolModels " + collection.size());
                this.db.println("No of deleted PoolModels" + collection2.size());
            }
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                poolModel = (PoolModel)poolModelMap.get(e);
                poolModel.init();
                this.poolModels.put(poolModel.getObjIndex(), poolModel);
                bl = true;
            }
            iterator = collection2.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                poolModel = (PoolModel)this.poolModels.get(e);
                poolModel.destroy();
                this.remove(poolModel);
            }
        }
        if (bl) {
            if (this.db.on()) {
                this.db.println("Sending UpdateStructure");
            }
            this.setChanged();
            this.notifyObservers(ModelUpdateType.ADDED);
        }
        if (this.db.on()) {
            this.db.println("Exiting UpdateStructure");
        }
    }

    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("UpdateLocal: entry");
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
        if (this.db.on()) {
            this.db.println("UpdateLocal: exit, notified observers");
        }
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            if (this.db.on()) {
                this.db.println("PoolModels::update(): Observable = " + observable + ", arg = " + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Event$eUpdateType == null ? (class$cerent$cms$idl$Event$eUpdateType = PoolModelsDelegate.class$("cerent.cms.idl.Event.eUpdateType")) : class$cerent$cms$idl$Event$eUpdateType))[n]);
            }
            switch (n) {
                case 1: {
                    this.updateLocal();
                    break;
                }
                case 0: {
                    break;
                }
                case 2: {
                    this.updateStructure();
                    break;
                }
                default: {
                    String string = "Unknown update message (" + n + ") on pool models";
                    this.db.println(string);
                    SDebug.printStackTrace((Throwable)new IllegalArgumentException(string));
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.db.on()) {
            this.db.println("Got a dispose message for PoolModels");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectSonetPoolList, 0, (Observer)this);
        }
        PoolModelsDelegate poolModelsDelegate = this;
        synchronized (poolModelsDelegate) {
            this.destroyPoolModels(this.poolModels.values());
            this.poolModels.clear();
        }
        super.dispose();
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("Got a destroy message for PoolModels");
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized PoolModel addPool(PoolModel poolModel) {
        PoolModel poolModel2 = null;
        PoolModelsDelegate poolModelsDelegate = this;
        synchronized (poolModelsDelegate) {
            int n = poolModel.getObjIndex();
            poolModel2 = this.poolModels.get(n);
            if (poolModel2 == null) {
                this.poolModels.put(n, poolModel);
                poolModel2 = poolModel;
            }
        }
        return poolModel2;
    }

    public PoolModel add(PoolModel poolModel) {
        PoolModel poolModel2 = this.addPool(poolModel);
        if (poolModel2 != poolModel) {
            this.setChanged();
            this.notifyObservers(ModelUpdateType.ADDED);
        }
        return poolModel2;
    }

    public synchronized Collection getPoolModels() {
        return this.poolModels.copy().values();
    }

    public IPoolModel[] getPoolModels(int n) {
        ArrayList<IPoolModel> arrayList;
        block6: {
            arrayList = new ArrayList<IPoolModel>();
            try {
                ElementModel elementModel = this.nmd.getElementModelsDelegate().getElementModel(n);
                if (this.db.on()) {
                    this.db.println("Element Model type = " + EnumStrings.getStrings((Class)(class$cerent$cms$idl$SonetTopology$eElementType == null ? (class$cerent$cms$idl$SonetTopology$eElementType = PoolModelsDelegate.class$("cerent.cms.idl.SonetTopology.eElementType")) : class$cerent$cms$idl$SonetTopology$eElementType))[elementModel.getType()]);
                }
                arrayList.add(this.getPoolModel(n));
                if (elementModel.getType() == 2) {
                    if (this.db.on()) {
                        this.db.println("Adding protect pool of 2F BlsrModel line model");
                    }
                    arrayList.add(this.getProtectPoolModel(n));
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!this.db.on()) break block6;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
        if (this.db.on()) {
            this.db.println("returnPoolList: " + arrayList.size() + "(size), " + arrayList);
        }
        return arrayList.toArray(new IPoolModel[0]);
    }

    public IPoolModel getPoolModel(int n) {
        ElementModel elementModel;
        try {
            elementModel = this.nmd.getElementModelsDelegate().getElementModel(n);
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            if (this.db.on()) {
                this.db.println("Could not find ElementModel for entityIndex");
            }
            return null;
        }
        if (elementModel instanceof UnprotectedLineModel) {
            if (this.db.on()) {
                this.db.println("EntityIndex of unprotected line model");
            }
            return ((UnprotectedLineModel)elementModel).getPoolModel();
        }
        if (elementModel instanceof OnePlusOneModel) {
            if (this.db.on()) {
                this.db.println("EntityIndex of OnePlusOne line model");
            }
            return ((OnePlusOneModel)elementModel).getPoolModel();
        }
        if (elementModel instanceof BlsrModel) {
            if (this.db.on()) {
                this.db.println("EntityIndex of BlsrModel line model");
            }
            return ((BlsrModel)elementModel).getPoolModel(n);
        }
        return null;
    }

    public IPoolModel getProtectPoolModel(int n) {
        ElementModel elementModel;
        try {
            elementModel = this.nmd.getElementModelsDelegate().getElementModel(n);
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            if (this.db.on()) {
                this.db.println("Not found ElementModel for entityIndex " + n);
            }
            return null;
        }
        if (this.db.on()) {
            this.db.println("Found ElementModel for entityIndex " + n);
        }
        if (elementModel instanceof UnprotectedLineModel) {
            if (this.db.on()) {
                this.db.println("No Protect Pool for Unprotected LineModel");
            }
            return null;
        }
        if (elementModel instanceof OnePlusOneModel) {
            if (this.db.on()) {
                this.db.println("getProtectPoolModel: Unspported for OnePlusOneModel");
            }
            return null;
        }
        if (elementModel instanceof BlsrModel) {
            boolean bl = false;
            boolean bl2 = false;
            BlsrModel blsrModel = (BlsrModel)elementModel;
            if (elementModel.getTypeEnum() == eElementType.BLSR_4_WIRE) {
                if (blsrModel.getEastProtectEntityIndex() == n) {
                    bl = true;
                } else if (blsrModel.getWestProtectEntityIndex() == n) {
                    bl2 = true;
                } else if (this.db.on()) {
                    this.db.println("Wrong entity Index for Protect Pool of 4F Blsr");
                }
            } else if (blsrModel.getEastEntityIndex() == n) {
                bl = true;
            } else if (blsrModel.getWestEntityIndex() == n) {
                bl2 = true;
            } else if (this.db.on()) {
                this.db.println("Wrong entity Index for Protect Pool of 2F Blsr");
            }
            if (bl) {
                if (this.db.on()) {
                    this.db.println("Returning Protect Pool of Blsr East");
                }
                return blsrModel.getEastProtectPoolModel();
            }
            if (bl2) {
                if (this.db.on()) {
                    this.db.println("Returning Protect Pool of Blsr West");
                }
                return blsrModel.getWestProtectPoolModel();
            }
            if (this.db.on()) {
                this.db.println("Wrong entity Index for Protect Pool of Blsr");
            }
            return null;
        }
        if (this.db.on()) {
            this.db.println("Unknown element model type for entityIndex " + n);
        }
        return null;
    }

    public synchronized PoolModel find(PoolModel poolModel) {
        return this.poolModels.get(poolModel.getObjIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolModel find(Pool pool) throws AbstractCmsIOException {
        try {
            PoolModelsDelegate poolModelsDelegate = this;
            synchronized (poolModelsDelegate) {
                Iterator iterator = this.poolModels.values().iterator();
                while (iterator.hasNext()) {
                    PoolModel poolModel = (PoolModel)iterator.next();
                    if (!pool._is_equivalent(poolModel.getPoolRef())) continue;
                    if (this.db.on) {
                        this.db.println("Found Pool based on _is_equivalent");
                    }
                    return poolModel;
                }
            }
            if (this.db.on) {
                this.db.println("Cannot find Pool based on _is_equivalent using Index");
            }
            return this.find((Integer)this.getObjIndex.get(pool));
        }
        catch (UserException userException) {
            if (this.db.on) {
                this.db.println("user exception in find " + (Object)((Object)userException));
            }
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public synchronized PoolModel find(Integer n) {
        return this.poolModels.get(n);
    }

    public Integer getObjIndexFromPool(Pool pool) throws NoSuchPoolException {
        PoolModel poolModel = this.find(pool);
        if (poolModel != null) {
            return new Integer(poolModel.getObjIndex());
        }
        if (this.db.on()) {
            this.db.println("Unable to calculate getObjIndexFromPool() in PoolModelsDelegate");
        }
        throw new NoSuchPoolException("Unable to find PoolModel in Cache");
    }

    public synchronized void remove(PoolModel poolModel) {
        this.poolModels.remove(poolModel.getObjIndex());
    }

    protected Collection getAddedObjects(Collection collection, Collection collection2) {
        HashSet hashSet = new HashSet(collection);
        HashSet hashSet2 = new HashSet(collection2);
        hashSet.removeAll(hashSet2);
        return hashSet;
    }

    protected Collection getDeletedObjects(Collection collection, Collection collection2) {
        HashSet hashSet = new HashSet(collection);
        HashSet hashSet2 = new HashSet(collection2);
        hashSet2.removeAll(hashSet);
        return hashSet2;
    }

    public String toString() {
        return "PoolModels Node: " + this.nmd.getHostName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class PmDebug
    extends SDebug {
        PmDebug(SDebug sDebug) {
            super((KDebug)sDebug, PoolModelsDelegate.PM_DEBUG_KEY);
        }

        public final void dumpPools() {
            if (PoolModelsDelegate.this.poolModels == null || PoolModelsDelegate.this.poolModels.size() == 0) {
                this.println("No Pool Models!");
                return;
            }
            Iterator iterator = PoolModelsDelegate.this.poolModels.values().iterator();
            while (iterator.hasNext()) {
                try {
                    PoolModel poolModel = (PoolModel)iterator.next();
                    this.println(poolModel.toString());
                }
                catch (Exception exception) {
                    this.println("Got Exception " + exception);
                    PmDebug.printStackTrace((Throwable)exception);
                }
            }
        }

        public final void update() {
            this.set(true);
            PoolModelsDelegate.this.updateStructure();
            this.set(false);
        }
    }

    class PoolModelMap
    extends HashMap {
        PoolModelMap() {
        }

        public PoolModel get(Integer n) {
            return (PoolModel)super.get(n);
        }

        public PoolModel get(int n) {
            return this.get(new Integer(n));
        }

        public void put(int n, PoolModel poolModel) {
            this.put(new Integer(n), poolModel);
        }

        public void put(Object object, PoolModel poolModel) {
            super.put(object, poolModel);
        }

        public void remove(int n) {
            super.remove(new Integer(n));
        }

        public HashMap copy() {
            return (HashMap)super.clone();
        }
    }

    private class GetSonetPools
    extends NonCachedValue {
        public GetSonetPools(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue() throws UserException {
            return this.node.getIorRepository().getSonetRef().getSonetPools();
        }

        public Object outer() {
            return PoolModelsDelegate.this;
        }
    }

    private class GetObjIndex
    extends NonCachedValue {
        public GetObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue(Object object) throws UserException {
            Pool pool = (Pool)object;
            return new Integer(pool.objIndex());
        }

        public Object outer() {
            return PoolModelsDelegate.this;
        }
    }
}

