/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.NodeModelDelegate;

public class ProxyXlator {
    public static final int PROXY_NONE = 0;
    public static final int PROXY_PNE = 1;
    public static final int PROXY_GNE = 2;
    public static final int PROXY_ENE = 3;
    public static final String S_PROXY_NONE = "None";
    public static final String S_PROXY_PNE = "ProxyOnlyNode";
    public static final String S_PROXY_PNE_ALTERNATE = "SOCKS proxy only";
    public static final String S_PROXY_GNE = "GNE";
    public static final String S_PROXY_ENE = "ENE";
    private static String[] PROXY_STATUS = new String[]{"None", "SOCKS proxy", "Firewall", "Craft Access Only"};

    public static String proxyToString(int n) {
        switch (n) {
            case 0: {
                return S_PROXY_NONE;
            }
            case 1: {
                return S_PROXY_PNE;
            }
            case 2: {
                return S_PROXY_GNE;
            }
            case 3: {
                return S_PROXY_ENE;
            }
        }
        return "type-" + n;
    }

    public static String proxyStringToAlternateString(String string) {
        if (string.equals(S_PROXY_PNE)) {
            return S_PROXY_PNE_ALTERNATE;
        }
        return string;
    }

    public static String alternateStringToProxyString(String string) {
        if (string.equals(S_PROXY_PNE_ALTERNATE)) {
            return S_PROXY_PNE;
        }
        return string;
    }

    public static int stringToProxy(String string) {
        String[] stringArray = new String[]{S_PROXY_NONE, S_PROXY_PNE, S_PROXY_GNE, S_PROXY_ENE};
        int n = 0;
        string = ProxyXlator.alternateStringToProxyString(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public static int getProxy(NodeModelDelegate nodeModelDelegate, WhetherTruly whetherTruly) {
        int n = 0;
        boolean bl = nodeModelDelegate.getProxyEnable();
        boolean bl2 = nodeModelDelegate.getFirewallEnable();
        boolean bl3 = nodeModelDelegate.getCraftAccessOnly();
        if (bl) {
            if (bl2) {
                if (bl3) {
                    n = 3;
                    whetherTruly.setWhetherTruly(true);
                } else {
                    n = 2;
                    whetherTruly.setWhetherTruly(true);
                }
            } else {
                n = 1;
                whetherTruly.setWhetherTruly(!bl3);
            }
        } else {
            whetherTruly.setWhetherTruly(!bl2 && !bl3);
        }
        return n;
    }

    public static int getProxy(NodeModelDelegate nodeModelDelegate) {
        return ProxyXlator.getProxy(nodeModelDelegate, new WhetherTruly());
    }

    public static String getProxyString(NodeModelDelegate nodeModelDelegate) {
        return ProxyXlator.proxyToString(ProxyXlator.getProxy(nodeModelDelegate));
    }

    public static String getProxyStringOrStatus(NodeModelDelegate nodeModelDelegate) {
        WhetherTruly whetherTruly = new WhetherTruly();
        int n = ProxyXlator.getProxy(nodeModelDelegate, whetherTruly);
        if (!whetherTruly.getWhetherTruly()) {
            return ProxyXlator.getProxyStatus(nodeModelDelegate);
        }
        return ProxyXlator.proxyToString(n);
    }

    public static String getProxyStatus(NodeModelDelegate nodeModelDelegate, int n) {
        String string = null;
        if (n == 0) {
            string = PROXY_STATUS[0];
        } else {
            if (n == 1 || n == 2 || n == 3) {
                string = PROXY_STATUS[1];
            }
            if (n == 2 || n == 3) {
                string = string == null ? PROXY_STATUS[2] : string + ", " + PROXY_STATUS[2];
            }
            if (n == 3 && !nodeModelDelegate.getPlatform().is600()) {
                string = string == null ? PROXY_STATUS[3] : string + ", " + PROXY_STATUS[3];
            }
        }
        return string;
    }

    public static String getProxyStatus(NodeModelDelegate nodeModelDelegate) {
        String string = null;
        if (nodeModelDelegate.getProxyEnable()) {
            string = PROXY_STATUS[1];
        }
        if (nodeModelDelegate.getFirewallEnable()) {
            string = string == null ? PROXY_STATUS[2] : string + ", " + PROXY_STATUS[2];
        }
        if (!nodeModelDelegate.getPlatform().is600() && nodeModelDelegate.getCraftAccessOnly()) {
            string = string == null ? PROXY_STATUS[3] : string + ", " + PROXY_STATUS[3];
        }
        if (string == null) {
            string = PROXY_STATUS[0];
        }
        return string;
    }

    public static void setProxy(NodeModelDelegate nodeModelDelegate, int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        switch (n) {
            case 3: {
                bl = true;
                bl2 = true;
                bl3 = true;
                break;
            }
            case 2: {
                bl = true;
                bl2 = false;
                bl3 = true;
                break;
            }
            case 1: {
                bl = true;
                bl2 = false;
                bl3 = false;
                break;
            }
        }
        if (bl2 != nodeModelDelegate.getCraftAccessOnly()) {
            nodeModelDelegate.setCraftAccessOnly(bl2);
        }
        if (bl3 != nodeModelDelegate.getFirewallEnable()) {
            nodeModelDelegate.setFirewallEnable(bl3);
        }
        if (bl != nodeModelDelegate.getProxyEnable()) {
            nodeModelDelegate.setProxyEnable(bl);
        }
    }

    public static void setProxy(NodeModelDelegate nodeModelDelegate, String string) {
        ProxyXlator.setProxy(nodeModelDelegate, ProxyXlator.stringToProxy(string));
    }

    public static class WhetherTruly {
        private boolean whetherTruly = true;

        public void setWhetherTruly(boolean bl) {
            this.whetherTruly = bl;
        }

        public boolean getWhetherTruly() {
            return this.whetherTruly;
        }
    }
}

