/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.FramingType;
import cerent.cms.model.IDccConnectionTableModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NoSuchTerm;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhTermModel;
import cerent.util.SDebug;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observer;
import java.util.Set;

public class SdccTermConnectionModel
extends AbstractTermConnectionModel
implements IDccConnectionTableModel {
    private static final OhChannelType DCC_TERM_CHANNEL = OhChannelType.SDCC_OBJ;
    private static final OhChannelType SDCC_IPTUNNEL_CHANNEL = OhChannelType.SDCC_IPTUNNEL_OBJ;
    private static ModelSingletonCollection dccConnectionModelSingletons;

    public static synchronized SdccTermConnectionModel getInstance(NodeModelDelegate nodeModelDelegate) {
        SdccTermConnectionModel sdccTermConnectionModel;
        if (dccConnectionModelSingletons == null) {
            dccConnectionModelSingletons = ModelSingletonCollection.getMSCInstanceByName("SdccTermConnectionModel");
        }
        if ((sdccTermConnectionModel = (SdccTermConnectionModel)dccConnectionModelSingletons.get(nodeModelDelegate)) == null) {
            sdccTermConnectionModel = new SdccTermConnectionModel(nodeModelDelegate);
            dccConnectionModelSingletons.add(nodeModelDelegate, sdccTermConnectionModel);
        }
        return sdccTermConnectionModel;
    }

    private SdccTermConnectionModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate);
    }

    public static void xmlInit(NodeModelDelegate nodeModelDelegate, Class clazz, int n) {
        SdccTermConnectionModel sdccTermConnectionModel = (SdccTermConnectionModel)nodeModelDelegate.getDccTermConnectionModel();
        sdccTermConnectionModel.init();
    }

    public void addSdccObserver(int n, Observer observer) throws NoSuchTerm {
        this.addTermObserver(n, observer);
    }

    public void deleteSdccObserver(int n, Observer observer) {
        this.deleteTermObserver(n, observer);
    }

    public boolean entityExistsInTerminations(IEntityModel iEntityModel) {
        return this.getTermModel(iEntityModel.getIndex()) != null;
    }

    public IEntityModel[] getTermCandidates() {
        Set set;
        HashSet<EntityModel> hashSet = new HashSet<EntityModel>();
        if (this.elementModels == null) {
            this.elementModels = this.nmd.getElementModelsDelegate();
        }
        Set set2 = this.getNonTransparentTermDwdmEntities();
        set2.removeAll(this.otnEnabledPorts(this.dwdmTrunkPorts(set2)));
        IFramingType iFramingType = FramingType.getFramingType((int)this.nmd.getFramingType());
        if (iFramingType.isSonet()) {
            set = this.elementModels.getNonProtectOpticalEntities();
            set.addAll(set2);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                try {
                    EntityModel entityModel = (EntityModel)iterator.next();
                    if (entityModel.getMediumType() != 1) continue;
                    if (this.db.on()) {
                        this.db.println("Found a Sonet port " + entityModel + " adding ...");
                    }
                    hashSet.add(entityModel);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        } else {
            hashSet.addAll(this.elementModels.getNonProtectOpticalEntities());
            hashSet.addAll(set2);
        }
        hashSet.removeAll(this.ocmd.getUsedOpticalPorts(DCC_TERM_CHANNEL));
        hashSet.removeAll(this.ocmd.getUsedOpticalPorts(SDCC_IPTUNNEL_CHANNEL));
        set = this.excludeUcpTerms(hashSet);
        return set.toArray(new IEntityModel[0]);
    }

    protected String getTypeName() {
        return "SDCC";
    }

    protected OhChannelType getChannelType(Object object) {
        return DCC_TERM_CHANNEL;
    }

    protected boolean termQualifies(OhTermModel ohTermModel) {
        return !this.isGccTerm(ohTermModel) && !this.isOscTerm(ohTermModel);
    }
}

