/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Ds1ModuleModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.OpticsAmplifiedLineModel;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsLineModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.model.TdmHoModel;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.SDebug;

public class SimpleMuxIndex {
    protected int framingType;
    protected Integer internalMuxIndex;
    protected Integer externalMuxIndex;
    protected Integer toStringMuxIndex;
    protected static SDebug db = new SDebug("MuxIndex");

    public SimpleMuxIndex(InterfaceModel interfaceModel, int n) {
        int n2;
        this.framingType = interfaceModel.getNodeModel().getFramingType();
        try {
            n2 = interfaceModel.getInfo().muxIndex;
        }
        catch (Exception exception) {
            db.println("Caught exception in <init>");
            SDebug.printStackTrace((Throwable)exception);
            n2 = -1;
        }
        if (n2 < 1) {
            n2 = n;
        }
        this.internalMuxIndex = new Integer(n2);
        this.externalMuxIndex = new Integer(this.convertToExternalMuxIndex(interfaceModel, n2));
        if (interfaceModel instanceof TdmHoModel) {
            short s = HoLoFactory.idlSts2HoNum(this.framingType, this.externalMuxIndex).getHoNum();
            this.toStringMuxIndex = new Integer(s);
        } else {
            this.toStringMuxIndex = this.externalMuxIndex;
        }
    }

    public SimpleMuxIndex(InterfaceModel interfaceModel) {
        this(interfaceModel, 1);
    }

    public SimpleMuxIndex() {
        this.internalMuxIndex = new Integer(-1);
        this.externalMuxIndex = new Integer(-1);
        this.toStringMuxIndex = new Integer(-1);
    }

    private int convertToExternalMuxIndex(InterfaceModel interfaceModel, int n) {
        block20: {
            if (interfaceModel instanceof TdmHoModel) {
                try {
                    int n2;
                    IPortModel iPortModel = ((TdmHoModel)interfaceModel).getPortModel();
                    IModuleModel iModuleModel = iPortModel.getModuleModel();
                    if (iModuleModel instanceof Ds1ModuleModel && (n2 = this.getStsNumFromPortModel(iPortModel)) != -1) {
                        n = n2;
                    }
                    break block20;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                    break block20;
                }
            }
            if (interfaceModel instanceof OpticsLineModel) {
                try {
                    IPortModel iPortModel = ((OpticsLineModel)interfaceModel).getPortModel();
                    n = iPortModel.getPort();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                    break block20;
                }
            }
            if (interfaceModel instanceof OpticsChannelModel) {
                try {
                    IPortModel iPortModel = ((OpticsChannelModel)interfaceModel).getPortModel();
                    n = iPortModel.getPort();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                    break block20;
                }
            }
            if (interfaceModel instanceof OpticsMultiplexSectionModel) {
                try {
                    IPortModel iPortModel = ((OpticsMultiplexSectionModel)interfaceModel).getPortModel();
                    n = iPortModel.getPort();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                    break block20;
                }
            }
            if (interfaceModel instanceof OpticsAmplifiedLineModel) {
                try {
                    IPortModel iPortModel = ((OpticsAmplifiedLineModel)interfaceModel).getPortModel();
                    n = iPortModel.getPort();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block20;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return n;
    }

    private int getStsNumFromPortModel(IPortModel iPortModel) {
        int n = iPortModel.getEqType();
        int n2 = iPortModel.getPort();
        switch (n) {
            case 34: 
            case 68: {
                return 1;
            }
            case 69: 
            case 70: {
                if (this.framingType == 0) {
                    return n2;
                }
                IHoNum iHoNum = iPortModel.getModuleModel().getHoNumForPort(n2, 7);
                return iHoNum.getIdlHoNum();
            }
        }
        return -1;
    }

    public Integer getInternalMuxIndex() {
        return this.internalMuxIndex;
    }

    public Integer getExternalMuxIndex() {
        return this.externalMuxIndex;
    }
}

