/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eQualityLevel;
import cerent.cms.idl.If.sLineSyncConfig;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xSyncProvBusy;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.Node.xStandbyTccNotReady;
import cerent.cms.idl.OpticsTopology.sOscPort;
import cerent.cms.idl.Synchronization.Sync;
import cerent.cms.idl.Synchronization.eBits;
import cerent.cms.idl.Synchronization.eManSwitchType;
import cerent.cms.idl.Synchronization.eRef;
import cerent.cms.idl.Synchronization.eTimingMode;
import cerent.cms.idl.Synchronization.sBitsConfig;
import cerent.cms.idl.Synchronization.sDemandData;
import cerent.cms.idl.Synchronization.sInfo;
import cerent.cms.idl.Synchronization.sRefSwitchStatus;
import cerent.cms.idl.Synchronization.sSyncConfig;
import cerent.cms.idl.Synchronization.xBadQuality;
import cerent.cms.idl.Synchronization.xBadReference;
import cerent.cms.idl.Synchronization.xBusy;
import cerent.cms.idl.Synchronization.xInvalidClockSource;
import cerent.cms.idl.Synchronization.xInvalidQuality;
import cerent.cms.idl.Synchronization.xNoSwitchCommandActive;
import cerent.cms.idl.Synchronization.xSyncProvError;
import cerent.cms.idl.Synchronization.xSyncSourceAlreadyDefinedForSlot;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BadReference;
import cerent.cms.model.Busy;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.ConfigError;
import cerent.cms.model.Ds1LineModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.HtmlSynchronizationReport;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IncompatibleTimingMode;
import cerent.cms.model.InvalidClockSource;
import cerent.cms.model.InvalidQuality;
import cerent.cms.model.IorRepository;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PortModel;
import cerent.cms.model.StandbyTccNotReady;
import cerent.cms.model.SyncEntityModel;
import cerent.cms.model.SyncInvalidAisThreshold;
import cerent.cms.model.SyncInvalidCoding;
import cerent.cms.model.SyncInvalidFacility;
import cerent.cms.model.SyncInvalidFormat;
import cerent.cms.model.SyncInvalidProvisioningForMode;
import cerent.cms.model.SyncInvalidRefSource;
import cerent.cms.model.SyncProvBusy;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.SyncSourceAlreadyDefinedForSlot;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.omg.CORBA.UserException;

public class SynchronizationModel
extends Model {
    private Config config;
    private Status status;
    private SonetSysConfig sonetSysConfig;
    private BitsIndex bitsIndex;
    private BitsConfig bitsConfig;
    private RefIndex refIndex;
    private ActiveRefSource activeRefSource;
    private RefSources refSources;
    private OnDemandReport onDemandReport;
    private SwitchRefSource switchRefSource;
    private ReleaseRefSource releaseRefSource;
    private ManualSwitchStatus manualSwitchStatus;
    private RefCandidates refCandidates;
    private HtmlSynchronizationReport syncReport;
    public int BITS_1;
    public int BITS_2;
    public int NE_REF;
    public int EXT_REF_1;
    public int EXT_REF_2;
    public int INT_CLOCK;
    public int NO_CLOCK;
    private SyncEntityModel bits1;
    private SyncEntityModel bits2;
    private SyncEntityModel neRef;
    private SyncEntityModel ext1Ref;
    private SyncEntityModel ext2Ref;
    private SyncEntityModel intClk;
    private SyncEntityModel noSync;
    private EventDispatcher dispatcher;
    private NodeModelDelegate nodeModel;
    private static ModelSingletonCollection synchronizationModelSingletons;
    private ElementModelsDelegate elementModels;
    private IorRepository iors;
    public static SDebug db;
    static /* synthetic */ Class class$cerent$cms$model$SynchronizationModel;

    public static synchronized SynchronizationModel getInstance(NodeModelDelegate nodeModelDelegate) {
        SynchronizationModel synchronizationModel;
        if (synchronizationModelSingletons == null) {
            synchronizationModelSingletons = ModelSingletonCollection.getMSCInstanceByName("SynchronizationModel");
        }
        if ((synchronizationModel = (SynchronizationModel)synchronizationModelSingletons.get(nodeModelDelegate)) == null) {
            synchronizationModel = new SynchronizationModel(nodeModelDelegate);
            synchronizationModelSingletons.add(nodeModelDelegate, synchronizationModel);
        }
        return synchronizationModel;
    }

    private SynchronizationModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(class$cerent$cms$model$SynchronizationModel == null ? (class$cerent$cms$model$SynchronizationModel = SynchronizationModel.class$("cerent.cms.model.SynchronizationModel")) : class$cerent$cms$model$SynchronizationModel));
        int n = nodeModelDelegate.getPlatform().getFirstControlCardIndex();
        this.BITS_1 = n + 2;
        this.BITS_2 = n + 3;
        this.NE_REF = n + 4;
        this.EXT_REF_1 = n + 5;
        this.EXT_REF_2 = n + 6;
        this.INT_CLOCK = n + 7;
        this.NO_CLOCK = n + 8;
        db.info("<init> ");
        this.nodeModel = nodeModelDelegate;
        this.index = 0;
        this.config = new Config(nodeModelDelegate, "SynchronizationModel::config");
        this.status = new Status(nodeModelDelegate, "SynchronizationModel::status");
        this.sonetSysConfig = new SonetSysConfig(nodeModelDelegate, "SynchronizationModel::sonetSysConfig");
        this.bitsIndex = new BitsIndex(nodeModelDelegate, "SynchronizationModel::bitsIndex");
        this.bitsConfig = new BitsConfig(nodeModelDelegate, "SynchronizationModel::bitsConfig");
        this.refIndex = new RefIndex(nodeModelDelegate, "SynchronizationModel::refIndex");
        this.activeRefSource = new ActiveRefSource(nodeModelDelegate, "SynchronizationModel::activeRefSource");
        this.refSources = new RefSources(nodeModelDelegate, "SynchronizationModel::refSources");
        this.onDemandReport = new OnDemandReport(nodeModelDelegate, "SynchronizationModel::onDemandReport");
        this.switchRefSource = new SwitchRefSource(nodeModelDelegate, "SynchronizationModel::switchRefSource");
        this.releaseRefSource = new ReleaseRefSource(nodeModelDelegate, "SynchronizationModel::releaseRefSource");
        this.manualSwitchStatus = new ManualSwitchStatus(nodeModelDelegate, "SynchronizationModel::manualSwitchStatus");
        this.refCandidates = new RefCandidates(nodeModelDelegate, "SynchronizationModel::refCandidates");
        int n2 = 0;
        this.bits1 = new SyncEntityModel(nodeModelDelegate, this.BITS_1, n2++, "BITS-1");
        this.bits2 = new SyncEntityModel(nodeModelDelegate, this.BITS_2, n2++, "BITS-2");
        this.neRef = new SyncEntityModel(nodeModelDelegate, this.NE_REF, n2++, "NE Reference");
        this.ext1Ref = new SyncEntityModel(nodeModelDelegate, this.EXT_REF_1, n2++, "Ext Sync Ref 1");
        this.ext2Ref = new SyncEntityModel(nodeModelDelegate, this.EXT_REF_2, n2++, "Ext Sync Ref 2");
        this.intClk = new SyncEntityModel(nodeModelDelegate, this.INT_CLOCK, n2++, "Internal Clock");
        this.noSync = new SyncEntityModel(nodeModelDelegate, this.NO_CLOCK, n2++, "None");
        this.dispatcher = null;
        this.elementModels = null;
        this.iors = null;
        this.syncReport = null;
    }

    public INodeModel getNodeModel() {
        return this.nodeModel;
    }

    private Sync getSynchronizationRef() {
        return this.getIorRepository().getSynchronizationRef();
    }

    private IorRepository getIorRepository() {
        if (this.iors == null) {
            this.iors = this.nodeModel.getIorRepository();
        }
        return this.iors;
    }

    private ElementModelsDelegate getElementModelsDelegate() {
        if (this.elementModels == null) {
            this.elementModels = this.nodeModel.getElementModelsDelegate();
        }
        return this.elementModels;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nodeModel;
    }

    public void init() {
        super.init0();
        db.info("Enter SynchronizationModel init()");
        this.dispatcher = this.nodeModel.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectSync, 0, (Observer)this);
            this.dispatcher.addObserver(ObjectType.ObjectSync, 1, (Observer)this);
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectSync, 0, (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectSync, 1, (Observer)this);
        }
        this.syncReport = null;
        super.dispose();
    }

    public void destroy() {
        db.info("Enter SynchronizationModel destroy()");
        super.destroy();
        this.bits1.destroy();
        this.bits2.destroy();
        this.neRef.destroy();
        this.ext1Ref.destroy();
        this.ext2Ref.destroy();
        this.intClk.destroy();
        this.noSync.destroy();
    }

    public void update(Observable observable, Object object) {
        this.setChanged();
        db.info("update(): calling notifyObservers(CHANGED)");
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public IEntityModel[] getRefCandidates(eTimingMode eTimingMode2, eRef eRef2) {
        ArrayList<SyncEntityModel> arrayList = new ArrayList<SyncEntityModel>();
        if (eTimingMode2 != eTimingMode.EXT_TIME && eTimingMode2 != eTimingMode.LINE_TIME && eTimingMode2 != eTimingMode.MIXED_TIME) {
            throw new IllegalArgumentException("Invalid mode passed to SynchronizationModel.getRefCandidates");
        }
        if (eRef2 == eRef.NE) {
            arrayList.add(this.intClk);
            if (eTimingMode2 == eTimingMode.EXT_TIME || eTimingMode2 == eTimingMode.MIXED_TIME) {
                arrayList.add(this.bits1);
                if (this.nodeModel.getPlatform().supportsBits2()) {
                    arrayList.add(this.bits2);
                }
            }
            if (eTimingMode2 == eTimingMode.LINE_TIME || eTimingMode2 == eTimingMode.MIXED_TIME) {
                arrayList.addAll(this.getElementModelsDelegate().getNonProtectOpticalEntities());
                if (this.nodeModel.getPlatform().supportsDWDM()) {
                    arrayList.addAll(this.getDwdmRefCandidates());
                    arrayList.addAll(this.getOscPorts());
                }
                if (this.nodeModel.getPlatform().isDs1TimingSupported()) {
                    arrayList.addAll(this.getDs1RefCandidates());
                }
            }
        } else if (eRef2 == eRef.EXT_1 || eRef2 == eRef.EXT_2) {
            arrayList.add(this.noSync);
            if (eTimingMode2 == eTimingMode.LINE_TIME) {
                arrayList.add(this.neRef);
            }
            arrayList.addAll(this.getElementModelsDelegate().getNonProtectOpticalEntities());
            if (this.nodeModel.getPlatform().supportsDWDM()) {
                arrayList.addAll(this.getDwdmRefCandidates());
                arrayList.addAll(this.getOscPorts());
            }
        } else {
            throw new IllegalArgumentException("Invalid ref passed to SynchronizationModel.getRefCandidates");
        }
        return arrayList.toArray(new EntityModel[0]);
    }

    public sSyncConfig getConfig() {
        try {
            return (sSyncConfig)this.config.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "getConfig", userException);
        }
    }

    public void setConfig(sSyncConfig sSyncConfig2) throws ConfigError, SyncProvBusy, InvalidQuality {
        try {
            this.config.set(sSyncConfig2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xSyncProvBusy xSyncProvBusy2) {
            throw new SyncProvBusy((UserException)xSyncProvBusy2);
        }
        catch (xInvalidQuality xInvalidQuality2) {
            throw new InvalidQuality((UserException)xInvalidQuality2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "setConfig", userException);
        }
    }

    public int getStatus(int n) throws xNoSuchInterface {
        try {
            return (Integer)this.status.get(new Integer(n));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw xNoSuchInterface2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "getStatus", userException);
        }
    }

    public sLineSyncConfig getSonetConfig(int n) throws xUnsupportedOperation, xNoSuchInterface {
        try {
            return (sLineSyncConfig)this.sonetSysConfig.get(new Integer(n));
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw xUnsupportedOperation2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw xNoSuchInterface2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "getSonetConfig", userException);
        }
    }

    public void setSonetConfig(int n, sLineSyncConfig sLineSyncConfig2) throws ConfigError, UnsupportedOperation, SyncProvBusy, InvalidQuality, NoSuchInterface {
        try {
            Object[] objectArray = new Object[]{new Integer(n), sLineSyncConfig2};
            this.sonetSysConfig.set(objectArray);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xSyncProvBusy xSyncProvBusy2) {
            throw new SyncProvBusy((UserException)xSyncProvBusy2);
        }
        catch (xInvalidQuality xInvalidQuality2) {
            throw new InvalidQuality((UserException)xInvalidQuality2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "setSonetConfig", userException);
        }
    }

    public int getBitsIndex(eBits eBits2) throws xNoSuchInterface {
        try {
            return (Integer)this.bitsIndex.get(eBits2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw xNoSuchInterface2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "getBitsIndex", userException);
        }
    }

    public sBitsConfig getBitsConfig(eBits eBits2) throws xNoSuchInterface {
        try {
            return (sBitsConfig)this.bitsConfig.get(eBits2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw xNoSuchInterface2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "getBitsConfig", userException);
        }
    }

    public void setBitsConfig(eBits eBits2, sBitsConfig sBitsConfig2) throws Busy, InvalidClockSource, ConfigError, UnsupportedOperation, InvalidQuality, SyncProvBusy, SyncProvError, NoSuchInterface, StandbyTccNotReady {
        try {
            Object[] objectArray = new Object[]{eBits2, sBitsConfig2};
            this.bitsConfig.set(objectArray);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xInvalidClockSource xInvalidClockSource2) {
            throw new InvalidClockSource((UserException)xInvalidClockSource2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xInvalidQuality xInvalidQuality2) {
            throw new InvalidQuality((UserException)xInvalidQuality2);
        }
        catch (xSyncProvBusy xSyncProvBusy2) {
            throw new SyncProvBusy((UserException)xSyncProvBusy2);
        }
        catch (xSyncProvError xSyncProvError2) {
            this.detailedSyncProvError(xSyncProvError2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xStandbyTccNotReady xStandbyTccNotReady2) {
            throw new StandbyTccNotReady((UserException)xStandbyTccNotReady2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "setBitsConfig", userException);
        }
    }

    public int getRefIndex(eRef eRef2) throws xNoSuchInterface {
        try {
            return (Integer)this.refIndex.get(eRef2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw xNoSuchInterface2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "getRefIndex", userException);
        }
    }

    public int getActiveRefSource(eRef eRef2) {
        try {
            return (Integer)this.activeRefSource.get(eRef2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "getActiveRefSource", userException);
        }
    }

    public sInfo[] getRefSources(eRef eRef2) {
        try {
            return (sInfo[])this.refSources.get(eRef2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "getRefSources", userException);
        }
    }

    public sDemandData[] getOnDemandData() {
        try {
            db.fine("Getting onDemandData");
            return (sDemandData[])this.onDemandReport.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "getOnDemandData", userException);
        }
    }

    public String getSyncReport() {
        if (this.syncReport == null) {
            db.fine("creating new HtmlSynchronizationReport");
            this.syncReport = new HtmlSynchronizationReport(this);
        }
        db.fine("generating HtmlSynchronizationReport");
        return this.syncReport.generateReport();
    }

    public EntityModel[] getRefEntities(eRef eRef2) {
        sInfo[] sInfoArray = this.getRefSources(eRef2);
        EntityModel[] entityModelArray = new EntityModel[sInfoArray.length];
        EntityTableModel entityTableModel = this.nodeModel.getEntityTableModel();
        for (int i = 0; i < sInfoArray.length; ++i) {
            EntityModel entityModel = null;
            int n = sInfoArray[i].line;
            if (n == this.BITS_1) {
                entityModel = this.bits1;
            } else if (n == this.BITS_2) {
                entityModel = this.bits2;
            } else if (n == this.NE_REF) {
                entityModel = this.neRef;
            } else if (n == this.INT_CLOCK) {
                entityModel = this.intClk;
            } else if (n == this.NO_CLOCK) {
                entityModel = this.noSync;
            } else {
                try {
                    entityModel = (EntityModel)entityTableModel.getEntityModelByIndex(sInfoArray[i].line);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                if (entityModel == null) {
                    db.severe("refList[i].line = " + sInfoArray[i].line + ", but refEntity = null");
                }
            }
            entityModelArray[i] = entityModel;
        }
        return entityModelArray;
    }

    public SyncEntityModel getInternalClockReference() {
        return this.intClk;
    }

    public SyncEntityModel getNoClockReference() {
        return this.noSync;
    }

    public void setRefSources(eRef eRef2, int[] nArray) throws BadReference, SyncSourceAlreadyDefinedForSlot, SyncProvBusy, InvalidClockSource, SyncProvError, IncompatibleTimingMode {
        try {
            Object[] objectArray = new Object[]{eRef2, nArray};
            this.refSources.set(objectArray);
        }
        catch (xBadReference xBadReference2) {
            throw new BadReference((UserException)xBadReference2);
        }
        catch (xSyncSourceAlreadyDefinedForSlot xSyncSourceAlreadyDefinedForSlot2) {
            throw new SyncSourceAlreadyDefinedForSlot((UserException)xSyncSourceAlreadyDefinedForSlot2);
        }
        catch (xSyncProvBusy xSyncProvBusy2) {
            throw new SyncProvBusy((UserException)xSyncProvBusy2);
        }
        catch (xInvalidClockSource xInvalidClockSource2) {
            throw new InvalidClockSource((UserException)xInvalidClockSource2);
        }
        catch (xSyncProvError xSyncProvError2) {
            this.detailedSyncProvError(xSyncProvError2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "setRefSources", userException);
        }
    }

    public void switchRefSource(eRef eRef2, int n, eManSwitchType eManSwitchType2) throws xBadReference, xBusy, xInvalidClockSource, xBadQuality {
        try {
            Object[] objectArray = new Object[]{eRef2, new Integer(n), eManSwitchType2};
            this.switchRefSource.set(objectArray);
        }
        catch (xBadReference xBadReference2) {
            throw xBadReference2;
        }
        catch (xBusy xBusy2) {
            throw xBusy2;
        }
        catch (xInvalidClockSource xInvalidClockSource2) {
            throw xInvalidClockSource2;
        }
        catch (xBadQuality xBadQuality2) {
            throw xBadQuality2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "switchRefSource", userException);
        }
    }

    public void releaseRefSource(eRef eRef2) throws xNoSwitchCommandActive {
        try {
            this.releaseRefSource.set(eRef2);
        }
        catch (xNoSwitchCommandActive xNoSwitchCommandActive2) {
            throw xNoSwitchCommandActive2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "releaseRefSource", userException);
        }
    }

    public sRefSwitchStatus getManualSwitchStatus(eRef eRef2) {
        try {
            return (sRefSwitchStatus)this.manualSwitchStatus.get(eRef2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(db, "getManualSwitchStatus", userException);
        }
    }

    public EntityModel getEntityModelByIndex(int n) throws AbstractCmsNoSuchEntityException {
        if (n == this.bits1.getIndex()) {
            return this.bits1;
        }
        if (n == this.bits2.getIndex()) {
            return this.bits2;
        }
        if (n == this.ext1Ref.getIndex()) {
            return this.ext1Ref;
        }
        if (n == this.ext2Ref.getIndex()) {
            return this.ext2Ref;
        }
        if (n == this.intClk.getIndex()) {
            return this.intClk;
        }
        if (n == this.noSync.getIndex()) {
            return this.noSync;
        }
        if (n == this.neRef.getIndex()) {
            return this.neRef;
        }
        return (EntityModel)this.nodeModel.getEntityTableModel().getEntityModelByIndex(n);
    }

    private Set getDwdmRefCandidates() {
        Set set = this.getElementModelsDelegate().getNonProtectDwdmEntities();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            if (((DwdmPortModel)iterator.next()).supportTiming()) continue;
            iterator.remove();
        }
        return set;
    }

    private Set getOscPorts() {
        HashSet<TdmPortModel> hashSet = new HashSet<TdmPortModel>();
        sOscPort[] sOscPortArray = null;
        try {
            sOscPortArray = this.nodeModel.getDwdmOpticalSetupModel().getOscPortList();
        }
        catch (FeatureUnsupported featureUnsupported) {
            db.info(featureUnsupported.toString());
        }
        catch (CannotPerform cannotPerform) {
            db.severe(cannotPerform.toString());
        }
        if (sOscPortArray != null) {
            IEntityModel iEntityModel = null;
            for (int i = 0; i < sOscPortArray.length; ++i) {
                block7: {
                    try {
                        iEntityModel = null;
                        iEntityModel = this.nodeModel.getEntityTableModel().getEntityModelByIndex(sOscPortArray[i].oscPort);
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!db.on()) break block7;
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
                if (iEntityModel == null || !(iEntityModel instanceof TdmPortModel)) continue;
                hashSet.add((TdmPortModel)iEntityModel);
            }
        }
        return hashSet;
    }

    private static boolean getDs1RetimingEnabled(PortModel portModel) throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType {
        return ((Ds1LineModel)portModel.getInterfaceModel()).getDs1RetimingEnabled();
    }

    private List getDs1Ports() {
        return this.nodeModel.getChassis().getDescendantsOfEqType(34);
    }

    private Set getDs1RefCandidates() {
        HashSet<PortModel> hashSet = new HashSet<PortModel>();
        Iterator iterator = this.getDs1Ports().iterator();
        while (iterator.hasNext()) {
            try {
                PortModel portModel = (PortModel)iterator.next();
                if (SynchronizationModel.getDs1RetimingEnabled(portModel)) continue;
                hashSet.add(portModel);
            }
            catch (UnsupportedOperation unsupportedOperation) {
            }
            catch (NoSuchInterface noSuchInterface) {
            }
            catch (WrongInterfaceType wrongInterfaceType) {}
        }
        return hashSet;
    }

    public String toString() {
        return "Sync[]";
    }

    private void detailedSyncProvError(xSyncProvError xSyncProvError2) throws SyncInvalidFormat, SyncInvalidCoding, SyncInvalidAisThreshold, SyncInvalidFacility, SyncInvalidRefSource, SyncInvalidProvisioningForMode, SyncProvError {
        switch (xSyncProvError2.reason.value()) {
            case 0: {
                throw new SyncInvalidFormat((UserException)xSyncProvError2);
            }
            case 1: {
                throw new SyncInvalidCoding((UserException)xSyncProvError2);
            }
            case 2: {
                throw new SyncInvalidAisThreshold((UserException)xSyncProvError2);
            }
            case 3: {
                throw new SyncInvalidFacility((UserException)xSyncProvError2);
            }
            case 4: {
                throw new SyncInvalidRefSource((UserException)xSyncProvError2);
            }
            case 5: {
                throw new SyncInvalidProvisioningForMode((UserException)xSyncProvError2);
            }
        }
        throw new SyncProvError((UserException)xSyncProvError2);
    }

    public boolean isTimingSource(int n) {
        sInfo[] sInfoArray = this.getRefSources(eRef.NE);
        for (int i = 0; i < sInfoArray.length; ++i) {
            if (sInfoArray[i].line != n) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        db = new SDebug("Sync");
    }

    class RefCandidates
    extends NonCachedValue {
        public RefCandidates(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) {
            Object[] objectArray = (Object[])object;
            return SynchronizationModel.this.getRefCandidates((eTimingMode)objectArray[0], (eRef)objectArray[1]);
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    class ManualSwitchStatus
    extends NonCachedValue {
        public ManualSwitchStatus(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) {
            return SynchronizationModel.this.getSynchronizationRef().getManualSwitchStatus((eRef)object);
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    class ReleaseRefSource
    extends NonCachedValue {
        public ReleaseRefSource(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xNoSwitchCommandActive {
            SynchronizationModel.this.getSynchronizationRef().releaseRefSource((eRef)object);
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    class SwitchRefSource
    extends NonCachedValue {
        public SwitchRefSource(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xBadReference, xBusy, xInvalidClockSource, xBadQuality {
            Object[] objectArray = (Object[])object;
            SynchronizationModel.this.getSynchronizationRef().switchRefSource((eRef)objectArray[0], (Integer)objectArray[1], (eManSwitchType)objectArray[2]);
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    class OnDemandReport
    extends NonCachedValue {
        public OnDemandReport(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            db.fine("Retrieving demand data array");
            sDemandData[] sDemandDataArray = SynchronizationModel.this.getSynchronizationRef().getSyncOnDemandReport();
            db.fine("Retrieved demand data array " + (sDemandDataArray == null ? "null" : Integer.toString(sDemandDataArray.length)));
            return sDemandDataArray;
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    class RefSources
    extends NonCachedValue {
        public RefSources(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xBadReference, xSyncSourceAlreadyDefinedForSlot, xSyncProvBusy, xInvalidClockSource, xSyncProvError {
            Object[] objectArray = (Object[])object;
            SynchronizationModel.this.getSynchronizationRef().setRefSources((eRef)objectArray[0], (int[])objectArray[1]);
        }

        protected Object getValue(Object object) {
            sInfo[] sInfoArray = SynchronizationModel.this.getSynchronizationRef().getRefSources((eRef)object);
            if (object.equals(eRef.NE)) {
                sInfo[] sInfoArray2 = new sInfo[sInfoArray.length + 1];
                for (int i = 0; i < sInfoArray.length; ++i) {
                    sInfoArray2[i] = sInfoArray[i];
                }
                sInfoArray2[sInfoArray.length] = new sInfo(SynchronizationModel.this.INT_CLOCK, true, eQualityLevel.ST3);
                return sInfoArray2;
            }
            return sInfoArray;
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    class ActiveRefSource
    extends NonCachedValue {
        public ActiveRefSource(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) {
            Integer n = new Integer(SynchronizationModel.this.getSynchronizationRef().getActiveRefSource((eRef)object));
            if (n == 0) {
                if (object.equals(eRef.NE)) {
                    return new Integer(SynchronizationModel.this.INT_CLOCK);
                }
                return new Integer(SynchronizationModel.this.NO_CLOCK);
            }
            return n;
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    class RefIndex
    extends NonCachedValue {
        public RefIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchInterface {
            return new Integer(SynchronizationModel.this.getSynchronizationRef().getRefIndex((eRef)object));
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    class BitsConfig
    extends NonCachedValue {
        public BitsConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xBusy, xInvalidClockSource, xConfigError, xUnsupportedOperation, xInvalidQuality, xSyncProvBusy, xSyncProvError, xNoSuchInterface, xStandbyTccNotReady {
            Object[] objectArray = (Object[])object;
            SynchronizationModel.this.getSynchronizationRef().setBitsConfig((eBits)objectArray[0], (sBitsConfig)objectArray[1]);
        }

        protected Object getValue(Object object) throws xNoSuchInterface {
            return SynchronizationModel.this.getSynchronizationRef().getBitsConfig((eBits)object);
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    class BitsIndex
    extends NonCachedValue {
        public BitsIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchInterface {
            return new Integer(SynchronizationModel.this.getSynchronizationRef().getBitsIndex((eBits)object));
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    class SonetSysConfig
    extends NonCachedValue {
        public SonetSysConfig(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xConfigError, xUnsupportedOperation, xSyncProvBusy, xInvalidQuality, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            SynchronizationModel.this.getSynchronizationRef().setSonetConfig((Integer)objectArray[0], (sLineSyncConfig)objectArray[1]);
        }

        protected Object getValue(Object object) throws xUnsupportedOperation, xNoSuchInterface {
            return SynchronizationModel.this.getSynchronizationRef().getSonetConfig((Integer)object);
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    class Status
    extends NonCachedValue {
        public Status(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchInterface {
            return new Integer(SynchronizationModel.this.getSynchronizationRef().getStatus((Integer)object));
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }

    class Config
    extends NonCachedValue {
        public Config(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xConfigError, xSyncProvBusy, xInvalidQuality {
            SynchronizationModel.this.getSynchronizationRef().setConfig((sSyncConfig)object);
        }

        protected Object getValue() {
            return SynchronizationModel.this.getSynchronizationRef().getConfig();
        }

        public Object outer() {
            return SynchronizationModel.this;
        }
    }
}

