/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.SonetTopology.SonetFactory;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.TapModel;
import cerent.cms.model.TapModelCollection;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;

public abstract class TapModels
extends CmsObservable
implements Observer {
    NodeModelDelegate node;
    TapModelCollection parent;
    private EventDispatcher dispatcher;
    HashMap tapModelMap = new HashMap();
    SonetFactory sf;
    protected TapModelDebug db;

    public TapModels(TapModelCollection tapModelCollection, String string) {
        this.parent = tapModelCollection;
        this.node = tapModelCollection.getNodeModel();
        this.db = new TapModelDebug(this.node.db, string);
        this.dispatcher = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectTapList, 0, (Observer)this);
        }
        this.sf = this.getSonetFactoryRef();
        TapModels tapModels = this;
        synchronized (tapModels) {
            this.tapModelMap = this.discover();
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        HashMap hashMap;
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectTapList, 0, (Observer)this);
            this.dispatcher = null;
        }
        Object object = this;
        synchronized (object) {
            hashMap = (HashMap)this.tapModelMap.clone();
        }
        object = hashMap.values().iterator();
        while (object.hasNext()) {
            try {
                ((TapModel)object.next()).dispose();
            }
            catch (Exception exception) {
                this.db.println("Unexpected exception " + exception);
                TapModelDebug.printStackTrace((Throwable)exception);
            }
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.DELETED);
    }

    public SonetFactory getSonetFactoryRef() {
        return this.node.getIorRepository().getSonetFactoryRef();
    }

    protected abstract void addTapModels(HashMap var1, HashMap var2);

    protected abstract void discoverTapItems(HashMap var1);

    private synchronized HashMap discover() {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        this.discoverTapItems(hashMap2);
        this.addTapModels(hashMap2, hashMap);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStructure() {
        TapModels tapModels = this;
        synchronized (tapModels) {
            HashMap hashMap = new HashMap();
            this.discoverTapItems(hashMap);
            Iterator iterator = this.tapModelMap.keySet().iterator();
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                Short s = (Short)iterator.next();
                if (hashMap.containsKey(s)) {
                    if (this.db.on) {
                        this.db.println("Removing " + s + " from New List");
                    }
                    hashMap.remove(s);
                    continue;
                }
                if (this.db.on) {
                    this.db.println("Adding " + s + " to Deleted List");
                }
                arrayList.add(this.tapModelMap.get(s));
            }
            if (hashMap.size() > 0) {
                if (this.db.on) {
                    this.db.println(hashMap.size() + " New Taps have been added");
                }
                this.addTapModels(hashMap, this.tapModelMap);
                this.setChanged();
            }
            this.deleteTaps(arrayList);
        }
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            if (n == 2) {
                this.updateStructure();
            } else if (this.db.on) {
                this.db.println("Unexpected Update type in " + this.getClass().getName());
                this.db.println("Update type is " + n);
            }
        }
    }

    protected synchronized void deleteTaps(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TapModel tapModel = (TapModel)iterator.next();
            if (this.db.on) {
                this.db.println("Deleting " + tapModel + " from Main list");
            }
            this.delete(tapModel);
            tapModel.dispose();
        }
    }

    protected synchronized void delete(TapModel tapModel) {
        this.tapModelMap.remove(new Short(tapModel.getTapNumber()));
    }

    public void destroy() {
        this.dispose();
        this.tapModelMap = null;
        this.node = null;
        this.parent = null;
        if (this.db != null) {
            this.db.dispose();
            this.db = null;
        }
    }

    public class TapModelDebug
    extends SDebug {
        public TapModelDebug(SDebug sDebug, String string) {
            super((KDebug)sDebug, string);
        }

        public final void updateTapStructure() {
            TapModels.this.updateStructure();
        }
    }
}

