/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.eQualityLevel;
import cerent.cms.idl.Common.sStsInfo;
import cerent.cms.idl.Common.xInvalidRange;
import cerent.cms.idl.Dwdm.eDataRate;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.sLineSyncConfig;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xInvalidState;
import cerent.cms.idl.If.xLoopbackActive;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xSyncProvBusy;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.SonetMedia.General;
import cerent.cms.idl.SonetMedia.eBlsrExtensionByte;
import cerent.cms.idl.SonetMedia.eMediumType;
import cerent.cms.idl.SonetMedia.ePathTraceMode;
import cerent.cms.idl.SonetMedia.eSectionTraceFormat;
import cerent.cms.idl.SonetMedia.eSectionTraceMode;
import cerent.cms.idl.SonetMedia.eStm1eMode;
import cerent.cms.idl.SonetMedia.sLaserParams;
import cerent.cms.idl.SonetMedia.sLineInfo;
import cerent.cms.idl.SonetMedia.sLineStats;
import cerent.cms.idl.SonetMedia.sLineStats600;
import cerent.cms.idl.SonetMedia.sLineStats600ListHolder;
import cerent.cms.idl.SonetMedia.sLineStatsHolder;
import cerent.cms.idl.SonetMedia.sLineThresholds;
import cerent.cms.idl.SonetMedia.sLineThresholds600;
import cerent.cms.idl.SonetMedia.sLineThresholds600Holder;
import cerent.cms.idl.SonetMedia.sLineThresholdsHolder;
import cerent.cms.idl.SonetMedia.sPathInfo;
import cerent.cms.idl.SonetMedia.sPathStats;
import cerent.cms.idl.SonetMedia.sPathStatsHolder;
import cerent.cms.idl.SonetMedia.sPathThresholds;
import cerent.cms.idl.SonetMedia.sPathThresholdsHolder;
import cerent.cms.idl.SonetMedia.sPhysicalStats;
import cerent.cms.idl.SonetMedia.sPhysicalStats600;
import cerent.cms.idl.SonetMedia.sPhysicalStats600ListHolder;
import cerent.cms.idl.SonetMedia.sPhysicalStatsHolder;
import cerent.cms.idl.SonetMedia.sPhysicalThresholds;
import cerent.cms.idl.SonetMedia.sPhysicalThresholdsHolder;
import cerent.cms.idl.SonetMedia.sSectionStats;
import cerent.cms.idl.SonetMedia.sSectionStats600;
import cerent.cms.idl.SonetMedia.sSectionStats600ListHolder;
import cerent.cms.idl.SonetMedia.sSectionStatsHolder;
import cerent.cms.idl.SonetMedia.sSectionThresholds;
import cerent.cms.idl.SonetMedia.sSectionThresholds600;
import cerent.cms.idl.SonetMedia.sSectionThresholds600Holder;
import cerent.cms.idl.SonetMedia.sSectionThresholdsHolder;
import cerent.cms.idl.SonetMedia.sSectionTrace;
import cerent.cms.idl.SonetMedia.sSonetLineAttributes;
import cerent.cms.idl.SonetMedia.sStsPathTraceInfo;
import cerent.cms.idl.SonetMedia.xClearPMStatsError;
import cerent.cms.idl.Synchronization.Sync;
import cerent.cms.idl.Synchronization.sInfo;
import cerent.cms.idl.Synchronization.xInvalidQuality;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AbstractPersistableModelState;
import cerent.cms.model.AdminState;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.ElementModel;
import cerent.cms.model.FramingType;
import cerent.cms.model.HoConnectionModel;
import cerent.cms.model.IAdminLineAccess;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IGenericTraceLine;
import cerent.cms.model.IOhConnectionModels;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmLineModel;
import cerent.cms.model.InService;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidLoopbackProvision;
import cerent.cms.model.InvalidQuality;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoConnectionModel;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.PathTraceInfo;
import cerent.cms.model.PoolModel;
import cerent.cms.model.SyncProvBusy;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.TdmLineInterfaceAttrs;
import cerent.cms.model.TdmLineStats;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.YCableModel;
import cerent.util.EnumStrings;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.SDHTDMTerminology;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.UserException;

public class TdmLineModel
extends InterfaceModel
implements ITdmLineModel,
IGenericTraceLine,
IAdminLineAccess {
    private static final int STS1_FRAME_RATE = 51840000;
    private BerLevel berLevel;
    private PmThresholds pmThresholds;
    private BlsrProtectPmThresholds blsrProtectPmThresholds;
    private BlsrProtectPmPathStats blsrProtectPmPathStats;
    private LineStats lineStats;
    private Status status;
    private ReceivedSectionTrace receivedSectionTrace;
    private GetPathTraces getPathTraces;
    private CurrentQuality currentQuality;
    private CurrentLaserParams currentLaserParams;
    private SetOpr setOpr;
    private SectionThresholds sectionThreshold;
    private LineThresholds lineThreshold;
    private PhysThresholds physThreshold;
    private LinePhysStats linePhysStats;
    private ClearStatsPerParam clearStatsPerParam;
    private ClearAllStatsForLine clearAllStatsForLine;
    private ClearAllStatsForCard clearAllStatsForCard;
    private AbstractPersistableModelState attrs;
    static /* synthetic */ Class class$cerent$cms$model$TdmLineModel;
    static /* synthetic */ Class class$cerent$cms$model$TdmLineInterfaceAttrs;

    public TdmLineModel(NodeModelDelegate nodeModelDelegate, int n) {
        this(nodeModelDelegate, n, (sInterface)null);
    }

    public TdmLineModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2) {
        super(nodeModelDelegate, n, sInterface2, nodeModelDelegate.getChildDebug(class$cerent$cms$model$TdmLineModel == null ? (class$cerent$cms$model$TdmLineModel = TdmLineModel.class$("cerent.cms.model.TdmLineModel")) : class$cerent$cms$model$TdmLineModel));
        this.index = n;
        this.receivedSectionTrace = new ReceivedSectionTrace(nodeModelDelegate, "TdmLineModel.receivedSectionTrace");
        this.berLevel = new BerLevel(nodeModelDelegate, "TdmLineModel.berLevel");
        this.getPathTraces = new GetPathTraces(nodeModelDelegate, "TdmLineModel.getPathTraces");
        this.pmThresholds = new PmThresholds(nodeModelDelegate, "TdmLineModel.pmThresholds");
        this.blsrProtectPmThresholds = new BlsrProtectPmThresholds(nodeModelDelegate, "TdmLineModel.blsrProtectPmThreholds");
        this.blsrProtectPmPathStats = new BlsrProtectPmPathStats(nodeModelDelegate, "TdmLineModel.blsrProtectPmPathStats");
        this.lineStats = new LineStats(nodeModelDelegate, "TdmLineModel.lineStats");
        this.status = new Status(nodeModelDelegate, "TdmLineModel.status");
        this.currentQuality = new CurrentQuality(nodeModelDelegate, "TdmLineModel.currentQuality");
        this.currentLaserParams = new CurrentLaserParams(nodeModelDelegate, "TdmLineModel.currentLaserParams");
        this.setOpr = new SetOpr(nodeModelDelegate, "TdmLineModel.setOpr");
        this.sectionThreshold = new SectionThresholds(nodeModelDelegate, "TdmLineModel.sectionThreshold");
        this.lineThreshold = new LineThresholds(nodeModelDelegate, "TdmLineModel.lineThreshold");
        this.physThreshold = new PhysThresholds(nodeModelDelegate, "TdmLineModel.physThreshold");
        this.linePhysStats = new LinePhysStats(nodeModelDelegate, "TdmLineModel.linePhysStats");
        this.clearStatsPerParam = new ClearStatsPerParam(nodeModelDelegate, "TdmLineModel.clearStatsPerParam");
        this.clearAllStatsForLine = new ClearAllStatsForLine(nodeModelDelegate, "TdmLineModel.clearAllStatsForLine");
        this.clearAllStatsForCard = new ClearAllStatsForCard(nodeModelDelegate, "TdmLineModel.clearAllStatsForCard");
    }

    public void setAttributes(sSonetLineAttributes sSonetLineAttributes2, long l) {
        super.setAttributes(sSonetLineAttributes2.base, l);
        this.getLineLoopbackCV().setValueExternally(sSonetLineAttributes2.lineLoopback, l);
        this.getLineBuildoutCV().setValueExternally(new Integer(sSonetLineAttributes2.lineBuildout), l);
        this.getSonetConfigCV().setValueExternally(sSonetLineAttributes2.syncConfig, l);
        this.getPointerMonitorStsNumberCV().setValueExternally(new Short(sSonetLineAttributes2.pointerMonitorStsNumber), l);
        this.getSdBerLevelCV().setValueExternally(new Short(sSonetLineAttributes2.sdBerLevel), l);
        this.getSfBerLevelCV().setValueExternally(new Short(sSonetLineAttributes2.sfBerLevel), l);
    }

    public void setAttributes(sSonetLineAttributes sSonetLineAttributes2) {
        this.setAttributes(sSonetLineAttributes2, -1L);
    }

    public void dispose() {
        this.dispose(this.getModelType(this._getPersistType()));
        super.dispose();
    }

    public void destroy() {
        int n = this.getModelType(this._getPersistType());
        super.destroy();
        this.destroy(n);
    }

    public void clearStats(boolean bl, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2};
            this.lineStats.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearStats", userException);
        }
    }

    public boolean isCurrentlyActive() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Boolean)this.getCurrentlyActiveCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("isCurrentlyActive", userException);
        }
    }

    public short getBerLevel() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Short)this.berLevel.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getBerLevel", userException);
        }
    }

    public short getSdBerLevel() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Short)this.getSdBerLevelCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSdBerLevel", userException);
        }
    }

    public void setSdBerLevel(short s) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            this.getSdBerLevelCV().set(new Short(s));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSdBerLevel", userException);
        }
    }

    public short getSfBerLevel() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Short)this.getSfBerLevelCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSfBerLevel", userException);
        }
    }

    public void setSfBerLevel(short s) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            this.getSfBerLevelCV().set(new Short(s));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSfBerLevel", userException);
        }
    }

    public int getBlsrByte() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, AbstractCmsIOException {
        try {
            return ((eBlsrExtensionByte)this.getBlsrByteCV().get()).value();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface("Attempted to access a non-existent interface [ TdmLineModel.getBlsrByte(" + this.getIndex() + ") ].");
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType("Attempted an operation that cannot be performed for this interface type [ TdmLineModel.getBlsrByte(" + this.getIndex() + ") ].");
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation("Attempted an operation that cannot be performed for this interface type [ TdmLineModel.getBlsrByte(" + this.getIndex() + ") ].");
        }
        catch (UserException userException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)userException);
            }
            throw this.doUnknown("getBlsrByte", userException);
        }
    }

    public boolean supportsBlsrExtByte() {
        boolean bl;
        block5: {
            bl = false;
            try {
                IEntityModel iEntityModel = this.getPortModel().getParent();
                if (iEntityModel.getEqType() == 11) {
                    String string;
                    int n = iEntityModel.getSlot();
                    ArrayList arrayList = iEntityModel.getNodeModel().getMfgData();
                    if (n > 0 && (string = (String)arrayList.get(n - 1)) != null && string.indexOf("AS") != -1) {
                        bl = true;
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block5;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        if (this.node.getPlatform().is600()) {
            bl = true;
        }
        return bl;
    }

    public void setBlsrByte(eBlsrExtensionByte eBlsrExtensionByte2) throws NoSuchInterface, WrongInterfaceType, ConfigError, AbstractCmsIOException {
        if (this.supportsBlsrExtByte()) {
            try {
                this.getBlsrByteCV().set(eBlsrExtensionByte2);
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface("Attempted to access a non-existent interface [ TdmLineModel.setBlsrByte(" + this.getIndex() + ") ].");
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType("Attempted an operation that cannot be performed for this interface type [ TdmLineModel.setBlsrByte(" + this.getIndex() + ") ].");
            }
            catch (xConfigError xConfigError2) {
                throw new ConfigError("Configuration error for TdmLineModel.getBlsrByte[" + this.getIndex() + "]");
            }
            catch (UserException userException) {
                throw this.doUnknown("setBlsrByte", userException);
            }
        } else if (this.db.on()) {
            this.db.println("supportBlsrExtByte() check failed.");
        }
    }

    public void setBlsrByte(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError, AbstractCmsIOException {
        this.setBlsrByte(eBlsrExtensionByte.from_int(n));
    }

    public sLineSyncConfig getSonetConfig() throws NoSuchInterface, UnsupportedOperation {
        sLineSyncConfig sLineSyncConfig2 = null;
        try {
            sLineSyncConfig2 = (sLineSyncConfig)this.getSonetConfigCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSonetConfig", userException);
        }
        return sLineSyncConfig2;
    }

    public void setSonetConfig(sLineSyncConfig sLineSyncConfig2) throws NoSuchInterface, UnsupportedOperation, ConfigError, SyncProvBusy, InvalidQuality {
        try {
            this.getSonetConfigCV().set(sLineSyncConfig2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xSyncProvBusy xSyncProvBusy2) {
            throw new SyncProvBusy((UserException)xSyncProvBusy2);
        }
        catch (xInvalidQuality xInvalidQuality2) {
            throw new InvalidQuality((UserException)xInvalidQuality2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSonetConfig", userException);
        }
    }

    public sLineInfo getLineInfo() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sLineInfo)this.getLineInfoCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getLineInfo", userException);
        }
    }

    public int getMediumType() {
        int n = this.getNodeModel().getFramingType();
        int n2 = 1;
        if (FramingType.getFramingType((int)n).isSdh()) {
            n2 = 0;
        } else {
            try {
                n2 = this.getLineInfoMediumType();
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return n2;
    }

    public int getLineInfoMediumType() throws NoSuchInterface, WrongInterfaceType {
        return this.getLineInfo().mediumType.value();
    }

    public void setLineInfoMediumType(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            this.getLineInfoCV().set(eMediumType.from_int(n));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setLineInfoMediumType", userException);
        }
    }

    public int getLineBuildout() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Integer)this.getLineBuildoutCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getLineBuildout", userException);
        }
    }

    public void setLineBuildout(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            this.getLineBuildoutCV().set(new Integer(n));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setLineBuildout", userException);
        }
    }

    public eLoopback getLoopback() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eLoopback)this.getLineLoopbackCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getLoopback", userException);
        }
    }

    public void setLoopback(eLoopback eLoopback2) throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType, InService, LoopbackActive {
        try {
            this.getLineLoopbackCV().set(eLoopback2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInvalidState xInvalidState2) {
            throw new InService((UserException)xInvalidState2);
        }
        catch (xLoopbackActive xLoopbackActive2) {
            throw new LoopbackActive((UserException)xLoopbackActive2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setLoopback", userException);
        }
    }

    public void getPmThresholds(boolean bl, eIntervalType eIntervalType2, sSectionThresholds sSectionThresholds2, sLineThresholds sLineThresholds2) throws NoSuchInterface, WrongInterfaceType {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2};
            Object[] objectArray2 = (Object[])this.pmThresholds.get(objectArray);
            sSectionThresholds sSectionThresholds3 = (sSectionThresholds)objectArray2[0];
            sLineThresholds sLineThresholds3 = (sLineThresholds)objectArray2[1];
            sSectionThresholds2.es = sSectionThresholds3.es;
            sSectionThresholds2.ses = sSectionThresholds3.ses;
            sSectionThresholds2.sefs = sSectionThresholds3.sefs;
            sSectionThresholds2.cv = sSectionThresholds3.cv;
            sSectionThresholds2.bbe = sSectionThresholds3.bbe;
            sLineThresholds2.es = sLineThresholds3.es;
            sLineThresholds2.ses = sLineThresholds3.ses;
            sLineThresholds2.cv = sLineThresholds3.cv;
            sLineThresholds2.uas = sLineThresholds3.uas;
            sLineThresholds2.fc = sLineThresholds3.fc;
            sLineThresholds2.bbe = sLineThresholds3.bbe;
            sLineThresholds2.psc = sLineThresholds3.psc;
            sLineThresholds2.psd = sLineThresholds3.psd;
            sLineThresholds2.pscw = sLineThresholds3.pscw;
            sLineThresholds2.psdw = sLineThresholds3.psdw;
            sLineThresholds2.pscs = sLineThresholds3.pscs;
            sLineThresholds2.psds = sLineThresholds3.psds;
            sLineThresholds2.pscr = sLineThresholds3.pscr;
            sLineThresholds2.psdr = sLineThresholds3.psdr;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getPmThresholds", userException);
        }
    }

    public void setPmThresholds(boolean bl, eIntervalType eIntervalType2, sSectionThresholds sSectionThresholds2, sLineThresholds sLineThresholds2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, sSectionThresholds2, sLineThresholds2};
            this.pmThresholds.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setPmThresholds", userException);
        }
    }

    public sLineThresholds getLinePmThresholds(eIntervalType eIntervalType2, boolean bl) throws NoSuchInterface, WrongInterfaceType {
        sSectionThresholds sSectionThresholds2 = new sSectionThresholds();
        sLineThresholds sLineThresholds2 = new sLineThresholds();
        this.getPmThresholds(bl, eIntervalType2, sSectionThresholds2, sLineThresholds2);
        return sLineThresholds2;
    }

    public sSectionThresholds getSectionPmThresholds(eIntervalType eIntervalType2, boolean bl) throws NoSuchInterface, WrongInterfaceType {
        sSectionThresholds sSectionThresholds2 = new sSectionThresholds();
        sLineThresholds sLineThresholds2 = new sLineThresholds();
        this.getPmThresholds(bl, eIntervalType2, sSectionThresholds2, sLineThresholds2);
        return sSectionThresholds2;
    }

    public void setLinePmThresholds(eIntervalType eIntervalType2, boolean bl, sLineThresholds sLineThresholds2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        sSectionThresholds sSectionThresholds2 = this.getSectionPmThresholds(eIntervalType2, bl);
        this.setPmThresholds(bl, eIntervalType2, sSectionThresholds2, sLineThresholds2);
    }

    public void setSectionPmThresholds(eIntervalType eIntervalType2, boolean bl, sSectionThresholds sSectionThresholds2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        sLineThresholds sLineThresholds2 = this.getLinePmThresholds(eIntervalType2, bl);
        this.setPmThresholds(bl, eIntervalType2, sSectionThresholds2, sLineThresholds2);
    }

    public TdmLineStats getStats(boolean bl, eIntervalType eIntervalType2, short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, new Short(s)};
            Object[] objectArray2 = (Object[])this.lineStats.get(objectArray);
            sSectionStats sSectionStats2 = (sSectionStats)objectArray2[0];
            sLineStats sLineStats2 = (sLineStats)objectArray2[1];
            sPhysicalStats sPhysicalStats2 = (sPhysicalStats)objectArray2[2];
            return new TdmLineStats(sSectionStats2, sLineStats2, sPhysicalStats2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getStats", userException);
        }
    }

    public int getStatus() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Integer)this.status.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getStatus", userException);
        }
    }

    public short getPointerMonitorStsNumber() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Short)this.getPointerMonitorStsNumberCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getPointerMonitorStsNumber", userException);
        }
    }

    public void setLinePointerMonitorStsNumber(short s) throws NoSuchInterface, WrongInterfaceType {
        try {
            this.getPointerMonitorStsNumberCV().set(new Short(s));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setLinePointerMonitorStsNumber", userException);
        }
    }

    public boolean isUsedForSynchronization() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Boolean)this.getUsedForSynchronizationCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("isUsedForSynchronization", userException);
        }
    }

    public void setUsedForSynchronization(boolean bl) throws NoSuchInterface, WrongInterfaceType {
        try {
            this.getUsedForSynchronizationCV().set(new Boolean(bl));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setUsedForSynchronization", userException);
        }
    }

    public short getSectionSdBerLevel() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Short)this.getSectionSdBerLevelCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSectionSdBerLevel", userException);
        }
    }

    public void setSectionSdBerLevel(short s) throws NoSuchInterface, WrongInterfaceType {
        try {
            this.getSectionSdBerLevelCV().set(new Short(s));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSectionSdBerLevel", userException);
        }
    }

    public int getTraceMode() throws NoSuchInterface, WrongInterfaceType {
        return this.getTraceModeEnum().value();
    }

    public void setTraceMode(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, ConfigError {
        this.setTraceModeEnum(eSectionTraceMode.from_int(n));
    }

    public eSectionTraceMode getTraceModeEnum() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eSectionTraceMode)this.getSectionTraceModeCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSectionTraceMode", userException);
        }
    }

    public void setTraceModeEnum(eSectionTraceMode eSectionTraceMode2) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, ConfigError {
        try {
            this.getSectionTraceModeCV().set(eSectionTraceMode2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSectionTraceMode", userException);
        }
    }

    public int getTraceFormat() throws NoSuchInterface, WrongInterfaceType {
        return this.getTraceFormatEnum().value();
    }

    public void setTraceFormat(int n) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, ConfigError {
        this.setTraceFormatEnum(eSectionTraceFormat.from_int(n));
    }

    public eSectionTraceFormat getTraceFormatEnum() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eSectionTraceFormat)this.getSectionTraceFormatCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSectionTraceFormat", userException);
        }
    }

    public void setTraceFormatEnum(eSectionTraceFormat eSectionTraceFormat2) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, ConfigError {
        try {
            this.getSectionTraceFormatCV().set(eSectionTraceFormat2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSectionTraceFormat", userException);
        }
    }

    public String getSendTrace() throws NoSuchInterface, WrongInterfaceType {
        throw new NoSuchInterface("getSendTrace() no longer supported");
    }

    public IGenericTraceLine.Trace getSendTraceAsTrace() throws NoSuchInterface, WrongInterfaceType {
        try {
            sSectionTrace sSectionTrace2 = (sSectionTrace)this.getSendSectionTraceCV().get();
            return new IGenericTraceLine.Trace(sSectionTrace2.sectionTrace.toCharArray(), sSectionTrace2.valid);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSendSectionTrace", userException);
        }
    }

    public char[] getSendTraceAsCharArray() throws NoSuchInterface, WrongInterfaceType {
        IGenericTraceLine.Trace trace = this.getSendTraceAsTrace();
        return trace.getTrace();
    }

    public void setSendTrace(String string) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, ConfigError {
        try {
            this.getSendSectionTraceCV().set(string);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSendSectionTrace", userException);
        }
    }

    public char[] getExpectedTrace() throws NoSuchInterface, WrongInterfaceType {
        IGenericTraceLine.Trace trace = this.getExpectedTraceAsTrace();
        return trace.getTrace();
    }

    public IGenericTraceLine.Trace getExpectedTraceAsTrace() throws NoSuchInterface, WrongInterfaceType {
        try {
            sSectionTrace sSectionTrace2 = (sSectionTrace)this.getExpectedSectionTraceCV().get();
            return new IGenericTraceLine.Trace(sSectionTrace2.sectionTrace.toCharArray(), sSectionTrace2.valid);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getExpectedSectionTrace", userException);
        }
    }

    public void setExpectedTrace(String string) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, ConfigError {
        try {
            this.getExpectedSectionTraceCV().set(string);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setExpectedSectionTrace", userException);
        }
    }

    public char[] getReceivedTrace() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        IGenericTraceLine.Trace trace = this.getReceivedTraceAsTrace();
        return trace.getTrace();
    }

    public IGenericTraceLine.Trace getReceivedTraceAsTrace() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            sSectionTrace sSectionTrace2 = (sSectionTrace)this.receivedSectionTrace.get();
            return new IGenericTraceLine.Trace(sSectionTrace2.sectionTrace.toCharArray(), sSectionTrace2.valid);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getReceivedSectionTrace", userException);
        }
    }

    public boolean supportsAutoTrace() throws AbstractCmsNoSuchEntityException {
        return this.getModuleModel().supportsAutoTrace();
    }

    public boolean canRequestReceivedTrace() {
        boolean bl = false;
        try {
            eEqState eEqState2 = this.getModuleModel().getState();
            switch (eEqState2.value()) {
                case 4: 
                case 5: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return bl;
    }

    public boolean isSectionTerminated() {
        return true;
    }

    public boolean isLineTerminated() {
        return true;
    }

    public byte getCurrentPayloadLabel() throws NoSuchInterface, WrongInterfaceType {
        throw new WrongInterfaceType("Not supported");
    }

    public eStm1eMode getStm1eMode() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eStm1eMode)this.getStm1eModeCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getStm1eMode", userException);
        }
    }

    public void setStm1eMode(eStm1eMode eStm1eMode2) throws NoSuchInterface, WrongInterfaceType {
        try {
            this.getStm1eModeCV().set(eStm1eMode2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setStm1eMode", userException);
        }
    }

    public boolean isStmMode() throws NoSuchInterface, WrongInterfaceType {
        return this.getStm1eMode() == eStm1eMode.STM_MODE;
    }

    public int numHo() throws NoSuchInterface, WrongInterfaceType {
        long l = this.getInfo().ifSpeed;
        int n = this.getNodeModel().getFramingType();
        int n2 = FramingType.getFramingType((int)n).getMinimumHoPathWidth();
        long l2 = 51840000 * n2;
        return (int)(l / l2);
    }

    public static long unsignedIntToLong(int n) {
        if ((n & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            return (long)(n & Integer.MAX_VALUE) + (long)Math.pow(2.0, 31.0);
        }
        return n;
    }

    public boolean isProtectLine() {
        block5: {
            try {
                ElementModel elementModel;
                InterfaceModel interfaceModel = this.getHighestParent();
                if (interfaceModel == null) {
                    interfaceModel = this;
                }
                if ((elementModel = interfaceModel.getElementModel()) instanceof OnePlusOneModel) {
                    return interfaceModel.getIndex() == ((OnePlusOneModel)elementModel).getProtectEntityIndex();
                }
                if (elementModel instanceof YCableModel) {
                    return interfaceModel.getIndex() == ((YCableModel)elementModel).getProtectEntityIndex();
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!this.db.on()) break block5;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
        return false;
    }

    public boolean isBlsrProtectLine() {
        boolean bl;
        block3: {
            bl = false;
            try {
                BlsrModel blsrModel;
                ElementModel elementModel = this.getElementModel();
                if (elementModel instanceof BlsrModel && (blsrModel = (BlsrModel)elementModel).getType() == 3) {
                    int n = this.getIndex();
                    bl = blsrModel.getEastProtectEntityIndex() == n || blsrModel.getWestProtectEntityIndex() == n;
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
        return bl;
    }

    private static boolean isConnectionModelUpsr(ConnectionModel connectionModel) {
        switch (connectionModel.getConnectionType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public Map getUpsrConnectionModels() {
        Iterator iterator = this.getConnectionsList().iterator();
        ArrayList<ConnectionModel> arrayList = new ArrayList<ConnectionModel>();
        ArrayList<ConnectionModel> arrayList2 = new ArrayList<ConnectionModel>();
        ConnectionModel connectionModel = null;
        while (iterator.hasNext()) {
            connectionModel = (ConnectionModel)iterator.next();
            if (!TdmLineModel.isConnectionModelUpsr(connectionModel)) continue;
            if (connectionModel instanceof HoConnectionModel) {
                arrayList.add(connectionModel);
                continue;
            }
            if (!(connectionModel instanceof LoConnectionModel)) continue;
            arrayList2.add(connectionModel);
        }
        HoConnectionModel[] hoConnectionModelArray = arrayList.toArray(new HoConnectionModel[0]);
        LoConnectionModel[] loConnectionModelArray = arrayList2.toArray(new LoConnectionModel[0]);
        HashMap<String, ConnectionModel[]> hashMap = new HashMap<String, ConnectionModel[]>();
        hashMap.put("lo", loConnectionModelArray);
        hashMap.put("ho", hoConnectionModelArray);
        return hashMap;
    }

    public List getConnectionsList() {
        IPoolModel[] iPoolModelArray = this.getNodeModelDelegate().getPoolModels().getPoolModels(this.getIndex());
        if (this.db.on()) {
            this.db.println("Number of PoolModels= " + iPoolModelArray.length);
        }
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < iPoolModelArray.length; ++i) {
            PoolModel poolModel = (PoolModel)iPoolModelArray[i];
            if (poolModel == null) continue;
            linkedList.addAll(poolModel.getConnectionsList());
        }
        if (this.db.on()) {
            this.db.println("ConnectionsList: " + linkedList.size() + "(size), " + linkedList);
        }
        return linkedList;
    }

    public List getOhConnectionsList() {
        int n;
        ArrayList<IOhTermModel> arrayList = new ArrayList<IOhTermModel>();
        try {
            n = this.getPortModel().getIndex();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return arrayList;
        }
        IOhConnectionModels iOhConnectionModels = this.getNodeModel().getOhConnectionModels();
        IOhTermModel[] iOhTermModelArray = iOhConnectionModels.getOhTermModels();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < iOhTermModelArray.length; ++j) {
                if (!iOhTermModelArray[j].usingEntity(n)) continue;
                arrayList.add(iOhTermModelArray[j]);
            }
            iOhTermModelArray = iOhConnectionModels.getOhXconModels();
        }
        return arrayList;
    }

    public boolean isOhCircuitPresent(OhChannelType ohChannelType) {
        int n;
        try {
            n = this.getPortModel().getIndex();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return false;
        }
        IOhConnectionModels iOhConnectionModels = this.getNodeModel().getOhConnectionModels();
        return iOhConnectionModels.isChannelInUse(n, ohChannelType);
    }

    protected void updateLocal(long l) {
        this.getTdmLineInterfaceAttrs().update(l);
        super.updateLocal(l);
    }

    public int getLoopbackAsInt() throws NoSuchInterface, WrongInterfaceType {
        return this.getLoopback().value();
    }

    public boolean supportsOhChannel(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                try {
                    return this.getPortModel().getEqType() != 28 || this.getModuleModel().getEqType() == 106 || this.node.getPlatform().Oc3SupportsLDC();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (this.db.on()) {
                        this.db.println("Can't find the portModel");
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public void setAdminStateNoLpbk(eAdminState eAdminState2) throws NoSuchInterface, UnsupportedOperation, InvalidLoopbackProvision, WrongInterfaceType, InService, LoopbackActive, SyncProvError, InvalidState {
        if (this.getLoopbackAsInt() != 0 && !AdminState.admitsLoopback(eAdminState2)) {
            this.setLoopback(eLoopback.NO_LOOPBACK);
        }
        this.setAdminState(eAdminState2);
    }

    Sync getSynchronizationRef() {
        return this.getNodeModelDelegate().getIorRepository().getSynchronizationRef();
    }

    General getSonetRef() {
        return this.getNodeModelDelegate().getIorRepository().getSonetRef();
    }

    public sPathThresholds getBlsrProtectStsTermPmThresholds(sStsInfo sStsInfo2, boolean bl, eIntervalType eIntervalType2) throws NoSuchInterface, UnsupportedOperation, WrongInterfaceType {
        try {
            Object[] objectArray = new Object[]{sStsInfo2, new Boolean(bl), eIntervalType2};
            Object object = this.blsrProtectPmThresholds.get(objectArray);
            return (sPathThresholds)object;
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getBlsrProtectStsTermPmThresholds", userException);
        }
    }

    public sPathStats getBlsrProtectPathStats(sStsInfo sStsInfo2, boolean bl, eIntervalType eIntervalType2, short s) throws NoSuchInterface, UnsupportedOperation, WrongInterfaceType {
        try {
            Object[] objectArray = new Object[]{sStsInfo2, new Boolean(bl), eIntervalType2, new Short(s)};
            sPathStats sPathStats2 = (sPathStats)this.blsrProtectPmPathStats.get(objectArray);
            return sPathStats2;
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getBlsrProtectPathStats", userException);
        }
    }

    public PathTraceInfo[] getPathTracesForPort() throws UnsupportedOperation {
        PathTraceInfo[] pathTraceInfoArray = null;
        try {
            sStsPathTraceInfo[] sStsPathTraceInfoArray = (sStsPathTraceInfo[])this.getPathTraces.get();
            pathTraceInfoArray = new PathTraceInfo[sStsPathTraceInfoArray.length];
            for (int i = 0; i < sStsPathTraceInfoArray.length; ++i) {
                int n;
                sStsPathTraceInfo sStsPathTraceInfo2 = sStsPathTraceInfoArray[i];
                sPathInfo sPathInfo2 = sStsPathTraceInfo2.pathInfo;
                short s = sPathInfo2.startingSts;
                int n2 = this.getNodeModel().getFramingType();
                IHoNum iHoNum = HoLoFactory.idlSts2HoNum(n2, s);
                s = iHoNum.getHoNum();
                String string = sStsPathTraceInfo2.expectedString;
                String string2 = sStsPathTraceInfo2.receivedString;
                ePathTraceMode ePathTraceMode2 = sStsPathTraceInfo2.pathTracemode;
                byte by = sStsPathTraceInfo2.payloadCode;
                char[] cArray = null;
                char[] cArray2 = null;
                if (string != null) {
                    cArray = new char[string.length()];
                    for (n = 0; n < string.length(); ++n) {
                        cArray[n] = string.charAt(n);
                    }
                }
                if (string2 != null) {
                    cArray2 = new char[string2.length()];
                    for (n = 0; n < string2.length(); ++n) {
                        cArray2[n] = string2.charAt(n);
                    }
                }
                pathTraceInfoArray[i] = new PathTraceInfo(0, this.getPortModel(), cArray, cArray2, (char)by, ePathTraceMode2.value(), s);
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.println("Caught CmsNoSuchEntity in getPathTracesForPort");
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getPathTracesForPort", userException);
        }
        return pathTraceInfoArray;
    }

    public String getCurrentQuality() throws NoSuchInterface, UnsupportedOperation {
        try {
            eQualityLevel eQualityLevel2 = ((sInfo)this.currentQuality.get()).currentQualityLevel;
            return EnumStrings.getString((Object)eQualityLevel2, (int)eQualityLevel2.value());
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getCurrentQuality", userException);
        }
    }

    public sLaserParams getCurrentLaserParams() throws NoSuchInterface, UnsupportedOperation, InternalCommError {
        try {
            sLaserParams sLaserParams2 = (sLaserParams)this.currentLaserParams.get();
            return sLaserParams2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getCurrentLaserParams", userException);
        }
    }

    public void setOpr() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            this.setOpr.set();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setOpr", userException);
        }
    }

    public void getLineThresholds(boolean bl, eIntervalType eIntervalType2, sLineThresholds600 sLineThresholds6002) throws NoSuchInterface, WrongInterfaceType {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2};
            sLineThresholds600 sLineThresholds6003 = (sLineThresholds600)this.lineThreshold.get(objectArray);
            sLineThresholds6002.es = sLineThresholds6003.es;
            sLineThresholds6002.ses = sLineThresholds6003.ses;
            sLineThresholds6002.cv = sLineThresholds6003.cv;
            sLineThresholds6002.uas = sLineThresholds6003.uas;
            sLineThresholds6002.fc = sLineThresholds6003.fc;
            sLineThresholds6002.psc = sLineThresholds6003.psc;
            sLineThresholds6002.psd = sLineThresholds6003.psd;
            sLineThresholds6002.pscw = sLineThresholds6003.pscw;
            sLineThresholds6002.psdw = sLineThresholds6003.psdw;
            sLineThresholds6002.pscs = sLineThresholds6003.pscs;
            sLineThresholds6002.psds = sLineThresholds6003.psds;
            sLineThresholds6002.pscr = sLineThresholds6003.pscr;
            sLineThresholds6002.psdr = sLineThresholds6003.psdr;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getLineThresholds", userException);
        }
    }

    public void setLineThresholds(boolean bl, eIntervalType eIntervalType2, sLineThresholds600 sLineThresholds6002) throws NoSuchInterface, WrongInterfaceType {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, sLineThresholds6002};
            this.lineThreshold.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setLineThresholds", userException);
        }
    }

    public void getSectionThresholds(boolean bl, eIntervalType eIntervalType2, sSectionThresholds600 sSectionThresholds6002) throws NoSuchInterface, WrongInterfaceType {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2};
            sSectionThresholds600 sSectionThresholds6003 = (sSectionThresholds600)this.sectionThreshold.get(objectArray);
            sSectionThresholds6002.es = sSectionThresholds6003.es;
            sSectionThresholds6002.ses = sSectionThresholds6003.ses;
            sSectionThresholds6002.sefs = sSectionThresholds6003.sefs;
            sSectionThresholds6002.cv = sSectionThresholds6003.cv;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSectionThresholds", userException);
        }
    }

    public void setSectionThresholds(boolean bl, eIntervalType eIntervalType2, sSectionThresholds600 sSectionThresholds6002) throws NoSuchInterface, WrongInterfaceType {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, sSectionThresholds6002};
            this.sectionThreshold.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSectionThresholds", userException);
        }
    }

    public void getPhysicalThresholds(boolean bl, eIntervalType eIntervalType2, sPhysicalThresholds sPhysicalThresholds2) throws NoSuchInterface, WrongInterfaceType {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2};
            sPhysicalThresholds sPhysicalThresholds3 = (sPhysicalThresholds)this.physThreshold.get(objectArray);
            sPhysicalThresholds2.lbcHigh = sPhysicalThresholds3.lbcHigh;
            sPhysicalThresholds2.lbcLow = sPhysicalThresholds3.lbcLow;
            sPhysicalThresholds2.optHigh = sPhysicalThresholds3.optHigh;
            sPhysicalThresholds2.optLow = sPhysicalThresholds3.optLow;
            sPhysicalThresholds2.oprHigh = sPhysicalThresholds3.oprHigh;
            sPhysicalThresholds2.oprLow = sPhysicalThresholds3.oprLow;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getPhysicalThresholds", userException);
        }
    }

    public sPhysicalThresholds getPhysicalThresholds(boolean bl, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType {
        sPhysicalThresholds sPhysicalThresholds2 = new sPhysicalThresholds();
        this.getPhysicalThresholds(bl, eIntervalType2, sPhysicalThresholds2);
        return sPhysicalThresholds2;
    }

    public void setPhysicalThresholds(boolean bl, eIntervalType eIntervalType2, sPhysicalThresholds sPhysicalThresholds2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, sPhysicalThresholds2};
            this.physThreshold.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setPhysicalThresholds", userException);
        }
    }

    public void getLineStats(boolean bl, eIntervalType eIntervalType2, short s, sLineStats600[] sLineStats600Array, sSectionStats600[] sSectionStats600Array, sPhysicalStats600[] sPhysicalStats600Array) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, new Short(s)};
            Object[] objectArray2 = (Object[])this.linePhysStats.get(objectArray);
            sLineStats600[] sLineStats600Array2 = (sLineStats600[])objectArray2[0];
            sSectionStats600[] sSectionStats600Array2 = (sSectionStats600[])objectArray2[1];
            sPhysicalStats600[] sPhysicalStats600Array2 = (sPhysicalStats600[])objectArray2[2];
            int n = sLineStats600Array2.length;
            for (int i = 0; i < n; ++i) {
                sSectionStats600Array[i].es = sSectionStats600Array2[i].es;
                sSectionStats600Array[i].ses = sSectionStats600Array2[i].ses;
                sSectionStats600Array[i].sefs = sSectionStats600Array2[i].sefs;
                sSectionStats600Array[i].cv = sSectionStats600Array2[i].cv;
                sLineStats600Array[i].es = sLineStats600Array2[i].es;
                sLineStats600Array[i].ses = sLineStats600Array2[i].ses;
                sLineStats600Array[i].cv = sLineStats600Array2[i].cv;
                sLineStats600Array[i].uas = sLineStats600Array2[i].uas;
                sLineStats600Array[i].fc = sLineStats600Array2[i].fc;
                sLineStats600Array[i].psc = sLineStats600Array2[i].psc;
                sLineStats600Array[i].psd = sLineStats600Array2[i].psd;
                sLineStats600Array[i].pscw = sLineStats600Array2[i].pscw;
                sLineStats600Array[i].psdw = sLineStats600Array2[i].psdw;
                sLineStats600Array[i].pscs = sLineStats600Array2[i].pscs;
                sLineStats600Array[i].psds = sLineStats600Array2[i].psds;
                sLineStats600Array[i].pscr = sLineStats600Array2[i].pscr;
                sLineStats600Array[i].psdr = sLineStats600Array2[i].psdr;
                sPhysicalStats600Array[i].lbc = sPhysicalStats600Array2[i].lbc;
                sPhysicalStats600Array[i].opt = sPhysicalStats600Array2[i].opt;
                sPhysicalStats600Array[i].opr = sPhysicalStats600Array2[i].opr;
            }
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getLineStats", userException);
        }
    }

    public void clearLineStats(boolean bl, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2};
            this.linePhysStats.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearStats", userException);
        }
    }

    public void clearStatsPerParam(boolean bl, eIntervalType eIntervalType2, String[] stringArray) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, stringArray};
            this.clearStatsPerParam.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearStatsPerParam", userException);
        }
    }

    public void clearAllStatsForLine() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            this.clearAllStatsForLine.set(new Object());
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearStats", userException);
        }
    }

    public void clearAllStatsForCard() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        block6: {
            try {
                int n = this.getModuleModel().getParent().getIndex();
                this.clearAllStatsForCard.set(new Integer(n));
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (xInternalCommError xInternalCommError2) {
                throw new InternalCommError((UserException)xInternalCommError2);
            }
            catch (UserException userException) {
                throw this.doUnknown("clearStats", userException);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block6;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
    }

    private String lineTypeToStr() {
        String string = "unknown";
        IPortModel iPortModel = null;
        try {
            iPortModel = this.getPortModel();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.severe(abstractCmsNoSuchEntityException.toString());
            return string;
        }
        IEntityModel iEntityModel = iPortModel.getParent();
        if ((iEntityModel.getEqType() == 150 || iEntityModel.getEqType() == 193) && (iEntityModel = iEntityModel.getParent()) != null && iEntityModel.getEqType() == 149) {
            iEntityModel = iEntityModel.getParent();
        }
        block2 : switch (iEntityModel.getEqType()) {
            case 118: 
            case 119: 
            case 181: 
            case 182: {
                if (iPortModel.getEqType() == 123) {
                    string = "pmthresholds.trunk";
                    break;
                }
                string = "pmthresholds.client";
                break;
            }
            case 120: 
            case 121: {
                InterfaceModel[] interfaceModelArray = null;
                interfaceModelArray = this.getLowerLayerModels();
                eDataRate eDataRate2 = null;
                try {
                    eDataRate2 = eDataRate.from_int(((AbstractDwdmLineModel)interfaceModelArray[0]).getDataRate());
                }
                catch (NoSuchInterface noSuchInterface) {
                    this.db.severe(noSuchInterface.toString());
                    return string;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    this.db.severe(wrongInterfaceType.toString());
                    return string;
                }
                int n = this.getNodeModel().getFramingType();
                boolean bl = FramingType.getFramingType((int)n).isSdh();
                switch (eDataRate2.value()) {
                    case 0: 
                    case 4: {
                        if (bl) {
                            string = "pmthresholds.stm1";
                            break block2;
                        }
                        string = "pmthresholds.oc3";
                        break block2;
                    }
                    case 1: 
                    case 5: {
                        if (bl) {
                            string = "pmthresholds.stm4";
                            break block2;
                        }
                        string = "pmthresholds.oc12";
                        break block2;
                    }
                    case 2: 
                    case 6: {
                        if (bl) {
                            string = "pmthresholds.stm16";
                            break block2;
                        }
                        string = "pmthresholds.oc48";
                        break block2;
                    }
                }
                this.db.severe("Unexpected data rate " + eDataRate2.value());
                break;
            }
            case 183: 
            case 184: {
                int n = this.getNodeModel().getFramingType();
                boolean bl = FramingType.getFramingType((int)n).isSdh();
                if (bl) {
                    string = "pmthresholds.sdh";
                    break;
                }
                string = "pmthresholds.sonet";
                break;
            }
            default: {
                string = "pmthresholds";
            }
        }
        return string;
    }

    private String lineOrSectionToStr(int n) {
        String string = "unknown";
        TDMTerminology tDMTerminology = this.getNodeModel().getTDMTerminology();
        if (tDMTerminology instanceof SDHTDMTerminology) {
            if (n == 2) {
                return "ms";
            }
            return "rs";
        }
        if (n == 2) {
            return "line";
        }
        return "section";
    }

    private String intervalToStr(eIntervalType eIntervalType2) {
        return eIntervalType2 == eIntervalType.INTERVAL_15_MIN ? "15min" : "1day";
    }

    private String endToStr(boolean bl) {
        return bl ? "nearend" : "farend";
    }

    private String buildValidationPrefix(int n, eIntervalType eIntervalType2, boolean bl) {
        return this.lineTypeToStr() + "." + this.lineOrSectionToStr(n) + "." + this.endToStr(bl) + "." + this.intervalToStr(eIntervalType2) + ".";
    }

    public String getLineValidationPrefix(eIntervalType eIntervalType2, boolean bl) {
        return this.buildValidationPrefix(2, eIntervalType2, bl);
    }

    public String getSectionValidationPrefix(eIntervalType eIntervalType2, boolean bl) {
        return this.buildValidationPrefix(3, eIntervalType2, bl);
    }

    public String getPhysicalValidationPrefix(eIntervalType eIntervalType2) {
        return "physicalthresholds." + this.intervalToStr(eIntervalType2) + ".";
    }

    CachedValue getCurrentlyActiveCV() {
        return this.getTdmLineInterfaceAttrs().getCurrentlyActive();
    }

    CachedValue getSdBerLevelCV() {
        return this.getTdmLineInterfaceAttrs().getSdBerLevel();
    }

    CachedValue getSfBerLevelCV() {
        return this.getTdmLineInterfaceAttrs().getSfBerLevel();
    }

    CachedValue getBlsrByteCV() {
        return this.getTdmLineInterfaceAttrs().getBlsrByte();
    }

    CachedValue getSonetConfigCV() {
        return this.getTdmLineInterfaceAttrs().getSonetConfig();
    }

    CachedValue getLineInfoCV() {
        return this.getTdmLineInterfaceAttrs().getLineInfo();
    }

    CachedValue getLineBuildoutCV() {
        return this.getTdmLineInterfaceAttrs().getLineBuildout();
    }

    CachedValue getLineLoopbackCV() {
        return this.getTdmLineInterfaceAttrs().getLineLoopback();
    }

    CachedValue getPointerMonitorStsNumberCV() {
        return this.getTdmLineInterfaceAttrs().getPointerMonitorStsNumber();
    }

    CachedValue getUsedForSynchronizationCV() {
        return this.getTdmLineInterfaceAttrs().getUsedForSynchronization();
    }

    CachedValue getSectionTraceModeCV() {
        return this.getTdmLineInterfaceAttrs().getSectionTraceMode();
    }

    CachedValue getSectionTraceFormatCV() {
        return this.getTdmLineInterfaceAttrs().getSectionTraceFormat();
    }

    CachedValue getSectionSdBerLevelCV() {
        return this.getTdmLineInterfaceAttrs().getSectionSdBerLevel();
    }

    CachedValue getSendSectionTraceCV() {
        return this.getTdmLineInterfaceAttrs().getSendSectionTrace();
    }

    CachedValue getExpectedSectionTraceCV() {
        return this.getTdmLineInterfaceAttrs().getExpectedSectionTrace();
    }

    CachedValue getStm1eModeCV() {
        return this.getTdmLineInterfaceAttrs().getStm1eMode();
    }

    private static Class _me() {
        return class$cerent$cms$model$TdmLineModel == null ? (class$cerent$cms$model$TdmLineModel = TdmLineModel.class$("cerent.cms.model.TdmLineModel")) : class$cerent$cms$model$TdmLineModel;
    }

    private static Class _state() {
        return class$cerent$cms$model$TdmLineInterfaceAttrs == null ? (class$cerent$cms$model$TdmLineInterfaceAttrs = TdmLineModel.class$("cerent.cms.model.TdmLineInterfaceAttrs")) : class$cerent$cms$model$TdmLineInterfaceAttrs;
    }

    private int _getPersistType() {
        return TdmLineInterfaceAttrs.getCookie();
    }

    private TdmLineInterfaceAttrs getTdmLineInterfaceAttrs() {
        int n = this._getPersistType();
        return (TdmLineInterfaceAttrs)this.retrieveAttrs(this.getModelType(n), n);
    }

    public static Field[] getAttrFields(Class clazz) {
        return TdmLineModel.getAttrsFields(clazz, TdmLineModel._me(), TdmLineModel._state());
    }

    protected AbstractPersistableModelState getAttrsField(int n) {
        return n == this._getPersistType() ? this.attrs : super.getAttrsField(n);
    }

    public int getAttrFieldsInMemory(int n) {
        boolean bl;
        boolean bl2 = bl = this.attrs != null;
        if (bl) {
            n |= 1 << this._getPersistType();
        }
        n |= super.getAttrFieldsInMemory(n);
        return n;
    }

    protected void setAttrsField(AbstractPersistableModelState abstractPersistableModelState, int n) {
        if (n == this._getPersistType() || abstractPersistableModelState instanceof TdmLineInterfaceAttrs) {
            this.attrs = abstractPersistableModelState;
        } else if (n == -1 && abstractPersistableModelState == null) {
            if (this.attrs != null) {
                this.attrs.linkModel(null);
            }
            this.attrs = abstractPersistableModelState;
            super.setAttrsField(abstractPersistableModelState, n);
        } else {
            super.setAttrsField(abstractPersistableModelState, n);
        }
    }

    protected AbstractPersistableModelState createInitialStateValue(int n) {
        if (n == -1 || n == this._getPersistType()) {
            return this.createInitialStateValue(TdmLineModel._state());
        }
        return super.createInitialStateValue(n);
    }

    void allAttributesIndicateWriteAccess(long l) {
        this.getTdmLineInterfaceAttrs().indicateWriteAccess(l);
        super.allAttributesIndicateWriteAccess(l);
    }

    public boolean supportsPhysicalPm() {
        ModuleModel moduleModel;
        block2: {
            moduleModel = null;
            try {
                moduleModel = this.getModuleModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.severe("Could not find ModuleModel in supportsPhysicalPm");
                if (!this.db.on()) break block2;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return moduleModel != null && moduleModel.supportsPhysicalPm();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ClearAllStatsForCard
    extends NonCachedValue {
        public ClearAllStatsForCard(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xInternalCommError, xNoSuchInterface {
            int n = (Integer)object;
            TdmLineModel.this.getSonetRef().clearAllStatsForCard(n);
        }
    }

    class ClearAllStatsForLine
    extends NonCachedValue {
        public ClearAllStatsForLine(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xInternalCommError, xClearPMStatsError, xNoSuchInterface {
            TdmLineModel.this.getSonetRef().clearAllStatsForLine(TdmLineModel.this.getIndex());
        }
    }

    class ClearStatsPerParam
    extends NonCachedValue {
        public ClearStatsPerParam(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xInternalCommError, xClearPMStatsError, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            TdmLineModel.this.getSonetRef().clearLineStatsPerParam(TdmLineModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], (String[])objectArray[2]);
        }
    }

    class CurrentLaserParams
    extends NonCachedValue {
        public CurrentLaserParams(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xInternalCommError, xNoSuchInterface {
            return TdmLineModel.this.getSonetRef().getLaserParams(TdmLineModel.this.getIndex());
        }
    }

    class CurrentQuality
    extends NonCachedValue {
        public CurrentQuality(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xUnsupportedOperation, xNoSuchInterface {
            return TdmLineModel.this.getSynchronizationRef().getCurrentQuality(TdmLineModel.this.getIndex());
        }
    }

    class SetOpr
    extends NonCachedValue {
        public SetOpr(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws xWrongInterfaceType, xInternalCommError, xNoSuchInterface {
            TdmLineModel.this.getSonetRef().setOPR(TdmLineModel.this.getIndex());
        }
    }

    class PhysThresholds
    extends NonCachedValue {
        public PhysThresholds(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            sPhysicalThresholdsHolder sPhysicalThresholdsHolder2 = new sPhysicalThresholdsHolder();
            Object[] objectArray = (Object[])object;
            TdmLineModel.this.getSonetRef().getPhysicalPmThresholds(TdmLineModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], sPhysicalThresholdsHolder2);
            return sPhysicalThresholdsHolder2.value;
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xNoSuchInterface, xConfigError {
            Object[] objectArray = (Object[])object;
            TdmLineModel.this.getSonetRef().setPhysicalPmThresholds(TdmLineModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], (sPhysicalThresholds)objectArray[2]);
        }
    }

    class SectionThresholds
    extends NonCachedValue {
        public SectionThresholds(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            sSectionThresholds600Holder sSectionThresholds600Holder2 = new sSectionThresholds600Holder();
            Object[] objectArray = (Object[])object;
            TdmLineModel.this.getSonetRef().getSectionPmThresholds600(TdmLineModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], sSectionThresholds600Holder2);
            return sSectionThresholds600Holder2.value;
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            TdmLineModel.this.getSonetRef().setSectionPmThresholds600(TdmLineModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], (sSectionThresholds600)objectArray[2]);
        }
    }

    class LineThresholds
    extends NonCachedValue {
        public LineThresholds(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            sLineThresholds600Holder sLineThresholds600Holder2 = new sLineThresholds600Holder();
            Object[] objectArray = (Object[])object;
            TdmLineModel.this.getSonetRef().getLinePmThresholds600(TdmLineModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], sLineThresholds600Holder2);
            return sLineThresholds600Holder2.value;
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            TdmLineModel.this.getSonetRef().setLinePmThresholds600(TdmLineModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], (sLineThresholds600)objectArray[2]);
        }
    }

    class LinePhysStats
    extends NonCachedValue {
        public LinePhysStats(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xInternalCommError, xClearPMStatsError, xNoSuchInterface, xConfigError {
            Object[] objectArray = (Object[])object;
            TdmLineModel.this.getSonetRef().clearLineStats(TdmLineModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1]);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xInternalCommError, xNoSuchInterface, xInvalidRange {
            sLineStats600ListHolder sLineStats600ListHolder2 = new sLineStats600ListHolder();
            sSectionStats600ListHolder sSectionStats600ListHolder2 = new sSectionStats600ListHolder();
            sPhysicalStats600ListHolder sPhysicalStats600ListHolder2 = new sPhysicalStats600ListHolder();
            Object[] objectArray = (Object[])object;
            TdmLineModel.this.getSonetRef().getLineStats600(TdmLineModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], (Short)objectArray[2], sLineStats600ListHolder2, sSectionStats600ListHolder2, sPhysicalStats600ListHolder2);
            Object[] objectArray2 = new Object[]{sLineStats600ListHolder2.value, sSectionStats600ListHolder2.value, sPhysicalStats600ListHolder2.value};
            return objectArray2;
        }
    }

    private class GetPathTraces
    extends NonCachedValue {
        public GetPathTraces(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return TdmLineModel.this.getSonetRef().getStsPathTracesForPort(TdmLineModel.this.getIndex());
        }

        public Object outer() {
            return TdmLineModel.this;
        }
    }

    private class BlsrProtectPmPathStats
    extends NonCachedValue {
        public BlsrProtectPmPathStats(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            sPathStatsHolder sPathStatsHolder2 = new sPathStatsHolder();
            Object[] objectArray = (Object[])object;
            TdmLineModel.this.getSonetRef().getBlsrProtectStsPathStats((sStsInfo)objectArray[0], (Boolean)objectArray[1], (eIntervalType)objectArray[2], (Short)objectArray[3], sPathStatsHolder2);
            return sPathStatsHolder2.value;
        }
    }

    private class BlsrProtectPmThresholds
    extends NonCachedValue {
        public BlsrProtectPmThresholds(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xUnsupportedOperation, xInternalCommError {
            sPathThresholdsHolder sPathThresholdsHolder2 = new sPathThresholdsHolder();
            Object[] objectArray = (Object[])object;
            TdmLineModel.this.getSonetRef().getBlsrProtectStsTermPmThresholds((sStsInfo)objectArray[0], (Boolean)objectArray[1], (eIntervalType)objectArray[2], sPathThresholdsHolder2);
            return sPathThresholdsHolder2.value;
        }

        public Object outer() {
            return TdmLineModel.this;
        }
    }

    private class ReceivedSectionTrace
    extends NonCachedValue {
        public ReceivedSectionTrace(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xUnsupportedOperation, xInternalCommError, xNoSuchInterface {
            return ((NodeModelDelegate)TdmLineModel.this.getNodeModel()).getIorRepository().getSonetRef().getReceivedSectionTrace(TdmLineModel.this.getIndex());
        }
    }

    private class Status
    extends NonCachedValue {
        public Status(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Integer(TdmLineModel.this.getSonetRef().getLineStatus(TdmLineModel.this.getIndex()));
        }

        public Object outer() {
            return TdmLineModel.this;
        }
    }

    private class LineStats
    extends NonCachedValue {
        public LineStats(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xWrongInterfaceType, xInternalCommError, xClearPMStatsError, xNoSuchInterface, xConfigError {
            Object[] objectArray = (Object[])object;
            TdmLineModel.this.getSonetRef().clearLineStats(TdmLineModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1]);
        }

        protected Object getValue(Object object) throws UserException {
            sSectionStatsHolder sSectionStatsHolder2 = new sSectionStatsHolder();
            sLineStatsHolder sLineStatsHolder2 = new sLineStatsHolder();
            sPhysicalStatsHolder sPhysicalStatsHolder2 = new sPhysicalStatsHolder();
            Object[] objectArray = (Object[])object;
            boolean bl = (Boolean)objectArray[0];
            short s = (Short)objectArray[2];
            TdmLineModel.this.getSonetRef().getLineStats(TdmLineModel.this.getIndex(), bl, (eIntervalType)objectArray[1], s, sSectionStatsHolder2, sLineStatsHolder2, sPhysicalStatsHolder2);
            Object[] objectArray2 = new Object[]{sSectionStatsHolder2.value, sLineStatsHolder2.value, sPhysicalStatsHolder2.value};
            return objectArray2;
        }

        public Object outer() {
            return TdmLineModel.this;
        }
    }

    private class PmThresholds
    extends NonCachedValue {
        public PmThresholds(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xWrongInterfaceType, xNoSuchInterface {
            sSectionThresholdsHolder sSectionThresholdsHolder2 = new sSectionThresholdsHolder();
            sLineThresholdsHolder sLineThresholdsHolder2 = new sLineThresholdsHolder();
            Object[] objectArray = (Object[])object;
            TdmLineModel.this.getSonetRef().getLinePmThresholds(TdmLineModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], sSectionThresholdsHolder2, sLineThresholdsHolder2);
            Object[] objectArray2 = new Object[]{sSectionThresholdsHolder2.value, sLineThresholdsHolder2.value};
            return objectArray2;
        }

        protected void setValue(Object object) throws xConfigError, xWrongInterfaceType, xNoSuchInterface {
            Object[] objectArray = (Object[])object;
            TdmLineModel.this.getSonetRef().setLinePmThresholds(TdmLineModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], (sSectionThresholds)objectArray[2], (sLineThresholds)objectArray[3]);
        }

        public Object outer() {
            return TdmLineModel.this;
        }
    }

    private class BerLevel
    extends NonCachedValue {
        public BerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongInterfaceType, xNoSuchInterface {
            return new Short(TdmLineModel.this.getSonetRef().getLineBerLevel(TdmLineModel.this.getIndex()));
        }

        public Object outer() {
            return TdmLineModel.this;
        }
    }
}

