/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.model.Model;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.SDebug;
import java.util.Observable;

public class VirtualLinkModel
extends Model
implements IVirtualLinkModel {
    private short origVLID;
    private IIpAddr origNode;
    private IEntityModel origEntity;
    private short termVLID;
    private IIpAddr termNode;
    private IEntityModel termEntity;
    private static final SDebug db = new SDebug("VirtualLinkModel");

    public VirtualLinkModel(short s, IIpAddr iIpAddr, IEntityModel iEntityModel, short s2, IIpAddr iIpAddr2, IEntityModel iEntityModel2) {
        super(db);
        this.origVLID = s;
        this.origNode = iIpAddr;
        this.origEntity = iEntityModel;
        this.termVLID = s2;
        this.termNode = iIpAddr2;
        this.termEntity = iEntityModel2;
    }

    public short getOrigVLID() {
        return this.origVLID;
    }

    public IIpAddr getOrigNode() {
        return this.origNode;
    }

    public IEntityModel getOrigEntity() {
        return this.origEntity;
    }

    public IEntityModel getTermEntity() {
        return this.termEntity;
    }

    public IIpAddr getTermNode() {
        return this.termNode;
    }

    public short getTermVLID() {
        return this.termVLID;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        if (object != null && object instanceof IVirtualLinkModel) {
            IVirtualLinkModel iVirtualLinkModel = (IVirtualLinkModel)object;
            if (db.on()) {
                db.fine("compareTo: this is " + this);
                db.fine("          other is " + iVirtualLinkModel);
            }
            if (iVirtualLinkModel.getOrigVLID() == this.origVLID) {
                if (iVirtualLinkModel.getOrigNode().compareTo((Object)this.origNode) == 0) {
                    if (iVirtualLinkModel.getOrigEntity() != null && iVirtualLinkModel.getOrigEntity().equals(this.origEntity) || iVirtualLinkModel.getOrigEntity() == null && this.origEntity == null) {
                        if (iVirtualLinkModel.getTermVLID() == this.origVLID) {
                            if (iVirtualLinkModel.getTermNode().compareTo((Object)this.termNode) == 0) {
                                if (iVirtualLinkModel.getTermEntity() == null && this.termEntity == null || iVirtualLinkModel.getTermEntity().equals(this.termEntity)) {
                                    return 0;
                                }
                                if (iVirtualLinkModel.getTermEntity() != null && this.termEntity == null) {
                                    return -1;
                                }
                                return 1;
                            }
                            return iVirtualLinkModel.getTermNode().compareTo((Object)this.termNode);
                        }
                        return new Integer(this.termVLID).compareTo(new Integer(iVirtualLinkModel.getTermVLID()));
                    }
                    if (iVirtualLinkModel.getOrigEntity() != null && this.origEntity == null) {
                        return -1;
                    }
                    return 1;
                }
                return iVirtualLinkModel.getOrigNode().compareTo((Object)this.origNode);
            }
            return new Integer(this.origVLID).compareTo(new Integer(iVirtualLinkModel.getOrigVLID()));
        }
        return 1;
    }

    private boolean shouldSwap() {
        boolean bl = true;
        if (this.origEntity != null && (this.origEntity.getEqType() == 139 || this.origEntity.getEqType() == 141) || this.termEntity != null && (this.termEntity.getEqType() == 139 || this.termEntity.getEqType() == 141)) {
            IModuleModel iModuleModel;
            IModuleModel iModuleModel2 = this.origEntity != null ? this.origEntity.getModuleModel() : null;
            IModuleModel iModuleModel3 = iModuleModel = this.termEntity != null ? this.termEntity.getModuleModel() : null;
            if (iModuleModel2 != null && iModuleModel != null && (iModuleModel2.getEqType() == 132 || iModuleModel.getEqType() == 131 || (iModuleModel2.getEqType() == 133 || this.origEntity.getEqType() == 141) && this.origEntity.getPositionInParent() % 2 == 0 || (iModuleModel.getEqType() == 133 || this.termEntity.getEqType() == 141) && this.termEntity.getPositionInParent() % 2 != 0)) {
                bl = false;
            }
        }
        return bl;
    }

    public void swap() {
        if (this.shouldSwap()) {
            short s = this.origVLID;
            IIpAddr iIpAddr = this.origNode;
            IEntityModel iEntityModel = this.origEntity;
            this.origVLID = this.termVLID;
            this.origNode = this.termNode;
            this.origEntity = this.termEntity;
            this.termVLID = s;
            this.termNode = iIpAddr;
            this.termEntity = iEntityModel;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(Short.toString(this.origVLID) + ", ");
        stringBuffer.append(VirtualLinkModel.ipToString(this.origNode) + ", ");
        stringBuffer.append(new EntityCellRenderer().getString(this.origEntity, "slot ") + ", ");
        stringBuffer.append(Short.toString(this.termVLID) + ", ");
        stringBuffer.append(VirtualLinkModel.ipToString(this.termNode) + ", ");
        stringBuffer.append(new EntityCellRenderer().getString(this.termEntity, "slot ") + "]");
        return stringBuffer.toString();
    }

    public static final String ipToString(IIpAddr iIpAddr) {
        byte[] byArray = iIpAddr.getAddr();
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < byArray.length; ++i) {
            if (bl && byArray[i] == 0) continue;
            bl = false;
            stringBuffer.append(Integer.toString(byArray[i] & 0xFF));
            if (i + 1 >= byArray.length) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public void update(Observable observable, Object object) {
    }

    public INodeModel getNodeModel() {
        return this.origEntity.getNodeModel();
    }
}

