/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.If.eIfType;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.Optics.xFeatureUnsupported;
import cerent.cms.idl.OpticsTopology.VirtualLink;
import cerent.cms.idl.OpticsTopology.sLinkEnd;
import cerent.cms.idl.OpticsTopology.sVirtualLink;
import cerent.cms.idl.OpticsTopology.xDuplicateLocalVlinkId;
import cerent.cms.idl.OpticsTopology.xDuplicateRemoteVlinkId;
import cerent.cms.idl.OpticsTopology.xEndPointInUse;
import cerent.cms.idl.OpticsTopology.xNoSuchVirtualLink;
import cerent.cms.idl.OpticsTopology.xProvisionError;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CmsCommFailException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DuplicateLocalVlinkId;
import cerent.cms.model.DuplicateRemoteVlinkId;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.ElementModel;
import cerent.cms.model.EndPointInUse;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.HdGeLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVirtualLinkModel;
import cerent.cms.model.IVirtualLinksManager;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchVirtualLink;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.VirtualLinkModel;
import cerent.cms.model.YCableModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.omg.CORBA.UserException;

public class VirtualLinksManager
extends Model
implements IVirtualLinksManager,
Observer {
    private VirtualLinkCreator virtualLinkCreator;
    private VirtualLinkDeletor virtualLinkDeletor;
    private VirtualLinkRetriever virtualLinkRetriever;
    private ArrayList cache = new ArrayList();
    private NodeModelDelegate nmd;
    private EventDispatcher dispatcher;
    private VlinkDebug dumpDebug;
    static /* synthetic */ Class class$cerent$cms$model$VirtualLinksManager;

    public void update(Observable observable, Object object) {
        this.db.fine("update from " + observable + " regarding " + object);
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 2: {
                    this.db.fine("\tObjectAdded");
                    this.clearCache();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.ADDED);
                    break;
                }
                case 0: {
                    this.db.fine("\tObjectDeleted");
                    this.cacheDelete((short)((IObjectMessageInfo)object).getIndex());
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.DELETED);
                    break;
                }
                case 1: {
                    this.db.fine("\tObjectChanged");
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
            }
        }
    }

    public IVirtualLinkModel[] getVirtualLinks() {
        if (this.nmd.getPlatform().is600()) {
            return new IVirtualLinkModel[0];
        }
        this.updateCache();
        return this.cache.toArray(new IVirtualLinkModel[0]);
    }

    public void deleteVirtualLink(short s) throws FeatureUnsupported, NoSuchVirtualLink {
        try {
            this.virtualLinkDeletor.set(new Short(s));
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNoSuchVirtualLink xNoSuchVirtualLink2) {
            throw new NoSuchVirtualLink((UserException)xNoSuchVirtualLink2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void createVirtualLink(IEntityModel iEntityModel, short s, IIpAddr iIpAddr, short s2, IIpAddr iIpAddr2) throws FeatureUnsupported, NoSuchInterface, EndPointInUse, DuplicateLocalVlinkId, DuplicateRemoteVlinkId, ProvisionError {
        try {
            sLinkEnd sLinkEnd2 = new sLinkEnd(IpAddrFactory.getIpAddr(iIpAddr), s);
            sLinkEnd sLinkEnd3 = new sLinkEnd(IpAddrFactory.getIpAddr(iIpAddr2), s2);
            this.virtualLinkCreator.set(new Object[]{new Integer(iEntityModel.getIndex()), sLinkEnd2, sLinkEnd3});
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xEndPointInUse xEndPointInUse2) {
            throw new EndPointInUse((UserException)xEndPointInUse2);
        }
        catch (xDuplicateLocalVlinkId xDuplicateLocalVlinkId2) {
            throw new DuplicateLocalVlinkId((UserException)xDuplicateLocalVlinkId2);
        }
        catch (xDuplicateRemoteVlinkId xDuplicateRemoteVlinkId2) {
            throw new DuplicateRemoteVlinkId((UserException)xDuplicateRemoteVlinkId2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            throw new ProvisionError("Failure creating virtual link.");
        }
    }

    public IEntityModel isProtected(IEntityModel iEntityModel) {
        IEntityModel iEntityModel2 = null;
        ModuleModel moduleModel = (ModuleModel)iEntityModel.getModuleModel();
        if (iEntityModel instanceof PortModel) {
            try {
                PortModel portModel = (PortModel)iEntityModel;
                InterfaceModel interfaceModel = (InterfaceModel)portModel.getInterfaceModel();
                ElementModel elementModel = interfaceModel.getElementModel();
                if (elementModel instanceof OnePlusOneModel) {
                    OnePlusOneModel onePlusOneModel = (OnePlusOneModel)elementModel;
                    iEntityModel2 = iEntityModel == onePlusOneModel.getProtectEntityModel() ? onePlusOneModel.getMainEntityModel() : onePlusOneModel.getProtectEntityModel();
                } else if (elementModel instanceof YCableModel) {
                    YCableModel yCableModel = (YCableModel)elementModel;
                    iEntityModel2 = iEntityModel == yCableModel.getProtectEntityModel() ? yCableModel.getMainEntityModel() : yCableModel.getProtectEntityModel();
                } else if (moduleModel.getProtectionGroupModel() != null) {
                    if (moduleModel == moduleModel.getProtectionGroupModel().getProtectModuleModel()) {
                        moduleModel = (ModuleModel)moduleModel.getProtectionGroupModel().getProtectedModuleModel();
                    }
                    Iterator iterator = moduleModel.getChildren().iterator();
                    while (iEntityModel2 != null && iterator.hasNext()) {
                        iEntityModel2 = (IEntityModel)iterator.next();
                    }
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return iEntityModel2;
    }

    public IEntityModel isYCableProtected(IEntityModel iEntityModel) {
        IEntityModel iEntityModel2 = null;
        ModuleModel moduleModel = (ModuleModel)iEntityModel.getModuleModel();
        if (iEntityModel instanceof PortModel) {
            try {
                YCableModel yCableModel;
                PortModel portModel = (PortModel)iEntityModel;
                InterfaceModel interfaceModel = (InterfaceModel)portModel.getInterfaceModel();
                ElementModel elementModel = interfaceModel.getElementModel();
                if (elementModel instanceof YCableModel && (yCableModel = (YCableModel)elementModel).getType() == 4) {
                    iEntityModel2 = iEntityModel == yCableModel.getProtectEntityModel() ? yCableModel.getMainEntityModel() : yCableModel.getProtectEntityModel();
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return iEntityModel2;
    }

    public void dispose() {
        super.dispose();
    }

    public IEntityModel[] getVirtualLinkCandidates() {
        if (this.nmd.getPlatform().is600()) {
            return new IEntityModel[0];
        }
        Set set = this.getValidEntities();
        this.filterOutExistingVlinks(set);
        this.filterOutNonTransparentCli(set);
        this.filterOutNonGCCTrk(set);
        this.filterOutNonDCCOcn(set);
        this.filterOutNonOCH(set);
        return set.toArray(new IEntityModel[0]);
    }

    protected void filterOutExistingVlinks(Set set) {
        IVirtualLinkModel[] iVirtualLinkModelArray = this.getVirtualLinks();
        if (iVirtualLinkModelArray != null && iVirtualLinkModelArray.length > 0) {
            for (int i = 0; i < iVirtualLinkModelArray.length; ++i) {
                IEntityModel iEntityModel = iVirtualLinkModelArray[i].getOrigEntity();
                IEntityModel iEntityModel2 = iVirtualLinkModelArray[i].getTermEntity();
                set.remove(iEntityModel);
                set.remove(iEntityModel2);
            }
        }
    }

    protected void filterOutNonTransparentCli(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            DwdmPortModel dwdmPortModel;
            DwdmModuleModel dwdmModuleModel;
            EntityModel entityModel = (EntityModel)iterator.next();
            if (entityModel.getEqType() != 122 || (dwdmModuleModel = (DwdmModuleModel)(dwdmPortModel = (DwdmPortModel)entityModel).getModuleModel()).isTransparent()) continue;
            iterator.remove();
        }
    }

    protected void filterOutNonGCCTrk(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            if (entityModel.getEqType() != 123) continue;
            DwdmPortModel dwdmPortModel = (DwdmPortModel)entityModel;
            DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)dwdmPortModel.getModuleModel();
            if (dwdmModuleModel.getEqType() == 121) {
                try {
                    DwdmPortModel dwdmPortModel2 = (DwdmPortModel)dwdmModuleModel.getFirstTrunkLine().getPortModel();
                    if (dwdmPortModel2.isGccTermination()) continue;
                    iterator.remove();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                continue;
            }
            if (dwdmModuleModel.getEqType() == 184 || dwdmModuleModel.getEqType() == 183) {
                if (dwdmModuleModel.getEqType() == 184) {
                    try {
                        dwdmPortModel = (DwdmPortModel)dwdmModuleModel.getDwdmLineModels()[dwdmModuleModel.getFirstTrunkPort()].getPortModel();
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
                if (dwdmPortModel.isSonetDccTermination()) continue;
                iterator.remove();
                continue;
            }
            if (dwdmPortModel.isGccTermination()) continue;
            iterator.remove();
        }
    }

    protected void filterOutNonDCCOcn(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            if (entityModel.getEqType() != 28 && entityModel.getEqType() != 29 && entityModel.getEqType() != 30 && entityModel.getEqType() != 61) continue;
            TdmPortModel tdmPortModel = (TdmPortModel)entityModel;
            if (tdmPortModel.hasOnePlusOneProtection()) {
                try {
                    OnePlusOneModel onePlusOneModel = (OnePlusOneModel)tdmPortModel.getTdmLineModel().getElementModel();
                    TdmPortModel tdmPortModel2 = (TdmPortModel)onePlusOneModel.getMainEntityModel();
                    if (tdmPortModel2.isSonetDccTermination()) continue;
                    iterator.remove();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                }
                catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {}
                continue;
            }
            if (tdmPortModel.isSonetDccTermination()) continue;
            iterator.remove();
        }
    }

    protected void filterOutNonOCH(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            if (entityModel.getEqType() == 142) {
                iterator.remove();
                continue;
            }
            if (entityModel.getEqType() != 139 && entityModel.getEqType() != 141) continue;
            PortModel portModel = (PortModel)entityModel;
            InterfaceModel interfaceModel = (InterfaceModel)portModel.getInterfaceModel();
            try {
                if (interfaceModel.getInfo().ifType == eIfType.OCH) continue;
                iterator.remove();
            }
            catch (NoSuchInterface noSuchInterface) {}
        }
    }

    protected Set getValidEntities() {
        HashSet<Model> hashSet = new HashSet<Model>();
        EntityTableModel entityTableModel = this.nmd.getEntityTableModel();
        if (entityTableModel == null || entityTableModel.getChassis() == null) {
            return hashSet;
        }
        EntityModel entityModel = (EntityModel)entityTableModel.getChassis().getChildren().get(0);
        int n = entityModel.getChildrenOfType(eClass.CONTAINER).size();
        for (int i = 1; i <= n; ++i) {
            Model model;
            int n2;
            ModuleModel moduleModel;
            EntityModel entityModel2;
            EntityModel entityModel3 = (EntityModel)entityTableModel.getEntityModelBySlot(i);
            if (entityModel3 == null || entityModel3.getChildren().size() <= 0 || !((entityModel2 = (EntityModel)entityModel3.getChildren().get(0)) instanceof ModuleModel) || (moduleModel = (ModuleModel)entityModel2).isDeleted()) continue;
            PortModel[] portModelArray = moduleModel.getPortModels();
            if (moduleModel.getEqType() == 62) {
                for (n2 = 0; n2 < portModelArray.length; ++n2) {
                    model = (HdGeLineModel)portModelArray[n2].getInterfaceModel();
                    if (!((HdGeLineModel)model).isTransponder()) continue;
                    hashSet.add(portModelArray[n2]);
                }
                continue;
            }
            for (n2 = 0; n2 < portModelArray.length; ++n2) {
                model = portModelArray[n2];
                if (((EntityModel)model).getEqType() != 139 && ((EntityModel)model).getEqType() != 141 && ((EntityModel)model).getEqType() != 122 && ((EntityModel)model).getEqType() != 123 && ((EntityModel)model).getEqType() != 28 && ((EntityModel)model).getEqType() != 29 && ((EntityModel)model).getEqType() != 30 && ((EntityModel)model).getEqType() != 61) continue;
                hashSet.add(model);
            }
        }
        return hashSet;
    }

    private IEntityModel indexToEntity(int n) {
        IEntityModel iEntityModel = null;
        try {
            iEntityModel = this.nmd.getEntityTableModel().getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this.db.println("No entity model for " + Integer.toHexString(n));
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return iEntityModel;
    }

    private void clearCache() {
        this.cache.clear();
    }

    private void cacheAdd(IVirtualLinkModel iVirtualLinkModel) {
        this.dispatcher.addObserver(ObjectType.ObjectVirtualLink, (int)iVirtualLinkModel.getOrigVLID(), (Observer)this);
        this.cache.add(iVirtualLinkModel);
    }

    private void cacheDelete(short s) {
        Iterator iterator = this.cache.iterator();
        while (iterator.hasNext()) {
            IVirtualLinkModel iVirtualLinkModel = (IVirtualLinkModel)iterator.next();
            if (iVirtualLinkModel.getOrigVLID() != s) continue;
            iterator.remove();
            this.dispatcher.deleteObserver(ObjectType.ObjectVirtualLink, (int)iVirtualLinkModel.getOrigVLID(), (Observer)this);
            break;
        }
    }

    private void updateCache() {
        this.clearCache();
        try {
            sVirtualLink[] sVirtualLinkArray = (sVirtualLink[])this.virtualLinkRetriever.get();
            if (sVirtualLinkArray != null) {
                for (int i = 0; i < sVirtualLinkArray.length; ++i) {
                    VirtualLinkModel virtualLinkModel = new VirtualLinkModel(sVirtualLinkArray[i].localLinkEnd.vlinkId, IpAddrFactory.getIIpAddr(sVirtualLinkArray[i].localLinkEnd.ipAdd), this.indexToEntity(sVirtualLinkArray[i].localIndex), sVirtualLinkArray[i].remoteLinkEnd.vlinkId, IpAddrFactory.getIIpAddr(sVirtualLinkArray[i].remoteLinkEnd.ipAdd), null);
                    this.cacheAdd(virtualLinkModel);
                }
            }
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            SDebug.printStackTrace((Throwable)((Object)xFeatureUnsupported2));
        }
        catch (CmsCommFailException cmsCommFailException) {
            SDebug.printStackTrace((Throwable)((Object)cmsCommFailException));
        }
        catch (CmsObjectNotExistException cmsObjectNotExistException) {
            SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public VirtualLinksManager(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(class$cerent$cms$model$VirtualLinksManager == null ? (class$cerent$cms$model$VirtualLinksManager = VirtualLinksManager.class$("cerent.cms.model.VirtualLinksManager")) : class$cerent$cms$model$VirtualLinksManager));
        this.dumpDebug = new VlinkDebug(nodeModelDelegate.db, "VirtualLinks");
        this.nmd = nodeModelDelegate;
        this.virtualLinkCreator = new VirtualLinkCreator("virtualLinkCreator", nodeModelDelegate);
        this.virtualLinkDeletor = new VirtualLinkDeletor("virtualLinkDeletor", nodeModelDelegate);
        this.virtualLinkRetriever = new VirtualLinkRetriever("virtualLinkRetriever", nodeModelDelegate);
        this.dispatcher = nodeModelDelegate.getDispatcher();
        this.dispatcher.addObserver(ObjectType.ObjectVirtualLinkList, 1, (Observer)this);
    }

    public String toString() {
        return "VLM:" + this.nmd.getName();
    }

    private VirtualLink getVirtualLinkRef() {
        return this.nmd.getIorRepository().getVirtualLinkRef();
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class VlinkDebug
    extends SDebug {
        public VlinkDebug(SDebug sDebug, String string) {
            super((KDebug)sDebug, string);
        }

        public final void dumpLinks() {
            this.println("Known Links [" + VirtualLinksManager.this.toString() + "]:");
            try {
                IVirtualLinkModel[] iVirtualLinkModelArray = VirtualLinksManager.this.getVirtualLinks();
                for (int i = 0; i < iVirtualLinkModelArray.length; ++i) {
                    this.println("\t" + iVirtualLinkModelArray[i]);
                }
            }
            catch (CmsCommFailException cmsCommFailException) {
                this.println("\tEncountered " + cmsCommFailException.getMessage());
            }
        }
    }

    private class VirtualLinkRetriever
    extends NonCachedValue {
        public VirtualLinkRetriever(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            sVirtualLink[] sVirtualLinkArray = VirtualLinksManager.this.getVirtualLinkRef().getAllVirtualLinks();
            return sVirtualLinkArray;
        }

        public Object outer() {
            return VirtualLinksManager.this;
        }
    }

    private class VirtualLinkDeletor
    extends NonCachedValue {
        public VirtualLinkDeletor(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Short s = (Short)object;
            VirtualLinksManager.this.getVirtualLinkRef().removeByVlinkId(s);
        }

        public Object outer() {
            return VirtualLinksManager.this;
        }
    }

    private class VirtualLinkCreator
    extends NonCachedValue {
        public VirtualLinkCreator(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            VirtualLinksManager.this.getVirtualLinkRef().add(n, (sLinkEnd)objectArray[1], (sLinkEnd)objectArray[2]);
        }

        public Object outer() {
            return VirtualLinksManager.this;
        }
    }
}

