/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds123PortModel;
import cerent.cms.model.Ds1LineModel;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProtectionGroupModel;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import java.util.LinkedList;
import java.util.List;

public class XtcModuleModel
extends ModuleModel
implements IModuleModel {
    public XtcModuleModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2);
    }

    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        PortModel[] portModelArray = this.getPortModels(eEqType2);
        InterfaceModel[] interfaceModelArray = new Ds123LineModel[portModelArray.length];
        for (int i = 0; i < portModelArray.length; ++i) {
            interfaceModelArray[i] = (Ds123LineModel)portModelArray[i].getInterfaceModel();
        }
        return interfaceModelArray;
    }

    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        portModelArray = eEqType2 != null ? this.getChildrenOfType(eEqType2).toArray(new Ds123PortModel[0]) : this.getDescendantsOfClassType(7).toArray(new Ds123PortModel[0]);
        return portModelArray == null ? new Ds123PortModel[]{} : portModelArray;
    }

    public Ds123LineModel[] getDs1Lines() {
        return (Ds123LineModel[])this.getLineModels(eEqType.DS1_VT_MAPPED);
    }

    public Ds123LineModel[] getDs3Lines() {
        return (Ds123LineModel[])this.getLineModels(eEqType.DS3);
    }

    public EnvAlarmModel[] getAlarmInput() {
        List list = this.getEnvModels(eEqType.ENVIRONMENT_ALARM);
        return list.toArray(new EnvAlarmModel[list.size()]);
    }

    public EnvControlModel[] getControlOutput() {
        List list = this.getEnvModels(eEqType.ENVIRONMENT_CONTROL);
        return list.toArray(new EnvControlModel[list.size()]);
    }

    public List getConnectionsList() {
        LinkedList linkedList = new LinkedList();
        if (this.isProtectModule()) {
            ProtectionGroupModel protectionGroupModel = this.getProtectionGroupModel();
            XtcModuleModel xtcModuleModel = (XtcModuleModel)protectionGroupModel.getProtectedModuleModel();
            if (xtcModuleModel != null) {
                return xtcModuleModel.getConnectionsList();
            }
            return linkedList;
        }
        XtcModuleModel.addConnectionList(linkedList, this.getDs3Lines());
        XtcModuleModel.addConnectionList(linkedList, this.getDs1Lines());
        return linkedList;
    }

    private static void addConnectionList(List list, Ds123LineModel[] ds123LineModelArray) {
        for (int i = 0; i < ds123LineModelArray.length; ++i) {
            try {
                list.addAll(ds123LineModelArray[i].getConnectionsList());
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    protected List getEnvModels(eEqType eEqType2) {
        List list = this.getDescendantsOfType(eEqType2);
        return list;
    }

    public List getPortsInGroup(IPortModel iPortModel, int n) {
        boolean bl = CircuitSize.getCircuitSize((int)n).isLo(this.getNodeModel().getFramingType());
        List list = null;
        list = !bl && iPortModel.getEqType() == 34 ? this.getDescendantsOfEqType(34) : super.getPortsInGroup(iPortModel, n);
        return list;
    }

    public String toString() {
        return "Xtc" + super.toString();
    }

    public ILoNum getLoNumForPort(int n, int n2) {
        int n3;
        ILoNum iLoNum = null;
        boolean bl = false;
        PortModel[] portModelArray = this.getPortModels();
        for (n3 = 0; n3 < portModelArray.length; ++n3) {
            if (portModelArray[n3].getPort() != n) continue;
            bl = true;
            break;
        }
        if (bl) {
            n3 = n;
            int n4 = this.getNodeModelDelegate().getFramingType();
            int n5 = CircuitSize.width2sizeOfLoCircuit((int)n2).getEnum();
            iLoNum = HoLoFactory.idlVt2LoNum(n4, n5, n3);
        }
        return iLoNum;
    }

    public IHoNum getHoNumForPort(int n, int n2) {
        int n3 = n - 1;
        int n4 = this.getNodeModel().getFramingType();
        int n5 = CircuitSize.width2sizeOfLoCircuit((int)n2).getEnum();
        IHoNum iHoNum = HoLoFactory.createFirstHoNum(n4);
        ILoNum iLoNum = HoLoFactory.createFirstLoNum(n4, n5);
        IHoLoNum iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
        iHoLoNum = HoLoFactory.addGroupOffset(iHoLoNum, n3);
        return iHoLoNum.getHoNum();
    }

    public int getPortForPath(ILoNum iLoNum, IHoNum iHoNum) {
        int n = 0;
        int n2 = this.getNodeModel().getFramingType();
        if (iLoNum == null) {
            n = HoLoFactory.createFirstHoNum(n2).equals(iHoNum) ? 1 : 0;
        } else {
            int n3 = iLoNum.getLoPathWidth();
            if (iHoNum != null || n3 != 7) {
                Ds123PortModel[] ds123PortModelArray = (Ds123PortModel[])this.getPortModels(eEqType.DS1_VT_MAPPED);
                for (int i = 1; i <= ds123PortModelArray.length; ++i) {
                    IHoNum iHoNum2;
                    ILoNum iLoNum2 = this.getLoNumForPort(i, n3);
                    if (iLoNum2 == null || !iLoNum2.equals(iLoNum) || iHoNum == null || (iHoNum2 = this.getHoNumForPort(i, n3)) == null || !iHoNum2.equals(iHoNum)) continue;
                    n = i;
                    break;
                }
            }
        }
        return n;
    }

    boolean isPortNumUnique(int n) {
        return false;
    }

    public boolean supportsJ1PathTrace(InterfaceModel[] interfaceModelArray) {
        return interfaceModelArray != null && interfaceModelArray.length > 0 && interfaceModelArray[0] instanceof Ds1LineModel;
    }

    public InterfaceModel[] getPathTraceLines() {
        return this.getLineModels(eEqType.DS1_VT_MAPPED);
    }

    public boolean isComboModule() {
        return true;
    }

    boolean supportXC() {
        return true;
    }
}

