/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.event;

import cerent.cms.idl.Common.sNames;
import cerent.cms.model.EnvAlarmTable;
import cerent.cms.model.FramingType;
import cerent.cms.model.IFramingType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.EventInfo;
import cerent.cms.ui.event.IAlarmDecoder;
import cerent.util.SDebug;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.omg.CORBA.UserException;

public class AlarmDecoder
implements IAlarmDecoder {
    private ArrayList neConditionCodeList = new ArrayList();
    private String[][] NEconditionLabels;
    private static final String[] updateType = new String[]{"Deleted", "Changed", "Added"};
    private static final String[] objTypeNames = new String[]{"None", "Entity Tbl", "Entity", "Interface", "Prot Grp", "SSM"};
    private static final String[] locationText = new String[]{"", " FAR", " NEAR", " ??"};
    private static final String[] periodText = new String[]{"", " 15MIN", " 1DAY", " ??", " 1HOUR", " ??", " ??", " ??"};
    public static final String COND_EXTERNAL = "EXT";
    public static final String COND_PM_TCA = "PM-TCA";
    public static final String COND_BRIDGE_RMON_ALARM = "RMON-ALARM";
    public static final String COND_INTSFT_UCP_CKT_DOWN = "CKTDOWN";
    public static final String COND_INTSFT_UCP_CKT_DOWN_EV = "CKTDOWNEV";
    public static final String[] ucpCauseCodes = new String[]{"", "RSVP Reservation message timeout", "Failed to send RSVP Path message", "RSVP Path Error message received", "RSVP Reservation Tear message received", "RSVP Reservation (Admin A&R) message received", "IPCC unavailable", "RSVP Reservation (Admin D&R) message received", "RSVP Path Ack timeout", "RSVP Path state timeout", "RSVP Path Tear received", "RSVP Path (Admin D&R) message received", "RSVP Path (Admin A&R) message received", "RSVP Reservation Error message received", "Reservation Confirm timer expiration", "RSVP Reservation Ack timeout", "RSVP Reservation state timeout", "Neighbor does not support RSVP recovery procedure", "RSVP recovery failed for circuit", "Invalid Path message for Path State"};
    private AlarmCondList alarmCondList;
    private NodeModelDelegate nmd;
    private IFramingType fType;
    private SDebug db;
    private static ModelSingletonCollection alarmDecoderSingletons;
    private static final String MON_PREFIX = "T-";
    private static final String TX_PWR_MIN = "TX-PWR-MIN";
    private static final String RX_PWR_MIN = "RX-PWR-MIN";
    private static final String LASER_BIAS_MAX = "LASER-BIAS-MAX";
    private static final String TX_PWR_MAX = "TX-PWR-MAX";
    private static final String RX_PWR_MAX = "RX-PWR-MAX";
    private static final String OPWR_MAX = "OPWRMAX";
    private static final String OPWR_MIN = "OPWRMIN";
    private static final int OPT_PWR_OFFSET = 400;
    private static final float OPT_SCALE_FACTOR = 10.0f;
    private static final float OPT_PWR_FACTOR = 10.0f;
    static /* synthetic */ Class class$cerent$cms$model$event$AlarmDecoder;

    public static synchronized AlarmDecoder getInstance(NodeModelDelegate nodeModelDelegate) {
        AlarmDecoder alarmDecoder;
        if (alarmDecoderSingletons == null) {
            alarmDecoderSingletons = ModelSingletonCollection.getMSCInstanceByName("AlarmDecoder");
        }
        if ((alarmDecoder = (AlarmDecoder)alarmDecoderSingletons.get(nodeModelDelegate)) == null) {
            alarmDecoder = new AlarmDecoder(nodeModelDelegate);
            alarmDecoderSingletons.add(nodeModelDelegate, alarmDecoder);
        }
        return alarmDecoder;
    }

    private AlarmDecoder(NodeModelDelegate nodeModelDelegate) {
        this.nmd = nodeModelDelegate;
        this.fType = FramingType.getFramingType((int)this.nmd.getFramingType());
        this.db = nodeModelDelegate.getChildDebug(class$cerent$cms$model$event$AlarmDecoder == null ? (class$cerent$cms$model$event$AlarmDecoder = AlarmDecoder.class$("cerent.cms.model.event.AlarmDecoder")) : class$cerent$cms$model$event$AlarmDecoder);
    }

    public void getNeConditionLabels() {
        if (this.NEconditionLabels == null) {
            this.alarmCondList = new AlarmCondList(this.nmd, "AlarmCondList");
            try {
                this.NEconditionLabels = (String[][])this.alarmCondList.get();
            }
            catch (UserException userException) {
                SDebug.printStackTrace((Throwable)userException);
            }
        }
    }

    public String getObjectTypeName(int n) {
        try {
            return objTypeNames[n];
        }
        catch (Exception exception) {
            return "???";
        }
    }

    public String getConditionCode(int n) {
        try {
            if (n >= 1024) {
                return this.getCTCconditionLabels(n - 1024, 0);
            }
            return this.getNEconditionLabels(n, 0);
        }
        catch (Exception exception) {
            return "??? " + n;
        }
    }

    public String getConditionDescription(int n) {
        try {
            if (n >= 1024) {
                return this.getCTCconditionLabels(n - 1024, 1);
            }
            return this.getNEconditionLabels(n, 1);
        }
        catch (Exception exception) {
            return "??? " + n;
        }
    }

    public int getConditionCodeSize() {
        return this.getNEconditionLabelsSize();
    }

    public String getUpdateTypeText(int n) {
        try {
            return updateType[n];
        }
        catch (Exception exception) {
            return "???";
        }
    }

    public String getTcaConditionCode(short s, long l, long l2) {
        int n = s & 0x3F;
        n |= (s & 0x3C00) >> 4;
        String[] stringArray = this.fType.isSdh() ? this.nmd.getPlatform().getSdhMonTypeNames() : this.nmd.getPlatform().getSonetMonTypeNames();
        try {
            return MON_PREFIX + stringArray[n];
        }
        catch (Exception exception) {
            return "???";
        }
    }

    private String normalizeMonValue(String string, long l) {
        String string2 = String.valueOf(l);
        if (!this.nmd.getPlatform().is310cl()) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(1);
            if (string.equals("T-TX-PWR-MIN") || string.equals("T-TX-PWR-MAX") || string.equals("T-RX-PWR-MIN") || string.equals("T-RX-PWR-MAX")) {
                string2 = String.valueOf(numberFormat.format((float)(l - 400L) / 10.0f));
            } else if (string.equals("T-LASER-BIAS-MAX")) {
                string2 = String.valueOf(numberFormat.format((float)l / 10.0f));
            } else if (string.equals("T-OPWRMAX") || string.equals("T-OPWRMIN")) {
                string2 = String.valueOf(numberFormat.format((float)l / 10.0f));
            }
        }
        return string2;
    }

    public String getTcaConditionDescription(short s, long l, long l2) {
        int n = (s & 0xC0) >> 6;
        int n2 = (s & 0x300) >> 8;
        int n3 = (s & 0xC000) >> 14;
        String string = this.getTcaConditionCode(s, l, l2);
        String string2 = this.normalizeMonValue(string, l);
        String string3 = this.normalizeMonValue(string, l2);
        String string4 = "";
        if (n3 == 1) {
            string4 = " (MON)";
        } else if (n3 == 2) {
            string4 = " (TERM)";
        }
        try {
            return "PM " + locationText[n] + periodText[n2] + " TCA" + string4 + ", threshold=" + string2 + ", current value= " + string3;
        }
        catch (Exception exception) {
            return "???";
        }
    }

    public String getRmonConditionDescription(short s, long l, long l2) {
        String string = "???";
        if (l2 == 1L) {
            string = "falling";
        } else if (l2 == 2L) {
            string = "rising";
        }
        return "RMON Alarm # " + l + " ( " + string + " ) fired.";
    }

    public String getCondCode(INodeModel iNodeModel, EventInfo eventInfo) {
        String string = null;
        string = this.getConditionCode(eventInfo.getCondition());
        if (COND_PM_TCA.equals(string)) {
            string = this.getTcaConditionCode(eventInfo.getSubType(), eventInfo.getData1(), eventInfo.getData2());
        } else if (COND_EXTERNAL.equals(string)) {
            string = iNodeModel.getEnvAlarmCode((int)eventInfo.getSubType());
        }
        return string;
    }

    public String getUcpCauseCodeDescription(long l) {
        if (l > 0L && l < (long)ucpCauseCodes.length) {
            return " - " + ucpCauseCodes[(int)l];
        }
        return ucpCauseCodes[0];
    }

    public String getCondDesc(INodeModel iNodeModel, EventInfo eventInfo) {
        String string = null;
        String string2 = null;
        string2 = this.getConditionCode(eventInfo.getCondition());
        string = this.getConditionDescription(eventInfo.getCondition());
        if (COND_PM_TCA.equals(string2)) {
            string = this.getTcaConditionDescription(eventInfo.getSubType(), eventInfo.getData1(), eventInfo.getData2());
        } else if (COND_BRIDGE_RMON_ALARM.equals(string2)) {
            string = this.getRmonConditionDescription(eventInfo.getSubType(), eventInfo.getData1(), eventInfo.getData2());
        } else if (COND_EXTERNAL.equals(string2)) {
            string = iNodeModel.getEnvAlarmDesc(eventInfo.getPort());
        } else if (COND_INTSFT_UCP_CKT_DOWN_EV.equals(string2)) {
            string = string + this.getUcpCauseCodeDescription(eventInfo.getData1());
        }
        return string;
    }

    public String getNEconditionLabels(int n, int n2) {
        return this.NEconditionLabels[n][n2];
    }

    public int getCondition(String string, int n) {
        for (int i = 0; i < this.NEconditionLabels.length; ++i) {
            if (!this.NEconditionLabels[i][n].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public ArrayList getAlarmConditionList() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.fType.isSdh() ? this.nmd.getPlatform().getSdhMonTypeNames() : this.nmd.getPlatform().getSonetMonTypeNames();
        arrayList.addAll(this.neConditionCodeList);
        int n2 = EnvAlarmTable.getEnvAlarmCodeSize();
        for (n = 0; n < n2; ++n) {
            arrayList.add(EnvAlarmTable.getEnvAlarmCode(n));
        }
        n = 0;
        while (true) {
            if (n >= IAlarmDecoder.CTCconditionLabels.length) break;
            arrayList.add(IAlarmDecoder.CTCconditionLabels[n][0]);
            ++n;
        }
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(MON_PREFIX + stringArray[n]);
        }
        return arrayList;
    }

    public String getCTCconditionLabels(int n, int n2) {
        return IAlarmDecoder.CTCconditionLabels[n][n2];
    }

    public int getNEconditionLabelsSize() {
        return this.NEconditionLabels.length;
    }

    public int getCTCconditionLabelsSize() {
        return IAlarmDecoder.CTCconditionLabels.length;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AlarmCondList
    extends NonCachedValue {
        public AlarmCondList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            sNames[] sNamesArray = AlarmDecoder.this.nmd.getIorRepository().getAlarmRef().alarmCondList();
            String[][] stringArray = new String[sNamesArray.length][2];
            for (int i = 0; i < sNamesArray.length; ++i) {
                stringArray[i][0] = sNamesArray[i].first;
                stringArray[i][1] = sNamesArray[i].second;
                AlarmDecoder.this.neConditionCodeList.add(sNamesArray[i].first);
            }
            return stringArray;
        }

        public Object outer() {
            return AlarmDecoder.this;
        }
    }
}

