/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.event;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.event.AbstractAlarmStore;
import cerent.cms.model.event.AbstractEventStore;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.model.event.ICardAlarmStore;
import cerent.util.Preferences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Set;

public class ElementAlarmStore
extends AbstractAlarmStore
implements ICardAlarmStore {
    private String PROP_KEY = "ctc.";
    private static final String PROP_TR_LOWATER = "node.tr.lowater";
    private static final String PROP_TR_HIWATER = "node.tr.hiwater";
    private static final int DEF_TR_LOWATER = 25;
    private static final int DEF_TR_HIWATER = 50;
    private static final int MIN_TR_HIWATER = 20;
    private HashSet removedTransient;
    boolean isComboCard;
    protected HashMap alarmStatusContainer;
    protected int portCountUsers = 0;
    private ElementAlarmStore parentStore;
    private NodeModelDelegate nodeModel;
    private int trCount;
    private int trLoWater;
    private int trHiWater;

    public ElementAlarmStore(NodeModelDelegate nodeModelDelegate, String string) {
        this(nodeModelDelegate, string, null);
    }

    private ElementAlarmStore(String string, ElementAlarmStore elementAlarmStore) {
        this(null, string, elementAlarmStore);
    }

    private ElementAlarmStore(NodeModelDelegate nodeModelDelegate, String string, ElementAlarmStore elementAlarmStore) {
        super(string);
        this.nodeModel = nodeModelDelegate;
        this.parentStore = elementAlarmStore;
        this.PROP_KEY = this.PROP_KEY + this.getNodeModelDelegate().getPlatform().getPlatformName();
        this.trLoWater = Preferences.instance().getInt(this.PROP_KEY, PROP_TR_LOWATER, 25);
        this.trHiWater = Preferences.instance().getInt(this.PROP_KEY, PROP_TR_HIWATER, 50);
        this.isComboCard = false;
        this.alarmStatusContainer = null;
        if (this.parentStore == null) {
            this.db = new AbstractAlarmStore.AsDebug(this, nodeModelDelegate.getDebug(), this.name);
            this.removedTransient = new HashSet();
        } else {
            this.db = this.parentStore.getDebug();
        }
        if (this.trHiWater < 20) {
            this.trHiWater = 20;
        }
        if (this.trLoWater >= this.trHiWater) {
            this.trLoWater = this.trHiWater / 2;
        }
        this.db.info("PROP_TR_LOWATER = " + this.trLoWater + ", PROP_TR_HIWATER = " + this.trHiWater);
    }

    protected NodeModelDelegate getNodeModelDelegate() {
        return this.parentStore != null ? this.parentStore.getNodeModelDelegate() : this.nodeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvents(ArrayList object) {
        Set set = null;
        ElementAlarmStore elementAlarmStore = this;
        synchronized (elementAlarmStore) {
            Integer n;
            int n2;
            Object object2;
            int n3;
            Object object3;
            int n4 = ((ArrayList)object).size();
            this.db.info(this.name + " adding " + n4 + " events");
            int n5 = this.trCount;
            if (this.db.isFineEnabled()) {
                EventInfo eventInfo;
                this.db.fine("***********addEvents() Begins************");
                this.db.fine("addEvents(): anyEvtArray STARTS :");
                object3 = ((ArrayList)object).iterator();
                while (object3.hasNext()) {
                    eventInfo = (EventInfo)object3.next();
                    this.db.fine(eventInfo.toString());
                }
                this.db.fine("addEvents(): anyEvtArray ENDS :");
                this.db.fine("addEvents(): arrayList STARTS:");
                object3 = this.arrayList.iterator();
                while (object3.hasNext()) {
                    eventInfo = (EventInfo)object3.next();
                    this.db.fine(eventInfo.toString());
                }
                this.db.fine("addEvents(): arrayList ENDS:");
                this.db.fine("addEvents(): filteredArrayList STARTS:");
                object3 = this.filteredArrayList.iterator();
                while (object3.hasNext()) {
                    eventInfo = (EventInfo)object3.next();
                    this.db.fine(eventInfo.toString());
                }
                this.db.fine("addEvents(): arrayList ENDS:");
            }
            object3 = null;
            for (n3 = 0; n3 < n4; ++n3) {
                object2 = (EventInfo)((ArrayList)object).get(n3);
                n2 = object2.getSlot();
                if (n2 != 0) {
                    n = new Integer(object2.getSlot());
                    ElementAlarmStore elementAlarmStore2 = (ElementAlarmStore)this.getChild(n);
                    if (elementAlarmStore2 == null) {
                        elementAlarmStore2 = (ElementAlarmStore)this.createChild(n, "Slot-" + object2.getSlot());
                    }
                    object3 = elementAlarmStore2.storeEvent((EventInfo)object2);
                    object3 = this.correlateAlarm((EventInfo)object2, (EventInfo)object3);
                } else {
                    object3 = this.storeEvent((EventInfo)object2);
                }
                object2.setCorrelated((EventInfo)object3);
                if (!this.db.on()) continue;
                this.db.fine("addEvent:" + object2 + " corl=" + object3);
            }
            if (this.trCount > this.trHiWater) {
                n3 = this.trCount - this.trLoWater;
                set = this.removeTransient(n3);
                this.trCount = this.trLoWater;
                if ((n3 -= n5) > 0) {
                    object2 = new ArrayList(((ArrayList)object).size());
                    this.db.info("TR discarded from new array=" + n3);
                    for (n2 = 0; n2 < ((ArrayList)object).size(); ++n2) {
                        n = (EventInfo)((ArrayList)object).get(n2);
                        if (n3 > 0 && n.getState() == 'T') {
                            --n3;
                            continue;
                        }
                        ((ArrayList)object2).add(n);
                    }
                    object = object2;
                }
            }
            if (set != null && this.children != null) {
                Iterator iterator = this.children.values().iterator();
                while (iterator.hasNext()) {
                    object2 = (ElementAlarmStore)iterator.next();
                    ((AbstractAlarmStore)object2).removeAlarms(set);
                }
            }
            if (this.db.isFineEnabled()) {
                this.db.fine("addEvents(): BEFORE  LEAVING the method");
                this.db.fine("addEvents(): arrayList STARTS:");
                Iterator iterator = this.arrayList.iterator();
                while (iterator.hasNext()) {
                    object2 = (EventInfo)iterator.next();
                    this.db.fine(object2.toString());
                }
                this.db.fine("addEvents(): arrayList ENDS:");
                this.db.fine("addEvents(): filteredArrayList STARTS:");
                iterator = this.filteredArrayList.iterator();
                while (iterator.hasNext()) {
                    object2 = (EventInfo)iterator.next();
                    this.db.fine(object2.toString());
                }
                this.db.fine("addEvents(): shortArrayList ENDS:");
                this.db.fine("***********addEvents() Ends**************");
            }
        }
        if (set != null) {
            this.storeObservable.setChanged();
            this.storeObservable.notifyObservers(set);
            this.fireBulkDataSourceChanged();
        }
        if (((ArrayList)object).size() > 0) {
            this.storeObservable.setChanged();
            this.storeObservable.notifyObservers(object);
        }
        this.updateView();
    }

    public ElementAlarmStore getAlarmStore(int n) {
        Integer n2 = new Integer(n);
        ElementAlarmStore elementAlarmStore = (ElementAlarmStore)this.getChild(n2);
        if (elementAlarmStore == null) {
            elementAlarmStore = (ElementAlarmStore)this.createChild(n2, "Slot-" + n);
        }
        return elementAlarmStore;
    }

    public ICardAlarmStore getCardAlarmStore(int n) {
        return this.getAlarmStore(n);
    }

    public void getPendingAlarms() throws AbstractCmsIOException {
        this.getNodeModelDelegate().synchronizeAlarm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enablePortAlarmsStatus(IModuleModel iModuleModel) {
        if (iModuleModel != null) {
            this.isComboCard = ((ModuleModel)iModuleModel).isComboModule();
        }
        ElementAlarmStore elementAlarmStore = this;
        synchronized (elementAlarmStore) {
            if (this.alarmStatusContainer == null) {
                this.alarmStatusContainer = new HashMap();
            } else {
                this.alarmStatusContainer.clear();
            }
            this.db.info("looping through " + this.filteredArrayList.size() + " events" + " (arrayList has " + this.arrayList.size() + " events)");
            for (int i = 0; i < this.arrayList.size(); ++i) {
                EventInfo eventInfo = (EventInfo)this.arrayList.get(i);
                if (eventInfo.getState() != 'R') continue;
                this.updatePortAlarmStatus(eventInfo);
            }
        }
        ++this.portCountUsers;
        this.db.info(this.name + " exiting enablePortAlarmsStatus " + this.getNodeModelDelegate().getHostName() + " " + this.getName() + " count=" + this.portCountUsers);
    }

    public synchronized void disablePortAlarmsStatus() {
        if (this.portCountUsers > 0) {
            --this.portCountUsers;
        }
        this.db.info(this.name + " disablePortAlarmsStatus " + this.getNodeModelDelegate().getHostName() + " " + this.getName() + " count=" + this.portCountUsers);
        if (this.portCountUsers == 0) {
            this.resetPortAlarmStatus(true);
        }
    }

    public synchronized IAlarmStatus getEntityAlarmStatus(IEntityModel iEntityModel) {
        if (iEntityModel == null) {
            return null;
        }
        int n = iEntityModel.getEqType();
        int[] nArray = null;
        if (iEntityModel instanceof PortModel) {
            nArray = ((PortModel)iEntityModel).getPortNum();
        } else if (iEntityModel instanceof PluggableModel) {
            nArray = ((PluggableModel)iEntityModel).getHierarchyNums();
        } else {
            nArray = new int[]{};
            if (this.db.on()) {
                this.db.println(this.name + " invalid model: " + iEntityModel);
            }
        }
        return this.getEntityAlarmStatus(n, nArray);
    }

    private synchronized IAlarmStatus getEntityAlarmStatus(int n, int[] nArray) {
        AlarmStatus alarmStatus = null;
        if (this.alarmStatusContainer != null) {
            String string = this.makeAlarmStatusContainerKey(n, nArray, this.isComboCard);
            if (this.alarmStatusContainer.containsKey(string)) {
                alarmStatus = (AlarmStatus)this.alarmStatusContainer.get(string);
            }
            if (this.db.on()) {
                String string2 = "";
                for (int i = 0; i < nArray.length; ++i) {
                    string2 = string2 + nArray[i];
                }
                this.db.println(this.name + " alarm status for equipment: " + n + " entity: " + string2 + " comboCard: " + this.isComboCard + " alarm status: " + alarmStatus + " container size: " + this.alarmStatusContainer.size());
            }
        } else if (this.db.on()) {
            String string = "";
            for (int i = 0; i < nArray.length; ++i) {
                string = string + nArray[i];
            }
            this.db.println(this.name + "Null alarm status container, eqType:" + n + " entity:" + string);
        }
        return alarmStatus;
    }

    public synchronized IAlarmStatus getPortAlarmStatus(int n, int n2) {
        AlarmStatus alarmStatus = null;
        if (this.alarmStatusContainer != null) {
            int[] nArray = new int[]{n2};
            String string = this.makeAlarmStatusContainerKey(n, nArray, this.isComboCard);
            if (this.alarmStatusContainer.containsKey(string)) {
                alarmStatus = (AlarmStatus)this.alarmStatusContainer.get(string);
            }
            this.db.info(this.name + " no alarm status for equipment:" + n + " port:" + n2 + " comboCard?" + this.isComboCard + " container size:" + this.alarmStatusContainer.size());
        } else {
            this.db.info(this.name + "Null alarm status container, eqType:" + n + " port:" + n2);
        }
        return alarmStatus;
    }

    public void removeClearedAlarms() {
        super.removeClearedAlarms();
        Object[] objectArray = new Object[]{IAlarmStore.DELETE_CLEARED_ALARM_BUTTON, new Integer(this.getNodeModelDelegate().getNodeId())};
        this.storeObservable.setChanged();
        this.storeObservable.notifyObservers(objectArray);
    }

    public void reset() {
        this.flushAlarmStore();
    }

    public void flushAlarmStore() {
        super.flushStore();
        Object[] objectArray = new Object[]{IAlarmStore.SYNC_ALARM_BUTTON, new Integer(this.getNodeModelDelegate().getNodeId())};
        this.storeObservable.setChanged();
        this.storeObservable.notifyObservers(objectArray);
        this.updateView();
    }

    protected synchronized void transientAdded() {
        if (this.parentStore == null) {
            ++this.trCount;
        }
    }

    private synchronized Set removeTransient(int n) {
        ArrayList arrayList = new ArrayList(this.arrayList.size());
        HashSet<EventInfo> hashSet = new HashSet<EventInfo>();
        this.db.info("Transient current=" + this.trCount + " discarding=" + n);
        for (int i = 0; i < this.arrayList.size(); ++i) {
            EventInfo eventInfo = (EventInfo)this.arrayList.get(i);
            if (n > 0 && eventInfo.getState() == 'T') {
                hashSet.add(eventInfo);
                --n;
                continue;
            }
            arrayList.add(this.arrayList.get(i));
        }
        this.arrayList.clear();
        this.arrayList = arrayList;
        return hashSet;
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            if (n.equals(IAlarmStore.DELETE_CLEARED_ALARM_BUTTON)) {
                this.db.info(this.name + " update: removeClearedAlarms()");
                super.removeClearedAlarms();
            } else if (n.equals(IAlarmStore.SYNC_ALARM_BUTTON)) {
                this.db.info(this.name + " update: SYNC (flushStore)");
                super.flushStore();
            }
        }
    }

    protected AbstractEventStore createInstance(String string) {
        return new ElementAlarmStore(null, string, this);
    }

    protected void localUpdateStatus(EventInfo eventInfo) {
        this.db.info(this.name + "localUpdateStatus");
        this.updatePortAlarmStatus(eventInfo);
    }

    protected void localFlushStore() {
        if (this.alarmStatusContainer != null) {
            this.alarmStatusContainer.clear();
        }
        super.localFlushStore();
        this.trCount = 0;
    }

    private synchronized void resetPortAlarmStatus(boolean bl) {
        if (this.alarmStatusContainer != null) {
            this.alarmStatusContainer.clear();
            if (bl) {
                this.alarmStatusContainer = null;
            }
        }
        this.db.info(this.name + " Resetting port alarm status " + this.getNodeModelDelegate().getHostName() + " " + this.getName());
    }

    private String makeAlarmStatusContainerKey(int n, int[] nArray, boolean bl) {
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            string = string + nArray[i];
        }
        if (bl) {
            return n + "-" + string;
        }
        return string;
    }

    protected synchronized void updatePortAlarmStatus(EventInfo eventInfo) {
        if (this.alarmStatusContainer != null && eventInfo.getEntityHierarchyNum().length != 0) {
            AlarmStatus alarmStatus = (AlarmStatus)this.getEntityAlarmStatus(eventInfo.getPortType(), eventInfo.getEntityHierarchyNum());
            if (alarmStatus == null) {
                String string = this.makeAlarmStatusContainerKey(eventInfo.getPortType(), eventInfo.getEntityHierarchyNum(), this.isComboCard);
                this.db.info(this.name + ": creating key: " + string);
                alarmStatus = new AlarmStatus();
                this.alarmStatusContainer.put(string, alarmStatus);
            } else if (this.db.on()) {
                this.db.fine(this.name + "reusing key " + eventInfo.getEntityHierarchyNum());
            }
            if (eventInfo.getState() == 'R') {
                alarmStatus.incrementSeverity(eventInfo.getSeverity());
            } else if (eventInfo.getState() == 'C') {
                alarmStatus.decrementSeverity(eventInfo.getSeverity());
            }
        } else if (this.db.isInfoEnabled() && this.alarmStatusContainer == null && this.parentStore != null && eventInfo.getPort() > 0) {
            this.db.info(this.name + " Null alarmStatusContainer, alarm on port:" + eventInfo.getEntityHierarchyNum());
        }
    }

    public ElementAlarmStore getParentStore() {
        return this.parentStore;
    }

    public void destroy() {
        this.db.info("destroy(): arrayList size=" + this.arrayList.size());
        Object[] objectArray = new Object[]{ModelUpdateType.DELETED, new ArrayList(this.arrayList)};
        this.storeObservable.setChanged();
        this.storeObservable.notifyObservers(objectArray);
        super.destroy();
        this.alarmStatusContainer = null;
    }
}

