/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.event;

import cerent.cms.model.ENMSUpdate;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.event.AbstractEventStore;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.StoreObservable;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;

public class ElementEventStore
extends AbstractEventStore
implements PropertyChangeListener {
    private int currentlyViewedSlotId = 0;
    private static String PROP_HISTORY_MAX = "nodehistory.max";
    protected static final int DEFAULT_HI_WATER = 500;
    protected int globalStoreHighWater = 500;
    private ElementEventStore parentStore;
    private NodeModelDelegate nodeModel;

    public ElementEventStore(NodeModelDelegate nodeModelDelegate, String string) {
        this.nodeModel = nodeModelDelegate;
        this.name = string;
        this.storeObservable = new StoreObservable(this.name);
        this.parentStore = null;
        this.db = new SDebug((KDebug)nodeModelDelegate.getDebug(), this.name);
        this.init();
    }

    private ElementEventStore(String string, ElementEventStore elementEventStore) {
        this.nodeModel = null;
        this.name = string;
        this.storeObservable = new StoreObservable(this.name);
        this.parentStore = elementEventStore;
        this.db = elementEventStore.getDebug();
        this.init();
    }

    protected NodeModelDelegate getNodeModelDelegate() {
        return this.parentStore != null ? this.parentStore.getNodeModelDelegate() : this.nodeModel;
    }

    public ElementEventStore getEventStore(int n) {
        if (this.currentlyViewedSlotId != 0 && this.currentlyViewedSlotId != n) {
            this.removeChild(new Integer(this.currentlyViewedSlotId));
        }
        if (this.db.on()) {
            this.db.println(this.name + " getEventStore(), currentlyViewSlotId:" + this.currentlyViewedSlotId + ", new slotId:" + n);
        }
        this.currentlyViewedSlotId = n;
        Integer n2 = new Integer(n);
        ElementEventStore elementEventStore = (ElementEventStore)this.getChild(n2);
        if (elementEventStore == null) {
            elementEventStore = (ElementEventStore)this.createChild(n2, "Slot-" + n);
            this.fillSlotStore(n, elementEventStore, this);
        }
        return elementEventStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvents(ArrayList arrayList) {
        ElementEventStore elementEventStore = this;
        synchronized (elementEventStore) {
            AbstractEventStore abstractEventStore;
            Object object;
            int n;
            int n2 = arrayList.size();
            if (n2 <= 0) {
                return;
            }
            int n3 = 0;
            boolean bl = false;
            int n4 = this.getRowCount();
            if (this.db.on()) {
                this.db.println("processEvents(): currentCount: " + n4 + ", incomingCount: " + n2 + ", threshold: " + this.globalStoreHighWater + ", lowWater: " + this.getLowWater());
            }
            if (n4 + n2 > this.globalStoreHighWater) {
                if (n2 >= this.globalStoreHighWater) {
                    this.flushStore();
                    n3 = n2 - this.getLowWater();
                } else if (n2 >= this.getLowWater()) {
                    this.flushStore();
                } else {
                    int n5;
                    n = this.getLowWater() - n2;
                    object = new ArrayList();
                    for (int i = n5 = n4 - n; i < n4; ++i) {
                        ((ArrayList)object).add(this.arrayList.get(i));
                    }
                    this.flushStore();
                    for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                        Integer n6;
                        AbstractEventStore abstractEventStore2;
                        EventInfo eventInfo = (EventInfo)((ArrayList)object).get(i);
                        this.storeEvent(eventInfo);
                        if (eventInfo.getSlot() <= 0 || (abstractEventStore2 = this.getChild(n6 = new Integer(eventInfo.getSlot()))) == null) continue;
                        abstractEventStore2.storeEvent(eventInfo);
                    }
                    abstractEventStore = null;
                }
                if (this.db.on()) {
                    this.db.println("clipping is going on !! startIndex " + n3);
                }
            }
            for (n = 0; n < n2; ++n) {
                Integer n7;
                object = (EventInfo)arrayList.get(n);
                this.storeEvent((EventInfo)object);
                if (this.db.on()) {
                    this.db.println(this.name + " " + object);
                }
                if (object.getSlot() > 0 && (abstractEventStore = this.getChild(n7 = new Integer(object.getSlot()))) != null) {
                    abstractEventStore.storeEvent((EventInfo)object);
                }
                object.setCorrelated(null);
            }
        }
        this.storeObservable.setChanged();
        this.storeObservable.notifyObservers(arrayList);
        this.updateView();
    }

    public void update(Observable observable, Object object) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals(PROP_HISTORY_MAX)) {
            try {
                int n = Integer.parseInt(this.prefs.getProperty("ctc", PROP_HISTORY_MAX, ""));
                if (n > 0) {
                    this.globalStoreHighWater = n;
                    this.db.config("globalStoreHighWater changed to " + this.globalStoreHighWater);
                }
            }
            catch (Exception exception) {
                this.db.warning("Exception in propertyChange(): " + exception);
            }
        }
    }

    public void init() {
        this.prefs = Preferences.instance();
        this.prefs.addPropertyChangeListener((PropertyChangeListener)this);
        try {
            int n = Integer.parseInt(this.prefs.getProperty("ctc", PROP_HISTORY_MAX, null));
            if (n > 0) {
                this.globalStoreHighWater = n;
                this.db.config("globalStoreHighWater changed to " + this.globalStoreHighWater);
            }
        }
        catch (Exception exception) {
            this.prefs.setProperty("ctc", PROP_HISTORY_MAX, String.valueOf(this.globalStoreHighWater));
        }
    }

    public void destroy() {
        super.destroy();
        if (this.prefs != null) {
            this.prefs.removePropertyChangeListener((PropertyChangeListener)this);
            this.prefs = null;
        }
    }

    public void sendReregisterNotification() {
        int n = this.getNodeModelDelegate().getNodeId();
        ENMSUpdate eNMSUpdate = new ENMSUpdate(n, new Integer(0));
        if (this.db.on()) {
            this.db.println("sending notification for reregister");
        }
        this.storeObservable.setChanged();
        this.storeObservable.notifyObservers(eNMSUpdate);
    }

    protected int getHighWater() {
        return this.globalStoreHighWater;
    }

    protected int getLowWater() {
        return this.globalStoreHighWater / 2;
    }

    protected AbstractEventStore createInstance(String string) {
        return new ElementEventStore(string, this);
    }

    private synchronized void fillSlotStore(int n, ElementEventStore elementEventStore, ElementEventStore elementEventStore2) {
        Iterator iterator = elementEventStore2.getAllObjects().iterator();
        while (iterator.hasNext()) {
            EventInfo eventInfo = (EventInfo)iterator.next();
            if (eventInfo.getSlot() != n) continue;
            elementEventStore.storeEvent(eventInfo);
        }
    }
}

