/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.nedefaults;

import cerent.cms.model.Attribute;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.nedefaults.DefaultsManager;
import cerent.cms.model.nedefaults.DefaultsNode;
import cerent.cms.model.nedefaults.IDefaultsElement;
import cerent.cms.model.nedefaults.IDefaultsNode;
import java.util.ArrayList;
import java.util.Iterator;

public class DefaultsElement
extends DefaultsNode
implements IDefaultsElement {
    private String myUnits = null;
    private String myValue = null;
    private String oldValue = null;
    private String presetValue = null;
    private int myClass = 0;
    private ArrayList validEnumValues = null;
    private boolean reprovisions = false;
    private boolean disconnects = false;
    private boolean reboots = false;
    private boolean checkIfSupported = false;
    private boolean isSupported = true;
    private String comment = "";
    protected static DefaultsManager.DefaultsManagerDebug db;

    public DefaultsElement(String string, DefaultsNode defaultsNode, String string2, String string3, int n, ArrayList arrayList, int n2, DefaultsManager.DefaultsManagerDebug defaultsManagerDebug) {
        super(string, defaultsNode);
        db = defaultsManagerDebug;
        this.myValue = string2;
        this.myUnits = string3;
        this.myClass = n;
        this.validEnumValues = arrayList;
        this.reprovisions = false;
        this.disconnects = false;
        this.reboots = false;
        this.checkIfSupported = false;
        switch (n2) {
            case 4: {
                this.checkIfSupported = true;
            }
            case 3: {
                this.reboots = true;
            }
            case 2: {
                this.disconnects = true;
            }
            case 1: {
                this.reprovisions = true;
                break;
            }
            case 5: {
                this.reprovisions = true;
                this.checkIfSupported = true;
                break;
            }
            case 6: {
                this.checkIfSupported = true;
                break;
            }
        }
        if (this.myUnits != null && this.myUnits.length() == 0) {
            this.myUnits = null;
        }
        this.comment = "";
        this.dirty = false;
        this.presetValue = null;
    }

    public void setValue(String string) throws ProvisionError {
        if (this.presetValue != null && this.presetValue != string) {
            db.severe("Pre-edited " + this.presetValue + " but setting " + string);
        }
        this.checkValue(string);
        if (!this.myValue.equals(string)) {
            this.oldValue = this.myValue;
            this.myValue = string;
            this.setDirty();
        }
        this.presetValue = null;
        this.crossCheckValue();
    }

    public void presetValue(String string) {
        if (string == null || this.myValue.equals(string)) {
            this.presetValue = null;
        } else if (this.validForSupportedElem(string)) {
            this.presetValue = string;
        }
    }

    private boolean validForSupportedElem(String string) {
        return this.myValue.equals(string) || !this.myValue.equals("(NOT SUPPORTED)") && !string.equals("(NOT SUPPORTED)");
    }

    public boolean reprovisions() {
        return this.reprovisions;
    }

    public boolean disconnects() {
        return this.disconnects;
    }

    public boolean causesReboot() {
        return this.reboots;
    }

    public boolean checkIfSupported() {
        return this.checkIfSupported;
    }

    public boolean ifSupportedCausesReboot() {
        return this.checkIfSupported && this.reboots;
    }

    public boolean ifSupportedReprovisions() {
        return this.checkIfSupported && this.reprovisions;
    }

    public void setSupported(boolean bl) {
        this.isSupported = bl;
    }

    public boolean isSupported() {
        return this.isSupported;
    }

    public void resetValue() {
        this.myValue = this.oldValue;
        this.recalcDirty();
    }

    public void initValue(String string) throws ProvisionError {
        this.myValue = string;
        this.oldValue = string;
    }

    public IDefaultsElement getSiblingElement(String string) {
        IDefaultsElement iDefaultsElement = null;
        if (string != this.getName()) {
            iDefaultsElement = (IDefaultsElement)((DefaultsNode)this.getParent()).getChild(string);
        }
        return iDefaultsElement;
    }

    private IDefaultsElement getCousinElement(String string) {
        IDefaultsNode iDefaultsNode = null;
        if (string != null && string != this.getName()) {
            String[] stringArray = string.split("\\.");
            iDefaultsNode = this.getParent();
            for (int i = 0; i < stringArray.length; ++i) {
                db.fine(this.getName() + " getCousinElement(): " + iDefaultsNode + " getting " + stringArray[i]);
                if (stringArray[i].equals("//")) {
                    iDefaultsNode = iDefaultsNode.getParent();
                } else if (!stringArray[i].equals("/")) {
                    iDefaultsNode = ((DefaultsNode)iDefaultsNode).getChild(stringArray[i]);
                }
                if (iDefaultsNode == null) break;
            }
        }
        if (iDefaultsNode == null) {
            db.severe("data initialization error on " + string);
        } else {
            db.info("getCousinElement() : result is " + iDefaultsNode.getName() + " " + iDefaultsNode.getClass().getName());
        }
        return (IDefaultsElement)iDefaultsNode;
    }

    private void checkStringEnum2(String string) throws ProvisionError {
        try {
            long l = Long.parseLong((String)this.validEnumValues.get(0));
            long l2 = Long.parseLong((String)this.validEnumValues.get(1));
            try {
                long l3 = Long.parseLong(string);
                if (l3 < l || l3 > l2) {
                    throw new ProvisionError(this.getFullName() + ": Value \"" + string + "\" out of range [" + l + ".." + l2 + "]");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProvisionError(this.getFullName() + ": Value \"" + string + "\" must be an integer [" + l + ".." + l2 + "]");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProvisionError(this.getFullName() + ": Range " + (String)this.validEnumValues.get(0) + "-" + (String)this.validEnumValues.get(1) + " must be integral");
        }
    }

    private void checkStringEnum4(String string) throws ProvisionError {
        String string2 = "";
        String string3 = "";
        try {
            IDefaultsElement iDefaultsElement;
            int n = Integer.parseInt((String)this.validEnumValues.get(0));
            int n2 = Integer.parseInt((String)this.validEnumValues.get(1));
            String string4 = (String)this.validEnumValues.get(2);
            String string5 = (String)this.validEnumValues.get(3);
            if (string4 != null && string4 != "" && (iDefaultsElement = this.getCousinElement(string4)) != null) {
                string2 = iDefaultsElement.getValue();
                n = Integer.parseInt(string2);
            }
            if (string5 != null && string5 != "" && (iDefaultsElement = this.getCousinElement(string5)) != null) {
                string3 = iDefaultsElement.getValue();
                n2 = Integer.parseInt(string3);
            }
            try {
                int n3 = Integer.parseInt(string);
                if (n3 < n || n3 > n2) {
                    throw new ProvisionError(this.getFullName() + ": Value \"" + string + "\" out of range [" + this.format(string4, Integer.toString(n), n, 1) + ".." + this.format(string5, Integer.toString(n2), n2, 1) + "]");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProvisionError(this.getFullName() + ": Value \"" + string + "\" must be an integer [" + n + ".." + n2 + "]");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProvisionError(this.getFullName() + ": Range " + (String)this.validEnumValues.get(0) + "(" + (String)this.validEnumValues.get(2) + "=" + string2 + ") - " + (String)this.validEnumValues.get(1) + "(" + (String)this.validEnumValues.get(3) + "=" + string3 + ") must be integral");
        }
    }

    private void checkStringEnum6(String string) throws ProvisionError {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        try {
            int n = Integer.parseInt((String)this.validEnumValues.get(0));
            int n2 = Integer.parseInt((String)this.validEnumValues.get(1));
            int n3 = Integer.parseInt((String)this.validEnumValues.get(3));
            string2 = (String)this.validEnumValues.get(4);
            string3 = (String)this.validEnumValues.get(5);
            String string6 = "unknown";
            try {
                IDefaultsElement iDefaultsElement;
                if (string2 != null && string2 != "" && (iDefaultsElement = this.getCousinElement(string6 = string2)) != null) {
                    string4 = iDefaultsElement.getValue();
                    if (string4 == null || string4.equals("")) {
                        string4 = "0";
                    }
                    n = Math.round(Float.parseFloat(string4) * (float)n3);
                }
                if (string3 != null && string3 != "" && (iDefaultsElement = this.getCousinElement(string6 = string3)) != null) {
                    string5 = iDefaultsElement.getValue();
                    if (string5 == null || string5.equals("")) {
                        string5 = "0";
                    }
                    n2 = Math.round(Float.parseFloat(string5) * (float)n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                DefaultsManager.DefaultsManagerDebug.printStackTrace((Throwable)numberFormatException);
                throw new ProvisionError(this.getFullName() + ": Variable Range for " + string6 + " value " + string + ": " + string2 + " " + string4 + "(=" + n + ") - " + string3 + " " + string5 + "(=" + n2 + ") and divisor " + n3 + " must be integral");
            }
            try {
                float f = Float.parseFloat(string);
                int n4 = Math.round(f * (float)n3);
                if (n4 < n || n4 > n2) {
                    throw new ProvisionError(this.getFullName() + ": Value \"" + string + "\" out of range [" + this.format(string2, string4, n, n3) + ".." + this.format(string3, string5, n2, n3) + "]");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProvisionError(this.getFullName() + ": Value of " + this.getName() + "\"" + string + "\" must be a float [" + n + ".." + n2 + "]");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProvisionError(this.getFullName() + ": Fixed range of " + this.getName() + " from " + (String)this.validEnumValues.get(0) + "(" + string2 + "=" + string4 + ") - " + (String)this.validEnumValues.get(1) + "(" + string3 + "=" + string5 + ") must be integral");
        }
    }

    private void checkStringEnum6(String string, String string2) throws ProvisionError {
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        try {
            int n = Integer.parseInt((String)this.validEnumValues.get(0));
            int n2 = Integer.parseInt((String)this.validEnumValues.get(1));
            int n3 = Integer.parseInt((String)this.validEnumValues.get(3));
            string3 = (String)this.validEnumValues.get(4);
            string4 = (String)this.validEnumValues.get(5);
            String string7 = "unknown";
            try {
                IDefaultsElement iDefaultsElement;
                if (string3 != null && string3 != "" && (iDefaultsElement = this.getCousinElement(string7 = string3)) != null) {
                    string5 = string2;
                    if (string5 == null || string5.equals("")) {
                        string5 = "0";
                    }
                    n = Math.round(Float.parseFloat(string5) * (float)n3);
                }
                if (string4 != null && string4 != "" && (iDefaultsElement = this.getCousinElement(string7 = string4)) != null) {
                    string6 = string2;
                    if (string6 == null || string6.equals("")) {
                        string6 = "0";
                    }
                    n2 = Math.round(Float.parseFloat(string6) * (float)n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                DefaultsManager.DefaultsManagerDebug.printStackTrace((Throwable)numberFormatException);
                throw new ProvisionError(this.getFullName() + ": Variable Range for " + string7 + " value " + string + ": " + string3 + " " + string5 + "(=" + n + ") - " + string4 + " " + string6 + "(=" + n2 + ") and divisor " + n3 + " must be integral");
            }
            try {
                float f = Float.parseFloat(string);
                int n4 = Math.round(f * (float)n3);
                if (n4 < n || n4 > n2) {
                    throw new ProvisionError(this.getFullName() + ": Value \"" + string + "\" out of range [" + this.format(string3, string5, n, n3) + ".." + this.format(string4, string6, n2, n3) + "]");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProvisionError(this.getFullName() + ": Value of " + this.getName() + "\"" + string + "\" must be a float [" + n + ".." + n2 + "]");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProvisionError(this.getFullName() + ": Fixed range of " + this.getName() + " from " + (String)this.validEnumValues.get(0) + "(" + string3 + "=" + string5 + ") - " + (String)this.validEnumValues.get(1) + "(" + string4 + "=" + string6 + ") must be integral");
        }
    }

    private String format(String string, String string2, int n, int n2) {
        if (string.equals("")) {
            return Float.toString(n / n2);
        }
        return string + "(" + string2 + ")";
    }

    private Attribute toAttribute(String string, ArrayList arrayList) {
        Attribute attribute = null;
        if (arrayList != null && arrayList.size() > 0 && arrayList.get(0) instanceof Attribute) {
            Iterator iterator = arrayList.iterator();
            while (attribute == null && iterator.hasNext()) {
                Attribute attribute2 = (Attribute)iterator.next();
                db.fine("Matching >" + string + "< against " + attribute2.getValue() + "=>" + attribute2.getKey() + "<");
                if (!attribute2.getKey().equals(string)) continue;
                attribute = attribute2;
            }
        } else {
            db.severe("No attributes available...");
        }
        return attribute;
    }

    private Attribute toAttribute(int n, ArrayList arrayList) {
        Attribute attribute = null;
        if (arrayList != null && arrayList.size() > 0 && arrayList.get(0) instanceof Attribute) {
            Iterator iterator = arrayList.iterator();
            while (attribute == null && iterator.hasNext()) {
                Attribute attribute2 = (Attribute)iterator.next();
                db.fine("Matching " + n + " against " + attribute2.getValue() + "=>" + attribute2.getKey());
                if (attribute2.getIntValue() != n) continue;
                attribute = attribute2;
            }
        }
        return attribute;
    }

    private void crossCheckValue() throws ProvisionError {
        if (this.myClass == 10) {
            Object e = this.validEnumValues.get(0);
            String[] stringArray = null;
            if (e instanceof String) {
                stringArray = new String[]{(String)e};
            } else if (e instanceof String[]) {
                stringArray = (String[])e;
            } else {
                db.severe("Unknown slave specification");
                stringArray = new String[]{};
            }
            String string = "";
            for (int i = 0; i < stringArray.length; ++i) {
                db.fine("Getting sibling slave for " + this.getName() + " based on " + stringArray[i] + " size is " + this.validEnumValues.size());
                DefaultsElement defaultsElement = (DefaultsElement)this.getCousinElement(stringArray[i]);
                try {
                    defaultsElement.checkValue();
                    continue;
                }
                catch (ProvisionError provisionError) {
                    db.info("Slave " + defaultsElement.getName() + " " + defaultsElement.getValue() + " failure on " + this.getFullName());
                    string = string + "Value of dependent " + defaultsElement.getName() + " is no longer a valid value\n";
                    if (this.presetValue == null) continue;
                    defaultsElement.setDirty();
                }
            }
            if (stringArray.length == 0 || string.length() > 0) {
                db.info("Throwing " + string + " on " + this.getFullName());
                DefaultsManager.DefaultsManagerDebug.printStackTrace((Throwable)new Exception(string));
                throw new ProvisionError(this.getFullName() + ": " + string);
            }
        }
    }

    public void checkValue(String string) throws ProvisionError {
        String string2 = this.getValue();
        if (this.myClass == 0) {
            if (this.validEnumValues != null) {
                switch (this.validEnumValues.size()) {
                    case 2: {
                        this.checkStringEnum2(string);
                        break;
                    }
                    case 4: {
                        this.checkStringEnum4(string);
                        break;
                    }
                    case 6: {
                        this.checkStringEnum6(string);
                        break;
                    }
                    default: {
                        this.validateSupportedValue(string2, string);
                        break;
                    }
                }
            }
        } else if (this.myClass == 2 || this.myClass == 7 || this.myClass == 10 || this.myClass == 11 || this.myClass == 12) {
            ArrayList arrayList = this.getCurrentlyValidEnumValues();
            boolean bl = false;
            Object var5_5 = null;
            if (arrayList.get(0) instanceof String) {
                db.fine(this.getName() + ": Checking enumerated value as string...");
                if (arrayList.indexOf(string) > -1) {
                    this.validateSupportedValue(string2, string);
                    bl = true;
                } else if (this.checkIfSupported()) {
                    this.validateSupportedValue(string2, string);
                    bl = true;
                }
            } else {
                db.fine(this.getName() + ": Checking enumerated value as attribute...");
                Attribute attribute = this.toAttribute(string, arrayList);
                if (attribute != null) {
                    bl = true;
                }
            }
            if (!bl) {
                throw new ProvisionError(this.getFullName() + ": " + "\"" + string + "\" is not a valid value");
            }
        } else {
            db.info("Unedited class " + this.myClass);
        }
    }

    public void checkValue(String string, String string2) throws ProvisionError {
        if (this.myClass == 0) {
            if (this.validEnumValues != null) {
                switch (this.validEnumValues.size()) {
                    case 2: {
                        this.checkStringEnum2(string);
                        break;
                    }
                    case 4: {
                        this.checkStringEnum4(string);
                        break;
                    }
                    case 6: {
                        this.checkStringEnum6(string, string2);
                        break;
                    }
                    default: {
                        this.validateSupportedValue(null, string);
                        break;
                    }
                }
            }
        } else if (this.myClass == 2 || this.myClass == 7 || this.myClass == 10 || this.myClass == 11 || this.myClass == 12) {
            ArrayList arrayList = this.getCurrentlyValidEnumValues();
            boolean bl = false;
            Object var5_5 = null;
            if (arrayList.get(0) instanceof String) {
                db.fine(this.getName() + ": Checking enumerated value as string...");
                if (arrayList.indexOf(string) > -1) {
                    this.validateSupportedValue(null, string);
                    bl = true;
                } else if (this.checkIfSupported()) {
                    this.validateSupportedValue(null, string);
                    bl = true;
                }
            } else {
                db.fine(this.getName() + ": Checking enumerated value as attribute...");
                Attribute attribute = this.toAttribute(string, arrayList);
                if (attribute != null) {
                    bl = true;
                }
            }
            if (!bl) {
                throw new ProvisionError(this.getFullName() + ": " + "\"" + string + "\" is not a valid value");
            }
        } else {
            db.info("Unedited class " + this.myClass);
        }
    }

    public void validateSupportedValue(String string, String string2) throws ProvisionError {
        String string3 = null;
        boolean bl = true;
        if (this.checkIfSupported() && (string == null || !string.equals(string2))) {
            if (string2.equals("(NOT SUPPORTED)")) {
                string3 = "\"" + string2 + "\"" + "is not a valid value for this attribute";
                bl = false;
            } else if (string.equals("(NOT SUPPORTED)")) {
                string3 = "\"" + string2 + "\"" + "is not a supported value for this node";
                bl = false;
            }
        }
        if (!bl) {
            throw new ProvisionError(this.getFullName() + ": " + string3);
        }
    }

    public void checkValue() throws ProvisionError {
        this.checkValue(this.getValue());
        this.crossCheckValue();
    }

    public String getValue() {
        return this.presetValue == null || this.presetValue.length() == 0 ? this.myValue : this.presetValue;
    }

    public int getEnumValue() throws ProvisionError {
        int n = Integer.MIN_VALUE;
        Attribute attribute = this.toAttribute(this.myValue, this.getCurrentlyValidEnumValues());
        if (attribute == null) {
            throw new ProvisionError(this.getFullName() + ": \"" + this.myValue + "\" is not a valid value for " + this.getFullName());
        }
        n = attribute.getValue();
        return n;
    }

    public void setEnumValue(int n) throws ProvisionError {
        Attribute attribute = this.toAttribute(n, this.getCurrentlyValidEnumValues());
        if (attribute == null) {
            throw new ProvisionError(this.getFullName() + ": \"" + n + "\" is not a valid value");
        }
        this.setValue(attribute.getKey());
    }

    public void initEnumValue(int n) throws ProvisionError {
        Attribute attribute = this.toAttribute(n, this.getCurrentlyValidEnumValues());
        if (attribute == null) {
            if (db.isSevereEnabled()) {
                db.severe("Coding error: looking for " + n + " in " + this.validEnumValues.size());
                for (int i = 0; i < this.validEnumValues.size(); ++i) {
                    db.severe(i + ":" + this.validEnumValues.get(i));
                }
                db.severe("\"" + n + "\" is not a valid enumerated value for " + this.getFullName());
            }
            this.initValue("UNKNOWN (" + n + ")");
            this.setDirty();
        } else {
            this.initValue(attribute.getKey());
        }
    }

    public String getUnits() {
        return this.myUnits;
    }

    public int getDefElemClass() {
        return this.myClass;
    }

    public void clearValidEnumValues() {
        this.validEnumValues.clear();
    }

    public void setValidEnumValues(ArrayList arrayList) {
        this.validEnumValues = arrayList;
    }

    private boolean checkEnumValues(String string, ArrayList arrayList) {
        boolean bl = false;
        if (arrayList.get(0) instanceof String) {
            db.fine("Checking enumerated value as string...");
            if (arrayList.indexOf(string) > -1) {
                bl = true;
            }
        } else {
            db.fine("Checking enumerated value as attribute...");
            Attribute attribute = this.toAttribute(string, arrayList);
            if (attribute != null) {
                bl = true;
            }
        }
        return bl;
    }

    private ArrayList getEnumValuesForVariableNamedEnumMasterClass(ArrayList arrayList) {
        ArrayList arrayList2 = (ArrayList)arrayList.clone();
        arrayList2.remove(0);
        return arrayList2;
    }

    private ArrayList getEnumValuesForVariableNamedOrRangeEnumSlaveClass(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        String string = (String)arrayList.get(0);
        DefaultsElement defaultsElement = (DefaultsElement)this.getCousinElement(string);
        if (defaultsElement != null && defaultsElement.myClass == 10) {
            db.fine("Getting enumerated values for " + this.getName() + " based on master " + string + " value of " + defaultsElement.getValue());
            String string2 = defaultsElement.getValue();
            for (int i = 1; i < arrayList.size(); ++i) {
                ArrayList[] arrayListArray = (ArrayList[])arrayList.get(i);
                if (!this.checkEnumValues(string2, arrayListArray[0])) continue;
                arrayList2 = arrayListArray[1];
                break;
            }
        } else {
            db.severe("Variable named enum master " + string + " must exist as a sibling for slave " + this.getFullName() + " and be an enumeration");
        }
        db.fine("Got " + arrayList2.size() + " enumerated values for " + this.getName() + " based on " + string);
        return arrayList2;
    }

    private ArrayList getEnumValuesForVariableRangeEnumClass(ArrayList arrayList) {
        int n;
        IDefaultsElement iDefaultsElement;
        ArrayList arrayList2 = (ArrayList)arrayList.clone();
        String string = (String)arrayList2.get(0);
        String string2 = (String)arrayList2.get(1);
        int n2 = 2;
        int n3 = arrayList2.size() - 1;
        if (string != null && string != "" && (iDefaultsElement = this.getCousinElement(string)) != null && (n = arrayList2.indexOf(string = iDefaultsElement.getValue())) > -1) {
            n2 = n;
        }
        if (string2 != null && string2 != "" && (iDefaultsElement = this.getCousinElement(string2)) != null && (n = arrayList2.indexOf(string2 = iDefaultsElement.getValue())) > -1) {
            n3 = n;
        }
        int n4 = arrayList2.size();
        for (n = arrayList2.size() - 1; n > n3; --n) {
            arrayList2.remove(n);
        }
        for (n = n2 - 1; n > -1; --n) {
            arrayList2.remove(n);
        }
        return arrayList2;
    }

    private ArrayList getCurrentlyValidEnumValues() {
        ArrayList arrayList = this.validEnumValues;
        if (this.myClass == 7) {
            db.info(this.getName() + ": Variable range: getting currently valid");
            arrayList = this.getEnumValuesForVariableRangeEnumClass(this.validEnumValues);
        } else if (this.myClass == 10) {
            db.info(this.getName() + ": Variable named enum master: getting currently valid");
            arrayList = this.getEnumValuesForVariableNamedEnumMasterClass(this.validEnumValues);
        } else if (this.myClass == 11 || this.myClass == 12) {
            db.info(this.getName() + ": Variable named or range enum slave: " + "getting currently valid");
            arrayList = this.getEnumValuesForVariableNamedOrRangeEnumSlaveClass(this.validEnumValues);
        }
        return arrayList;
    }

    public Object[] getValidEnumValues() {
        return this.getCurrentlyValidEnumValues().toArray(new Object[0]);
    }

    public boolean hasIndependentValidity() {
        boolean bl = true;
        if (this.myClass == 0) {
            if (this.validEnumValues != null && this.validEnumValues.size() == 6) {
                bl = false;
            }
        } else if (this.myClass == 7 || this.myClass == 10 || this.myClass == 11 || this.myClass == 12) {
            bl = false;
        }
        return bl;
    }

    public void applyToNode() {
        this.dirty = false;
    }

    public String getFullName() {
        return this.name;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        int n = this.name.lastIndexOf(".");
        return this.name.substring(n + 1);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string == null ? "" : string;
    }

    public void makeClean() {
        this.dirty = false;
    }

    public boolean isDirty() {
        if (db.treatEverythingAsDirty()) {
            return true;
        }
        return super.isDirty();
    }
}

