/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.nedefaults;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.Attribute;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.CtcTimeZone;
import cerent.cms.model.CtcTimeZoneFactory;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.model.nedefaults.DefaultsElement;
import cerent.cms.model.nedefaults.DefaultsNode;
import cerent.cms.model.nedefaults.DefaultsTree;
import cerent.cms.model.nedefaults.IDefaultsElement;
import cerent.cms.model.nedefaults.IDefaultsNode;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.launcher.CmsClassLoader;
import cerent.util.BuildInfo;
import cerent.util.DetailedLog;
import cerent.util.KDebug;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import cerent.util.SortableProperties;
import cerent.util.TDMTerminology;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Properties;
import java.util.TreeMap;

public class DefaultsManager
extends Model {
    private static final String INV_VALUE = "Defaults with invalid values (";
    private static final String MISSING_DEFAULTS = "Missing defaults (";
    private static final String UNKNOWN_DEFAULTS = "Unknown defaults (";
    private static final String MY_DEBUG_KEY = "DefaultsManager";
    private NodeModelDelegate node;
    private IDefaultsNode rootNode = null;
    private static ModelSingletonCollection defaultsManagerSingletons;
    private DefaultsTree defaultsTree;
    private static final int ELEMENT_FULL_NAME = 0;
    private static final int ELEMENT_SIDE_EFFECTS = 1;
    private static final int ELEMENT_TYPE = 2;
    private static final int ELEMENT_UOM = 3;
    private static final int ELEMENT_VARIABLE_LENGTH_START = 4;
    private Map validationMap = null;
    private int nodesVisited;
    private int elementsVisited;

    public static synchronized DefaultsManager getInstance(NodeModelDelegate nodeModelDelegate) {
        DefaultsManager defaultsManager;
        if (defaultsManagerSingletons == null) {
            defaultsManagerSingletons = ModelSingletonCollection.getMSCInstanceByName(MY_DEBUG_KEY);
        }
        if ((defaultsManager = (DefaultsManager)defaultsManagerSingletons.get(nodeModelDelegate)) == null) {
            defaultsManager = new DefaultsManager(nodeModelDelegate);
            defaultsManagerSingletons.add(nodeModelDelegate, defaultsManager);
        }
        return defaultsManager;
    }

    private DefaultsManager(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.index = 0;
        this.node = nodeModelDelegate;
        this.db = new DefaultsManagerDebug(nodeModelDelegate.getDebug());
    }

    public NeDefaultsModel getNeDefaultsModel() {
        return this.defaultsTree.getNeDefaultsModel();
    }

    private String[] getLastLevel(String string) {
        if (string == "") {
            return null;
        }
        String[] stringArray = new String[2];
        int n = string.lastIndexOf(".");
        stringArray[0] = string.substring(n + 1);
        stringArray[1] = string.substring(0, n);
        this.db.fine("lastlevel:outstr0 = " + stringArray[0] + " outstr1 = " + stringArray[1]);
        return stringArray;
    }

    private String[] getFirstLevel(String string) {
        String[] stringArray = new String[2];
        if (string == null || string == "") {
            this.db.fine("firstlevel:anystring was null or empty");
            stringArray[0] = null;
            stringArray[1] = null;
        } else {
            int n = string.indexOf(".");
            if (n < 0) {
                this.db.fine("firstlevel:Hit End of Line....str = " + string);
                stringArray[0] = string;
                stringArray[1] = null;
            } else {
                stringArray[0] = string.substring(0, n);
                stringArray[1] = string.substring(n + 1);
                this.db.fine("firstlevel:outstr0 = " + stringArray[0] + " outstr1 = " + stringArray[1]);
            }
        }
        return stringArray;
    }

    private DefaultsNode childExistsAlready(DefaultsNode defaultsNode, String string) {
        DefaultsNode[] defaultsNodeArray = (DefaultsNode[])defaultsNode.getChildren();
        if (defaultsNodeArray == null) {
            this.db.fine("childExistsAlready:children == null");
            return null;
        }
        if (defaultsNodeArray.length == 0) {
            this.db.fine("childExistsAlready:children length == 0");
            return null;
        }
        for (int i = 0; i < defaultsNodeArray.length; ++i) {
            if (!defaultsNodeArray[i].getName().equals(string)) continue;
            this.db.fine("childExistsAlready:found child of name - " + string);
            return defaultsNodeArray[i];
        }
        this.db.info("childExistsAlready:didnt find child of name - " + string);
        return null;
    }

    private void makeElementPath(DefaultsNode defaultsNode, String string, DefaultsElement defaultsElement) {
        if (string == null) {
            this.db.fine("makeElementPath:end of line...added child " + defaultsElement.getName());
            defaultsNode.addChild(defaultsElement);
            defaultsElement.setParent(defaultsNode);
            return;
        }
        String[] stringArray = this.getFirstLevel(string);
        DefaultsNode defaultsNode2 = this.childExistsAlready(defaultsNode, stringArray[0]);
        if (defaultsNode2 == null) {
            defaultsNode2 = new DefaultsNode(stringArray[0]);
            this.db.fine("makeElementPath:created new child " + stringArray[0]);
            defaultsNode.addChild(defaultsNode2);
        }
        this.makeElementPath(defaultsNode2, stringArray[1], defaultsElement);
    }

    public String getDefaultValue(String string) throws NoSuchDefault {
        this.db.info("getDefaultValue(): " + string);
        if (string.equals("NODE.circuits.CreateLikeTL1")) {
            try {
                return "" + this.defaultsTree.getNeDefaultsModel().getTl1LikeCircuits();
            }
            catch (Exception exception) {
                this.db.severe("getDefaultValue(): " + exception.toString());
                throw new NoSuchDefault();
            }
        }
        if (string.equals("NODE.protection.blsr.RingReversionTime")) {
            try {
                return "" + this.defaultsTree.getNeDefaultsModel().getDefBlsrRingRev().reversionTime;
            }
            catch (Exception exception) {
                this.db.severe("getDefaultValue(): " + exception.toString());
                throw new NoSuchDefault();
            }
        }
        if (string.equals("NODE.protection.blsr.SpanReversionTime")) {
            try {
                return "" + this.defaultsTree.getNeDefaultsModel().getDefBlsrSpanRev().reversionTime;
            }
            catch (Exception exception) {
                this.db.severe("getDefaultValue(): " + exception.toString());
                throw new NoSuchDefault();
            }
        }
        if (string.equals("NODE.circuits.State")) {
            try {
                return "" + this.defaultsTree.getNeDefaultsModel().getDefaultCircuitAdminState().value();
            }
            catch (Exception exception) {
                this.db.severe("getDefaultValue(): " + exception.toString());
                throw new NoSuchDefault();
            }
        }
        if (string.equals("NODE.circuits.upsr.STS_SFBER")) {
            try {
                return "" + this.node.getUpsrSfBerLevel(2);
            }
            catch (Exception exception) {
                this.db.severe("getDefaultValue(): " + exception.toString());
                throw new NoSuchDefault();
            }
        }
        if (string.equals("NODE.circuits.upsr.STS_SDBER")) {
            try {
                return "" + this.node.getUpsrSdBerLevel(2);
            }
            catch (Exception exception) {
                this.db.severe("getDefaultValue(): " + exception.toString());
                throw new NoSuchDefault();
            }
        }
        if (string.equals("NODE.circuits.upsr.VT_SFBER")) {
            try {
                return "" + this.node.getUpsrSfBerLevel(1);
            }
            catch (Exception exception) {
                this.db.severe("getDefaultValue(): " + exception.toString());
                throw new NoSuchDefault();
            }
        }
        if (string.equals("NODE.circuits.upsr.VT_SDBER")) {
            try {
                return "" + this.node.getUpsrSdBerLevel(1);
            }
            catch (Exception exception) {
                this.db.severe("getDefaultValue(): " + exception.toString());
                throw new NoSuchDefault();
            }
        }
        if (string.equals("NODE.circuits.upsr.AllowUpsrOverOnePlusOne") || string.equals("NODE.circuits.sncp.AllowSncpOverOnePlusOne")) {
            try {
                return "" + this.defaultsTree.getNeDefaultsModel().allowUpsrOverOnePlusOne();
            }
            catch (Exception exception) {
                this.db.severe("getDefaultValue(): " + exception.toString());
                throw new NoSuchDefault();
            }
        }
        this.db.info("getClientDefaultValue(): client default: " + string);
        try {
            return this.defaultsTree.getNeDefaultsModel().getClientDefault(string);
        }
        catch (Exception exception) {
            this.db.severe("getDefaultValue(): " + exception.toString());
            throw new NoSuchDefault();
        }
    }

    private String getTimeNotation(int n) {
        int n2 = n / 60;
        int n3 = n % 60;
        String string = "";
        String string2 = "";
        string = n2 < 10 ? "0" + String.valueOf(n2) : String.valueOf(n2);
        string2 = n3 < 10 ? "0" + String.valueOf(n3) : String.valueOf(n3);
        return string + ":" + string2;
    }

    private int makeEnumValuesForEnumType(String[] stringArray, ArrayList arrayList) {
        int n = 2;
        String string = stringArray[4];
        String string2 = string + ": ";
        for (int i = 4; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
            string2 = string2 + " " + stringArray[i];
        }
        this.db.fine("ENUMLIST: " + string2);
        return n;
    }

    private int makeEnumValuesForRangeEnumType(int n, String[] stringArray, ArrayList arrayList) {
        int n2 = 2;
        int n3 = Integer.parseInt(stringArray[n]);
        int n4 = Integer.parseInt(stringArray[n + 1]);
        int n5 = Integer.parseInt(stringArray[n + 2]);
        int n6 = Integer.parseInt(stringArray[n + 3]);
        for (int i = n3; i <= n4; i += n5) {
            if (n6 == 1) {
                arrayList.add(String.valueOf(i));
                continue;
            }
            arrayList.add(String.valueOf((float)i / (float)n6));
        }
        return n2;
    }

    private int makeEnumValuesForVariableRangeEnumType(String[] stringArray, ArrayList arrayList) {
        int n = 7;
        int n2 = Integer.parseInt(stringArray[4]);
        int n3 = Integer.parseInt(stringArray[5]);
        int n4 = Integer.parseInt(stringArray[6]);
        int n5 = Integer.parseInt(stringArray[7]);
        arrayList.add(stringArray[8]);
        arrayList.add(stringArray[9]);
        for (int i = n2; i <= n3; i += n4) {
            arrayList.add(String.valueOf((float)i / (float)n5));
        }
        return n;
    }

    private int makeEnumValuesForTimeRangeEnumType(String[] stringArray, ArrayList arrayList) {
        int n = 2;
        int n2 = Integer.parseInt(stringArray[4]);
        int n3 = Integer.parseInt(stringArray[5]);
        int n4 = Integer.parseInt(stringArray[6]);
        for (int i = n2; i <= n3; i += n4) {
            arrayList.add(this.getTimeNotation(i));
        }
        return n;
    }

    private int makeEnumValuesForTimeZoneEnumType(String[] stringArray, ArrayList arrayList) {
        int n = 2;
        CtcTimeZoneFactory ctcTimeZoneFactory = this.node.getCtcTimeZoneFactory();
        for (int i = 0; i < ctcTimeZoneFactory.getNumberofTimeZones(); ++i) {
            CtcTimeZone ctcTimeZone = ctcTimeZoneFactory.getCtcTimeZone(i);
            arrayList.add(ctcTimeZone.toString());
        }
        return n;
    }

    private void getEnumValues(String string, ArrayList arrayList) {
        Attribute[] attributeArray = ElementDefaults.getAttributeMap(this.node).getAttributeArray(string);
        String string2 = string + ": ";
        for (int i = 0; i < attributeArray.length; ++i) {
            arrayList.add(attributeArray[i]);
            string2 = string2 + " " + attributeArray[i].toString();
        }
        this.db.fine("NAMED ENUMLIST: " + string2);
    }

    private int makeEnumValuesForNamedEnumType(String[] stringArray, ArrayList arrayList) {
        int n = 2;
        this.getEnumValues(stringArray[4], arrayList);
        return n;
    }

    private int makeEnumValuesForVariableRangeType(String[] stringArray, ArrayList arrayList) {
        int n = 0;
        int n2 = stringArray.length - 4;
        if (n2 != 4 && n2 != 6) {
            this.db.severe("expected 2 ranges, optionally a step and divisor (for floats): 2 override fields (one probably empty), got " + n2 + " elements!");
        }
        for (int i = 4; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return n;
    }

    private int makeEnumValuesForVariableNamedEnumMasterType(Object[] objectArray, ArrayList arrayList) {
        int n = 10;
        arrayList.add(objectArray[4]);
        String[] stringArray = new String[objectArray.length - 1];
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (i == 4) continue;
            stringArray[n2++] = (String)objectArray[i];
        }
        this.makeEnumValuesForNamedEnumType(stringArray, arrayList);
        return n;
    }

    private int makeEnumValuesForVariableNamedEnumSlaveType(String[] stringArray, ArrayList arrayList) {
        int n = 11;
        String string = stringArray[4];
        arrayList.add(string);
        for (int i = 5; i < stringArray.length; i += 2) {
            String string2 = stringArray[i];
            String string3 = stringArray[i + 1];
            ArrayList[] arrayListArray = new ArrayList[]{new ArrayList(), new ArrayList()};
            this.getEnumValues(string2, arrayListArray[0]);
            this.getEnumValues(string3, arrayListArray[1]);
            arrayList.add(arrayListArray);
        }
        return n;
    }

    private int makeEnumValuesForVariableRangeEnumSlaveType(String[] stringArray, ArrayList arrayList) {
        int n = 12;
        String string = stringArray[4];
        arrayList.add(string);
        for (int i = 5; i < stringArray.length; i += 5) {
            String string2 = stringArray[i];
            int n2 = i + 1;
            ArrayList[] arrayListArray = new ArrayList[]{new ArrayList(), new ArrayList()};
            this.getEnumValues(string2, arrayListArray[0]);
            this.makeEnumValuesForRangeEnumType(n2, stringArray, arrayListArray[1]);
            arrayList.add(arrayListArray);
        }
        return n;
    }

    private void makeTreeWithInfo(DefaultsNode defaultsNode, Object[] objectArray) {
        int n;
        String[] stringArray = this.getLastLevel((String)objectArray[0]);
        this.db.info("ElementName[0] = " + stringArray[0] + " ElementName[1] = " + stringArray[1]);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        int n3 = 0;
        try {
            n3 = Integer.parseInt((String)objectArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            this.db.severe("ElementName[0] = " + stringArray[0] + " ElementName[1] = " + stringArray[1] + " Bad Element Type " + (String)objectArray[2]);
        }
        String[] stringArray2 = null;
        if (n3 != 10) {
            stringArray2 = new String[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                stringArray2[n] = (String)objectArray[n];
            }
        }
        switch (n3) {
            case 2: {
                n2 = this.makeEnumValuesForEnumType(stringArray2, arrayList);
                break;
            }
            case 3: {
                n2 = this.makeEnumValuesForRangeEnumType(4, stringArray2, arrayList);
                break;
            }
            case 7: {
                n2 = this.makeEnumValuesForVariableRangeEnumType(stringArray2, arrayList);
                break;
            }
            case 4: {
                n2 = this.makeEnumValuesForTimeRangeEnumType(stringArray2, arrayList);
                break;
            }
            case 6: {
                n2 = this.makeEnumValuesForTimeZoneEnumType(stringArray2, arrayList);
                break;
            }
            case 9: {
                n2 = this.makeEnumValuesForNamedEnumType(stringArray2, arrayList);
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 5: {
                n2 = 5;
                break;
            }
            case 8: {
                n2 = this.makeEnumValuesForVariableRangeType(stringArray2, arrayList);
                break;
            }
            case 10: {
                n2 = this.makeEnumValuesForVariableNamedEnumMasterType(objectArray, arrayList);
                break;
            }
            case 11: {
                n2 = this.makeEnumValuesForVariableNamedEnumSlaveType(stringArray2, arrayList);
                break;
            }
            case 12: {
                n2 = this.makeEnumValuesForVariableRangeEnumSlaveType(stringArray2, arrayList);
                break;
            }
            default: {
                if (objectArray[2].equals(IDefaultsElement.S_STRING)) {
                    this.db.info("String (Default Handling) " + stringArray[1] + "." + stringArray[0] + " type " + objectArray[2]);
                }
                if (objectArray[4] == "") break;
                arrayList.add(objectArray[4]);
                arrayList.add(objectArray[5]);
            }
        }
        if (this.db.isFineEnabled() && arrayList != null) {
            String string = objectArray[0] + " has " + arrayList.size() + " enum values";
            if (arrayList.size() > 1000) {
                this.db.info(string);
            } else {
                this.db.fine(string);
            }
        }
        n = 0;
        if (!objectArray[1].equals("FALSE")) {
            n = objectArray[1].equals("TRUE") ? 1 : Integer.parseInt((String)objectArray[1]);
        }
        DefaultsElement defaultsElement = new DefaultsElement((String)objectArray[0], null, "", (String)objectArray[3], n2, arrayList, n, (DefaultsManagerDebug)this.db);
        this.makeElementPath(defaultsNode, stringArray[1], defaultsElement);
    }

    private void helpGetDefaultsTree(DefaultsNode defaultsNode, Object[][] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.db.fine("=======================================loop" + i);
            this.makeTreeWithInfo(defaultsNode, objectArray[i]);
        }
    }

    public void setResQuality(String string) {
        String[] stringArray = new String[]{"PRS<RES", "STU<RES<PRS", "ST2<RES<STU", "ST3<RES<ST2", "SMC<RES<ST3", "ST4<RES<SMC", "RES<ST4", "RES=DUS"};
        String[] stringArray2 = new String[]{"PRS<RES", "STU<RES<PRS", "ST2<RES<STU", "TNC<RES<ST2", "ST3E<RES<TNC", "ST3<RES<ST3E", "SMC<RES<ST3", "ST4<RES<SMC", "RES<ST4", "RES=DUS"};
        ArrayList<String> arrayList = new ArrayList<String>();
        IDefaultsElement iDefaultsElement = this.getElement(this.rootNode, "NODE.timing.general.QualityOfRES");
        if (iDefaultsElement == null) {
            return;
        }
        iDefaultsElement.clearValidEnumValues();
        if (string.indexOf(50) > 0) {
            for (int i = 0; i < stringArray2.length; ++i) {
                arrayList.add(stringArray2[i]);
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        iDefaultsElement.setValidEnumValues(arrayList);
    }

    public IDefaultsNode getDefaultsTree() throws Exception {
        Object[][] objectArray;
        DefaultsNode defaultsNode = new DefaultsNode(this.node.getName());
        Object[] objectArray2 = this.node.getPlatform().getListOfDefaultsLists();
        this.db.info("listOfDefaultsLists.length = " + objectArray2.length);
        for (int i = 0; i < objectArray2.length; ++i) {
            if (objectArray2[i] != null) {
                objectArray = (Object[][])objectArray2[i];
                this.db.info("defaultsList.length = " + objectArray.length + " first item:" + objectArray[0][0].toString());
                this.helpGetDefaultsTree(defaultsNode, objectArray);
                continue;
            }
            this.db.severe("Null pointer at " + i);
        }
        this.defaultsTree.resetFromNode(defaultsNode);
        this.rootNode = defaultsNode;
        IDefaultsElement iDefaultsElement = this.getElement(defaultsNode, "NODE.timing.general.SSMMessageSet");
        if (iDefaultsElement != null) {
            objectArray = iDefaultsElement.getValue();
            this.setResQuality((String)objectArray);
        }
        return defaultsNode;
    }

    public IDefaultsElement getElement(IDefaultsNode iDefaultsNode, String string) {
        String string2;
        int n = string.indexOf(46);
        if (n < 0) {
            string2 = string;
            string = null;
        } else {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        IDefaultsNode iDefaultsNode2 = null;
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsNode iDefaultsNode3 = iDefaultsNodeArray[i];
            if (!iDefaultsNode3.getName().equals(string2)) continue;
            iDefaultsNode2 = iDefaultsNode3;
            break;
        }
        if (iDefaultsNode2 == null) {
            return null;
        }
        if (string != null) {
            return this.getElement(iDefaultsNode2, string);
        }
        if (iDefaultsNode2 instanceof IDefaultsElement) {
            return (IDefaultsElement)iDefaultsNode2;
        }
        return null;
    }

    private DefaultsNode makeValidationTree(eEqType eEqType2) {
        DefaultsNode defaultsNode = null;
        Object[][] objectArray = null;
        String string = this.defaultsTree.getNameFromEqType(eEqType2);
        if (string != "") {
            objectArray = this.node.getPlatform().getDefaultsList(string);
            if (objectArray != null) {
                defaultsNode = new DefaultsNode(string);
                this.helpGetDefaultsTree(defaultsNode, objectArray);
            } else {
                this.db.info("No tree for " + string);
            }
        }
        return defaultsNode;
    }

    private String getFullPath(eEqType eEqType2, DefaultsNode defaultsNode, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (eEqType.CTX_CARD.equals(eEqType2)) {
            stringBuffer.append("CTX.");
        }
        stringBuffer.append(defaultsNode.getName());
        stringBuffer.append('.');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private DefaultsNode getRoot(eEqType eEqType2) {
        DefaultsNode defaultsNode;
        Integer n = new Integer(eEqType2.value());
        if (this.validationMap == null) {
            this.validationMap = new TreeMap();
        }
        if ((defaultsNode = (DefaultsNode)this.validationMap.get(n)) == null && (defaultsNode = this.makeValidationTree(eEqType2)) != null) {
            this.validationMap.put(n, defaultsNode);
        }
        return defaultsNode;
    }

    private String toString(eEqType eEqType2) {
        return eEqType2 == null ? "null" : Integer.toString(eEqType2.value());
    }

    public void validate(eEqType eEqType2, String string, String string2) throws ProvisionError {
        this.validate(eEqType2, null, string, string2);
    }

    private IDefaultsElement getElement(eEqType eEqType2, eEqType eEqType3, String string) {
        IDefaultsElement iDefaultsElement = null;
        DefaultsNode defaultsNode = eEqType.CTX_CARD.equals(eEqType2) ? this.getRoot(eEqType3) : this.getRoot(eEqType2);
        if (defaultsNode == null) {
            this.db.info("No validation exists");
        } else {
            String string2 = this.getFullPath(eEqType2, defaultsNode, string);
            iDefaultsElement = this.getElement(defaultsNode, string2);
            if (iDefaultsElement == null) {
                this.db.severe("Invalid validation attempt: fullPath=" + string2);
            }
        }
        return iDefaultsElement;
    }

    public void validate(eEqType eEqType2, eEqType eEqType3, String string, String string2) throws ProvisionError {
        IDefaultsElement iDefaultsElement = this.getElement(eEqType2, eEqType3, string);
        this.db.info("Validating module=" + this.toString(eEqType2) + " port=" + this.toString(eEqType3) + " path=" + string + " value=" + string2);
        if (iDefaultsElement != null) {
            iDefaultsElement.checkValue(string2);
        }
    }

    public void validate(eEqType eEqType2, eEqType eEqType3, String string, String string2, String string3) throws ProvisionError {
        IDefaultsElement iDefaultsElement = this.getElement(eEqType2, eEqType3, string);
        this.db.info("Validating module=" + this.toString(eEqType2) + " port=" + this.toString(eEqType3) + " path=" + string + " value=" + string2 + " cousinValue=" + string3);
        if (iDefaultsElement != null) {
            iDefaultsElement.checkValue(string2, string3);
        }
    }

    public void analyzeTree(DefaultsNode defaultsNode) {
        IDefaultsNode[] iDefaultsNodeArray;
        if (defaultsNode == null) {
            this.db.severe("Error!! defNode == null");
        }
        if ((iDefaultsNodeArray = defaultsNode.getChildren()) == null || iDefaultsNodeArray.length == 0) {
            this.db.severe(((DefaultsElement)defaultsNode).getFullName() + " -> " + ((DefaultsElement)defaultsNode).getValue());
        }
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            this.analyzeTree((DefaultsNode)iDefaultsNodeArray[i]);
        }
    }

    public boolean doChangesCauseReboot(IDefaultsNode iDefaultsNode) {
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            String string = iDefaultsNodeArray[i].getName();
            if (!string.equals("NODE")) continue;
            IDefaultsNode[] iDefaultsNodeArray2 = iDefaultsNodeArray[i].getChildren();
            for (int j = 0; j < iDefaultsNodeArray2.length; ++j) {
                String string2 = iDefaultsNodeArray2[j].getName();
                if (!string2.equals("general")) continue;
                IDefaultsNode[] iDefaultsNodeArray3 = iDefaultsNodeArray2[j].getChildren();
                for (int k = 0; k < iDefaultsNodeArray3.length; ++k) {
                    String string3 = iDefaultsNodeArray3[k].getName();
                    if (!string3.equals("IIOPListenerPort")) continue;
                    IDefaultsElement iDefaultsElement = (IDefaultsElement)iDefaultsNodeArray3[k];
                    return iDefaultsElement.isDirty();
                }
            }
        }
        return false;
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    public void updateLocal() {
        super.updateLocal();
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 0: {
                    this.db.info(this.getClass().getName() + "::update():    this DELETED");
                    this.delete();
                    break;
                }
                case 1: {
                    this.db.info(this.getClass().getName() + " update():    thisCHANGED");
                    this.setChanged();
                    this.updateLocal();
                    break;
                }
                case 2: {
                    this.db.info(this.getClass().getName() + " update():    STRUCTURE CHANGED");
                    break;
                }
                default: {
                    this.db.info(this.getClass().getName() + "update():    " + "UNKNOWN NE UPDATE TYPE" + n);
                }
            }
        }
    }

    public void init() {
        this.db.info("Initing DefaultsManager " + this.toString());
        super.init0();
        HashMap[] hashMapArray = (HashMap[])this.node.getPlatform().getEqTypeNameMapsForDefaults();
        HashMap hashMap = hashMapArray[0];
        HashMap hashMap2 = hashMapArray[1];
        this.defaultsTree = new DefaultsTree(this.node, hashMap, hashMap2, this.db);
    }

    public void delete() {
        this.db.info("Deleting DefaultsManager " + this.toString());
        this.dispose();
    }

    public void destroy() {
        this.db.info("Destroying DefaultsManager " + this.toString());
        super.destroy();
    }

    public void dispose() {
        this.db.info("Disposing DefaultsManager " + this.toString());
        super.dispose();
        this.defaultsTree = null;
    }

    public boolean importDefaults(String string) throws CTCUserException {
        IDefaultsNode iDefaultsNode = null;
        File file = new File(string);
        try {
            iDefaultsNode = this.getDefaultsTree();
        }
        catch (Exception exception) {
            throw new CTCUserException("Cannot load defaults from NE " + file.getAbsolutePath() + ":" + exception.getMessage(), (Throwable)exception);
        }
        if (this.importDefaults(file, iDefaultsNode, null)) {
            this.db.info("Committing...");
            try {
                this.defaultsTree.applyToNode(iDefaultsNode);
            }
            catch (Exception exception) {
                throw new CTCUserException("Cannot apply defaults file " + file.getAbsolutePath() + ":" + exception.getMessage(), (Throwable)exception);
            }
        } else {
            return false;
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean importDefaults(File file, IDefaultsNode iDefaultsNode, IValidity iValidity) throws CTCUserException {
        HashMap hashMap;
        Properties properties;
        FileInputStream fileInputStream;
        block22: {
            this.db.info("Importing defaults...");
            if (file == null) {
                this.db.severe("No file argument passed in");
                return false;
            }
            if (iDefaultsNode == null) {
                this.db.severe("No droot argument passed in");
                return false;
            }
            fileInputStream = null;
            properties = new Properties();
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            hashMap = new HashMap();
            DetailedLog detailedLog = this.parseProperties(properties, iDefaultsNode, hashMap);
            if (detailedLog == null) break block22;
            if (iValidity == null) {
                Iterator iterator = hashMap.values().iterator();
                while (iterator.hasNext()) {
                    IDefaultsElement iDefaultsElement = (IDefaultsElement)iterator.next();
                    if (iDefaultsElement.checkIfSupported() && this.node.supportsSecureMode()) continue;
                    iDefaultsElement.presetValue(null);
                }
                throw new CTCUserException(DefaultsManager.getWarningsText(detailedLog));
            }
            if (!iValidity.doCancel(hashMap.size(), detailedLog)) break block22;
            this.db.info("User canceled import...clearing presets");
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                IDefaultsElement iDefaultsElement = (IDefaultsElement)iterator.next();
                iDefaultsElement.presetValue(null);
            }
            boolean bl = true;
            Object var14_18 = null;
            if (fileInputStream == null) return bl;
            try {
                fileInputStream.close();
                return bl;
            }
            catch (Exception exception) {
                this.db.severe("cannot close " + fileInputStream);
            }
            return bl;
        }
        this.db.info(hashMap.size() + " valid elements to set ...");
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = properties.getProperty(string);
            IDefaultsElement iDefaultsElement = (IDefaultsElement)hashMap.get(string);
            if (iDefaultsElement.checkIfSupported()) {
                if (this.node.supportsSecureMode()) {
                    iDefaultsElement.setSupported(true);
                } else {
                    string2 = "(NOT SUPPORTED)";
                }
            }
            try {
                iDefaultsElement.setValue(string2);
            }
            catch (ProvisionError provisionError) {
                this.db.severe("Pre-edited value failed subsequent edit: " + (Object)((Object)provisionError));
            }
        }
        Object var14_19 = null;
        if (fileInputStream == null) return true;
        try {
            fileInputStream.close();
            return true;
        }
        catch (Exception exception) {
            this.db.severe("cannot close " + fileInputStream);
        }
        return true;
        {
            catch (IOException iOException) {
                throw new CTCUserException("Cannot load defaults file " + file.getAbsolutePath() + ":" + iOException.getMessage(), (Throwable)iOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CTCUserException("Cannot load defaults file " + file.getAbsolutePath() + ": this file might not be a valid defaults file;" + illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            }
            catch (Exception exception) {
                throw new CTCUserException("Cannot load defaults file:" + exception.getMessage(), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var14_20 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                this.db.severe("cannot close " + fileInputStream);
            }
            throw throwable;
        }
    }

    protected static String getWarningsText(DetailedLog detailedLog) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = detailedLog.getChildren().iterator();
        while (iterator.hasNext()) {
            DetailedLog detailedLog2 = (DetailedLog)iterator.next();
            String string = detailedLog2.getDesc();
            if (string.startsWith(INV_VALUE)) {
                string = "";
            } else {
                int n = string.indexOf("s (");
                if (n > 0) {
                    string = string.substring(0, n) + ":";
                }
            }
            Iterator iterator2 = detailedLog2.getChildren().iterator();
            while (iterator2.hasNext()) {
                DetailedLog detailedLog3 = (DetailedLog)iterator2.next();
                if (!bl) {
                    stringBuffer.append("; ");
                }
                stringBuffer.append(string);
                stringBuffer.append(detailedLog3.getDesc());
                bl = false;
            }
        }
        return stringBuffer.toString();
    }

    private DetailedLog parseProperties(Properties properties, IDefaultsNode iDefaultsNode, HashMap hashMap) {
        String string;
        Object object;
        String string2;
        Iterator iterator;
        DetailedLog detailedLog = new DetailedLog(3);
        DetailedLog detailedLog2 = new DetailedLog(2);
        ArrayList arrayList = new ArrayList();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            iterator = (String)enumeration.nextElement();
            string2 = properties.getProperty((String)((Object)iterator));
            object = this.getElement(iDefaultsNode, (String)((Object)iterator));
            if (object == null) {
                detailedLog2.addChild(new DetailedLog((String)((Object)iterator)));
                continue;
            }
            if (object.hasIndependentValidity()) {
                try {
                    object.checkValue(string2);
                    object.presetValue(string2);
                    hashMap.put(iterator, object);
                }
                catch (ProvisionError provisionError) {
                    this.db.severe("Bypassing invalid element " + (String)((Object)iterator) + " with value " + string2 + ": " + (Object)((Object)provisionError));
                    detailedLog.addChild(new DetailedLog(provisionError.getMessage()));
                }
                continue;
            }
            this.db.fine((String)((Object)iterator) + " is of uncertain validity");
            object.presetValue(string2);
            arrayList.add(iterator);
            hashMap.put(iterator, object);
        }
        this.db.info("Uncertain validity list has " + arrayList.size() + " elements");
        int n = 1;
        this.db.info("Processing elements of uncertain validity...");
        while (n > 0) {
            n = 0;
            this.db.info("loop...");
            iterator = arrayList.iterator();
            while (n == 0 && iterator.hasNext()) {
                string2 = (String)iterator.next();
                object = (IDefaultsElement)hashMap.get(string2);
                try {
                    object.checkValue();
                }
                catch (ProvisionError provisionError) {
                    this.db.fine("Removing invalid element " + string2 + " from uncertain validity list: " + (Object)((Object)provisionError));
                    ++n;
                    iterator.remove();
                    hashMap.remove(string2);
                    detailedLog.addChild(new DetailedLog(provisionError.getMessage()));
                }
            }
        }
        this.db.info("Processing missing elements");
        iterator = new TreeMap();
        this.fillMap((Map)((Object)iterator), iDefaultsNode);
        string2 = new DetailedLog(2);
        object = ((TreeMap)((Object)iterator)).keySet().iterator();
        while (object.hasNext()) {
            string = (String)object.next();
            if (properties.containsKey(string)) continue;
            string2.addChild(new DetailedLog(string));
        }
        int n2 = string2.getChildCount() + detailedLog.getChildCount() + detailedLog2.getChildCount();
        if (n2 == 0) {
            return null;
        }
        string = new DetailedLog("Found " + n2 + " error(s)/warning(s)");
        this.addChildDl((DetailedLog)string, detailedLog, INV_VALUE);
        this.addChildDl((DetailedLog)string, (DetailedLog)string2, MISSING_DEFAULTS);
        this.addChildDl((DetailedLog)string, detailedLog2, UNKNOWN_DEFAULTS);
        return string;
    }

    private void addChildDl(DetailedLog detailedLog, DetailedLog detailedLog2, String string) {
        int n = detailedLog2.getChildCount();
        if (n > 0) {
            detailedLog2.setDesc(string + n + PluralisationUtil.s(" item", n) + ")");
            detailedLog.addChild(detailedLog2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exportDefaults(String string) throws CTCUserException {
        boolean bl;
        File file = new File(string);
        FileOutputStream fileOutputStream = null;
        try {
            try {
                Properties properties = this.getDefaultsProperties();
                ClassLoader classLoader = this.getClass().getClassLoader();
                String string2 = "unknown";
                if (classLoader instanceof CmsClassLoader) {
                    string2 = BuildInfo.sanitize(((CmsClassLoader)classLoader).getSwVersion());
                }
                String string3 = "unknown";
                try {
                    string3 = BuildInfo.sanitize(this.node.getSwVersion());
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                String string4 = " NE Defaults from build=" + string3;
                string4 = string4 + "\n# ELE build=" + string2 + "\n#";
                try {
                    fileOutputStream = new FileOutputStream(file);
                    properties.store(fileOutputStream, string4);
                    bl = true;
                }
                catch (Exception exception) {
                    throw new CTCUserException("Cannot save defaults to file " + file.getAbsolutePath() + ":" + exception.getMessage(), (Throwable)exception);
                }
                Object var11_13 = null;
                if (fileOutputStream == null) return bl;
            }
            catch (Exception exception2) {
                throw new CTCUserException("Cannot load default properties from the node:" + exception2.getMessage(), (Throwable)exception2);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (Exception exception3) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return bl;
        }
        fileOutputStream.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exportDefaultsUnits(String string) throws CTCUserException {
        boolean bl;
        File file = new File(string);
        FileOutputStream fileOutputStream = null;
        try {
            try {
                Properties properties = this.getDefaultsUnits();
                ClassLoader classLoader = this.getClass().getClassLoader();
                String string2 = "unknown";
                if (classLoader instanceof CmsClassLoader) {
                    string2 = BuildInfo.sanitize(((CmsClassLoader)classLoader).getSwVersion());
                }
                String string3 = "NE Defaults units from build=" + string2;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    properties.store(fileOutputStream, string3);
                    bl = true;
                }
                catch (Exception exception) {
                    throw new CTCUserException("Cannot save defaults to file " + file.getAbsolutePath() + ":" + exception.getMessage(), (Throwable)exception);
                }
                Object var10_11 = null;
                if (fileOutputStream == null) return bl;
            }
            catch (Exception exception2) {
                throw new CTCUserException("Cannot load default properties from the node:" + exception2.getMessage(), (Throwable)exception2);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (Exception exception3) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return bl;
        }
        fileOutputStream.close();
        return bl;
    }

    private Properties getDefaultsProperties() throws Exception {
        SortableProperties sortableProperties = new SortableProperties(new Properties());
        HashMap hashMap = new HashMap();
        this.fillMap(hashMap, this.getDefaultsTree());
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            IDefaultsElement iDefaultsElement = (IDefaultsElement)hashMap.get(string);
            sortableProperties.setProperty(string, iDefaultsElement.getValue());
        }
        sortableProperties.setSortedKeys(true);
        return sortableProperties;
    }

    private Properties getDefaultsUnits() throws Exception {
        SortableProperties sortableProperties = new SortableProperties(new Properties());
        HashMap hashMap = new HashMap();
        this.fillMap(hashMap, this.getDefaultsTree());
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = string + ".units";
            IDefaultsElement iDefaultsElement = (IDefaultsElement)hashMap.get(string);
            if (iDefaultsElement.getUnits() == null || iDefaultsElement.getUnits().equals("")) {
                this.db.fine("key : " + string + " value : " + iDefaultsElement);
                sortableProperties.setProperty(string2, "undefined");
                continue;
            }
            sortableProperties.setProperty(string2, iDefaultsElement.getUnits());
        }
        sortableProperties.setSortedKeys(true);
        return sortableProperties;
    }

    private void fillMap(Map map, IDefaultsNode iDefaultsNode) {
        IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
        for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
            IDefaultsNode iDefaultsNode2 = iDefaultsNodeArray[i];
            if (iDefaultsNode2 instanceof IDefaultsElement) {
                map.put(((IDefaultsElement)iDefaultsNode2).getFullName(), iDefaultsNode2);
                continue;
            }
            this.fillMap(map, iDefaultsNode2);
        }
    }

    private void validateDirty(IDefaultsNode iDefaultsNode) throws Exception {
        if (iDefaultsNode.isDirty()) {
            if (iDefaultsNode instanceof IDefaultsElement) {
                ++this.elementsVisited;
                ((IDefaultsElement)iDefaultsNode).checkValue();
            } else {
                ++this.nodesVisited;
                IDefaultsNode[] iDefaultsNodeArray = iDefaultsNode.getChildren();
                for (int i = 0; i < iDefaultsNodeArray.length; ++i) {
                    this.validateDirty(iDefaultsNodeArray[i]);
                }
            }
        }
    }

    public void applyToNode(IDefaultsNode iDefaultsNode) throws Exception {
        this.nodesVisited = 0;
        this.elementsVisited = 0;
        this.validateDirty(iDefaultsNode);
        this.db.info("NodesVisited " + this.nodesVisited + " Elements visited " + this.elementsVisited);
        this.defaultsTree.applyToNode(iDefaultsNode);
    }

    public void setPassword(String string) {
        this.defaultsTree.setPassword(string);
    }

    public class DefaultsManagerDebug
    extends SDebug {
        private boolean treatEverythingAsDirty = false;

        DefaultsManagerDebug(KDebug kDebug) {
            super(kDebug, DefaultsManager.MY_DEBUG_KEY);
        }

        public final void getTree() {
            try {
                DefaultsManager.this.getDefaultsTree();
            }
            catch (Exception exception) {
                DefaultsManager.this.db.severe(exception.toString());
            }
        }

        public final void setTree() {
            try {
                DefaultsManager.this.defaultsTree.applyToNode(DefaultsManager.this.rootNode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public final void toggleTreatEverythingAsDirty() {
            this.treatEverythingAsDirty = !this.treatEverythingAsDirty;
        }

        public final boolean treatEverythingAsDirty() {
            return this.treatEverythingAsDirty;
        }

        public final void printEqTypeNames() {
            if (DefaultsManager.this.node != null) {
                TDMTerminology tDMTerminology = DefaultsManager.this.node.getTDMTerminology();
                EqTypeHelper.printEqTypeNames((KDebug)this, (TDMTerminology)tDMTerminology);
            }
        }
    }

    public static interface IValidity {
        public boolean doCancel(int var1, DetailedLog var2);
    }
}

