/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.nedefaults;

import cerent.cms.model.nedefaults.IDefaultsNode;
import java.util.ArrayList;
import java.util.Iterator;

public class DefaultsNode
implements IDefaultsNode {
    protected boolean dirty = false;
    protected String name = null;
    private DefaultsNode parent = null;
    private ArrayList children = null;

    public DefaultsNode(String string) {
        this.name = string;
        this.parent = null;
        this.children = null;
    }

    public DefaultsNode(String string, DefaultsNode defaultsNode) {
        this.name = string;
        this.parent = defaultsNode;
        this.children = null;
    }

    public DefaultsNode(String string, DefaultsNode defaultsNode, ArrayList arrayList) {
        this.name = string;
        this.parent = defaultsNode;
        this.children = arrayList;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        if (this.parent == null) {
            return this.name;
        }
        if (this.parent.getParent() == null) {
            return this.name;
        }
        return this.parent.getFullName() + "." + this.name;
    }

    public IDefaultsNode getParent() {
        return this.parent;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty() {
        if (!this.dirty) {
            this.dirty = true;
            if (this.parent != null) {
                this.parent.setDirty();
            }
        }
    }

    public void resetDirty() {
        if (this.dirty) {
            this.dirty = false;
            if (this.children != null) {
                for (int i = 0; i < this.children.size(); ++i) {
                    ((IDefaultsNode)this.children.get(i)).resetDirty();
                }
            }
        }
    }

    protected void recalcDirty() {
        this.dirty = false;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                if (!((IDefaultsNode)this.children.get(i)).isDirty()) continue;
                this.setDirty();
            }
        }
        if (this.parent != null && !this.dirty) {
            this.parent.recalcDirty();
        }
    }

    public void setParent(IDefaultsNode iDefaultsNode) {
        this.parent = (DefaultsNode)iDefaultsNode;
    }

    protected IDefaultsNode getChild(String string) {
        IDefaultsNode iDefaultsNode = null;
        if (this.children != null) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                IDefaultsNode iDefaultsNode2 = (IDefaultsNode)iterator.next();
                if (!iDefaultsNode2.getName().equals(string)) continue;
                iDefaultsNode = iDefaultsNode2;
                break;
            }
        }
        return iDefaultsNode;
    }

    public IDefaultsNode[] getChildren() {
        if (this.children == null) {
            return new DefaultsNode[0];
        }
        return this.children.toArray(new DefaultsNode[0]);
    }

    public void addChild(IDefaultsNode iDefaultsNode) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(iDefaultsNode);
        iDefaultsNode.setParent(this);
    }
}

