/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.persistence;

import cerent.cms.model.CTCUserException;
import cerent.cms.model.IStateBatchInfo;
import cerent.cms.model.StateBatchInfo;
import cerent.cms.model.persistence.Bar;
import cerent.cms.model.persistence.ContextFactory;
import cerent.cms.model.persistence.IContextFactory;
import cerent.cms.model.persistence.StateDAO;
import cerent.util.id.INetwideModelIdentity;
import cerent.util.id.INetwideModelTypeIdentity;
import cerent.util.id.INetwideNodeIdentity;
import cerent.util.id.ModelIdentityFactory;
import cerent.util.id.NetwideModelIdentity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class PersistenceTest
extends Bar
implements Serializable {
    private String s1;
    private int i1;
    private int[] ia1;
    private String s2;
    private ArrayList l1;
    private HashMap h1;
    private transient int t1;
    static int I1;

    public PersistenceTest(String string, String string2, String string3, int n, int[] nArray, String string4, ArrayList arrayList, HashMap hashMap, int n2) {
        super(string, string2);
        this.s1 = string3;
        this.i1 = n;
        this.ia1 = nArray;
        this.s2 = string4;
        this.l1 = arrayList;
        this.h1 = hashMap;
        this.t1 = n2;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("hash code: 0x" + Integer.toHexString(this.hashCode()) + "\n");
        stringBuffer.append(super.toString());
        stringBuffer.append("s1: '" + this.s1 + "'\n");
        stringBuffer.append("i1: " + this.i1 + "\n");
        for (n = 0; n < this.ia1.length; ++n) {
            stringBuffer.append("ia1[" + n + "]: " + this.ia1[n] + "\n");
        }
        stringBuffer.append("s2: '" + this.s2 + "'\n");
        for (n = 0; n < this.l1.size(); ++n) {
            stringBuffer.append("l1[" + n + "]: " + this.l1.get(n) + "\n");
        }
        TreeSet treeSet = new TreeSet(this.h1.keySet());
        Iterator iterator = treeSet.iterator();
        n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            stringBuffer.append("h1(" + e + "): " + this.h1.get(e) + "\n");
            ++n;
        }
        stringBuffer.append("t1: " + this.t1 + "\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            System.out.println("cerent.cms.model.persistence.PersistenceTest database user password");
            System.exit(0);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        try {
            int n;
            IStateBatchInfo iStateBatchInfo;
            StateDAO stateDAO = new StateDAO(string, string2, string3);
            stateDAO.init();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(new Integer(5));
            arrayList.add(new Integer(6));
            arrayList.add(new Integer(7));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("8", new Integer(8));
            hashMap.put("9", "9");
            PersistenceTest persistenceTest = new PersistenceTest("foo", "bar", "obj1", 1, new int[]{2, 3}, "4", arrayList, hashMap, 1);
            PersistenceTest persistenceTest2 = new PersistenceTest("foo", "bar", "obj1a", 1, new int[]{2, 3}, "4", arrayList, hashMap, 1);
            PersistenceTest persistenceTest3 = new PersistenceTest("foo", "bar", "obj1b", 21, new int[]{22, 23}, "24", arrayList, hashMap, 1);
            PersistenceTest persistenceTest4 = new PersistenceTest("foo", "bar", "obj1c", 25, new int[]{26, 27}, "28", arrayList, hashMap, 1);
            PersistenceTest persistenceTest5 = new PersistenceTest("foo", "bar", "obj1d", 29, new int[]{30, 31}, "32", arrayList, hashMap, 1);
            PersistenceTest persistenceTest6 = new PersistenceTest("foo", "bar", "obj1c", 33, new int[]{34, 35}, "36", arrayList, hashMap, 1);
            Object[] objectArray = new Object[]{persistenceTest3, persistenceTest4, persistenceTest5, persistenceTest6};
            int n2 = 1;
            int n3 = 2;
            int n4 = 3;
            ModelIdentityFactory modelIdentityFactory = ModelIdentityFactory.instance();
            NetwideModelIdentity netwideModelIdentity = modelIdentityFactory.createNetwideModelIdentity(n2, n3, n4);
            System.out.println("");
            System.out.println("*******************");
            System.out.println("original obj1:");
            System.out.println(persistenceTest);
            stateDAO.save((INetwideModelIdentity)netwideModelIdentity, persistenceTest);
            int n5 = stateDAO.retrieveCount((INetwideModelTypeIdentity)netwideModelIdentity);
            System.out.println("# db count (should be 1): " + n5);
            PersistenceTest persistenceTest7 = (PersistenceTest)stateDAO.retrieve((INetwideModelIdentity)netwideModelIdentity, null);
            System.out.println("");
            System.out.println("*******************");
            System.out.println("retrieved obj1:");
            System.out.println(persistenceTest7);
            IStateBatchInfo[] iStateBatchInfoArray = new StateBatchInfo[4];
            for (int i = 0; i < iStateBatchInfoArray.length; ++i) {
                iStateBatchInfo = new StateBatchInfo();
                int n6 = 21 + 4 * i;
                iStateBatchInfo.id = modelIdentityFactory.createNetwideModelIdentity(n6, n6 + 1, n6 + 2);
                iStateBatchInfo.state = objectArray[i];
                iStateBatchInfo.seqNum = new Long(n6 + 3);
                iStateBatchInfoArray[i] = iStateBatchInfo;
            }
            stateDAO.batchSave(iStateBatchInfoArray);
            for (n = 0; n < iStateBatchInfoArray.length; ++n) {
                iStateBatchInfo = iStateBatchInfoArray[n];
                Object object = stateDAO.retrieve(iStateBatchInfo.id, null);
                if (object != null) continue;
                System.out.println("error: did not find batch obj for: " + iStateBatchInfo.id);
            }
            n = 7;
            int n7 = stateDAO.delete((INetwideModelIdentity)netwideModelIdentity, n);
            System.out.println("# rows deleted (should be 1): " + n7);
            long l = stateDAO.retrieveSequenceNum((INetwideModelTypeIdentity)netwideModelIdentity, -1L);
            System.out.println("# db seq # (should be " + n + "): " + l);
            n5 = stateDAO.retrieveCount((INetwideModelTypeIdentity)netwideModelIdentity);
            System.out.println("# db count (should be 0): " + n5);
            n7 = stateDAO.delete((INetwideModelIdentity)netwideModelIdentity);
            System.out.println("# rows deleted (should be 0): " + n7);
            boolean bl = stateDAO.save((INetwideModelIdentity)netwideModelIdentity, persistenceTest);
            System.out.println("insert happened (should return true): " + bl);
            n7 = stateDAO.delete((INetwideModelTypeIdentity)netwideModelIdentity);
            System.out.println("# rows deleted (should be 1): " + n7);
            PersistenceTest persistenceTest8 = (PersistenceTest)stateDAO.retrieve((INetwideModelIdentity)netwideModelIdentity, null);
            if (persistenceTest8 == null) {
                System.out.println("obj3 null as expected");
            }
            stateDAO.save((INetwideModelIdentity)netwideModelIdentity, persistenceTest);
            int n8 = 1;
            int n9 = 3;
            int n10 = 3;
            NetwideModelIdentity netwideModelIdentity2 = modelIdentityFactory.createNetwideModelIdentity(n8, n9, n10);
            stateDAO.save((INetwideModelIdentity)netwideModelIdentity, persistenceTest);
            stateDAO.save((INetwideModelIdentity)netwideModelIdentity2, persistenceTest2);
            n7 = stateDAO.deletePartition((INetwideModelTypeIdentity)netwideModelIdentity2);
            System.out.println("deletePartition(mid2) returned (should return 2): " + n7);
            boolean bl2 = stateDAO.changeNodeId(4, 5);
            System.out.println("changeNodeId(4,5) returned (should be false): " + bl2);
            bl2 = stateDAO.changeNodeId(1, 6);
            System.out.println("changeNodeId(1,6) returned (should be true): " + bl2);
            bl2 = stateDAO.changeNodeId(6, 1);
            System.out.println("changeNodeId(6,1) returned (should be true): " + bl2);
            int n11 = 1;
            int n12 = 3;
            int n13 = 5;
            NetwideModelIdentity netwideModelIdentity3 = modelIdentityFactory.createNetwideModelIdentity(n11, n12, n13);
            NetwideModelIdentity netwideModelIdentity4 = modelIdentityFactory.createNetwideModelIdentity(n11, n12, n13 + 1);
            ContextFactory contextFactory = new ContextFactory();
            stateDAO.save((INetwideModelIdentity)netwideModelIdentity, persistenceTest);
            stateDAO.save((INetwideModelIdentity)netwideModelIdentity3, persistenceTest);
            stateDAO.save((INetwideModelIdentity)netwideModelIdentity4, persistenceTest);
            contextFactory.count = 0;
            stateDAO.bulkRetrieve((INetwideModelTypeIdentity)netwideModelIdentity3, (IContextFactory)contextFactory);
            System.out.println("context factory count (should be 2): " + contextFactory.count);
            contextFactory.count = 0;
            stateDAO.bulkRetrieve((INetwideNodeIdentity)netwideModelIdentity3, (IContextFactory)contextFactory);
            System.out.println("context factory count (should be 3): " + contextFactory.count);
            n7 = stateDAO.delete((INetwideNodeIdentity)netwideModelIdentity2);
            System.out.println("system wide node delete deleted: " + n7 + " rows");
            n = (int)stateDAO.retrieveSequenceNum((INetwideModelTypeIdentity)netwideModelIdentity, -1L);
            System.out.println("sequence number (should be -1): " + n);
            n7 = stateDAO.delete();
            System.out.println("*** completed tests");
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3;
            while (throwable3 instanceof CTCUserException && (throwable2 = ((CTCUserException)throwable3).getTargetException()) != null) {
                throwable3 = throwable2;
            }
            System.out.println(throwable3.getMessage());
            throwable3.printStackTrace(System.out);
        }
    }
}

