/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CardViewController;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardBehavior;
import cerent.cms.ui.shelf.CardView;
import cerent.util.SDebug;
import cerent.util.gui.GridBagPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class AbstractCardViewPanel
extends GridBagPanel
implements ActionListener {
    public static final Dimension GRAPHIC_VIEW_DIM = new Dimension(600, 248);
    protected ModuleModel model;
    protected CardView cardView;
    protected String cardName = "";
    private CardViewController cvc;
    private CardBehavior cardBehavior;
    private IPlatform pci;
    private static final String CMD_UP = "Go To Parent View";
    protected static final SDebug db = new SDebug("CardViewPanel");

    public AbstractCardViewPanel(ModuleModel moduleModel, CardViewController cardViewController) {
        if (db.on()) {
            db.println("<init>");
        }
        this.model = moduleModel;
        this.cvc = cardViewController;
        this.pci = this.model.getNodeModelDelegate().getPlatform();
        this.cardBehavior = this.pci.getCardBehavior(this.model.getNodeModelDelegate(), db);
        this.initPanel();
        PopupListener popupListener = new PopupListener();
        this.addMouseListener(popupListener);
    }

    protected void initPanel() {
        this.cardName = this.model.getEqLabel();
        JLabel jLabel = AbstractShelfLayout.formatLabel(new JLabel(this.cardName));
        this.add(jLabel, 0, 1, 2, 1);
        this.setupCardView();
        this.add(this.cardView, 1, 2, 1, 0);
    }

    protected abstract void setupCardView();

    public void dispose() {
        this.cardView.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == CMD_UP) {
            this.cvc.tryJumpView(this.cvc.getParentVC().getViewName());
        } else if (string == "Open IOS Connection...") {
            this.cardBehavior.openIOS(this.model);
        } else if (string == "Reset Card") {
            this.cardBehavior.resetCard(this, this.model);
        } else if (string == "Hard-reset Card") {
            this.cardBehavior.hardResetCard(this, this.model);
        } else if (string == "Soft-reset Card") {
            this.cardBehavior.softResetCard(this, this.model);
        } else if (string == "IOS Startup Config...") {
            this.cardBehavior.openIOSConfig(this, this.model);
        }
    }

    protected JMenuItem makeMenuAction(String string, boolean bl, int n) {
        JMenuItem jMenuItem = new JMenuItem(string, n);
        if (bl) {
            jMenuItem.addActionListener(this);
        } else {
            jMenuItem.setEnabled(false);
        }
        return jMenuItem;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            boolean bl = AbstractPane.isUserAuthorized(AbstractCardViewPanel.this.model, SecurityLevel.MAINTENANCE);
            boolean bl2 = AbstractPane.isUserAuthorized(AbstractCardViewPanel.this.model, SecurityLevel.PROVISIONING);
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(AbstractCardViewPanel.this.makeMenuAction(AbstractCardViewPanel.CMD_UP, true, 71));
            jPopupMenu.addSeparator();
            if (CardBehavior.supportsGenericResetCard(AbstractCardViewPanel.this.pci, AbstractCardViewPanel.this.model.getEqType())) {
                jPopupMenu.add(AbstractCardViewPanel.this.makeMenuAction("Reset Card", bl && AbstractCardViewPanel.this.model.isResettable(), 82));
            } else {
                jPopupMenu.add(AbstractCardViewPanel.this.makeMenuAction("Hard-reset Card", bl && AbstractCardViewPanel.this.model.isHardResettable(), 72));
                jPopupMenu.add(AbstractCardViewPanel.this.makeMenuAction("Soft-reset Card", bl && AbstractCardViewPanel.this.model.isSoftResettable(), 83));
            }
            if (AbstractCardViewPanel.this.model instanceof L2scModuleModel || AbstractCardViewPanel.this.model instanceof ML2ModuleModel && !((ML2ModuleModel)AbstractCardViewPanel.this.model).isInMapperMode()) {
                jPopupMenu.addSeparator();
                eEqState eEqState2 = AbstractCardViewPanel.this.model.getState();
                boolean bl3 = eEqState2 == eEqState.ACTIVE || eEqState2 == eEqState.STANDBY;
                jPopupMenu.add(AbstractCardViewPanel.this.makeMenuAction("Open IOS Connection...", bl3 && bl2, 79));
                jPopupMenu.add(AbstractCardViewPanel.this.makeMenuAction("IOS Startup Config...", bl2, 73));
            }
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

