/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AlarmModel;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.IStringTag;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractProvTableModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.AnnotatedException;
import cerent.util.BlockingModeController;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Observable;

public class CardProvAlarmsTableModel
extends AbstractProvTableModel
implements BlockingModeController {
    private static final int NEEDS_REFRESH = 1;
    private static final int NEEDS_RESET = 2;
    public static final int PORTNUMBER_INDEX = 0;
    public static final int PROFILE_INDEX = 1;
    public static final int SUPPRESS_INDEX = 2;
    private static SDebug db = new SDebug("CardProvAlarmsTableModel");
    protected String[] availableProfileNames;
    protected AlarmModel alarmModel;
    protected String[] profileNames;
    protected Boolean[] suppressFlags;
    protected EntityCellRenderer myPortRenderer;
    private ModuleModel mm;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public CardProvAlarmsTableModel(ModuleModel moduleModel) {
        super(moduleModel.getAlarmablePorts(), true, "");
        this.mm = moduleModel;
        this.columnNames = new String[]{"Port", "Profile", "Suppress Alarms"};
        this.myPortRenderer = new EntityCellRenderer(true);
        this.init();
    }

    protected void init() {
        this.profileNames = new String[this.numLines];
        this.suppressFlags = new Boolean[this.numLines];
        this.alarmModel = (AlarmModel)this.mm.getNodeModel().getAlarmModel();
        this.observableManager.addObservable((Observable)((Object)this.alarmModel));
        this.observableManager.setBlockingModeController((BlockingModeController)this);
        this.getPortProfiles();
    }

    protected void refreshMyPorts() {
        int n;
        IModel[] iModelArray = this.mm.getAlarmablePorts();
        ArrayList<IModel> arrayList = new ArrayList<IModel>();
        for (n = 0; n < iModelArray.length; ++n) {
            try {
                iModelArray[n].getInterfaceModel();
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                continue;
            }
            arrayList.add(iModelArray[n]);
        }
        iModelArray = arrayList.toArray(new PortModel[arrayList.size()]);
        this.setModels(iModelArray);
        this.observableManager.addObservable((Observable)((Object)this.alarmModel));
        this.profileNames = new String[this.numLines];
        this.suppressFlags = new Boolean[this.numLines];
        for (n = 0; n < this.numLines; ++n) {
            this.profileNames[n] = null;
            this.suppressFlags[n] = null;
            this.rowDirty[n] = false;
        }
        this.fireTableDataChanged();
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            switch (n2) {
                case 1: {
                    String string = (String)object;
                    if (this.profileNames[n].equals(string)) {
                        return;
                    }
                    this.profileNames[n] = string;
                    break;
                }
                case 2: {
                    Boolean bl = (Boolean)object;
                    if (this.suppressFlags[n].equals(bl)) {
                        return;
                    }
                    this.suppressFlags[n] = bl;
                    break;
                }
                default: {
                    db.println("Invalid col index #" + n2);
                    return;
                }
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (ClassCastException classCastException) {
            SDebug.printStackTrace((Throwable)classCastException);
        }
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.cmsModels != null && this.numLines > 0) {
            try {
                if (AbstractPane.isUserAuthorized((PortModel)this.cmsModels[n], SecurityLevel.PROVISIONING) && (n2 == 1 || n2 == 2)) {
                    return true;
                }
            }
            catch (Exception exception) {
                db.finest("Exception in isCellEditable() " + exception);
            }
        }
        return false;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 2: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = CardProvAlarmsTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            case 0: {
                return class$java$lang$String == null ? (class$java$lang$String = CardProvAlarmsTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
        }
        return super.getColumnClass(n);
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        return this.myPortRenderer.getPortString((PortModel)this.cmsModels[n], false);
    }

    public Object getValueAt(int n, int n2) {
        Object object;
        block8: {
            object = null;
            try {
                switch (n2) {
                    case 0: {
                        object = this.getPortDescriptionFor(n);
                        break;
                    }
                    case 1: {
                        object = this.getProfileName(n);
                        break;
                    }
                    case 2: {
                        object = this.getSuppressAlarms(n);
                        break;
                    }
                    default: {
                        db.println("Unexpected column value = " + n2);
                        if (db.on()) {
                            SDebug.printStackTrace((Throwable)new Exception());
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                db.println("Could not getValueAt(" + n + "," + n2 + ")");
                if (!db.on()) break block8;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return object;
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.profileNames[i] = null;
            this.suppressFlags[i] = null;
            this.rowDirty[i] = false;
        }
        super.refreshFromModel();
    }

    public void refreshFromModel(int n) throws Exception {
        if (n == -1 || n == 2) {
            if (db.on()) {
                db.println("refresh from model, mode " + n);
            }
            this.getPortProfiles();
        }
        this.refreshFromModel();
    }

    public void applyToModel() throws Exception {
        int n = 0;
        this.observableManager.setPassing(false);
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (!this.rowDirty[n]) continue;
                PortModel portModel = (PortModel)this.cmsModels[n];
                portModel.setAlarmProfileName(this.getProfileName(n));
                portModel.setSuppressAlarms(this.getSuppressAlarms(n));
            }
        }
        catch (Exception exception) {
            throw new AnnotatedException("Error applying changes to row " + (n + 1), exception);
        }
        finally {
            this.observableManager.setPassing(true);
        }
    }

    public String[] getProfileNames() {
        if (this.availableProfileNames == null) {
            this.getPortProfiles();
        }
        return this.availableProfileNames;
    }

    protected void getPortProfiles() {
        IStringTag[] iStringTagArray = this.alarmModel.getAlarmProfileList();
        this.availableProfileNames = new String[iStringTagArray.length];
        for (int i = 0; i < iStringTagArray.length; ++i) {
            this.availableProfileNames[i] = iStringTagArray[i].getFirst();
        }
    }

    public AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap((IModel)this.mm.getNodeModel());
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("Received update " + object + " from " + observable);
        }
        if (observable instanceof AlarmModel) {
            this.getPortProfiles();
        }
        super.update(observable, object);
    }

    public int processBlockedEvent(Observable observable, Object object, int n) {
        if (CardProvAlarmsTableModel.db.on) {
            db.println("processBlockedEvent: src " + observable + ", event = " + object + ", previousState = " + n);
        }
        if (observable instanceof AlarmModel) {
            return 2;
        }
        if (n == 0) {
            return 1;
        }
        return n;
    }

    private String getProfileName(int n) {
        if (this.profileNames[n] == null) {
            this.profileNames[n] = ((PortModel)this.cmsModels[n]).getAlarmProfileName();
        }
        return this.profileNames[n];
    }

    private Boolean getSuppressAlarms(int n) {
        if (this.suppressFlags[n] == null) {
            this.suppressFlags[n] = new Boolean(((PortModel)this.cmsModels[n]).getSuppressAlarms());
        }
        return this.suppressFlags[n];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

