/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.AbstractInvalidViewException;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.CardVitalStatsPane;
import cerent.cms.ui.DefaultViewControllerLayout;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.IViewController;
import cerent.cms.ui.InvalidViewException;
import cerent.cms.ui.ShelfViewController;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.event.ShelfEventPanelController;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.UObservable;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CardViewController
extends AbstractViewController
implements Observer,
Runnable {
    protected IPlatform pci;
    private INodeModel nodeModel = null;
    private AbstractCardViewPanel cv = null;
    private TabbedView ctv = null;
    private CardVitalStatsPane cvsp = null;
    private IEntityModel entityModel = null;
    private DefaultViewControllerLayout cvcl = null;
    private int curTabIndex;
    private static final SDebug db = new SDebug("CVC");

    public CardViewController(ShelfViewController shelfViewController, INodeModel iNodeModel, IUiToolkit iUiToolkit, int n, int n2) {
        super((IViewController)shelfViewController, new ViewName(n, n2), iUiToolkit, (KDebug)db);
        this.nodeModel = iNodeModel;
        this.pci = ((NodeModelDelegate)this.nodeModel).getPlatform();
        if (db.on()) {
            db.println("<init> " + this.getViewName());
        }
    }

    public CardVitalStatsPane getVitalStatsPane() {
        if (db.on()) {
            db.println("getVitalStatsPane");
        }
        return this.cvsp;
    }

    public TabbedView getTabbedView() {
        if (db.on()) {
            db.println("getTabbedView");
        }
        return this.ctv;
    }

    protected void localUpdateViewPanel(ViewName viewName) throws AbstractInvalidViewException, AbstractLeavePageException {
        INodeModel iNodeModel;
        if (db.on()) {
            db.println("localUpdateViewPanel destView is " + viewName);
        }
        if (!(iNodeModel = this.getEntityModel().getNodeModel()).isInited() || !iNodeModel.getConnectionState()) {
            ErrorMsg.displayWarning((Component)this.getFrame(), (EID)EMC.WID_NODE_NOT_INITIALIZED_PARAM_1, iNodeModel.getName());
            this.throwInvalidViewException(iNodeModel.getName() + " not initialized.");
        }
        if (db.on()) {
            db.println("local update view panel " + viewName);
        }
        if (viewName.getTabId() != 0 && !this.ctv.changeTab(viewName.getTabId())) {
            throw new InvalidViewException("View=" + viewName, 5);
        }
    }

    protected void localDispose() {
        if (db.on()) {
            db.println(this.getViewName() + " localDispose");
        }
        if (this.cv != null) {
            this.cv.dispose();
            this.cv = null;
        }
        if (this.ctv != null) {
            this.ctv.destroy();
            this.ctv = null;
        }
        if (this.cvsp != null) {
            this.cvsp.dispose();
            this.cvsp = null;
        }
        if (this.cvcl != null) {
            this.cvcl.dispose();
            this.cvcl.destroy();
            this.cvcl = null;
        }
        if (this.entityModel != null) {
            this.entityModel.deleteObserver((Observer)this);
            this.entityModel = null;
        }
    }

    protected void localDestroy() {
        if (db.on()) {
            db.println(this.getViewName() + " localDestroy");
        }
        this.localDispose();
    }

    protected void throwInvalidViewException(String string) throws AbstractInvalidViewException {
        throw new InvalidViewException(string, 3);
    }

    protected void localEnterView(ViewName viewName) {
        if (db.on()) {
            db.println("localEnterView destView is " + viewName);
        }
        this.setTitleLabel(this.nodeModel.getName());
        try {
            this.ctv.setSelectedIndex(this.curTabIndex);
            this.ctv.setShowing(true);
        }
        catch (AbstractLeavePageException abstractLeavePageException) {
            if (db.on()) {
                db.println("AbstractLeavePageException in CardViewController.localEnterView(): " + abstractLeavePageException.getMessage());
            }
        }
        catch (Exception exception) {
            db.finest("Exception in localEnterView " + exception);
        }
        if (this.entityModel != null) {
            this.entityModel.addObserver((Observer)this);
        }
        this.cvcl.updateSplitPanes();
        AbstractViewController.setActiveObject(null);
    }

    protected void localExitView(ViewName viewName, ViewName viewName2) throws AbstractLeavePageException {
        if (db.on()) {
            db.println("localExitView srcView is " + viewName + " destView is " + viewName2);
        }
        if (this.cvcl != null) {
            this.cvcl.dispose();
        }
        try {
            this.curTabIndex = this.ctv.getSelectedIndex();
            this.ctv.setShowing(false);
        }
        catch (AbstractLeavePageException abstractLeavePageException) {
            throw abstractLeavePageException;
        }
        catch (Exception exception) {
            db.finest("Exception in localExitView " + exception);
        }
        if (this.entityModel != null) {
            this.entityModel.deleteObserver((Observer)this);
        }
    }

    protected JPanel createPanel(ViewName viewName) throws AbstractInvalidViewException {
        if (db.on()) {
            db.println("createPanel destView is " + viewName);
        }
        try {
            JPanel jPanel = new JPanel();
            this.cvcl = new DefaultViewControllerLayout(jPanel, "card");
            if (this.getEntityModel().getChildren().size() < 1) {
                throw new InvalidViewException("There is no card in slot " + this.getViewName().getSlotId() + ".", 2);
            }
            this.entityModel = (IEntityModel)this.getEntityModel().getChildren().get(0);
            if (this.entityModel instanceof ModuleModel) {
                this.ctv = this.pci.getCardTabbedViewFactory().getCardView((ModuleModel)this.entityModel, new ShelfEventPanelController(this), this.uiToolkit);
                if (this.ctv == null) {
                    throw new InvalidViewException(this.getViewName() + " does not exist", 2);
                }
                this.ctv.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
                this.cv = this.pci.getCardViewPanel((ModuleModel)this.entityModel, this);
                this.cvsp = new CardVitalStatsPane((ModuleModel)this.entityModel, (UObservable)this.ctv.getObservable());
                this.cvcl.setComponents((JComponent)new UScrollPane((Component)this.cv), (JComponent)this.ctv, this.cvsp);
            }
            return jPanel;
        }
        catch (AbstractInvalidViewException abstractInvalidViewException) {
            this.localFlushViewPanel(null);
            SDebug.printStackTrace((Throwable)abstractInvalidViewException);
            throw abstractInvalidViewException;
        }
        catch (Exception exception) {
            this.localFlushViewPanel(null);
            SDebug.printStackTrace((Throwable)exception);
            throw new InvalidViewException(exception.getMessage(), 1);
        }
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update from " + observable + " tag is " + object);
        }
        if (object instanceof Integer && object == ModelUpdateType.DELETED) {
            if (this.nodeModel.isInited() && ((NodeModelDelegate)this.nodeModel).getLoginState()) {
                try {
                    db.println("update: jumping to shelf");
                    this.jumpView(this.viewName.getParentView(), false);
                    SwingUtilities.invokeLater(this);
                }
                catch (Exception exception) {
                    if (db.on()) {
                        db.println("update got exception when trying to jump to shelf view");
                    }
                    SDebug.printStackTrace((Throwable)exception);
                    this.tryJumpView(ViewName.ROOT_VIEW);
                }
            } else {
                db.println("update discarded (NMD !inited/LoggedOut)");
            }
        }
    }

    public void run() {
        ErrorMsg.displayWarning(this.getFrame(), (EID)EMC.WID_NAV_CARD_DELETED);
    }

    private EntityModel getEntityModel() {
        List list;
        EntityModel entityModel = null;
        EntityModel entityModel2 = (EntityModel)this.nodeModel.getChassis();
        List list2 = entityModel2 != null ? entityModel2.getChildrenOfType(eClass.BACKPLANE) : null;
        EntityModel entityModel3 = list2 != null && list2.size() > 0 ? (EntityModel)list2.get(0) : null;
        List list3 = list = entityModel3 != null ? entityModel3.getChildren() : null;
        if (list != null) {
            entityModel = (EntityModel)list.get(this.getViewName().getSlotId() - 1);
        }
        return entityModel;
    }
}

