/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.util.Preferences;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class DefaultViewControllerLayout {
    private JPanel parent;
    private JSplitPane mainSplitPane;
    private JSplitPane upperSplitPane;
    private final Preferences pref = Preferences.instance();
    private String splitter1Key;
    private String splitter2Key;
    private static final String PROP_PREFIX = "ctc";
    private static final String PROP_SPLIT1 = "layout.split1";
    private static final String PROP_SPLIT2 = "layout.split2";
    private static final int MIN_UPPER_SPLIT = 100;
    private boolean splitterBug;

    public DefaultViewControllerLayout(JPanel jPanel) {
        this(jPanel, null);
    }

    public DefaultViewControllerLayout(JPanel jPanel, String string) {
        this.parent = jPanel;
        jPanel.setLayout(new BorderLayout());
        this.mainSplitPane = new JSplitPane(0);
        this.upperSplitPane = new JSplitPane(1);
        this.mainSplitPane.setDividerSize(2);
        this.upperSplitPane.setDividerSize(2);
        jPanel.add((Component)this.mainSplitPane, "Center");
        this.mainSplitPane.setTopComponent(this.upperSplitPane);
        String string2 = System.getProperty("java.version");
        if (string2.startsWith("1.2")) {
            this.splitterBug = true;
        }
        this.splitter1Key = PROP_SPLIT1;
        this.splitter2Key = PROP_SPLIT2;
        if (string != null) {
            this.splitter1Key = this.splitter1Key + "." + string;
            this.splitter2Key = this.splitter2Key + "." + string;
        }
    }

    public void setStatusBarArea(JComponent jComponent) {
        this.parent.add((Component)jComponent, "South");
    }

    public void setComponents(JComponent jComponent, JComponent jComponent2, JComponent jComponent3) {
        this.mainSplitPane.setBottomComponent(jComponent2);
        this.upperSplitPane.setRightComponent(jComponent);
        this.upperSplitPane.setLeftComponent(jComponent3);
        this.updateSplitPanes();
        if (jComponent2 instanceof JComponent) {
            jComponent2.requestFocus();
        }
    }

    public void updateSplitPanes() {
        this.upperSplitPane.resetToPreferredSizes();
        this.mainSplitPane.resetToPreferredSizes();
        try {
            int n = Integer.parseInt(this.pref.getProperty(PROP_PREFIX, this.splitter1Key, ""));
            if (n > 0 && !this.splitterBug) {
                this.mainSplitPane.setDividerLocation(n);
            }
            if ((n = Integer.parseInt(this.pref.getProperty(PROP_PREFIX, this.splitter2Key, ""))) < 100) {
                n = 100;
            }
            if (n > 0) {
                this.upperSplitPane.setDividerLocation(n);
            }
        }
        catch (Exception exception) {
            this.mainSplitPane.setDividerLocation(300);
            this.upperSplitPane.setDividerLocation(150);
        }
        this.mainSplitPane.invalidate();
    }

    public void dispose() {
        this.pref.setProperty(PROP_PREFIX, this.splitter1Key, Integer.toString(this.mainSplitPane.getDividerLocation()));
        this.pref.setProperty(PROP_PREFIX, this.splitter2Key, Integer.toString(this.upperSplitPane.getDividerLocation()));
    }

    public void destroy() {
        this.parent.removeAll();
        this.parent = null;
        this.mainSplitPane.removeAll();
        this.mainSplitPane = null;
        this.upperSplitPane.removeAll();
        this.upperSplitPane = null;
    }
}

