/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ElementModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.cms.ui.helper.PluggableHelper;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.SDebug;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class EntityCellRenderer
implements IEntityCellRenderer {
    private String prefix;
    private boolean iShowPortAlias = true;
    private boolean useDs1PortNums;
    private DefaultListCellRenderer dlcr;
    private DefaultTableCellRenderer dtcr;
    private static String BLSR_TERM;
    protected static SDebug db;

    public EntityCellRenderer() {
        this("", false);
    }

    public EntityCellRenderer(String string) {
        this(string, false);
    }

    public EntityCellRenderer(boolean bl) {
        this("", bl);
    }

    public EntityCellRenderer(String string, boolean bl) {
        this.prefix = string;
        this.useDs1PortNums = bl;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (this.dlcr == null) {
            this.dlcr = new DefaultListCellRenderer();
        }
        this.dlcr.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (object instanceof EntityModel) {
            this.dlcr.setText(this.getString((EntityModel)object, this.prefix));
        }
        return this.dlcr;
    }

    public String getTruncatedString(String string) {
        String string2;
        block2: {
            string2 = "";
            try {
                StringBuffer stringBuffer = new StringBuffer(string);
                int n = stringBuffer.indexOf("slot ");
                stringBuffer = stringBuffer.replace(n + 1, "slot ".length(), "");
                n = stringBuffer.indexOf("port ");
                stringBuffer = stringBuffer.replace(n + 1, n + "port ".length(), "");
                string2 = stringBuffer.toString();
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string2;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (this.dtcr == null) {
            this.dtcr = new DefaultTableCellRenderer();
        }
        this.dtcr.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (object instanceof EntityModel) {
            this.dtcr.setText(this.getString((EntityModel)object, this.prefix));
        }
        return this.dtcr;
    }

    public String getString(Object object, String string) {
        String string2 = "<invalid entity>";
        if (object != null && object instanceof EntityModel) {
            EntityModel entityModel = (EntityModel)object;
            StringBuffer stringBuffer = new StringBuffer(29);
            if (string != null) {
                stringBuffer.append(string);
            }
            try {
                switch (entityModel.getGenericClass()) {
                    case 6: {
                        if (entityModel instanceof ModuleModel) {
                            int n = entityModel.getSlot();
                            if (n == 0) {
                                stringBuffer.append("<no slot>");
                            } else {
                                if (n >= 0 && n < 10) {
                                    stringBuffer.append(' ');
                                }
                                stringBuffer.append(n);
                            }
                            stringBuffer.append(" (");
                            stringBuffer.append(((ModuleModel)entityModel).getEqTypeName());
                            stringBuffer.append(")");
                        } else if (entityModel instanceof PluggableModel) {
                            stringBuffer.append(PluggableHelper.getHierarchyNumString(((PluggableModel)entityModel).getHierarchyNums(), '-'));
                        }
                        string2 = stringBuffer.toString();
                        break;
                    }
                    case 7: {
                        stringBuffer.append(this.getString(entityModel.getModuleModel(), ""));
                        stringBuffer.append(", ");
                        stringBuffer.append("port ");
                        stringBuffer.append(this.getPortString(entityModel, false));
                        string2 = stringBuffer.toString();
                        break;
                    }
                    default: {
                        string2 = entityModel.toString();
                        break;
                    }
                }
            }
            catch (Exception exception) {
                db.finer("Exception in getString. " + exception);
                string2 = "Unknown";
            }
        }
        return string2;
    }

    public int getMediumType(IEntityModel iEntityModel) {
        int n;
        block8: {
            boolean bl = true;
            n = 1;
            switch (iEntityModel.getEqType()) {
                case 28: 
                case 29: 
                case 30: 
                case 61: {
                    try {
                        n = ((TdmLineModel)((TdmPortModel)iEntityModel).getInterfaceModel()).getMediumType();
                        bl = false;
                    }
                    catch (Exception exception) {
                        if (!db.on()) break;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    break;
                }
            }
            if (bl) {
                try {
                    n = Model.getFramingType(iEntityModel.getNodeModel()).isSonet() ? 1 : 0;
                }
                catch (Exception exception) {
                    if (!db.on()) break block8;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return n;
    }

    public String getMediumTypeStr(TdmLineModel tdmLineModel) {
        return this.getMediumTypeStr(tdmLineModel.getMediumType());
    }

    public String getMediumTypeStr(IEntityModel iEntityModel) {
        return this.getMediumTypeStr(this.getMediumType(iEntityModel));
    }

    private String getMediumTypeStr(int n) {
        return n == 0 ? ElementDefaults.getPortMediumString(n) : "";
    }

    public static String getPayloadTypeStr(InterfaceModel interfaceModel) {
        String string;
        block8: {
            string = "";
            try {
                ModuleModel moduleModel = interfaceModel.getModuleModel();
                String string2 = null;
                switch (moduleModel.getEqType()) {
                    case 119: 
                    case 182: {
                        string2 = "declMXP10GPayloadDataType";
                        break;
                    }
                    case 118: {
                        string2 = "declTXP10GPayloadDataType";
                        break;
                    }
                    case 181: {
                        string2 = "declTXP10EPayloadDataType";
                        break;
                    }
                    case 120: 
                    case 121: 
                    case 183: 
                    case 184: {
                        string2 = "declAllDataRate";
                        break;
                    }
                    default: {
                        throw new Exception(interfaceModel + " is not a DWDM Line Model");
                    }
                }
                string = ElementDefaults.getAttributeMap(moduleModel).getAttributeForVal(string2, ((AbstractDwdmLineModel)interfaceModel).getDataRate()).getKey();
            }
            catch (Exception exception) {
                db.println("Caught exception in getPayloadTypeStr");
                if (!db.on()) break block8;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public static int mapPayloadType(int n) {
        return n == 8 ? 2 : AbstractDwdmLineModel.mapFramingType(n);
    }

    public String getFramingTypeStr(InterfaceModel interfaceModel) {
        String string;
        block2: {
            string = "";
            try {
                string = ElementDefaults.getAttributeMap(interfaceModel.getModuleModel()).getAttributeForVal("declFullSetDwdmFramingType", ((AbstractDwdmLineModel)interfaceModel).getFramingType()).getKey();
            }
            catch (Exception exception) {
                db.println("Caught exception in getFramingTypeStr");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public String getTermMode(InterfaceModel interfaceModel) {
        String string;
        block2: {
            string = "";
            try {
                AbstractDwdmLineModel abstractDwdmLineModel = (AbstractDwdmLineModel)interfaceModel;
                DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)abstractDwdmLineModel.getModuleModel();
                string = ElementDefaults.getAttributeMap(dwdmModuleModel).getAttributeForVal(dwdmModuleModel.supportSectionTermMode() ? "declTermModeFullSet" : "declTermModeTransparentSection", abstractDwdmLineModel.getTermMode()).getKey();
            }
            catch (Exception exception) {
                db.println("Caught exception in getTermMode");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public String getPortString(IEntityModel iEntityModel, boolean bl, boolean bl2) {
        String string;
        block5: {
            string = null;
            if (iEntityModel != null) {
                try {
                    String string2;
                    StringBuffer stringBuffer = new StringBuffer(this.getFormattedPortNumberFor(iEntityModel, bl2));
                    if (iEntityModel instanceof IPortModel) {
                        stringBuffer.append(this.getFormattedPortAliasFor((IPortModel)iEntityModel));
                    }
                    if (bl && Model.getFramingType(iEntityModel.getNodeModel()).isSonet() && iEntityModel instanceof TdmPortModel && (string2 = this.getMediumTypeStr(iEntityModel)).length() > 0) {
                        stringBuffer.append(" (");
                        stringBuffer.append(string2);
                        stringBuffer.append(")");
                    }
                    string = stringBuffer.toString();
                }
                catch (Exception exception) {
                    db.info("Caught exception in getPortString");
                    if (!db.on()) break block5;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return string == null ? "" : string;
    }

    public String getPortString(IEntityModel iEntityModel, boolean bl) {
        return this.getPortString(iEntityModel, bl, false);
    }

    public String getSonetLineProtectionDescription(TdmLineModel tdmLineModel, boolean bl) {
        String string;
        block20: {
            ElementModel elementModel;
            String string2;
            block18: {
                string = string2 = bl ? ", Unprotected" : ":Unprotected";
                elementModel = null;
                try {
                    elementModel = tdmLineModel.getElementModel();
                }
                catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                    if (!db.on()) break block18;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                }
            }
            if (elementModel != null) {
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                String string8;
                String string9;
                block19: {
                    string9 = "";
                    if (BLSR_TERM == null) {
                        try {
                            BLSR_TERM = Model.getTDMTerminology((IModel)tdmLineModel.getNodeModel()).getRingTerms(1);
                        }
                        catch (Exception exception) {
                            if (!db.on()) break block19;
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                }
                String string10 = string8 = BLSR_TERM != null ? BLSR_TERM : "BLSR/MS-SPRing";
                if (bl) {
                    string7 = ": Active";
                    string6 = ": Standby";
                    string5 = ", One plus one";
                    string4 = ", " + string8 + " 2 fiber";
                    string3 = ", " + string8 + " 4 fiber";
                } else {
                    string7 = ":Act";
                    string6 = ":Sby";
                    string5 = ":1+1";
                    string4 = ":" + string8 + " 2F";
                    string3 = ":" + string8 + " 4F";
                }
                try {
                    int n = tdmLineModel.getAdminState();
                    if (n != 1 && n != -1) {
                        string9 = string6;
                        if (tdmLineModel.isCurrentlyActive()) {
                            string9 = string7;
                        }
                    }
                    switch (elementModel.getType()) {
                        case 1: {
                            string = string5 + string9;
                            break;
                        }
                        case 2: {
                            string = string4 + string9;
                            break;
                        }
                        case 3: {
                            string = string3 + string9;
                            break;
                        }
                        default: {
                            string = string2;
                            if (string9.equals(string6)) {
                                db.severe("Standby status on unprotected line " + tdmLineModel.getIndex() + " detected!");
                            }
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    db.info("TdmLineModel or elementModel.getType() threw an exception - accepting default");
                    if (!db.on()) break block20;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return string;
    }

    public String getDwdmLineProtectionDescription(InterfaceModel interfaceModel, boolean bl) {
        ElementModel elementModel;
        String string;
        block15: {
            string = "";
            elementModel = null;
            if (!(interfaceModel instanceof AbstractDwdmLineModel)) {
                interfaceModel = interfaceModel.getHighestParent();
            }
            try {
                if (interfaceModel != null) {
                    elementModel = interfaceModel.getElementModel();
                }
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!db.on()) break block15;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
        if (elementModel != null) {
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            block16: {
                String string7;
                string6 = "";
                if (bl) {
                    string7 = ": Active";
                    string5 = ": Standby";
                    string4 = ", Y Cable";
                    string3 = ", Splitter";
                    string2 = ", Unprotected";
                } else {
                    string7 = ":Act";
                    string5 = ":Sby";
                    string4 = ":Ycbl";
                    string3 = ":Spltr";
                    string2 = ":Unprot";
                }
                try {
                    int n = interfaceModel.getAdminState();
                    if (n != 1 && n != -1) {
                        string6 = string5;
                        if (interfaceModel.isCurrentlyActive()) {
                            string6 = string7;
                        }
                    }
                }
                catch (Exception exception) {
                    db.info("Caught exception in getDwdmLineProtectionDescription");
                    if (!db.on()) break block16;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            switch (elementModel.getType()) {
                case 4: {
                    string = string4 + string6;
                    break;
                }
                case 5: {
                    string = string3 + string6;
                    break;
                }
                default: {
                    string = string2;
                    if (!string6.equals(string5)) break;
                    db.severe("Standby status on unprotected line " + interfaceModel.getIndex() + " detected!");
                }
            }
        }
        return string;
    }

    public void showPortAlias(boolean bl) {
        this.iShowPortAlias = bl;
    }

    public boolean isShowingPortAlias() {
        return this.iShowPortAlias;
    }

    protected String getFormattedPortAliasFor(IPortModel iPortModel) {
        return this.iShowPortAlias ? PortHelper.getFormattedPortAlias((IPortModel)iPortModel) : "";
    }

    protected String getFormattedPortNumberFor(IEntityModel iEntityModel, boolean bl) {
        return iEntityModel instanceof IPortModel ? PortHelper.getPortNumAndTypeString((IPortModel)((IPortModel)iEntityModel), (boolean)bl, (boolean)this.useDs1PortNums) : Integer.toString(iEntityModel.getPort());
    }

    static {
        db = new SDebug("EntityCellRenderer");
    }
}

