/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.RoDataSourceControl;
import cerent.cms.ui.TabbedView;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.Observable;

public abstract class ObserverPane
extends AbstractPane {
    private RoDataSourceControl dsControl = null;
    private IObservableManager observableManager;

    protected ObserverPane(String string, TabbedView tabbedView, RoDataSourceControl roDataSourceControl) {
        super(string, tabbedView);
        this.setDataSourceControl(roDataSourceControl);
    }

    protected ObserverPane(String string, TabbedView tabbedView) {
        this(string, tabbedView, null);
    }

    protected IObservableManager getObservableManager() {
        return this.observableManager;
    }

    public void setDataSourceControl(RoDataSourceControl roDataSourceControl) {
        this.dsControl = roDataSourceControl;
        if (roDataSourceControl != null) {
            this.observableManager = roDataSourceControl.getObservableManager();
        }
    }

    public void leavingPage() throws Exception {
        if (db.on()) {
            db.println("setPassing:false");
        }
        if (this.observableManager != null) {
            this.observableManager.setPassing(false);
        }
    }

    public void enteringPage() throws Exception {
        if (this.observableManager != null) {
            int n = this.observableManager.getBlockingModeControllerState();
            if (n != 0 && this.dsControl != null) {
                if (db.on()) {
                    db.println("refreshing data source:" + n);
                }
                this.dsControl.refreshFromModel(n);
            }
            this.observableManager.setPassing(true);
            if (db.on()) {
                db.println("setPassing:true");
            }
        }
    }

    public void refresh() {
        try {
            if (this.dsControl != null) {
                this.dsControl.refreshFromModel();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_REFRESH);
        }
    }

    public void dispose() {
        if (this.dsControl != null) {
            this.dsControl.disposeDataSource();
        }
        if (this.observableManager != null) {
            this.observableManager.reset();
        }
        super.dispose();
    }

    public void changeMessage(Observable observable, Object object) {
        try {
            if (this.dsControl != null) {
                this.dsControl.refreshFromModel();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_REFRESH);
        }
    }

    public void deleteMessage(Observable observable, Object object) {
        try {
            if (this.dsControl != null) {
                this.dsControl.refreshFromModel();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_REFRESH);
        }
    }

    public void structureChangeMessage(Observable observable, Object object) {
        try {
            if (this.dsControl != null) {
                this.dsControl.refreshFromModel();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_REFRESH);
        }
    }
}

