/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.RevertiveBehavior;
import cerent.cms.ui.AbstractProvPane;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RevertiveBehaviorPanel
extends JPanel
implements ActionListener {
    private AbstractProvPane container;
    private boolean authorized = true;
    private JCheckBox revertiveCB;
    private JLabel reversionTimeLabel;
    private JComboBox reversionTimeCB;
    public static final ReversionTime[] reversionTimes = new ReversionTime[]{new ReversionTime("0.5", 30), new ReversionTime("1.0", 60), new ReversionTime("1.5", 90), new ReversionTime("2.0", 120), new ReversionTime("2.5", 150), new ReversionTime("3.0", 180), new ReversionTime("3.5", 210), new ReversionTime("4.0", 240), new ReversionTime("4.5", 270), new ReversionTime("5.0", 300), new ReversionTime("5.5", 330), new ReversionTime("6.0", 360), new ReversionTime("6.5", 390), new ReversionTime("7.0", 420), new ReversionTime("7.5", 450), new ReversionTime("8.0", 480), new ReversionTime("8.5", 510), new ReversionTime("9.0", 540), new ReversionTime("9.5", 570), new ReversionTime("10.0", 600), new ReversionTime("10.5", 630), new ReversionTime("11.0", 660), new ReversionTime("11.5", 690), new ReversionTime("12.0", 720)};
    private static final String MINUTES = "min";
    public static final boolean DEFAULT_REVERTIVE = false;
    public static final int DEFAULT_REVERSION_TIME = 300;
    public static final int TIMING_DEFAULT_REVERSION_TIME = 0;
    private static SDebug db = new SDebug("RevertiveBehaviorPanel");
    private boolean isTimingPane = false;
    private int preferredTime;
    private int preferredMode;

    public RevertiveBehaviorPanel(AbstractProvPane abstractProvPane) {
        this(abstractProvPane, false);
    }

    public RevertiveBehaviorPanel(AbstractProvPane abstractProvPane, boolean bl) {
        this.isTimingPane = bl;
        this.commonInit(abstractProvPane);
    }

    private void commonInit(AbstractProvPane abstractProvPane) {
        this.container = abstractProvPane;
        this.authorized = this.container != null ? this.container.isUserAuthorized() : true;
        this.setLayout(new FlowLayout(0, 5, 5));
        JLabel jLabel = new JLabel("Reversion time (min): ");
        this.revertiveCB = new JCheckBox("Revertive", false);
        this.reversionTimeCB = new JComboBox<ReversionTime>(reversionTimes);
        if (this.isTimingPane) {
            this.reversionTimeCB.insertItemAt(new ReversionTime("0.0 (2 second wait)", 0), 0);
        }
        this.add(this.revertiveCB);
        this.add(jLabel);
        this.add(this.reversionTimeCB);
        this.preferredTime = 300;
        this.preferredMode = 1;
        this.revertiveCB.setEnabled(this.authorized);
        this.revertiveCB.addActionListener(this);
        this.setReversionTimeEnabled();
        this.reversionTimeCB.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.revertiveCB) {
            this.preferredMode = this.revertiveCB.isSelected() ? 2 : 1;
            this.setReversionTimeEnabled();
            if (RevertiveBehaviorPanel.db.on) {
                db.println("actionPerformed: Revertive = " + this.revertiveCB.isSelected());
            }
        } else if (object == this.reversionTimeCB) {
            if (this.revertiveCB.isSelected()) {
                this.preferredTime = this.getReversionTime();
            }
            if (RevertiveBehaviorPanel.db.on) {
                db.println("actionPerformed: ReversionTime = " + this.preferredTime);
            }
        }
        if (this.container != null) {
            this.container.setDirty();
        }
    }

    public void updateReversionTimes(IEntityModel iEntityModel) {
        boolean bl = false;
        ReversionTime reversionTime = RevertiveBehaviorPanel.getReversionTime(30);
        for (int i = 0; i < this.reversionTimeCB.getItemCount(); ++i) {
            if (this.reversionTimeCB.getItemAt(i) != reversionTime) continue;
            bl = true;
            break;
        }
        if (iEntityModel == null) {
            if (!bl) {
                this.reversionTimeCB.insertItemAt(RevertiveBehaviorPanel.getReversionTime(30), 0);
            }
        } else if (iEntityModel.getEqType() == 65) {
            if (bl) {
                this.reversionTimeCB.removeItem(reversionTime);
            }
        } else if (iEntityModel.getEqType() != 65 && !bl) {
            this.reversionTimeCB.insertItemAt(RevertiveBehaviorPanel.getReversionTime(30), 0);
        }
    }

    public void setRevertiveBehavior(IRevertiveBehavior iRevertiveBehavior) {
        if (db.on()) {
            db.println("setRevertiveBehavior called....");
            SDebug.printStackTrace((Throwable)new Exception());
        }
        if (iRevertiveBehavior == null) {
            if (RevertiveBehaviorPanel.db.on) {
                db.println("setRevertiveBehavior(null)");
            }
            this.setRevertive(false);
            this.revertiveCB.setEnabled(false);
            this.reversionTimeCB.setSelectedItem(null);
        } else {
            this.setPreferredRevertiveBehavior(iRevertiveBehavior);
            this.setRevertive(iRevertiveBehavior.getReversionMode() == 2);
            this.setReversionTime(this.revertiveCB.isSelected() ? iRevertiveBehavior.getReversionTime() : this.getDefaultReversionTime());
        }
    }

    public void setRevertive(boolean bl) {
        if (bl && !this.revertiveCB.isSelected() || !bl && this.revertiveCB.isSelected()) {
            this.revertiveCB.setSelected(bl);
            this.preferredMode = this.revertiveCB.isSelected() ? 2 : 1;
            this.setReversionTimeEnabled();
        }
    }

    public void setRevertiveEnabled(boolean bl) {
        this.revertiveCB.setEnabled(bl);
    }

    private void setReversionTimeEnabled() {
        if (this.revertiveCB.isSelected() && this.authorized) {
            this.reversionTimeCB.setEnabled(true);
            this.setReversionTime(this.preferredTime);
        } else {
            this.reversionTimeCB.setEnabled(false);
            this.setReversionTime(this.getDefaultReversionTime());
        }
    }

    public void setReversionTime(int n) {
        RevertiveBehaviorPanel.setReversionTime(this.reversionTimeCB, n);
    }

    public static void setReversionTime(JComboBox jComboBox, int n) {
        int n2;
        int n3;
        ReversionTime reversionTime = (ReversionTime)jComboBox.getItemAt(0);
        ReversionTime reversionTime2 = (ReversionTime)jComboBox.getItemAt(1);
        for (int i = 2; n > reversionTime2.getTime() && i < jComboBox.getItemCount(); ++i) {
            reversionTime = (ReversionTime)jComboBox.getItemAt(i - 1);
            reversionTime2 = (ReversionTime)jComboBox.getItemAt(i);
        }
        ReversionTime reversionTime3 = null;
        reversionTime3 = n > reversionTime2.getTime() ? reversionTime2 : ((n3 = n - reversionTime.getTime()) <= (n2 = reversionTime2.getTime() - n) ? reversionTime : reversionTime2);
        jComboBox.setSelectedItem(reversionTime3);
    }

    public int getReversionTime() {
        return ((ReversionTime)this.reversionTimeCB.getSelectedItem()).getTime();
    }

    public IRevertiveBehavior getRevertiveBehavior() {
        RevertiveBehavior revertiveBehavior = null;
        revertiveBehavior = this.revertiveCB.isSelected() ? new RevertiveBehavior(2, this.getReversionTime()) : new RevertiveBehavior(1, this.getDefaultReversionTime());
        return revertiveBehavior;
    }

    public boolean RevertiveDialog() {
        if (!this.isTimingPane) {
            return CerentDialog.yesNoDialog((Component)((Object)this.container), (String)"A reversion time of 0.0 is no longer supported.\nChanging a reversion time from 0.0 can't be undone later.\n\nOK to continue?", (String)"Zero Reversion Time Not Supported");
        }
        return true;
    }

    private int getDefaultReversionTime() {
        if (this.isTimingPane) {
            return 0;
        }
        return 300;
    }

    public static ReversionTime getReversionTime(int n) {
        int n2;
        int n3;
        ReversionTime reversionTime = reversionTimes[0];
        ReversionTime reversionTime2 = reversionTimes[1];
        for (int i = 2; n > reversionTime2.getTime() && i < reversionTimes.length; ++i) {
            reversionTime = reversionTimes[i - 1];
            reversionTime2 = reversionTimes[i];
        }
        ReversionTime reversionTime3 = n > reversionTime2.getTime() ? reversionTime2 : ((n3 = n - reversionTime.getTime()) <= (n2 = reversionTime2.getTime() - n) ? reversionTime : reversionTime2);
        return reversionTime3;
    }

    public static String getReversionTimeString(int n) {
        return RevertiveBehaviorPanel.getReversionTime(n).toString();
    }

    private void setPreferredRevertiveBehavior(IRevertiveBehavior iRevertiveBehavior) {
        this.preferredMode = iRevertiveBehavior.getReversionMode();
        this.preferredTime = iRevertiveBehavior.getReversionTime();
        if (db.on()) {
            db.println("Setting preferred revertive behavior to " + this.preferredMode + ", " + this.preferredTime);
        }
    }

    public void removeActionListener() {
        this.revertiveCB.removeActionListener(this);
        this.reversionTimeCB.removeActionListener(this);
    }

    public static class ReversionTime {
        private String minuteLabel;
        private int seconds;

        public ReversionTime(String string, int n) {
            this.minuteLabel = string;
            this.seconds = n;
        }

        public String toString() {
            return this.minuteLabel;
        }

        public int getTime() {
            return this.seconds;
        }
    }
}

