/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractInvalidViewException;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.CardViewController;
import cerent.cms.ui.DefaultViewControllerLayout;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.IViewController;
import cerent.cms.ui.InvalidViewException;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.event.ShelfEventPanelController;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardPanel;
import cerent.cms.ui.shelf.NodeVitalStatsPane;
import cerent.cms.ui.shelf.ShelfTabbedView;
import cerent.cms.ui.shelf.ShelfViewPanel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class ShelfViewController
extends AbstractViewController
implements Observer,
ActionListener {
    private NodeModelDelegate nmd = null;
    private INodeModel.AbstractConnectionNotifier cn = null;
    private String name = " ";
    private ShelfViewPanel sv = null;
    private AbstractShelfLayout ssl = null;
    private ShelfTabbedView stv = null;
    private NodeVitalStatsPane nvsp = null;
    private DefaultViewControllerLayout svcl = null;
    private int curTabIndex;
    private static final SDebug db = new SDebug("SVC");
    private boolean setupMenuPosted = false;
    private JMenuItem setupMenuItem;

    public ShelfViewController(IViewController iViewController, INodeModel iNodeModel, IUiToolkit iUiToolkit) {
        super(iViewController, new ViewName(iNodeModel.getNodeId()), iUiToolkit, (KDebug)db);
        if (db.on()) {
            db.println("<init> " + this.getViewName());
        }
        this.nmd = (NodeModelDelegate)iNodeModel.getDelegate();
        this.nmd.addObserver(this);
        this.cn = this.nmd.getConnectionNotifier();
        this.cn.addObserver((Observer)this);
        try {
            this.name = this.nmd.getName();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            // empty catch block
        }
    }

    public NodeVitalStatsPane getVitalStatsPane() {
        if (db.on()) {
            db.println("getVitalStatsPane");
        }
        return this.nvsp;
    }

    public TabbedView getTabbedView() {
        if (db.on()) {
            db.println("getTabbedView");
        }
        return this.stv;
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update( " + object + " ) from " + observable);
        }
        if (this.nmd == null) {
            return;
        }
        if (observable instanceof NodeModelDelegate.ConnectionNotifier) {
            if (object == ModelUpdateType.CHANGED) {
                if (this.nmd.isInited() && this.nmd.getConnectionState()) {
                    try {
                        this.name = this.nmd.getName();
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {}
                } else {
                    this.disconnect(this.viewName);
                }
            }
        } else if (observable instanceof NodeModelDelegate) {
            if (object == ModelUpdateType.DELETED) {
                if (db.on()) {
                    db.println("Got a DELETED event");
                }
                if (this.parentVC != null) {
                    if (db.on()) {
                        db.println("Unmounting SVC");
                    }
                    this.parentVC.removeChild((IViewController)this);
                }
                this.disconnect(this.viewName);
            } else if (object == ModelUpdateType.CHANGED) {
                try {
                    this.name = this.nmd.getName();
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    // empty catch block
                }
                if (this.getCurrentView() != null && this.viewName.contains(this.getCurrentView())) {
                    if (db.on()) {
                        db.println("View is displayed. Setting title to " + this.name);
                    }
                    this.setTitleLabel(this.name);
                }
            }
        }
    }

    protected void localUpdateViewPanel(ViewName viewName) throws AbstractInvalidViewException, AbstractLeavePageException {
        if (db.on()) {
            db.println("localUpdateViewPanel destView is " + viewName);
        }
        if (!this.nmd.isInited()) {
            ErrorMsg.displayWarning((Component)this.getFrame(), (EID)EMC.WID_NODE_NOT_INITIALIZED_PARAM_1, this.name);
            this.throwInvalidViewException(this.name + " not initialized.");
        }
        if (viewName.getTabId() != 0 && !this.stv.changeTab(viewName.getTabId())) {
            throw new InvalidViewException("View=" + viewName, 5);
        }
    }

    protected ViewName localGetSelectedView(ViewName viewName) {
        EntityModel entityModel;
        CardPanel cardPanel;
        if (db.on()) {
            db.println("localGetSelectedView destView is " + viewName);
        }
        if ((cardPanel = this.ssl.getSelectedCard()) != null && (entityModel = cardPanel.getEntityModel()) != null && entityModel.getEqType() != 2 && entityModel.getEqType() != 48 && entityModel.getEqType() != 3 && entityModel.getEqType() != 43) {
            return new ViewName(this.nmd.getNodeId(), entityModel.getPositionInParent());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localDispose() {
        if (db.on()) {
            db.println(this.getViewName() + " localDispose");
        }
        if (this.sv != null) {
            this.sv.remove(this.ssl);
        }
        this.releaseShelfLayout();
        if (this.stv != null) {
            try {
                this.stv.destroy();
            }
            finally {
                this.stv = null;
            }
        }
        if (this.nvsp != null) {
            try {
                this.nvsp.dispose();
            }
            finally {
                this.nvsp = null;
            }
        }
        if (this.svcl != null) {
            try {
                this.svcl.destroy();
            }
            finally {
                this.svcl = null;
            }
        }
        this.sv = null;
    }

    protected void localDestroy() {
        this.localDispose();
        if (db.on()) {
            db.println(this.getViewName() + " localDestroy");
        }
        if (this.nmd != null) {
            try {
                this.cn.deleteObserver((Observer)this);
                this.nmd.deleteObserver(this);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected void localEnterView(ViewName viewName) {
        if (db.on()) {
            db.println("localEnterView destView is " + viewName);
        }
        this.setTitleLabel(this.name);
        try {
            this.stv.setSelectedIndex(this.curTabIndex);
            this.stv.setShowing(true);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        this.postMenuEntries();
    }

    protected void localExitView(ViewName viewName, ViewName viewName2) throws AbstractLeavePageException {
        if (db.on()) {
            db.println("localExitView srcView is " + viewName + " destView is " + viewName2);
        }
        if (this.svcl != null) {
            this.svcl.dispose();
        }
        this.removeMenuEntries();
        try {
            if (this.stv != null) {
                this.curTabIndex = this.stv.getSelectedIndex();
                this.stv.setShowing(false);
            }
        }
        catch (AbstractLeavePageException abstractLeavePageException) {
            throw abstractLeavePageException;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    protected void throwInvalidViewException(String string) throws AbstractInvalidViewException {
        throw new InvalidViewException(string, 2);
    }

    protected JPanel createPanel(ViewName viewName) throws AbstractInvalidViewException {
        if (db.on()) {
            db.println("createPanel destView is " + viewName);
        }
        try {
            this.getShelfLayout();
            this.sv = new ShelfViewPanel(this);
            if (this.stv == null) {
                this.stv = new ShelfTabbedView(this.nmd, new ShelfEventPanelController(this), (IGuestPaneFactory)this.uiToolkit);
                this.stv.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
            }
            this.nvsp = new NodeVitalStatsPane(this.nmd);
            this.sv.add(this.ssl);
            JPanel jPanel = new JPanel();
            this.svcl = new DefaultViewControllerLayout(jPanel, "shelf");
            this.svcl.setComponents((JComponent)new UScrollPane((Component)this.sv), (JComponent)((Object)this.stv), this.nvsp);
            return jPanel;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("createPanel failed: " + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            this.localFlushViewPanel(null);
            throw new InvalidViewException(exception.getMessage(), 1);
        }
    }

    private AbstractShelfLayout getShelfLayout() throws Exception {
        if (!this.nmd.isInited() || !this.nmd.getConnectionState()) {
            db.println("NMD.isInited( ) -> " + this.nmd.isInited() + "\n\tNMD.getConnectionState( ) -> " + this.nmd.getConnectionState());
            throw new Exception("Node is disconnected");
        }
        if (this.ssl == null) {
            this.ssl = this.nmd.getPlatform().getShelfLayout(this.nmd, this, this.uiToolkit);
        }
        return this.ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseShelfLayout() {
        if (this.ssl != null) {
            if (db.on()) {
                db.println(this.getViewName() + " releaseShelfLayout");
            }
            if (this.svcl != null) {
                this.svcl.dispose();
            }
            try {
                this.ssl.destroy();
            }
            finally {
                this.ssl = null;
            }
        }
    }

    public AbstractViewController createChildContainerVC(ViewName viewName) throws AbstractInvalidViewException {
        int n = viewName.getSlotId();
        if (db.on()) {
            db.println("Creating CVC for slot " + n);
        }
        if (!this.nmd.isInited()) {
            this.throwInvalidViewException("Node is not ready yet:" + viewName);
        }
        EntityModel entityModel = (EntityModel)this.nmd.getChassis();
        List list = entityModel.getChildrenOfType(eClass.BACKPLANE);
        EntityModel entityModel2 = (EntityModel)list.get(0);
        List list2 = entityModel2.getChildren();
        try {
            EntityModel entityModel3 = (EntityModel)list2.get(n - 1);
            if (entityModel3 == null) {
                this.throwInvalidViewException("Cannot find NodeModel for:" + viewName);
            }
            CardViewController cardViewController = new CardViewController(this, this.nmd, this.uiToolkit, this.nmd.getNodeId(), n);
            return cardViewController;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.throwInvalidViewException("Invalid slot for:" + viewName);
            return null;
        }
    }

    private void postMenuEntries() {
    }

    private void removeMenuEntries() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public JMenuItem getSetupMenu() {
        return this.setupMenuItem;
    }
}

