/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.INodeModel;
import cerent.cms.ui.NodeVersionInfo;
import cerent.util.CEMC;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobListener;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobStatus;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class SoftMaintDataSource
extends AbstractRowDataSource
implements IJobListener {
    public static final String CANCELLING_DOWNLOAD = "cancelling download...";
    private ArrayList nodeVersionInfoList = new ArrayList(0);
    private HashMap runningJobs = new HashMap();
    private int affectedRow;
    private static SoftMaintDataSource instance = null;
    private static INodeModel nodeModel = null;
    private static final SDebug db = new SDebug("SoftMaintDataSource");

    private SoftMaintDataSource() {
    }

    public static SoftMaintDataSource instance() {
        if (instance == null) {
            instance = new SoftMaintDataSource();
        }
        return instance;
    }

    public synchronized void addNode(INodeModel iNodeModel) {
        String string = "";
        if (SoftMaintDataSource.db.on) {
            try {
                string = iNodeModel.getName();
            }
            catch (Exception exception) {
                string = "?????";
            }
            db.println("addNode: trying to add node " + string);
        }
        if (!this.isNodeInList(iNodeModel)) {
            if (SoftMaintDataSource.db.on) {
                db.println("addNode: adding node " + string);
            }
            this.nodeVersionInfoList.add(new NodeVersionInfo(iNodeModel, this));
        }
    }

    public synchronized void deleteNode(NodeVersionInfo nodeVersionInfo) {
        int n = this.nodeVersionInfoList.indexOf(nodeVersionInfo);
        if (n != -1) {
            this.nodeVersionInfoList.remove(n);
            this.update();
        }
    }

    private boolean isNodeInList(INodeModel iNodeModel) {
        boolean bl = false;
        Iterator iterator = this.nodeVersionInfoList.iterator();
        while (iterator.hasNext()) {
            NodeVersionInfo nodeVersionInfo = (NodeVersionInfo)iterator.next();
            if (nodeVersionInfo.getNodeModel() != iNodeModel) continue;
            bl = true;
            break;
        }
        if (SoftMaintDataSource.db.on) {
            db.println("isNodeInList: node=" + iNodeModel.getHostName() + " " + (bl ? "found" : "not found"));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String string, Object[] objectArray, int n) {
        int n2;
        Object object;
        Object object2;
        int n3;
        if (objectArray.length == 0) {
            return;
        }
        JobController jobController = JobControllerFactory.createJC((int)(objectArray.length > n ? n : objectArray.length));
        int n4 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            object2 = (NodeVersionInfo)objectArray[n3];
            object = ((NodeVersionInfo)object2).getNodeModel();
            if (!object.getNeType().startsWith("15600")) continue;
            n2 = 0;
            try {
                n2 = object.isSafeToUpgrade() ? 1 : 0;
                db.fine("safeToUpgrade = " + (n2 != 0));
            }
            catch (AbstractMethodError abstractMethodError) {
                db.fine("15600 thrown AbstractMethodError exception. If it's not 1.0, something broke");
            }
            if (n2 != 0) continue;
            arrayList.add(object);
        }
        n3 = 1;
        if (!arrayList.isEmpty()) {
            object2 = new StringBuffer();
            object = null;
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                object = (INodeModel)arrayList.get(n2);
                ((StringBuffer)object2).append(object.getName() + "\n");
            }
            String string2 = ErrorMsg.getString((EID)CEMC.WID_SW_UPGRADE_TSC_5_ACTIVE);
            n3 = CerentDialog.yesNoWarningDialog((Component)this.getFrame((INodeModel)object), (String)(string2 + ((StringBuffer)object2).toString() + "\nContinue with software upgrade?"), (String)"Warning") ? 1 : 0;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            IJobControl iJobControl;
            object = (NodeVersionInfo)objectArray[i];
            ((NodeVersionInfo)object).setJobController(jobController);
            INodeModel iNodeModel = ((NodeVersionInfo)object).getNodeModel();
            try {
                if (arrayList.contains(iNodeModel) && n3 == 0) continue;
                iJobControl = iNodeModel.createDataTransferJob(string, 3, (IJobProgressControl)object);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                continue;
            }
            JobGroup jobGroup = new JobGroup(iJobControl, (IJobListener)this, object);
            HashMap hashMap = this.runningJobs;
            synchronized (hashMap) {
                this.runningJobs.put(jobGroup, object);
            }
            jobController.submitJob(jobGroup);
            ++n4;
        }
        if (n4 == 0) {
            JobControllerFactory.disposeJC((JobController)jobController);
        }
    }

    public void cancelDownload(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            JobController jobController;
            JobGroup jobGroup = (JobGroup)objectArray[i];
            NodeVersionInfo nodeVersionInfo = (NodeVersionInfo)this.runningJobs.get(jobGroup);
            if (nodeVersionInfo == null || (jobController = nodeVersionInfo.getJobController()) == null) continue;
            if (nodeVersionInfo.getJobStatus().value() != 0) {
                nodeVersionInfo.setStatusString(CANCELLING_DOWNLOAD);
            }
            jobController.abortJob(jobGroup);
        }
    }

    public void setStatusString(INodeModel iNodeModel, String string) {
        if (iNodeModel == null) {
            return;
        }
        NodeVersionInfo nodeVersionInfo = this.getNodeVerInfo(iNodeModel);
        nodeVersionInfo.setStatusString(string);
    }

    public NodeVersionInfo getNodeVerInfo(INodeModel iNodeModel) {
        Iterator iterator = this.nodeVersionInfoList.iterator();
        while (iterator.hasNext()) {
            NodeVersionInfo nodeVersionInfo = (NodeVersionInfo)iterator.next();
            if (nodeVersionInfo.getNodeModel() != iNodeModel) continue;
            return nodeVersionInfo;
        }
        return null;
    }

    public boolean isDownloadInProgress() {
        return this.runningJobs.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getRunningJobs() {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = this.runningJobs;
        synchronized (hashMap2) {
            hashMap = (HashMap)this.runningJobs.clone();
        }
        if (nodeModel == null) {
            return hashMap;
        }
        return this.getRunningJob(hashMap, nodeModel);
    }

    private HashMap getRunningJob(HashMap hashMap, INodeModel iNodeModel) {
        HashMap hashMap2 = new HashMap();
        Set set = hashMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            NodeVersionInfo nodeVersionInfo = (NodeVersionInfo)entry.getValue();
            if (nodeVersionInfo.getNodeModel() != iNodeModel) continue;
            Object k = entry.getKey();
            hashMap2.put(k, nodeVersionInfo);
            return hashMap2;
        }
        return hashMap2;
    }

    public void setNodeModel(INodeModel iNodeModel) {
        nodeModel = iNodeModel;
    }

    public int getRowCount() {
        if (nodeModel == null) {
            return this.nodeVersionInfoList.size();
        }
        return 1;
    }

    public Object getObjectAtRow(int n) {
        if (nodeModel == null) {
            return this.nodeVersionInfoList.get(n);
        }
        return this.getNodeVerInfo(nodeModel);
    }

    public Collection getAllObjects() {
        if (nodeModel == null) {
            return this.nodeVersionInfoList;
        }
        ArrayList<NodeVersionInfo> arrayList = new ArrayList<NodeVersionInfo>();
        arrayList.add(this.getNodeVerInfo(nodeModel));
        return arrayList;
    }

    public void jobWaiting(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
        ((NodeVersionInfo)object).setJobStatus(jobStatus);
    }

    public void jobRunning(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
        ((NodeVersionInfo)object).setJobStatus(jobStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobFinished(JobGroup jobGroup, IJobControl iJobControl, final JobStatus jobStatus, final Object object) {
        HashMap hashMap = this.runningJobs;
        synchronized (hashMap) {
            this.runningJobs.remove(jobGroup);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SoftMaintDataSource.this.finishJob(jobStatus, (NodeVersionInfo)object);
            }
        });
    }

    private void finishJob(JobStatus jobStatus, NodeVersionInfo nodeVersionInfo) {
        Exception exception;
        nodeVersionInfo.setJobStatus(jobStatus);
        JobController jobController = nodeVersionInfo.getJobController();
        nodeVersionInfo.setJobController(null);
        if (jobStatus.value() == 2 && (exception = (Exception)jobStatus.getResult()) != null) {
            String string = ErrorMsg.getString((EID)CEMC.EID_SW_DOWNLOAD_FAILED_PARAM_1, (Object)nodeVersionInfo.getNodeModel().getName());
            DetailedLog detailedLog = new DetailedLog(3, string, exception);
            EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
        }
        if (jobController != null && jobController.isIdle()) {
            JobControllerFactory.disposeJC((JobController)jobController);
        }
    }

    private Frame getFrame(INodeModel iNodeModel) {
        return iNodeModel.getUiToolkit().getApplicationFrame();
    }

    private void fire() {
        this.fireDataSourceChanged();
    }

    public void update() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fire();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SoftMaintDataSource.this.fire();
                }
            });
        }
    }

    public void dispose() {
        block3: {
            try {
                Iterator iterator = this.nodeVersionInfoList.iterator();
                while (iterator.hasNext()) {
                    NodeVersionInfo nodeVersionInfo = (NodeVersionInfo)iterator.next();
                    nodeVersionInfo.dispose();
                }
            }
            catch (Exception exception) {
                if (!SoftMaintDataSource.db.on) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }
}

