/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.gui.row.SortableRowTableModel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TablePropertyMgr {
    public static final String PREFS_CTC = "ctc";
    public static final String PREFS_HIDDEN = "hidden";
    public static final String PREFS_ORDER = "order";
    public static final String PREFS_SORT_DIR = "sort_dir";
    public static final String PREFS_SORT_COL = "sort_col";
    public static final String PREFS_SORT_NUM = "sort_num";
    public static final String PREFS_WIDTH = "width";
    private static final SDebug dbg = new SDebug("TablePropertyMgr");
    private static final int DEFAULT_WIDTH = 75;
    private static Preferences prefs = Preferences.instance();

    public static void setColumnPrefs(JTable jTable, String string) {
        Object[] objectArray;
        String string2 = TablePropertyMgr.getParsedName(string);
        if (jTable == null) {
            if (dbg.on()) {
                dbg.println("setColumnPrefs: " + string2 + " table is null");
            }
            return;
        }
        TableModel tableModel = jTable.getModel();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            objectArray = tableColumnModel.getColumn(i);
            stringArray[i] = objectArray.getIdentifier().toString();
            stringArray2[i] = new Integer(objectArray.getWidth()).toString();
        }
        prefs.setPropertyArray(PREFS_CTC, string2 + '.' + PREFS_ORDER, stringArray);
        prefs.setPropertyArray(PREFS_CTC, string2 + '.' + PREFS_WIDTH, stringArray2);
        if (tableModel instanceof SortableRowTableModel) {
            String[] stringArray3 = new String[((SortableRowTableModel)((Object)tableModel)).getHiddenColumns().size()];
            objectArray = ((SortableRowTableModel)((Object)tableModel)).getHiddenColumns().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray3[i] = ((TableColumn)objectArray[i]).getIdentifier().toString();
            }
            prefs.setPropertyArray(PREFS_CTC, string2 + '.' + PREFS_HIDDEN, stringArray3);
            String[] stringArray4 = TablePropertyMgr.boolToStringArray(((SortableRowTableModel)((Object)tableModel)).getSortDir());
            String[] stringArray5 = TablePropertyMgr.intToStringArray(((SortableRowTableModel)((Object)tableModel)).getSortCols());
            int n2 = ((SortableRowTableModel)((Object)tableModel)).getNbSortCols();
            prefs.setPropertyArray(PREFS_CTC, string2 + '.' + PREFS_SORT_DIR, stringArray4);
            prefs.setPropertyArray(PREFS_CTC, string2 + '.' + PREFS_SORT_COL, stringArray5);
            prefs.setInt(PREFS_CTC, string2 + '.' + PREFS_SORT_NUM, n2);
        }
    }

    public static void getColumnPrefs(JTable jTable, String string) {
        block21: {
            int n;
            int[] nArray;
            boolean[] blArray;
            TableModel tableModel;
            String string2;
            block20: {
                string2 = TablePropertyMgr.getParsedName(string);
                if (jTable == null) {
                    if (dbg.on()) {
                        dbg.println("getColumnPrefs: " + string2 + " table is null");
                    }
                    return;
                }
                TableColumnModel tableColumnModel = jTable.getColumnModel();
                tableModel = jTable.getModel();
                blArray = null;
                nArray = null;
                n = 0;
                String[] stringArray = null;
                if (tableModel instanceof SortableRowTableModel) {
                    try {
                        stringArray = prefs.getPropertyArray(PREFS_CTC, string2 + '.' + PREFS_HIDDEN, null);
                        if (stringArray == null) {
                            ((SortableRowTableModel)((Object)tableModel)).useDefaultHiding();
                        } else {
                            ((SortableRowTableModel)((Object)tableModel)).restoreHidingPrefs(stringArray);
                        }
                    }
                    catch (Exception exception) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
                try {
                    String[] stringArray2 = prefs.getPropertyArray(PREFS_CTC, string2 + '.' + PREFS_ORDER, null);
                    String[] stringArray3 = prefs.getPropertyArray(PREFS_CTC, string2 + '.' + PREFS_WIDTH, null);
                    if (stringArray2 != null) {
                        int n2;
                        TableColumn tableColumn;
                        int n3;
                        int n4;
                        int n5 = Math.min(tableModel.getColumnCount(), jTable.getColumnCount());
                        for (n4 = 0; n4 < stringArray2.length; ++n4) {
                            for (n3 = 0; n3 < n5; ++n3) {
                                tableColumn = tableColumnModel.getColumn(n3);
                                n2 = tableColumnModel.getColumnIndex(tableColumn.getIdentifier());
                                if (!stringArray2[n4].equals(tableColumn.getIdentifier()) || n4 == n2 || n4 >= n5) continue;
                                jTable.moveColumn(n2, n4);
                            }
                        }
                        if (stringArray3 != null) {
                            for (n4 = 0; n4 < stringArray3.length; ++n4) {
                                for (n3 = 0; n3 < n5; ++n3) {
                                    tableColumn = tableColumnModel.getColumn(n3);
                                    n2 = tableColumnModel.getColumnIndex(tableColumn.getIdentifier());
                                    if (!stringArray2[n4].equals(tableColumn.getIdentifier())) continue;
                                    tableColumn.setPreferredWidth(Integer.parseInt(stringArray3[n4]));
                                }
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    if (!dbg.on()) break block20;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (tableModel instanceof SortableRowTableModel) {
                try {
                    blArray = TablePropertyMgr.stringToBoolArray(prefs.getPropertyArray(PREFS_CTC, string2 + '.' + PREFS_SORT_DIR, null));
                    nArray = TablePropertyMgr.stringToIntArray(prefs.getPropertyArray(PREFS_CTC, string2 + '.' + PREFS_SORT_COL, null));
                    n = prefs.getInt(PREFS_CTC, string2 + '.' + PREFS_SORT_NUM, 0);
                    if (nArray == null || blArray == null) {
                        ((SortableRowTableModel)((Object)tableModel)).useDefaultSorting();
                    } else {
                        ((SortableRowTableModel)((Object)tableModel)).restoreSortingPrefs(nArray, blArray, n);
                    }
                }
                catch (Exception exception) {
                    if (!dbg.on()) break block21;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    private static String getParsedName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        return string.substring(n + 1);
    }

    private static boolean[] stringToBoolArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            blArray[i] = new Boolean(stringArray[i]);
        }
        return blArray;
    }

    private static String[] boolToStringArray(boolean[] blArray) {
        if (blArray == null) {
            return null;
        }
        String[] stringArray = new String[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            stringArray[i] = new Boolean(blArray[i]).toString();
        }
        return stringArray;
    }

    private static int[] stringToIntArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    private static String[] intToStringArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = Integer.toString(nArray[i]);
        }
        return stringArray;
    }
}

