/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.aic;

import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.EventInfo;
import cerent.cms.ui.aic.AbstractAicEnvAlarmTableModel;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Observable;

public class AicEnvAlarmMaintTableModel
extends AbstractAicEnvAlarmTableModel {
    public static final int LINENUMBER_INDEX = 0;
    public static final int RAISED_INDEX = 1;
    public static final int CONTACT_STATE_INDEX = 2;
    public static final int ALARM_TYPE_INDEX = 3;
    public static final int SEVERITY_INDEX = 4;
    public static final int VIRTUAL_WIRE_INDEX = 5;
    public static final int DESCRIPTION_INDEX = 6;
    private static final SDebug dbmaint = new SDebug("EnvAlrmMaint");
    private static final String[] maintColNames = new String[]{"Input#", "Raised", "Contact Status", "Alarm Type", "Severity", "Virtual Wire", "Description"};
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    public AicEnvAlarmMaintTableModel(INodeModel iNodeModel, EnvAlarmModel[] envAlarmModelArray) {
        this(iNodeModel, envAlarmModelArray, envAlarmModelArray);
    }

    public AicEnvAlarmMaintTableModel(INodeModel iNodeModel, EnvAlarmModel[] envAlarmModelArray, EnvAlarmModel[] envAlarmModelArray2) {
        super(iNodeModel, envAlarmModelArray, envAlarmModelArray2);
        this.db = dbmaint;
        this.columnNames = maintColNames;
        int n = envAlarmModelArray2[0].getSlot();
        ElementAlarmStore elementAlarmStore = (ElementAlarmStore)iNodeModel.getElementAlarmStore();
        this.alarmStore = elementAlarmStore.getAlarmStore(n);
        Observable observable = this.alarmStore.getAlarmStatusObservable();
        this.observableManager.addObservable(observable);
        this.updateEnvRaisedState();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = AicEnvAlarmMaintTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = AicEnvAlarmMaintTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public Object getValueAt(int n, int n2) {
        if (this.settings[n] == null) {
            return this.getDefaultValue(n2);
        }
        try {
            switch (n2) {
                case 0: {
                    return Integer.toString(n + 1);
                }
            }
            if (this.settings[n].enabled) {
                switch (n2) {
                    case 3: {
                        return this.alarmType[n];
                    }
                    case 4: {
                        return this.severity[n];
                    }
                    case 5: {
                        return this.virtualWire[n];
                    }
                    case 1: {
                        return this.getBoolean(this.raised[n]);
                    }
                    case 2: {
                        boolean bl = this.settings[n].raisedWhenClosed ? this.raised[n] : !this.raised[n];
                        return this.getPrintableContactStatus(bl);
                    }
                    case 6: {
                        return this.settings[n].description;
                    }
                }
            }
            if (n2 == 1) {
                return Boolean.FALSE;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return this.getDefaultValue(n2);
    }

    private Object getDefaultValue(int n) {
        if (n == 1) {
            return this.getBoolean(false);
        }
        return "";
    }

    public void setValueAt(Object object, int n, int n2) {
        if (this.db.on()) {
            this.db.println("setValueAt( " + object + ", " + n + ", " + n2 + ")");
        }
    }

    private synchronized void updateEnvRaisedState() {
        if (this.alarmStore != null) {
            ArrayList arrayList = this.alarmStore.getAlarmByCondition(1);
            if (this.db.on) {
                this.db.println("Env Input: alarms retrieved =" + arrayList.size());
            }
            block0: for (int i = 0; i < this.numLines; ++i) {
                int n = this.alarmStoreModels[i].getEntityIndex();
                for (int j = 0; j < arrayList.size(); ++j) {
                    EventInfo eventInfo = (EventInfo)arrayList.get(j);
                    if (eventInfo.getIndex() != n) continue;
                    boolean bl = this.raised[i] = eventInfo.getState() == 'R';
                    if (!this.db.on) continue block0;
                    this.db.println("detected change of raised state on #" + i + " raised=" + this.raised[i]);
                    continue block0;
                }
                this.raised[i] = false;
            }
        }
    }

    public void refreshFromModel() throws Exception {
        if (this.db.on) {
            this.db.println("Refreshing");
        }
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLine(i);
        }
        this.updateEnvRaisedState();
        super.refreshFromModel();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

