/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.aic;

import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OhTermModel;
import cerent.cms.model.OhTerms;
import cerent.cms.ui.RoDataSourceControl;
import cerent.cms.ui.aic.AicOhTermPane;
import cerent.cms.ui.aic.AicOhTermRowObject;
import cerent.util.IObservableManager;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class AicOhTermDataSource
extends AbstractRowDataSource
implements Observer,
RoDataSourceControl {
    private ModuleModel moduleModel;
    private List ohTerms = new ArrayList();
    private ObservableManager observableManager;
    private OhTerms ohTermsObj;
    private static final SDebug db = new SDebug((KDebug)AicOhTermPane.db, "AicOhTermDataSource");

    public AicOhTermDataSource(Object object) {
        if (db.on()) {
            db.fine("<init>");
        }
        this.moduleModel = (ModuleModel)object;
        OhConnectionModelsDelegate ohConnectionModelsDelegate = (OhConnectionModelsDelegate)this.moduleModel.getNodeModelDelegate().getOhConnectionModels();
        this.ohTermsObj = ohConnectionModelsDelegate.getOhTerms();
        Observable[] observableArray = new Observable[]{ohConnectionModelsDelegate, this.ohTermsObj};
        this.observableManager = new ObservableManager(this, true, observableArray);
        this.observableManager.setPassing(true);
    }

    private void deleteModel(OhTermModel ohTermModel) {
        if (db.on()) {
            db.fine("deleteModel - " + ohTermModel);
        }
        this.observableManager.removeObservable((Observable)((Object)ohTermModel));
        Iterator iterator = this.ohTerms.iterator();
        while (iterator.hasNext()) {
            AicOhTermRowObject aicOhTermRowObject = (AicOhTermRowObject)iterator.next();
            if (!aicOhTermRowObject.getOhTermModel().equals(ohTermModel)) continue;
            if (db.on()) {
                db.fine("Find model - " + ohTermModel);
            }
            this.ohTerms.remove(aicOhTermRowObject);
            return;
        }
    }

    public void refreshFromModel() {
        if (db.on()) {
            db.println("refreshFromModel");
        }
        this.addModels();
        this.fireDataSourceChanged();
    }

    private void addModels() {
        if (db.on()) {
            db.fine("addNewModels");
        }
        HashSet hashSet = new HashSet(this.ohTermsObj.getNonSdccTermModels());
        HashSet<OhTermModel> hashSet2 = new HashSet<OhTermModel>();
        Iterator iterator = this.ohTerms.iterator();
        while (iterator.hasNext()) {
            hashSet2.add(((AicOhTermRowObject)iterator.next()).getOhTermModel());
        }
        hashSet.removeAll(hashSet2);
        if (db.on()) {
            db.fine("find " + hashSet.size() + " new OhTerms");
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            OhTermModel ohTermModel = (OhTermModel)iterator.next();
            this.ohTerms.add(new AicOhTermRowObject(ohTermModel));
            this.observableManager.addObservable((Observable)((Object)ohTermModel));
            if (!db.on()) continue;
            db.println("Add new model - " + ohTermModel);
        }
    }

    public void refreshFromModel(int n) throws Exception {
        this.refreshFromModel();
    }

    public IObservableManager getObservableManager() {
        return this.observableManager;
    }

    public void disposeDataSource() {
        if (this.ohTerms != null) {
            this.ohTerms.clear();
        }
    }

    public Object getObjectAtRow(int n) {
        return this.ohTerms.get(n);
    }

    public int getRowCount() {
        return this.ohTerms.size();
    }

    public Collection getAllObjects() {
        return this.ohTerms;
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.info("update: src = " + observable + ", evt = " + object);
        }
        try {
            if (observable instanceof OhTerms && object == ModelUpdateType.ADDED) {
                this.addModels();
            }
            if (observable instanceof OhTermModel && object == ModelUpdateType.DELETED) {
                this.deleteModel((OhTermModel)((Object)observable));
            }
            if (observable instanceof OhConnectionModelsDelegate && object != ModelUpdateType.CHANGED) {
                return;
            }
            this.fireDataSourceChanged();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }
}

