/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.aic;

import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.OrderwireModel;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.UnimplementedPane;
import cerent.cms.ui.aic.AicEnvAlarmPane;
import cerent.cms.ui.aic.AicEnvControlPane;
import cerent.cms.ui.aic.AicProvOrderwirePane;
import java.awt.Component;

public class AicProvPane
extends NodeProvPane
implements ITabName {
    protected static final int LOCAL_ORDERWIRE_NUM = 0;
    protected static final int EXPRESS_ORDERWIRE_NUM = 1;
    private static final String[] orderWireNotes = new String[]{null, "Take care to prevent provisioning of EOW loops as this will render EOW unusable"};

    public AicProvPane(String string, TabbedView tabbedView, EnvAlarmModel[] envAlarmModelArray, EnvControlModel[] envControlModelArray, OrderwireModel[] orderwireModelArray) {
        this(string, tabbedView, envAlarmModelArray);
        this.subTabs.setTabPlacement(2);
        this.init(envAlarmModelArray, envControlModelArray, orderwireModelArray);
    }

    public AicProvPane(String string, TabbedView tabbedView, EnvAlarmModel[] envAlarmModelArray) {
        super(string, tabbedView);
        this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
    }

    protected void init(EnvAlarmModel[] envAlarmModelArray, EnvControlModel[] envControlModelArray, OrderwireModel[] orderwireModelArray) {
        this.subTabs.addTab("External Alarms", (Component)this.getEnvAlarmTab(envAlarmModelArray));
        this.subTabs.addTab("External Controls", (Component)this.getEnvControlTab(envControlModelArray));
        this.subTabs.addTab("Local Orderwire", (Component)this.getLocalOrderwireTab(orderwireModelArray));
        this.subTabs.addTab("Express Orderwire", (Component)this.getExpressOrderwireTab(orderwireModelArray));
        this.add((Component)this.subTabs);
    }

    protected Pane getEnvAlarmTab(EnvAlarmModel[] envAlarmModelArray) {
        if (envAlarmModelArray != null) {
            return new AicEnvAlarmPane("External Alarms", this.getParentView(), envAlarmModelArray, 0);
        }
        return new UnimplementedPane("External Alarms", this.getParentView());
    }

    protected Pane getEnvControlTab(EnvControlModel[] envControlModelArray) {
        if (envControlModelArray != null) {
            return new AicEnvControlPane("External Controls", this.getParentView(), envControlModelArray, 0);
        }
        return new UnimplementedPane("External Controls", this.getParentView());
    }

    private Pane getExpressOrderwireTab(OrderwireModel[] orderwireModelArray) {
        String string;
        try {
            string = orderWireNotes[1];
        }
        catch (Exception exception) {
            string = null;
        }
        OrderwireModel orderwireModel = this.getOrderwireModel(orderwireModelArray, 1);
        if (orderwireModel != null) {
            return this.getOrderwirePane("Express Orderwire", this.getParentView(), orderwireModel, string);
        }
        return new UnimplementedPane("Express Orderwire", this.getParentView());
    }

    private Pane getLocalOrderwireTab(OrderwireModel[] orderwireModelArray) {
        String string;
        try {
            string = orderWireNotes[0];
        }
        catch (Exception exception) {
            string = null;
        }
        OrderwireModel orderwireModel = this.getOrderwireModel(orderwireModelArray, 0);
        if (orderwireModel != null) {
            return this.getOrderwirePane("Local Orderwire", this.getParentView(), orderwireModel, string);
        }
        return new UnimplementedPane("Local Orderwire", this.getParentView());
    }

    protected OrderwireModel getOrderwireModel(OrderwireModel[] orderwireModelArray, int n) {
        if (orderwireModelArray != null && orderwireModelArray.length > 0) {
            int n2 = orderwireModelArray[0].getPositionInParent();
            int n3 = 0;
            if (n == 0) {
                for (int i = 1; i < orderwireModelArray.length; ++i) {
                    if (orderwireModelArray[i].getPositionInParent() >= n2) continue;
                    n2 = orderwireModelArray[i].getPositionInParent();
                    n3 = i;
                }
            } else {
                for (int i = 1; i < orderwireModelArray.length; ++i) {
                    if (orderwireModelArray[i].getPositionInParent() <= n2) continue;
                    n2 = orderwireModelArray[i].getPositionInParent();
                    n3 = i;
                }
            }
            return orderwireModelArray[n3];
        }
        return null;
    }

    public boolean hasSubTabs() {
        return true;
    }

    protected Pane getOrderwirePane(String string, TabbedView tabbedView, OrderwireModel orderwireModel, String string2) {
        return new AicProvOrderwirePane(string, tabbedView, orderwireModel, string2);
    }
}

