/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.aic;

import cerent.cms.idl.Equipment.eAlarmSeverityRank;
import cerent.cms.idl.Equipment.eEnvCtrlMode;
import cerent.cms.idl.Equipment.eEnvCtrlType;
import cerent.cms.idl.Equipment.eTriggerType;
import cerent.cms.idl.Equipment.eVirtWire;
import cerent.cms.idl.Equipment.sEnvCtrlManOverRide;
import cerent.cms.idl.Equipment.sEnvCtrlOutputConfig;
import cerent.cms.idl.Equipment.uTriggerInfo;
import cerent.cms.model.Attribute;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EnvControlModel;
import cerent.util.SDebug;
import java.lang.reflect.Method;

public class EnvCtrlSetting {
    protected static Method discriminatorMethod = null;
    private static final String PREFIX = "AICControl.";
    private EnvControlModel model;
    public sEnvCtrlOutputConfig outputConfig;
    sEnvCtrlManOverRide manOverride;
    boolean autoClosed;
    boolean currClosed;
    private Attribute modeAttr;
    private Attribute typeAttr;
    private Attribute triggerAttr;
    private static final SDebug db = new SDebug("EnvCtrlSetting");
    static /* synthetic */ Class class$cerent$cms$idl$Equipment$eEnvCtrlType;
    static /* synthetic */ Class class$cerent$cms$idl$Equipment$eEnvCtrlMode;
    static /* synthetic */ Class class$cerent$cms$idl$Equipment$uTriggerInfo;

    public EnvCtrlSetting(EnvControlModel envControlModel) {
        this.model = envControlModel;
    }

    public void refresh() {
        block3: {
            try {
                this.outputConfig = this.model.settings();
                this.manOverride = this.model.manOverRide();
                this.autoClosed = this.model.autoClosed();
                this.currClosed = this.model.currClosed();
                this.typeAttr = this.getAttributeFor((class$cerent$cms$idl$Equipment$eEnvCtrlType == null ? (class$cerent$cms$idl$Equipment$eEnvCtrlType = EnvCtrlSetting.class$("cerent.cms.idl.Equipment.eEnvCtrlType")) : class$cerent$cms$idl$Equipment$eEnvCtrlType).getName(), this.outputConfig.type.value());
                if (this.typeAttr == null) {
                    this.typeAttr = this.getAttributeFor((class$cerent$cms$idl$Equipment$eEnvCtrlType == null ? (class$cerent$cms$idl$Equipment$eEnvCtrlType = EnvCtrlSetting.class$("cerent.cms.idl.Equipment.eEnvCtrlType")) : class$cerent$cms$idl$Equipment$eEnvCtrlType).getName(), 7);
                }
                this.triggerAttr = this.getAttributeForTrigger(this.outputConfig.triggerInfo);
                this.modeAttr = this.getAttributeFor((class$cerent$cms$idl$Equipment$eEnvCtrlMode == null ? (class$cerent$cms$idl$Equipment$eEnvCtrlMode = EnvCtrlSetting.class$("cerent.cms.idl.Equipment.eEnvCtrlMode")) : class$cerent$cms$idl$Equipment$eEnvCtrlMode).getName(), this.manOverride.mode.value());
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (!db.on()) break block3;
                db.println("Caught CmsObjectNotExistException in EnvCtrlSetting refresh");
            }
        }
    }

    public void submit() {
        this.model.settings(this.outputConfig);
        this.model.manOverRide(this.manOverride);
    }

    protected static int discriminatorValue(uTriggerInfo uTriggerInfo2) {
        Object object;
        int n = -1;
        if (discriminatorMethod == null) {
            Method method;
            object = new StringBuffer("discriminator");
            Class clazz = class$cerent$cms$idl$Equipment$uTriggerInfo == null ? (class$cerent$cms$idl$Equipment$uTriggerInfo = EnvCtrlSetting.class$("cerent.cms.idl.Equipment.uTriggerInfo")) : class$cerent$cms$idl$Equipment$uTriggerInfo;
            try {
                method = clazz.getMethod(((StringBuffer)object).toString(), null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ((StringBuffer)object).insert(0, '_');
                try {
                    method = clazz.getMethod(((StringBuffer)object).toString(), null);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    return n;
                }
                catch (SecurityException securityException) {
                    return n;
                }
            }
            catch (SecurityException securityException) {
                return n;
            }
            discriminatorMethod = method;
        }
        try {
            object = (eTriggerType)discriminatorMethod.invoke((Object)uTriggerInfo2, null);
            n = ((eTriggerType)object).value();
        }
        catch (Exception exception) {
            db.fine("Exception in discriminatorValue() " + exception);
        }
        return n;
    }

    void print(SDebug sDebug, String string) {
        if (sDebug.on && this.outputConfig.enabled) {
            switch (EnvCtrlSetting.discriminatorValue(this.outputConfig.triggerInfo)) {
                case 0: {
                    sDebug.print(" locAlrm=" + this.outputConfig.triggerInfo.localAlrmRank().value());
                    break;
                }
                case 1: {
                    sDebug.print(" remAlrm=" + this.outputConfig.triggerInfo.rmtAlrmRank().value());
                    break;
                }
                case 2: {
                    sDebug.print(" vw=" + this.outputConfig.triggerInfo.virtualWireNumber().value());
                }
            }
            sDebug.print(" desc=" + this.outputConfig.description);
            sDebug.print(" manOvrActive=" + this.manOverride.manOvrActive);
            sDebug.println(" manOvrMode=" + this.manOverride.mode.value());
        }
    }

    Attribute getTrigger() {
        return this.triggerAttr;
    }

    Attribute getType() {
        return this.typeAttr;
    }

    Attribute getManOverride() {
        return this.modeAttr;
    }

    public void setTrigger(Attribute attribute) {
        this.triggerAttr = attribute;
        this.outputConfig.triggerInfo = this.getTriggerInfoFromInt(this.triggerAttr.getIntValue());
    }

    void setType(Attribute attribute) {
        this.typeAttr = attribute;
        this.outputConfig.type = eEnvCtrlType.from_int(this.typeAttr.getIntValue());
    }

    void setManOverride(Attribute attribute) {
        this.modeAttr = attribute;
        this.manOverride.mode = eEnvCtrlMode.from_int(attribute.getIntValue());
        this.manOverride.manOvrActive = this.manOverride.mode.value() != 0;
    }

    private Attribute getAttributeForTrigger(uTriggerInfo uTriggerInfo2) {
        int n = EnvCtrlSetting.discriminatorValue(uTriggerInfo2);
        switch (n) {
            case 0: {
                return this.getAttributeForLocalAlarm(uTriggerInfo2.localAlrmRank());
            }
            case 1: {
                return this.getAttributeForRemoteAlarm(uTriggerInfo2.rmtAlrmRank());
            }
            case 2: {
                return this.getAttributeForVirtualWire(uTriggerInfo2.virtualWireNumber());
            }
        }
        return null;
    }

    public Attribute getAttributeForLocalAlarm(eAlarmSeverityRank eAlarmSeverityRank2) {
        switch (eAlarmSeverityRank2.value()) {
            case 3: {
                return this.getAttributeFor((class$cerent$cms$idl$Equipment$uTriggerInfo == null ? (class$cerent$cms$idl$Equipment$uTriggerInfo = EnvCtrlSetting.class$("cerent.cms.idl.Equipment.uTriggerInfo")) : class$cerent$cms$idl$Equipment$uTriggerInfo).getName(), 0);
            }
            case 4: {
                return this.getAttributeFor((class$cerent$cms$idl$Equipment$uTriggerInfo == null ? (class$cerent$cms$idl$Equipment$uTriggerInfo = EnvCtrlSetting.class$("cerent.cms.idl.Equipment.uTriggerInfo")) : class$cerent$cms$idl$Equipment$uTriggerInfo).getName(), 1);
            }
            case 5: {
                return this.getAttributeFor((class$cerent$cms$idl$Equipment$uTriggerInfo == null ? (class$cerent$cms$idl$Equipment$uTriggerInfo = EnvCtrlSetting.class$("cerent.cms.idl.Equipment.uTriggerInfo")) : class$cerent$cms$idl$Equipment$uTriggerInfo).getName(), 2);
            }
        }
        return null;
    }

    public Attribute getAttributeForRemoteAlarm(eAlarmSeverityRank eAlarmSeverityRank2) {
        switch (eAlarmSeverityRank2.value()) {
            case 3: {
                return this.getAttributeFor((class$cerent$cms$idl$Equipment$uTriggerInfo == null ? (class$cerent$cms$idl$Equipment$uTriggerInfo = EnvCtrlSetting.class$("cerent.cms.idl.Equipment.uTriggerInfo")) : class$cerent$cms$idl$Equipment$uTriggerInfo).getName(), 3);
            }
            case 4: {
                return this.getAttributeFor((class$cerent$cms$idl$Equipment$uTriggerInfo == null ? (class$cerent$cms$idl$Equipment$uTriggerInfo = EnvCtrlSetting.class$("cerent.cms.idl.Equipment.uTriggerInfo")) : class$cerent$cms$idl$Equipment$uTriggerInfo).getName(), 4);
            }
            case 5: {
                return this.getAttributeFor((class$cerent$cms$idl$Equipment$uTriggerInfo == null ? (class$cerent$cms$idl$Equipment$uTriggerInfo = EnvCtrlSetting.class$("cerent.cms.idl.Equipment.uTriggerInfo")) : class$cerent$cms$idl$Equipment$uTriggerInfo).getName(), 5);
            }
        }
        return null;
    }

    public Attribute getAttributeForVirtualWire(eVirtWire eVirtWire2) {
        switch (eVirtWire2.value()) {
            case 1: {
                return this.getAttributeFor((class$cerent$cms$idl$Equipment$uTriggerInfo == null ? (class$cerent$cms$idl$Equipment$uTriggerInfo = EnvCtrlSetting.class$("cerent.cms.idl.Equipment.uTriggerInfo")) : class$cerent$cms$idl$Equipment$uTriggerInfo).getName(), 6);
            }
            case 2: {
                return this.getAttributeFor((class$cerent$cms$idl$Equipment$uTriggerInfo == null ? (class$cerent$cms$idl$Equipment$uTriggerInfo = EnvCtrlSetting.class$("cerent.cms.idl.Equipment.uTriggerInfo")) : class$cerent$cms$idl$Equipment$uTriggerInfo).getName(), 7);
            }
            case 3: {
                return this.getAttributeFor((class$cerent$cms$idl$Equipment$uTriggerInfo == null ? (class$cerent$cms$idl$Equipment$uTriggerInfo = EnvCtrlSetting.class$("cerent.cms.idl.Equipment.uTriggerInfo")) : class$cerent$cms$idl$Equipment$uTriggerInfo).getName(), 8);
            }
        }
        return this.getAttributeFor((class$cerent$cms$idl$Equipment$uTriggerInfo == null ? (class$cerent$cms$idl$Equipment$uTriggerInfo = EnvCtrlSetting.class$("cerent.cms.idl.Equipment.uTriggerInfo")) : class$cerent$cms$idl$Equipment$uTriggerInfo).getName(), 9);
    }

    protected uTriggerInfo getTriggerInfoFromInt(int n) {
        uTriggerInfo uTriggerInfo2 = new uTriggerInfo();
        switch (n) {
            case 0: {
                uTriggerInfo2.localAlrmRank(eAlarmSeverityRank.HIGHWATER_MINOR);
                return uTriggerInfo2;
            }
            case 1: {
                uTriggerInfo2.localAlrmRank(eAlarmSeverityRank.HIGHWATER_MAJOR);
                return uTriggerInfo2;
            }
            case 2: {
                uTriggerInfo2.localAlrmRank(eAlarmSeverityRank.HIGHWATER_CRITICAL);
                return uTriggerInfo2;
            }
            case 3: {
                uTriggerInfo2.rmtAlrmRank(eAlarmSeverityRank.HIGHWATER_MINOR);
                return uTriggerInfo2;
            }
            case 4: {
                uTriggerInfo2.rmtAlrmRank(eAlarmSeverityRank.HIGHWATER_MAJOR);
                return uTriggerInfo2;
            }
            case 5: {
                uTriggerInfo2.rmtAlrmRank(eAlarmSeverityRank.HIGHWATER_CRITICAL);
                return uTriggerInfo2;
            }
            case 6: {
                uTriggerInfo2.virtualWireNumber(eVirtWire.VIRT_WIRE_1);
                return uTriggerInfo2;
            }
            case 7: {
                uTriggerInfo2.virtualWireNumber(eVirtWire.VIRT_WIRE_2);
                return uTriggerInfo2;
            }
            case 8: {
                uTriggerInfo2.virtualWireNumber(eVirtWire.VIRT_WIRE_3);
                return uTriggerInfo2;
            }
            case 9: {
                uTriggerInfo2.virtualWireNumber(eVirtWire.VIRT_WIRE_4);
                return uTriggerInfo2;
            }
        }
        return null;
    }

    protected Attribute getAttributeFor(String string, int n) {
        return ElementDefaults.getAttributeMap(this.model).getAttributeForVal(PREFIX + string, n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

