/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ampli.AmpliModeTableModel;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.util.NoSuchElementException;
import java.util.Observable;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class AmpliModeMaintenancePane
extends NodeProvPane
implements TableModelListener {
    private AmpliModeTableModel dataModel;
    protected OpticsModuleModel eqpmtModel;
    protected AbstractOpticsLineModel[] lineModels;
    protected int numLines;
    private boolean notInited = true;
    protected static final SDebug db = new SDebug("AbstractOadmParametersProvPane");

    public AmpliModeMaintenancePane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.init();
    }

    protected void init() {
        this.eqpmtModel = (OpticsModuleModel)this.getUiModel();
        this.numLines = 1;
        this.dataModel = new AmpliModeTableModel();
        this.dataModel.addTableModelListener(this);
        this.table = new JTable(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.prepareColumns();
        this.registerWithModel();
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.table.setAutoResizeMode(0);
        this.notInited = false;
    }

    protected void prepareColumns() {
        TableColumn tableColumn = this.table.getColumn(AmpliModeTableModel.columnNames[0]);
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxForSystemType()));
        tableColumn.setPreferredWidth(90);
        tableColumn = this.table.getColumn(AmpliModeTableModel.columnNames[1]);
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(180);
    }

    protected void setAttrCellEditor(int n, String string) {
        this.setAttrCellEditor(n, string, -1);
    }

    protected void setAttrCellEditor(int n, String string, int n2) {
        TableColumn tableColumn = this.table.getColumn(AmpliModeTableModel.columnNames[n]);
        try {
            Attribute[] attributeArray = this.getAttributeArray(string);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
            if (n2 == -1) {
                tableColumn.setPreferredWidth(tableColumn.getWidth());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            db.println("WARNING: cannot find attributes for " + string + "\nPlease edit ElementDefaults.java");
            this.table.removeColumn(tableColumn);
        }
    }

    protected void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(AmpliModeTableModel.columnNames[n]);
        this.table.removeColumn(tableColumn);
    }

    protected JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public Attribute[] getAttributeArray(String string) throws NoSuchElementException {
        Attribute[] attributeArray = ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeArray(string);
        if (attributeArray == null) {
            throw new NoSuchElementException();
        }
        return attributeArray;
    }

    protected JComboBox getComboBoxForSystemType() {
        JComboBox<String> jComboBox = new JComboBox<String>(this.dataModel.getSystemTypeStrings());
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws Exception {
        this.resetDirty();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                AmpliModeMaintenancePane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        if (db.on()) {
            db.println("Refreshing Line 1");
        }
        this.dataModel.refreshLineFromModel(1);
    }

    protected void registerWithModel() {
        for (int i = 0; i < this.numLines; ++i) {
        }
    }

    public void destroy() {
        for (int i = 0; i < this.numLines; ++i) {
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }
}

