/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.idl.OpticsTopology.sParameterKey;
import cerent.cms.model.ANS.ANSElement;
import cerent.cms.model.ANS.ANSNode;
import cerent.cms.model.ANS.IANSElement;
import cerent.cms.model.ANS.IANSNode;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.DataSourceControl;
import cerent.cms.ui.ans.ANSHelper;
import cerent.cms.ui.ans.ANSTableModel;
import cerent.cms.ui.shelf.SppAnsNeUpdatePane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.Comparator;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ANSController
implements DataSourceControl,
Observer,
Runnable {
    private static final String PROP_PREF = "ctc.defaults";
    private static final String PROP_SCOPE = "scope";
    private IObservableManager om = new ObservableManager(this, true);
    private static final ANSNode LOADING_DNODE = new ANSNode("Loading defaults...");
    private static final DefaultMutableTreeNode LOADING_TREE_NODE = new DefaultMutableTreeNode(LOADING_DNODE);
    static ANSNode ERROR_DNODE = new ANSNode("Error loading defaults");
    static DefaultMutableTreeNode ERROR_TREE_NODE = new DefaultMutableTreeNode(ERROR_DNODE);
    private IANSNode droot;
    private DefaultTreeModel treeModel;
    private ANSTableModel tableModel;
    private boolean disposed = false;
    private ANSHelper dfh;
    private SDebug dbg;
    private SppAnsNeUpdatePane pane;
    private boolean dirty;
    private NodeModelDelegate nmd;

    public ANSController(SppAnsNeUpdatePane sppAnsNeUpdatePane, NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        this.nmd = nodeModelDelegate;
        this.dfh = new ANSHelper((Component)((Object)sppAnsNeUpdatePane), this.nmd);
        this.dfh.addObserver(this);
        this.treeModel = new DefaultTreeModel(LOADING_TREE_NODE);
        this.tableModel = new ANSTableModel(this);
        this.dfh = this.dfh;
        this.dbg = sDebug;
        this.pane = sppAnsNeUpdatePane;
    }

    public ANSTableModel getTableModel() {
        return this.tableModel;
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public void importDefaults() {
        String string = this.dfh.importDefaults();
        if (string != null) {
            this.refreshPane(string);
            if (this.droot.isDirty()) {
                this.pane.setDirty();
            }
        }
    }

    private void refreshPane(String string) {
        this.tableModel.fireTableDataChanged();
        this.refreshTree((DefaultMutableTreeNode)this.treeModel.getRoot());
        this.pane.updateLabel(string);
    }

    private void refreshTree(TreeNode treeNode) {
        this.treeModel.nodeChanged(treeNode);
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            this.refreshTree(treeNode.getChildAt(i));
        }
    }

    public void exportDefaults() {
        this.dfh.exportDefaults();
    }

    final Component getParentComponent() {
        return this.pane;
    }

    public boolean validateData() {
        return true;
    }

    public void applyToModel() throws Exception {
        this.dfh.applyToNode();
        this.droot.resetDirty();
        this.refreshPane("node");
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public void refreshFromModel() throws Exception {
        String string = this.getTreeSelection();
        Preferences.instance().setProperty(PROP_PREF, PROP_SCOPE, string);
        this.setEditorContent(LOADING_TREE_NODE);
        new Thread((Runnable)this, "ANS NE Update loader for " + this.nmd.getName()).start();
    }

    public void refreshFromModel(int n) throws Exception {
        this.refreshFromModel();
    }

    public void disposeDataSource() {
        this.disposed = true;
    }

    public IObservableManager getObservableManager() {
        return this.om;
    }

    public void update(Observable observable, Object object) {
        try {
            this.refreshFromModel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        if (!this.disposed) {
            this.pane.clearLabel();
            try {
                this.droot = this.dfh.getDefaultsRoot(true);
                DefaultMutableTreeNode defaultMutableTreeNode = this.createTree(this.droot);
                this.treeModel.setRoot(defaultMutableTreeNode);
                String string = Preferences.instance().getProperty(PROP_PREF, PROP_SCOPE, null);
                DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                if (string != null) {
                    defaultMutableTreeNode2 = this.getTreeRoot(defaultMutableTreeNode, string);
                }
                if (defaultMutableTreeNode2 == null) {
                    defaultMutableTreeNode2 = defaultMutableTreeNode;
                }
                this.pane.getTreeSelectionModel().setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
                this.pane.updateLabel("node");
            }
            catch (Exception exception) {
                this.setEditorContent(ERROR_TREE_NODE);
                String string = "No reason available";
                if (exception.getMessage() != null) {
                    string = exception.toString();
                }
                if (this.dbg.isSevereEnabled()) {
                    this.dbg.severe(string);
                    SDebug.printStackTrace((Throwable)exception);
                }
                ErrorMsg.displayError((Component)((Object)this.pane), (EID)EMC.EID_ERROR_RETRIEVING_DEFAULTS_PARAM_1, (Object)string);
            }
        }
    }

    public void setTableContent(TreePath treePath) {
        if (treePath != null) {
            IANSNode iANSNode = this.getANSNode(treePath);
            TreeMap treeMap = new TreeMap(new ListComparator());
            this.dfh.fillMap(treeMap, iANSNode);
            this.tableModel.setScope(this.pane.getTable(), treeMap);
        }
    }

    public void setEditorContent(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.droot = (ANSNode)defaultMutableTreeNode.getUserObject();
        this.treeModel.setRoot(defaultMutableTreeNode);
        this.pane.getTreeSelectionModel().clearSelection();
        this.pane.getTreeSelectionModel().setSelectionPath(new TreePath(defaultMutableTreeNode));
    }

    public void setDirty(IANSElement iANSElement) {
        this.pane.setDirty();
        this.updateTreeModel((DefaultMutableTreeNode)this.treeModel.getRoot(), iANSElement.getFullName());
    }

    private void updateTreeModel(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        this.treeModel.nodeChanged(defaultMutableTreeNode);
        int n = string.indexOf(46);
        if (n < 0) {
            return;
        }
        String string2 = string.substring(0, n);
        string = string.substring(n + 1);
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            IANSNode iANSNode = (IANSNode)defaultMutableTreeNode3.getUserObject();
            if (!iANSNode.getName().equals(string2)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            break;
        }
        if (defaultMutableTreeNode2 != null) {
            this.updateTreeModel(defaultMutableTreeNode2, string);
        }
    }

    private String getTreeSelection() {
        TreePath treePath = this.pane.getTreeSelectionModel().getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            return ((IANSNode)defaultMutableTreeNode.getUserObject()).getFullName();
        }
        return "";
    }

    private DefaultMutableTreeNode getTreeRoot(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        String string2;
        int n = string.indexOf(46);
        if (n < 0) {
            string2 = string;
            string = null;
        } else {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            IANSNode iANSNode = (IANSNode)defaultMutableTreeNode3.getUserObject();
            if (!iANSNode.getName().equals(string2)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
            break;
        }
        if (defaultMutableTreeNode2 != null && string != null) {
            return this.getTreeRoot(defaultMutableTreeNode2, string);
        }
        return defaultMutableTreeNode2;
    }

    boolean isAuthorized() {
        return this.nmd.isUserAuthorized(SecurityLevel.SUPERUSER);
    }

    private DefaultMutableTreeNode createTree(IANSNode iANSNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(iANSNode);
        IANSNode[] iANSNodeArray = iANSNode.getChildren();
        for (int i = 0; i < iANSNodeArray.length && !(iANSNodeArray[i] instanceof IANSElement); ++i) {
            defaultMutableTreeNode.add(this.createTree(iANSNodeArray[i]));
        }
        return defaultMutableTreeNode;
    }

    private IANSNode getANSNode(TreePath treePath) {
        Object var2_2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return (IANSNode)defaultMutableTreeNode.getUserObject();
    }

    class ListComparator
    implements Comparator {
        ListComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof ANSElement && object2 instanceof ANSElement) {
                ANSElement aNSElement = (ANSElement)object;
                sParameterKey sParameterKey2 = (sParameterKey)aNSElement.getKey();
                ANSElement aNSElement2 = (ANSElement)object2;
                sParameterKey sParameterKey3 = (sParameterKey)aNSElement2.getKey();
                if (sParameterKey2.spectrumIndex > 0 && sParameterKey3.spectrumIndex > 0) {
                    return sParameterKey2.spectrumIndex > sParameterKey3.spectrumIndex ? 1 : -1;
                }
                return aNSElement.getKeyStr().compareTo(aNSElement2.getKeyStr());
            }
            return 1;
        }
    }
}

