/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.EntityModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OptLinkModel;
import cerent.cms.model.ParserIfName;
import cerent.cms.model.PortModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.ComparisonUtil;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class AnsConnColumnRenderer
extends AbstractColumnRenderer {
    public static final int SLT_FROM = 0;
    public static final int UNIT_FROM = 1;
    public static final int PORT_FROM = 2;
    public static final int SLT_TO = 3;
    public static final int UNIT_TO = 4;
    public static final int PORT_TO = 5;
    public static final int CON_STAT = 6;
    private static final int COLUMN_NO = 7;
    private static AttributeMaps attributeMap = new AttributeMaps();
    private static final String OPT_LINK_STAT_KEY = "OpticalLinkStatusKey";
    private static final EntityCellRenderer renderer = new EntityCellRenderer();
    private JLabel label;
    private Color[] status_color = new Color[]{Color.black, Color.blue, Color.red};

    public AnsConnColumnRenderer(String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.label = new JLabel();
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        OptLinkModel optLinkModel;
        String string = "";
        JLabel jLabel = this.label;
        try {
            optLinkModel = (OptLinkModel)object;
        }
        catch (Exception exception) {
            this.label.setText("");
            return jLabel;
        }
        switch (n2) {
            case 0: {
                string = this.getSlot((NodeModelDelegate)optLinkModel.getNodeModel(), optLinkModel.getFrom());
                break;
            }
            case 1: {
                string = this.getCardString((NodeModelDelegate)optLinkModel.getNodeModel(), optLinkModel.getFrom());
                break;
            }
            case 2: {
                string = this.getPortName(optLinkModel.getFrom());
                break;
            }
            case 3: {
                string = this.getSlot((NodeModelDelegate)optLinkModel.getNodeModel(), optLinkModel.getTo());
                break;
            }
            case 4: {
                string = this.getCardString((NodeModelDelegate)optLinkModel.getNodeModel(), optLinkModel.getTo());
                break;
            }
            case 5: {
                string = this.getPortName(optLinkModel.getTo());
                break;
            }
            case 6: {
                string = optLinkModel.getOptLnkStateString();
            }
        }
        this.label.setToolTipText(this.getCardString((NodeModelDelegate)optLinkModel.getNodeModel(), optLinkModel.getFrom()));
        this.label.setText(string);
        Color color = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        Color color2 = bl ? jTable.getSelectionForeground() : this.status_color[optLinkModel.getOptLnkState().value() - 1];
        ((Component)jLabel).setBackground(color);
        ((Component)jLabel).setForeground(color2);
        return jLabel;
    }

    private String getSlot(NodeModelDelegate nodeModelDelegate, int n) {
        int n2 = AnsConnColumnRenderer.getSlotInt(nodeModelDelegate, n);
        if (n2 == -1) {
            return "unknown";
        }
        return String.valueOf(n2);
    }

    private String getSlotPort(NodeModelDelegate nodeModelDelegate, int n) {
        int n2 = AnsConnColumnRenderer.getSlotInt(nodeModelDelegate, n);
        int[] nArray = AnsConnColumnRenderer.getPortNum(nodeModelDelegate, n);
        if (n2 == -1 || nArray == null) {
            return "unknown";
        }
        return "p" + this.getPortString(nodeModelDelegate, n);
    }

    private String getPortString(NodeModelDelegate nodeModelDelegate, int n) {
        EntityModel entityModel = null;
        try {
            entityModel = (EntityModel)nodeModelDelegate.getEntityTableModel().getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return null;
        }
        return renderer.getPortString(entityModel, false, true);
    }

    private String getPortName(int n) {
        return new ParserIfName(n).getAID();
    }

    static int[] getPortNum(NodeModelDelegate nodeModelDelegate, int n) {
        EntityModel entityModel = null;
        try {
            entityModel = (EntityModel)nodeModelDelegate.getEntityTableModel().getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return null;
        }
        if (entityModel != null && entityModel instanceof PortModel) {
            return ((PortModel)entityModel).getPortNum();
        }
        return null;
    }

    private String getCardString(NodeModelDelegate nodeModelDelegate, int n) {
        EntityModel entityModel = null;
        try {
            entityModel = (EntityModel)nodeModelDelegate.getEntityTableModel().getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return null;
        }
        return entityModel.getModuleModel().getEqTypeName();
    }

    static int getSlotInt(NodeModelDelegate nodeModelDelegate, int n) {
        EntityModel entityModel = null;
        try {
            entityModel = (EntityModel)nodeModelDelegate.getEntityTableModel().getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return -1;
        }
        if (entityModel != null && entityModel instanceof PortModel) {
            return entityModel.getSlot();
        }
        return -1;
    }

    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        OptLinkModel optLinkModel = (OptLinkModel)object;
        OptLinkModel optLinkModel2 = (OptLinkModel)object2;
        switch (n) {
            case 0: {
                n2 = ComparisonUtil.compare(optLinkModel.getFrom(), optLinkModel2.getFrom());
                break;
            }
            case 2: {
                n2 = this.getPortName(optLinkModel.getFrom()).compareTo(this.getPortName(optLinkModel2.getFrom()));
                break;
            }
            case 1: {
                n2 = this.getCardString((NodeModelDelegate)optLinkModel.getNodeModel(), optLinkModel.getFrom()).compareTo(this.getCardString((NodeModelDelegate)optLinkModel2.getNodeModel(), optLinkModel2.getFrom()));
                break;
            }
            case 3: {
                n2 = ComparisonUtil.compare(optLinkModel.getTo(), optLinkModel2.getTo());
                break;
            }
            case 5: {
                n2 = this.getPortName(optLinkModel.getTo()).compareTo(this.getPortName(optLinkModel2.getTo()));
                break;
            }
            case 4: {
                n2 = this.getCardString((NodeModelDelegate)optLinkModel.getNodeModel(), optLinkModel.getTo()).compareTo(this.getCardString((NodeModelDelegate)optLinkModel2.getNodeModel(), optLinkModel2.getTo()));
                break;
            }
            case 6: {
                n2 = ComparisonUtil.compare(optLinkModel.getOptLnkState().value(), optLinkModel2.getOptLnkState().value());
            }
        }
        return n2;
    }

    static ColumnRenderer[] createTableRenderers() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[7];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = AnsConnColumnRenderer.createColumnRenderer(i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "Slot-From";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "Unit-From";
                n3 = 150;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Port-From";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 3: {
                string = "Slot-To";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 4: {
                string = "Unit-To";
                n3 = 150;
                bl = true;
                n2 = 2;
                break;
            }
            case 5: {
                string = "Port-To";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 6: {
                string = "State";
                n3 = 120;
                bl = true;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new AnsConnColumnRenderer(string, n3, bl, n2);
    }

    public static AttributeMaps getTopologyAttributeMaps() {
        return attributeMap;
    }
}

