/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ctx;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BbeSlot;
import cerent.cms.model.CtxModuleModel;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.Ec1LineUpdate;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.PluggableCardTabbedView;
import cerent.cms.ui.ctx.CtxMaintPane;
import cerent.cms.ui.ctx.CtxPmPane;
import cerent.cms.ui.ctx.CtxProvPane;
import cerent.cms.ui.event.IEventPanelController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;

public class CtxCardTabbedView
extends PluggableCardTabbedView
implements ITabName {
    private ArrayList _ds3LinesList;
    private ArrayList _ec1LinesList;
    private ArrayList _ocnLinesList;
    private BbeSlot _bbeSlot;
    private Ds123LineModel[] _ds1Lines;
    private EnvAlarmModel[] _alarmInputs;
    private EnvControlModel[] _controlOutputs;

    public CtxCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
    }

    protected void init() {
        int n;
        CtxModuleModel ctxModuleModel = (CtxModuleModel)this.getUiModel();
        Ds123LineModel[] ds123LineModelArray = ctxModuleModel.getDs3Lines();
        this._ds3LinesList = new ArrayList<Ds123LineModel>(Arrays.asList(ds123LineModelArray));
        this.getOM().addObservable((Observable[])ds123LineModelArray);
        int n2 = ds123LineModelArray.length;
        TdmLineModel[] tdmLineModelArray = ctxModuleModel.getEc1Lines();
        this._ec1LinesList = new ArrayList<TdmLineModel>(Arrays.asList(tdmLineModelArray));
        this.getOM().addObservable((Observable[])tdmLineModelArray);
        int n3 = tdmLineModelArray.length;
        TdmLineModel[] tdmLineModelArray2 = ctxModuleModel.getOpticalLines();
        this._ocnLinesList = new ArrayList<TdmLineModel>(Arrays.asList(tdmLineModelArray2));
        this.getOM().addObservable((Observable[])tdmLineModelArray2);
        int n4 = tdmLineModelArray2.length;
        this._interfaceContainers = Collections.synchronizedMap(new HashMap(n4 + n3 + n2));
        for (n = 0; n < n2; ++n) {
            this.addContainerMap(ds123LineModelArray[n]);
        }
        for (n = 0; n < n3; ++n) {
            this.addContainerMap(tdmLineModelArray[n]);
        }
        for (n = 0; n < n4; ++n) {
            this.addContainerMap(tdmLineModelArray2[n]);
        }
        try {
            this._bbeSlot = ctxModuleModel.getBbeSlot();
            this.getOM().addObservable((Observable)((Object)this._bbeSlot));
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this._bbeSlot = null;
        }
        this._ds1Lines = ctxModuleModel.getDs1Lines();
        this._alarmInputs = ctxModuleModel.getAlarmInput();
        this._controlOutputs = ctxModuleModel.getControlOutput();
        super.init();
    }

    private Ds123LineModel[] getDs3LinesArray() {
        return this._ds3LinesList.toArray(new Ds123LineModel[this._ds3LinesList.size()]);
    }

    private TdmLineModel[] getEc1LinesArray() {
        return this._ec1LinesList.toArray(new TdmLineModel[this._ec1LinesList.size()]);
    }

    private TdmLineModel[] getOcnLinesArray() {
        return this._ocnLinesList.toArray(new TdmLineModel[this._ocnLinesList.size()]);
    }

    protected List addModel(Observable observable) {
        ArrayList<ModuleModelUpdate> arrayList;
        block4: {
            Model[] modelArray;
            IPortContainer iPortContainer;
            block5: {
                CtxModuleModel ctxModuleModel;
                block3: {
                    ctxModuleModel = (CtxModuleModel)this.getUiModel();
                    arrayList = new ArrayList<ModuleModelUpdate>();
                    if (!(observable instanceof PpmModel)) break block3;
                    IPortContainer iPortContainer2 = (IPortContainer)((Object)observable);
                    Model[] modelArray2 = ctxModuleModel.getOpticalLines();
                    this._ocnLinesList = new ArrayList<TdmLineModel>(Arrays.asList(modelArray2));
                    this.getOM().addObservable((Observable[])modelArray2);
                    arrayList.add(new OcnLineUpdate(modelArray2, iPortContainer2));
                    Iterator iterator = iPortContainer2.getContainedPorts().iterator();
                    while (iterator.hasNext()) {
                        this.addContainerMap(((PortModel)iterator.next()).getInterfaceModel(), iPortContainer2);
                    }
                    break block4;
                }
                if (!(observable instanceof BbeSlot)) break block4;
                iPortContainer = (IPortContainer)((Object)observable);
                Model[] modelArray3 = ctxModuleModel.getDs3Lines();
                modelArray = ctxModuleModel.getEc1Lines();
                if (modelArray3.length <= this._ds3LinesList.size()) break block5;
                this._ds3LinesList = new ArrayList<Ds123LineModel>(Arrays.asList(modelArray3));
                this.getOM().addObservable((Observable[])modelArray3);
                arrayList.add(new Ds3LineUpdate(modelArray3, iPortContainer));
                Iterator iterator = iPortContainer.getContainedPorts().iterator();
                while (iterator.hasNext()) {
                    this.addContainerMap(((PortModel)iterator.next()).getInterfaceModel(), iPortContainer);
                }
                break block4;
            }
            if (modelArray.length <= this._ec1LinesList.size()) break block4;
            this._ec1LinesList = new ArrayList<TdmLineModel>(Arrays.asList(modelArray));
            this.getOM().addObservable((Observable[])modelArray);
            arrayList.add(new Ec1LineUpdate(modelArray, iPortContainer));
            Iterator iterator = iPortContainer.getContainedPorts().iterator();
            while (iterator.hasNext()) {
                this.addContainerMap(((PortModel)iterator.next()).getInterfaceModel(), iPortContainer);
            }
        }
        return arrayList.size() > 0 ? arrayList : super.addModel(observable);
    }

    protected List removeModel(Observable observable) {
        ArrayList<ModuleModelUpdate> arrayList = new ArrayList<ModuleModelUpdate>();
        IPortContainer iPortContainer = (IPortContainer)this._interfaceContainers.get(observable);
        if (observable instanceof IInterfaceModel) {
            this.removeContainerMap((IInterfaceModel)observable);
        }
        this.getOM().removeObservable(observable);
        if (observable instanceof Ds123LineModel && this._ds3LinesList.remove(observable)) {
            arrayList.add(new Ds3LineUpdate(this.getDs3LinesArray(), iPortContainer));
        } else if (observable instanceof TdmLineModel) {
            if (this._ec1LinesList.remove(observable)) {
                arrayList.add(new Ec1LineUpdate(this.getEc1LinesArray(), iPortContainer));
            } else if (this._ocnLinesList.remove(observable)) {
                arrayList.add(new OcnLineUpdate(this.getOcnLinesArray(), iPortContainer));
            }
        }
        return arrayList.size() > 0 ? arrayList : super.removeModel(observable);
    }

    public Pane getMaintenanceTab() {
        return new CtxMaintPane("Maintenance", this, this._ds1Lines, this.getDs3LinesArray(), this.getEc1LinesArray(), this.getOcnLinesArray(), this._alarmInputs, this._controlOutputs);
    }

    public Pane getProvTab() {
        return new CtxProvPane("Provisioning", this, this._ds1Lines, this.getDs3LinesArray(), this.getEc1LinesArray(), this.getOcnLinesArray(), this._alarmInputs, this._controlOutputs);
    }

    public Pane getPerformanceTab() {
        return new CtxPmPane("Performance", this, this._ds1Lines, this.getDs3LinesArray(), this.getEc1LinesArray(), this.getOcnLinesArray());
    }

    public void destroy() {
        this._ds3LinesList.clear();
        this._ec1LinesList.clear();
        this._ocnLinesList.clear();
        this._ds1Lines = null;
        this._alarmInputs = null;
        this._controlOutputs = null;
        super.destroy();
    }
}

