/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ctx;

import cerent.cms.model.BbeSlot;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.CtxModuleModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PortModel;
import cerent.cms.ui.ppm.PpmSlotView;
import cerent.cms.ui.shelf.AbstractPortGraphic;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.EnvPortGraphic;
import cerent.cms.ui.shelf.GenericPortGraphic;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CtxCardView
extends CardView {
    private static final int MAX_PER_ROW = 7;
    protected static final SDebug db = new SDebug("CtxCardView");
    protected BbeSlot bbeSlot;
    protected List bbePortObsList;

    public CtxCardView(ModuleModel moduleModel) {
        block2: {
            super(moduleModel);
            try {
                this.bbeSlot = ((CtxModuleModel)moduleModel).getBbeSlot();
            }
            catch (CmsNoSuchEntityException cmsNoSuchEntityException) {
                db.println("Caught CmsNoSuchEntityException while registeringCtxCardView");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)((Object)cmsNoSuchEntityException));
            }
        }
        this.bbePortObsList = new ArrayList();
        this.registerForLocalUpdates();
    }

    private JLabel formatLabel(String string) {
        return AbstractShelfLayout.formatLabel(new JLabel(string));
    }

    private int[] getEnvInputTypes() {
        return new int[]{38};
    }

    private int[] getEnvOutputTypes() {
        return new int[]{39};
    }

    private int[] getOpticalTypes() {
        return new int[]{28, 29};
    }

    private int[] getBbeTypes() {
        return new int[]{32, 31};
    }

    private int[] getWbeTypes() {
        return new int[]{34};
    }

    private boolean isa(EntityModel entityModel, int[] nArray) {
        int n = entityModel.getEqType();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private void addAlarmPorts(int[] nArray, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 1;
        for (int i = 0; i < this.numPorts; ++i) {
            EntityModel entityModel;
            Object e = this.portModels.get(i);
            if (!(e instanceof EntityModel) || !this.isa(entityModel = (EntityModel)e, nArray)) continue;
            this.ports[i] = new EnvPortGraphic(this, entityModel, entityModel.getPort());
            this.add((Component)this.ports[i], gridBagConstraints);
            if (++gridBagConstraints.gridx <= 7) continue;
            gridBagConstraints.gridx = 1;
            ++gridBagConstraints.gridy;
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
    }

    private void addBbePorts(int[] nArray, GridBagConstraints gridBagConstraints) {
        JPanel[] jPanelArray;
        block6: {
            gridBagConstraints.gridx = 1;
            jPanelArray = null;
            try {
                BbeSlot bbeSlot = ((CtxModuleModel)this.model).getBbeSlot();
                jPanelArray = new JPanel[bbeSlot.getMaxPorts()];
            }
            catch (CmsNoSuchEntityException cmsNoSuchEntityException) {
                db.println("Caught CmsNoSuchEntityException while creatingCtxCardView");
                if (!db.on()) break block6;
                SDebug.printStackTrace((Throwable)((Object)cmsNoSuchEntityException));
            }
        }
        if (jPanelArray != null) {
            int n;
            for (n = 0; n < this.numPorts; ++n) {
                EntityModel entityModel;
                Object e = this.portModels.get(n);
                if (!(e instanceof EntityModel) || !this.isa(entityModel = (EntityModel)e, nArray)) continue;
                this.ports[n] = new GenericPortGraphic(this, entityModel, entityModel.getPort());
                int n2 = entityModel.getPositionInParent();
                jPanelArray[n2 - 1] = this.ports[n];
            }
            for (n = 0; n < jPanelArray.length; ++n) {
                if (jPanelArray[n] == null) {
                    jPanelArray[n] = this.getPortSlotGraphic();
                }
                this.add((Component)jPanelArray[n], gridBagConstraints);
                if (++gridBagConstraints.gridx <= 7) continue;
                gridBagConstraints.gridx = 1;
                ++gridBagConstraints.gridy;
            }
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
    }

    private void addPorts(int[] nArray, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 1;
        for (int i = 0; i < this.numPorts; ++i) {
            EntityModel entityModel;
            Object e = this.portModels.get(i);
            if (!(e instanceof EntityModel) || !this.isa(entityModel = (EntityModel)e, nArray)) continue;
            this.ports[i] = new GenericPortGraphic(this, entityModel, entityModel.getPort());
            this.add((Component)this.ports[i], gridBagConstraints);
            if (++gridBagConstraints.gridx <= 7) continue;
            gridBagConstraints.gridx = 1;
            ++gridBagConstraints.gridy;
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
    }

    private void addPpmPorts(int[] nArray, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 1;
        Insets insets = gridBagConstraints.insets;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        List list = this.model.getDescendantsOfEqType(149);
        PpmSlotView[] ppmSlotViewArray = new PpmSlotView[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            PluggableSlotModel pluggableSlotModel = (PluggableSlotModel)list.get(i);
            ppmSlotViewArray[i] = new PpmSlotView(pluggableSlotModel);
            this.add((Component)ppmSlotViewArray[i], gridBagConstraints);
            if (++gridBagConstraints.gridx <= 7) continue;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy += 2;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy += 2;
        gridBagConstraints.insets = insets;
    }

    private void addLabel(String string, GridBagConstraints gridBagConstraints) {
        int n = gridBagConstraints.anchor;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.formatLabel(string), gridBagConstraints);
        gridBagConstraints.anchor = n;
    }

    protected void addPorts(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.addLabel("External Alarm Inputs", gridBagConstraints);
        this.addAlarmPorts(this.getEnvInputTypes(), gridBagConstraints);
        this.addLabel("External Control Outputs", gridBagConstraints);
        this.addAlarmPorts(this.getEnvOutputTypes(), gridBagConstraints);
        this.addLabel("Optical (OC3/OC12)", gridBagConstraints);
        this.addPpmPorts(this.getOpticalTypes(), gridBagConstraints);
        this.addLabel("Broadband (DS3/EC1)", gridBagConstraints);
        this.addBbePorts(this.getBbeTypes(), gridBagConstraints);
        this.addLabel("Wideband (DS1)", gridBagConstraints);
        this.addPorts(this.getWbeTypes(), gridBagConstraints);
        this.invalidate();
    }

    private JPanel getPortSlotGraphic() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        jPanel.setBackground(Color.lightGray);
        jPanel.setPreferredSize(new Dimension(16, 16));
        return jPanel;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof EntityModel) {
            if (this.model != null && this.model.getNodeModel().isInited() && object instanceof Integer) {
                Integer n = (Integer)object;
                if (db.on()) {
                    db.println("update(): CtxCardView, From=" + observable + ", arg=" + n);
                }
                if (n.equals(ModelUpdateType.ADDED)) {
                    SwingUtilities.invokeLater(new ReplacePort());
                    if (db.on()) {
                        db.println("Port ADDED");
                    }
                } else if (n.equals(ModelUpdateType.DELETED)) {
                    SwingUtilities.invokeLater(new ReplacePort());
                    if (db.on()) {
                        db.println("Port DELETED");
                    }
                }
            }
        } else {
            super.update(observable, object);
        }
    }

    protected void registerForLocalUpdates() {
        if (this.bbeSlot != null) {
            this.bbeSlot.addObserver(this);
            if (db.on()) {
                db.println("Registered BBE slot: " + this.bbeSlot);
            }
            List list = this.bbeSlot.getChildren();
            this.bbePortObsList = new ArrayList(list.size());
            PortModel portModel = null;
            for (int i = 0; i < list.size(); ++i) {
                portModel = (PortModel)list.get(i);
                if (portModel == null) continue;
                portModel.addObserver(this);
                this.bbePortObsList.add(portModel);
                if (!db.on()) continue;
                db.println("Registered BBE port: " + portModel);
            }
        }
    }

    protected void deregisterFromLocalUpdates() {
        if (this.bbeSlot != null) {
            this.bbeSlot.deleteObserver(this);
            if (db.on()) {
                db.println("Deregistered parent: " + this.bbeSlot);
            }
        }
        if (this.bbePortObsList != null) {
            PortModel portModel = null;
            ListIterator listIterator = this.bbePortObsList.listIterator();
            while (listIterator.hasNext()) {
                portModel = (PortModel)listIterator.next();
                if (portModel == null) continue;
                portModel.deleteObserver(this);
                listIterator.remove();
                if (!db.on()) continue;
                db.println("Deregistered Child: " + portModel);
            }
        }
    }

    protected void localDispose() {
        this.deregisterFromLocalUpdates();
        if (this.ports != null) {
            for (int i = 0; i < this.ports.length; ++i) {
                if (this.ports[i] == null) continue;
                this.ports[i].dispose();
                this.ports[i] = null;
            }
            this.ports = null;
        }
        this.removeAll();
    }

    static /* synthetic */ AbstractPortGraphic[] access$502(CtxCardView ctxCardView, AbstractPortGraphic[] abstractPortGraphicArray) {
        ctxCardView.ports = abstractPortGraphicArray;
        return abstractPortGraphicArray;
    }

    protected class ReplacePort
    implements Runnable {
        protected ReplacePort() {
        }

        public void run() {
            block4: {
                try {
                    CtxCardView.this.localDispose();
                    if (CtxCardView.this.model != null) {
                        CtxCardView.this.portModels = CtxCardView.this.getPorts();
                        CtxCardView.this.numPorts = CtxCardView.this.portModels.size();
                        CtxCardView.access$502(CtxCardView.this, new AbstractPortGraphic[CtxCardView.this.numPorts]);
                        CtxCardView.this.addPorts(false);
                        CtxCardView.this.refreshAlarmInfo();
                        CtxCardView.this.registerForLocalUpdates();
                    }
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                }
                catch (Exception exception) {
                    if (!db.on()) break block4;
                    db.println("Error replacing port: " + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            CtxCardView.this.validate();
            CtxCardView.this.repaint();
        }
    }
}

