/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ctx;

import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.Ec1LineUpdate;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.aic.AicEnvAlarmPane;
import cerent.cms.ui.aic.EnvControlPanesFactory;
import cerent.cms.ui.ds1.Ds1CardTabbedView;
import cerent.cms.ui.ds3e.Ds3eCardTabbedView;
import cerent.cms.ui.ec1.Ec1CardTabbedView;
import cerent.cms.ui.sonet.TdmCardTabbedView;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.awt.Component;

public class CtxMaintPane
extends AbstractSubTabbedPane
implements ITabName {
    protected Ds123LineModel[] ds3Lines;
    protected TdmLineModel[] ec1Lines;
    protected TdmLineModel[] ocnLines;
    protected Ds123LineModel[] ds1Lines;
    protected EnvAlarmModel[] alarmInputs;
    protected EnvControlModel[] controlOutputs;
    private static final SDebug dbg = new SDebug("CtxMaintPane");

    public CtxMaintPane(String string, CardTabbedView cardTabbedView, Ds123LineModel[] ds123LineModelArray, Ds123LineModel[] ds123LineModelArray2, TdmLineModel[] tdmLineModelArray, TdmLineModel[] tdmLineModelArray2, EnvAlarmModel[] envAlarmModelArray, EnvControlModel[] envControlModelArray) {
        super(string, cardTabbedView);
        this.ds1Lines = ds123LineModelArray;
        this.ds3Lines = ds123LineModelArray2;
        this.ec1Lines = tdmLineModelArray;
        this.ocnLines = tdmLineModelArray2;
        this.alarmInputs = envAlarmModelArray;
        this.controlOutputs = envControlModelArray;
        this.registerWithModel();
    }

    protected void createSubTabs() {
        boolean bl;
        String string;
        String string2;
        ModuleModel moduleModel;
        block6: {
            if (dbg.on()) {
                dbg.info("Creating SubTabs");
            }
            moduleModel = (ModuleModel)this.getUiModel();
            string2 = "DS1/E1";
            string = "DS3/E3";
            bl = true;
            try {
                bl = Model.getFramingType(moduleModel.getNodeModelDelegate()).isSonet();
                if (bl) {
                    string2 = "DS1";
                    string = "DS3";
                } else {
                    string2 = "E1";
                    string = "E3";
                }
            }
            catch (AnnotatedException annotatedException) {
                dbg.println("Could not determine terminology for CtxMaintPane!");
                if (!dbg.on()) break block6;
                SDebug.printStackTrace((Throwable)annotatedException);
            }
        }
        this.subTabs.addTab(string2, (Component)this.getDs1Tab(this.subTabs, moduleModel, this.ds1Lines));
        this.subTabs.addTab(string, (Component)this.getDs3Tab(this.subTabs, moduleModel, this.ds3Lines));
        if (bl) {
            this.subTabs.addTab("EC1", (Component)this.getEc1Tab(this.subTabs, moduleModel, this.ec1Lines));
        }
        this.subTabs.addTab("Optical", (Component)this.getOpticalTab(this.subTabs, moduleModel, this.ocnLines));
        this.subTabs.addTab("External Alarms", (Component)this.getExtAlarmsTab(moduleModel, this.alarmInputs));
        this.subTabs.addTab("External Controls", (Component)this.getExtControlsTab(moduleModel, this.controlOutputs));
        this.subTabs.addTab("Virtual Wires", (Component)this.getVirtualWireTab(moduleModel));
    }

    private Pane getDs1Tab(TabbedView tabbedView, ModuleModel moduleModel, Ds123LineModel[] ds123LineModelArray) {
        return Ds1CardTabbedView.getDs1MaintPane(tabbedView, moduleModel, ds123LineModelArray);
    }

    private Pane getDs3Tab(TabbedView tabbedView, ModuleModel moduleModel, Ds123LineModel[] ds123LineModelArray) {
        return Ds3eCardTabbedView.getDs3eMaintPane(tabbedView, moduleModel, ds123LineModelArray);
    }

    private Pane getEc1Tab(TabbedView tabbedView, ModuleModel moduleModel, TdmLineModel[] tdmLineModelArray) {
        return Ec1CardTabbedView.getEc1MaintPane("EC1", tabbedView, moduleModel, tdmLineModelArray);
    }

    private Pane getOpticalTab(TabbedView tabbedView, ModuleModel moduleModel, TdmLineModel[] tdmLineModelArray) {
        return TdmCardTabbedView.getTdmMaintPane("Optical", tabbedView, tdmLineModelArray);
    }

    private Pane getExtAlarmsTab(ModuleModel moduleModel, EnvAlarmModel[] envAlarmModelArray) {
        return new ProtCardDualPane(this.subTabs, moduleModel, new AicEnvAlarmPane("External Alarms", this.subTabs, envAlarmModelArray, envAlarmModelArray, 1));
    }

    private Pane getExtControlsTab(ModuleModel moduleModel, EnvControlModel[] envControlModelArray) {
        EnvControlPanesFactory envControlPanesFactory = new EnvControlPanesFactory(this.subTabs, envControlModelArray);
        return new ProtCardDualPane(this.subTabs, moduleModel, envControlPanesFactory.getEnvControlMaintTab());
    }

    private Pane getVirtualWireTab(ModuleModel moduleModel) {
        return new ProtCardDualPane(this.subTabs, moduleModel, (Pane)this.uiToolkit.getGuestPane(5, this.subTabs));
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof Ds3LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received Ds3LineUpdate..");
            }
            this.ds3Lines = (Ds123LineModel[])((Ds3LineUpdate)object).getModels();
        } else if (object instanceof Ec1LineUpdate) {
            if (dbg.on()) {
                dbg.info("Received Ec1LineUpdate...");
            }
            this.ec1Lines = (TdmLineModel[])((Ec1LineUpdate)object).getModels();
        } else if (object instanceof OcnLineUpdate) {
            if (dbg.on()) {
                dbg.info("Received OcnLineUpdate...");
            }
            this.ocnLines = (TdmLineModel[])((OcnLineUpdate)object).getModels();
        } else if (dbg.on()) {
            dbg.println("refreshMyLines received " + object);
        }
    }
}

