/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds1;

import cerent.cms.idl.Ds123Media.eThresholdType;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ds1.Ds1FePmThresholdsPane;
import cerent.cms.ui.ds123.Ds123PmThresholdsPane;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public class Ds1LinePmThresholdsPane
extends AbstractPane {
    Ds123LineModel[] models = null;
    protected Ds1LineThresholdButtonPanel buttonPanel = null;
    protected JPanel tablePanel = null;
    protected Pane[] panes = null;
    protected Pane currentPane = null;
    protected CardLayout cl = null;
    public static final int FE_ONE_DAY = 3;
    public static final int FE_MIN_15 = 2;
    public static final int NE_ONE_DAY = 1;
    public static final int NE_MIN_15 = 0;
    public static final String FE_ONE_DAY_PANEL = "Far End 1Day";
    public static final String FE_MIN_15_PANEL = "Far End 15Min";
    public static final String NE_ONE_DAY_PANEL = "Near End 1Day";
    public static final String NE_MIN_15_PANEL = "Near End 15Min";
    private CSHelpID helpID = null;
    private static final SDebug db = new SDebug("Pane.Ds1LinePmThresholdsPane");

    public Ds1LinePmThresholdsPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, CSHelpID cSHelpID) {
        super(string, tabbedView);
        this.models = ds123LineModelArray;
        this.helpID = cSHelpID;
        this.panes = new Pane[4];
        this.initializeLayout();
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + this.currentPane.getName());
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.getButtonPanel(), "North");
        this.add(this.getTablePanel(), "Center");
    }

    protected Ds1LineThresholdButtonPanel getButtonPanel() {
        this.buttonPanel = new Ds1LineThresholdButtonPanel();
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        this.tablePanel = new JPanel();
        this.cl = new CardLayout();
        this.tablePanel.setLayout(this.cl);
        this.tablePanel.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.panes[3] = this.getDs1PmThresholdsPane(FE_ONE_DAY_PANEL, eThresholdType.THRESHOLD_1_DAY, false, this.helpID);
        this.tablePanel.add((Component)this.panes[3], FE_ONE_DAY_PANEL);
        this.panes[2] = this.getDs1PmThresholdsPane(FE_MIN_15_PANEL, eThresholdType.THRESHOLD_15_MIN, false, this.helpID);
        this.tablePanel.add((Component)this.panes[2], FE_MIN_15_PANEL);
        this.panes[1] = this.getDs1PmThresholdsPane(NE_ONE_DAY_PANEL, eThresholdType.THRESHOLD_1_DAY, true, this.helpID);
        this.tablePanel.add((Component)this.panes[1], NE_ONE_DAY_PANEL);
        this.panes[0] = this.getDs1PmThresholdsPane(NE_MIN_15_PANEL, eThresholdType.THRESHOLD_15_MIN, true, this.helpID);
        this.tablePanel.add((Component)this.panes[0], NE_MIN_15_PANEL);
        this.cl.show(this.tablePanel, NE_MIN_15_PANEL);
        this.currentPane = this.panes[0];
        return this.tablePanel;
    }

    protected Ds123PmThresholdsPane getDs1PmThresholdsPane(String string, eThresholdType eThresholdType2, boolean bl, CSHelpID cSHelpID) {
        if (bl) {
            return new Ds123PmThresholdsPane(string, this.getParentView(), this.models, eThresholdType2, bl, cSHelpID);
        }
        return new Ds1FePmThresholdsPane(string, this.getParentView(), this.models, eThresholdType2, bl, cSHelpID);
    }

    protected void showPanel(Pane pane) {
        block4: {
            try {
                TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + this.currentPane.getName());
                this.currentPane.leavingPage();
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("Error in leaving page");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        try {
            pane.enteringPage();
            TablePropertyMgr.getColumnPrefs(pane.getTable(), ((Object)((Object)this)).getClass().getName() + pane.getName());
        }
        catch (Exception exception) {
            db.finer("Exception in showPanel() " + exception);
        }
        this.cl.show(this.tablePanel, pane.getName());
        this.currentPane = pane;
    }

    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + this.currentPane.getName());
        if (this.currentPane != null) {
            this.currentPane.leavingPage();
        }
    }

    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
        }
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + this.currentPane.getName());
    }

    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    public void destroy() {
        for (int i = 0; i < this.panes.length; ++i) {
            TablePropertyMgr.setColumnPrefs(this.panes[i].getTable(), ((Object)((Object)this)).getClass().getName() + this.panes[i].getName());
            this.panes[i].destroy();
            this.panes[i] = null;
        }
        this.cl = null;
        this.buttonPanel = null;
        super.destroy();
    }

    protected class Ds1LineThresholdButtonPanel
    extends JPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JRadioButton buttonNE;
        public JRadioButton buttonFE;
        public JButton showButton = new JButton("Show Thresholds");
        public ButtonGroup periodButtonGroup;
        public ButtonGroup nefeButtonGroup;

        public Ds1LineThresholdButtonPanel() {
            this.initialize();
        }

        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.buttonNE = new JRadioButton("Near End", true);
            this.buttonFE = new JRadioButton("Far End");
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.nefeButtonGroup = new ButtonGroup();
            this.nefeButtonGroup.add(this.buttonNE);
            this.nefeButtonGroup.add(this.buttonFE);
            this.showButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Ds1LineThresholdButtonPanel this$1;
                {
                    this.this$1 = ds1LineThresholdButtonPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.refreshAction();
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.buttonNE, "North");
            jPanel.add((Component)this.buttonFE, "South");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)this.button15Min, "North");
            jPanel2.add((Component)this.button1Day, "South");
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(jPanel2);
            this.add(this.showButton);
            this.setPreferredSize(new Dimension(800, 50));
        }

        protected void refreshAction() {
            if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                if (this.nefeButtonGroup.getSelection() == this.buttonNE.getModel()) {
                    Ds1LinePmThresholdsPane.this.showPanel(Ds1LinePmThresholdsPane.this.panes[1]);
                } else {
                    Ds1LinePmThresholdsPane.this.showPanel(Ds1LinePmThresholdsPane.this.panes[3]);
                }
            } else if (this.nefeButtonGroup.getSelection() == this.buttonNE.getModel()) {
                Ds1LinePmThresholdsPane.this.showPanel(Ds1LinePmThresholdsPane.this.panes[0]);
            } else {
                Ds1LinePmThresholdsPane.this.showPanel(Ds1LinePmThresholdsPane.this.panes[2]);
            }
        }
    }
}

