/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds1;

import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds1.Ds1LinePmThresholdsPane;
import cerent.cms.ui.ds1.Ds1LineProvPane;
import cerent.cms.ui.ds1.Ds1PathPmThresholdsPane;
import cerent.cms.ui.ds1.Ds1SonetPmThresholdsPane;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.awt.Component;

public class Ds1ProvPane
extends AbstractSubTabbedPane
implements ITabName {
    Ds123LineModel[] lineModels = null;
    boolean includeAlarmingPane;
    private static final SDebug dbg = new SDebug("Ds1ProvPane");

    public Ds1ProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        this(string, tabbedView, ds123LineModelArray, true);
    }

    public Ds1ProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, boolean bl) {
        super(string, tabbedView);
        this.lineModels = ds123LineModelArray;
        this.includeAlarmingPane = bl;
        this.registerWithModel();
    }

    protected void createSubTabs() {
        String string;
        block4: {
            if (dbg.on()) {
                dbg.info("Creating SubTabs");
            }
            this.subTabs.addTab("Line", (Component)this.getLineProvTab());
            this.subTabs.addTab("Line Thresholds", (Component)this.getLineThreshold());
            this.subTabs.addTab("Elect Path Thresholds", (Component)this.getPathThreshold());
            INodeModel iNodeModel = this.getUiModel().getNodeModel();
            string = "SONET Thresholds/SDH Thresholds";
            try {
                boolean bl = Model.getFramingType(iNodeModel).isSonet();
                string = bl ? "SONET Thresholds" : "SDH Thresholds";
            }
            catch (AnnotatedException annotatedException) {
                dbg.println("Could not determine framingType for CtxProvPane!");
                if (!dbg.on()) break block4;
                SDebug.printStackTrace((Throwable)annotatedException);
            }
        }
        this.subTabs.addTab(string, (Component)this.getSonetThreshold());
        if (this.includeAlarmingPane) {
            this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, true));
        }
    }

    private Pane getLineThreshold() {
        CSHelpID cSHelpID = CSHelpConst.Ds1LineThresholdsPane;
        int n = this.getModuleType(this.lineModels[0]);
        if (n == 47) {
            cSHelpID = CSHelpConst.XtcDs1LineThresholdsPane;
        } else if (n == 157) {
            cSHelpID = CSHelpConst.CtxDs1LineThresholdsPane;
        }
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds1LinePmThresholdsPane("Line Thresholds", this.getParentView(), this.lineModels, cSHelpID));
    }

    private Pane getPathThreshold() {
        CSHelpID cSHelpID = CSHelpConst.Ds1ElectPathThresholdsPane;
        int n = this.getModuleType(this.lineModels[0]);
        if (n == 47) {
            cSHelpID = CSHelpConst.XtcDs1ElectPathThresholdsPane;
        } else if (n == 157) {
            cSHelpID = CSHelpConst.CtxDs1ElectPathThresholdsPane;
        }
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds1PathPmThresholdsPane("Elect Path Thresholds", this.getParentView(), this.lineModels, cSHelpID));
    }

    private Pane getLineProvTab() {
        CSHelpID cSHelpID = CSHelpConst.Ds1LineProvPane;
        int n = this.getModuleType(this.lineModels[0]);
        if (n == 47) {
            cSHelpID = CSHelpConst.XtcDs1LineProvPane;
        } else if (n == 157) {
            cSHelpID = CSHelpConst.CtxDs1LineProvPane;
        }
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds1LineProvPane("DS1 Line", this.getParentView(), this.lineModels, cSHelpID));
    }

    private Pane getSonetThreshold() {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds1SonetPmThresholdsPane("SONET Thresholds", this.getParentView(), this.lineModels));
    }

    private int getModuleType(InterfaceModel interfaceModel) {
        try {
            return interfaceModel.getModuleModel().getEqType();
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return -1;
        }
    }
}

