/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds123;

import cerent.cms.idl.Ds123Media.eLineType;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.PmPane;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.gui.IgnorableDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;

public abstract class AbstractDs123PmPane
extends PmPane {
    protected Ds123LineModel[] lineModels = null;
    private static final String MESSAGE = "Far-end DS-1 PM values are valid only when the DS-1 line\nis set to extended super frame (ESF). The DS-1 you chose\nis not set to ESF, so the far-end PM values are invalid.";
    private static final String TITLE = "Far-end DS-1 PM Invalid";
    private static final String PREF_KEY = "IgnoreFarEndDs1PmNonEsfFraming";
    private static final String PREF_DESC = "Warning for far-end DS-1 PM without ESF framing.";

    public AbstractDs123PmPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        super(string, tabbedView);
        this.lineModels = ds123LineModelArray;
        this.init();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    protected PmTableModel createDataModel() {
        PmTableModel pmTableModel = this.getDataModel(this.lineModels);
        pmTableModel.addTableModelListener(this);
        return pmTableModel;
    }

    protected PmTableModel getDataModel(Ds123LineModel[] ds123LineModelArray) {
        return new PmTableModel((InterfaceModel[])ds123LineModelArray, (NodeModelDelegate)this.getUiModel().getNodeModel());
    }

    protected void ds1Warning(ActionEvent actionEvent) {
        int n;
        Object object = actionEvent.getSource();
        boolean bl = false;
        if (object == this.farRB) {
            bl = this.nearEnd;
        } else if (object == this.getComponentForLayer(0)) {
            boolean bl2 = bl = !this.nearEnd;
        }
        if (bl && this.lineModels != null && (n = this.getSelectedIndex(0)) >= 0 && n < this.lineModels.length) {
            Ds123LineModel ds123LineModel = this.lineModels[n];
            try {
                if (ds123LineModel.getConfig().lineType != eLineType.ESF) {
                    IgnorableDialog.warningDialog((Component)((Object)this), (String)MESSAGE, (String)TITLE, (String)PREF_KEY, (String)PREF_DESC);
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                db.println("No such interface: " + this.getSelectedItem(0));
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                db.println("Wrong interface type: " + this.getSelectedItem(0));
            }
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.Ds123PmPane;
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }
}

