/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.NotApplicablePane;
import cerent.util.SDebug;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JTable;

public class DwdmCardDualPane
extends AbstractPane {
    public static final int NA_PANE_FOR_UNFRAMED = 1;
    public static final int NA_PANE_FOR_ESCON = 2;
    public static final int NA_PANE_FOR_NO_OOS_AINS = 3;
    public static final int NA_PANE_FOR_UNFRAMED_ISC_OTN = 4;
    private static final SDebug db = new SDebug("DwdmCardDualPane");
    private Pane mainPane;
    private NotApplicablePane notApplicablePane;
    private Pane currentPane;
    private CardLayout layout;
    private int naPaneMode;
    private AbstractDwdmLineModel[] models;

    public DwdmCardDualPane(TabbedView tabbedView, AbstractDwdmLineModel[] abstractDwdmLineModelArray, Pane pane) {
        this(tabbedView, abstractDwdmLineModelArray, pane, 1);
    }

    public DwdmCardDualPane(TabbedView tabbedView, AbstractDwdmLineModel[] abstractDwdmLineModelArray, Pane pane, int n) {
        super(pane.getName(), tabbedView);
        this.currentPane = this.mainPane = pane;
        this.models = abstractDwdmLineModelArray;
        this.naPaneMode = n;
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        this.notApplicablePane = NotApplicablePane.createPane(tabbedView, n == 2);
        if (n == 3) {
            this.notApplicablePane.setText("", "");
        } else if (n == 4) {
            this.notApplicablePane.setText("When payload type is ISC or framing type is UNFRAMED, OTN/FEC is not supported", "");
        }
        this.add(pane.getName(), (Component)pane);
        this.add(this.notApplicablePane.getName(), (Component)((Object)this.notApplicablePane));
    }

    public String getName() {
        return this.mainPane.getName();
    }

    public JTable getTable() {
        return this.currentPane == this.mainPane ? this.mainPane.getTable() : null;
    }

    public void refresh() throws Exception {
        this.currentPane.refresh();
    }

    public void destroy() {
        if (this.notApplicablePane != null) {
            this.notApplicablePane.destroy();
        }
        if (this.mainPane != null) {
            this.mainPane.destroy();
        }
        this.currentPane = null;
        super.destroy();
    }

    public void enteringPage() throws Exception {
        Pane pane = this.mainPane;
        try {
            if (this.naPaneMode == 1 && this.models[0].getFramingType() == 4 || this.naPaneMode == 2 && this.models[0].getDataRate() == 12 || this.naPaneMode == 3 && !this.models[0].isSonetSdhPayload() || this.naPaneMode == 4 && (this.models[0].getFramingType() == 4 || this.models[0].getDataRate() == 21)) {
                pane = this.notApplicablePane;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pane != this.currentPane) {
            this.currentPane = pane;
            this.layout.show((Container)((Object)this), this.currentPane.getName());
        }
        this.currentPane.setShowing(true);
    }

    public void leavingPage() throws Exception {
        this.currentPane.setShowing(false);
    }
}

